package com.xforceplus.bi.commons.sql.generator;

import com.xforceplus.bi.commons.sql.generator.conditions.SQLCondition;
import com.xforceplus.bi.commons.sql.generator.fields.FieldValue;

import java.util.List;

/**
 * DML语句生成服务
 */
public interface SQLGenDMLService {
    /**
     * 生成SQL:根据条件判断记录是否存在
     *
     * @param dialect       数据库方言
     * @param tableName     表名
     * @param sqlConditions 查询条件
     * @return
     */
    String recordExistsSQL(String dialect, String tableName, List<SQLCondition> sqlConditions);

    /**
     * 生成SQL:插入一条记录的SQL
     *
     * @param dialect     数据库方言
     * @param tableName   表名
     * @param fieldValues 字段值
     * @return
     */
    String recordInsertSQL(String dialect, String tableName, List<FieldValue> fieldValues);

    /**
     * 生成SQL:更新记录的SQL
     *
     * @param dialect       数据库方言
     * @param tableName     表名
     * @param fieldValues   字段值
     * @param sqlConditions 条件
     * @return
     */
    String recordUpdateSQL(String dialect, String tableName, List<FieldValue> fieldValues, List<SQLCondition> sqlConditions);
}
