package com.xforceplus.bi.commons.sqlparser.utils;

import org.apache.commons.lang3.StringUtils;

public class DataFormatUtils {
    /**
     * @param field        维度字段
     * @param selectMethod 筛选方式
     * @param fieldType    字段类型
     * @param fieldFormat  字段格式
     */
    public static String formatRangeField(String field, String selectMethod, String fieldType, String fieldFormat) {
        if ("standardRange".equalsIgnoreCase(selectMethod)) {
            return field;
        }
        if ("number".equals(fieldType)) {
            int endPoint = 0;
            if ("quarterRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 5;
            } else if ("yearRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 4;
            } else if ("monthRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 6;
            } else if ("dayRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 8;
            } else if ("timeRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 14;
            }
            return "substr(cast(" + field + " as varchar), 1, " + endPoint + ")";
        }
        if ("string".equalsIgnoreCase(fieldType)) {
            if (StringUtils.isEmpty(fieldFormat)) {
                return field;
            }
            field = "to_date(" + field + ", '" + fieldFormat + "')";
        }
        return formatDateRangeField(field, selectMethod);
    }

    public static String formatDateRangeField(String field, String selectMethod) {
        if ("quarterRange".equalsIgnoreCase(selectMethod)) {
            return "(to_char(" + field + ", 'YYYY') || date_part('quarter', " + field + ")";
        }
        String pattern = null;
        if ("yearRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYY";
        } else if ("monthRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYYMM";
        } else if ("dayRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYYMMDD";
        } else if ("timeRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYYMMDDHH24MISS";
        } else {
            throw new RuntimeException("不支持的筛选范围: selectMethod=" + selectMethod);
        }
        return "to_char(" + field + ", '" + pattern + "')";
    }

    public static boolean isRange(String selectMethod) {
        return StringUtils.endsWith(selectMethod, "Range");
    }
}
