/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.sql.parser.utils;

import org.apache.commons.lang3.StringUtils;

public class DataFormatUtils {
    public static String formatRangeField(String field, String selectMethod, String fieldType, String fieldFormat) {
        if ("standardRange".equalsIgnoreCase(selectMethod)) {
            return field;
        }
        if ("number".equals(fieldType)) {
            int endPoint = 0;
            if ("quarterRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 5;
            } else if ("yearRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 4;
            } else if ("monthRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 6;
            } else if ("dayRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 8;
            } else if ("timeRange".equalsIgnoreCase(selectMethod)) {
                endPoint = 14;
            }
            return "substr(cast(" + field + " as varchar), 1, " + endPoint + ")";
        }
        if ("string".equalsIgnoreCase(fieldType)) {
            if (StringUtils.isEmpty((CharSequence)fieldFormat)) {
                return field;
            }
            field = "to_date(" + field + ", '" + fieldFormat + "')";
        }
        return DataFormatUtils.formatDateRangeField(field, selectMethod);
    }

    public static String formatDateRangeField(String field, String selectMethod) {
        if ("quarterRange".equalsIgnoreCase(selectMethod)) {
            return "(to_char(" + field + ", 'YYYY') || date_part('quarter', " + field + ")";
        }
        String pattern = null;
        if ("yearRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYY";
        } else if ("monthRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYYMM";
        } else if ("dayRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYYMMDD";
        } else if ("timeRange".equalsIgnoreCase(selectMethod)) {
            pattern = "YYYYMMDDHH24MISS";
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b5b\u9009\u8303\u56f4: selectMethod=" + selectMethod);
        }
        return "to_char(" + field + ", '" + pattern + "')";
    }

    public static boolean isRange(String selectMethod) {
        return StringUtils.endsWith((CharSequence)selectMethod, (CharSequence)"Range");
    }
}

