package com.xforceplus.bi.commons.sql.parser.clauses.utils;

import com.google.common.collect.Lists;
import com.xforceplus.bi.commons.sql.parser.clauses.beans.ConditionBean;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.*;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

public class ConditionUtils {

    public static String appendConditions(String originSQL, List<ConditionBean> conditionBeans) throws JSQLParserException {
        Select select = (Select) CCJSqlParserUtil.parse(originSQL);
        PlainSelect plainSelect = (PlainSelect) select.getSelectBody();

        append(plainSelect, conditionBeans);

        return select.toString();
    }

    private static void append(PlainSelect plainSelect, List<ConditionBean> conditionBeans) throws JSQLParserException {
        // from后的表达式
        FromItem fromItem = plainSelect.getFromItem();

        if (fromItem instanceof Table) {
            // from是表
            List<String> tables = Lists.newArrayList();

            // 主表
            Table table = (Table) fromItem;
            tables.add(getTableName(table));

            // 关联表
            List<Join> joins = plainSelect.getJoins();
            if (CollectionUtils.isNotEmpty(joins)) {
                for (Join join : joins) {
                    FromItem joinItem = join.getRightItem();
                    if (joinItem instanceof Table) {
                        Table joinTable = (Table) joinItem;
                        tables.add(getTableName(table));
                    } else if (joinItem instanceof SubSelect) {
                        SubSelect subSelect = (SubSelect) joinItem;
                        PlainSelect joinPlainSelect = (PlainSelect) subSelect.getSelectBody();
                        append(joinPlainSelect, conditionBeans);
                    }
                }
            }

            for (ConditionBean conditionBean : conditionBeans) {
                if (tables.contains(conditionBean.getConditionOnTable())) {
                    appendSingle(plainSelect, conditionBean.getCondition());
                }
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect) fromItem;
            PlainSelect subPlainSelect = (PlainSelect) subSelect.getSelectBody();
            append(subPlainSelect, conditionBeans);
        }
    }

    private static String getTableName(Table table) {
        return table.getAlias() == null ? table.getName() : table.getAlias().getName();
    }

    private static void appendSingle(PlainSelect plainSelect, String permission) throws JSQLParserException {
        Expression condition = CCJSqlParserUtil.parseCondExpression(permission);
        Expression originCondition = plainSelect.getWhere();
        if (originCondition == null) {
            plainSelect.setWhere(condition);
        } else {
            AndExpression andExpression = new AndExpression(originCondition, condition);
            plainSelect.setWhere(andExpression);
        }
    }
}
