package com.xforceplus.bi.commons.sql.parser.table;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;

import java.util.Map;

public class TableUtils {
    /**
     * 获取SQL中所有的表和别名
     * Key为表名
     * Value为别名
     * @param sql
     * @return
     * @throws JSQLParserException
     */
    public static Map<String, String> getTables(String sql) throws JSQLParserException {
        Statement statement = CCJSqlParserUtil.parse(sql);
        Select selectStatement = (Select) statement;
        TablesNamesFinderV2 tablesNamesFinder = new TablesNamesFinderV2();
        return tablesNamesFinder.getTableList(selectStatement);
    }
}
