/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.cache;

import com.xforceplus.phoenix.bill.utils.ReflectUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String cacheName = "LOCAL_CACHE";

    @Cacheable(cacheNames={"LOCAL_CACHE"}, key="#root.args[0].toString()")
    public List<String> getTableFieldNameCache(Object entity) {
        this.logger.debug("======================getTableFieldCache-request-{}============================", entity);
        List<String> fields = ReflectUtil.getFields(entity);
        this.logger.debug("=================fields-{}===========================================", fields);
        return fields;
    }

    @Cacheable(cacheNames={"LOCAL_CACHE"}, key="#root.args[0].toString()")
    public Field[] getTableFieldsCache(Object entity) {
        Field[] declaredFields = entity.getClass().getDeclaredFields();
        return declaredFields;
    }
}

