/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.cache.casm;

import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.phoenix.bill.client.casm.CasmClient;
import com.xforceplus.phoenix.bill.core.vo.BankModel;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.casm.model.MsCasDetails;
import com.xforceplus.phoenix.casm.model.MsCasInvoiceInfo;
import com.xforceplus.phoenix.casm.model.MsListCasDetailsRequest;
import com.xforceplus.phoenix.casm.model.MsListCasDetailsResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalCasmCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String cacheName = "CASM_LOCAL_CACHE";
    @Autowired
    private CasmClient casmClient;

    @Cacheable(cacheNames={"CASM_LOCAL_CACHE"})
    public Map<String, Object> getCompanyInfoFromMerchant(String companyNo, String companyName, String companyTaxNo, Long groupId) {
        List results;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        MsListCasDetailsRequest request = new MsListCasDetailsRequest();
        if (groupId == null) {
            return map;
        }
        request.setGroupid(groupId);
        if (companyNo != null) {
            request.setIdentifierNo(companyNo);
        } else if (companyName != null && companyTaxNo != null) {
            request.setEnterpriseName(companyName);
            request.setTaxNo(companyTaxNo);
        }
        MsListCasDetailsResult msListCasDetailsResult = this.casmClient.listCasDetails(request);
        if (msListCasDetailsResult.getCode() == 1 && !CommonTools.isEmpty(results = msListCasDetailsResult.getResult())) {
            MsCasDetails m = (MsCasDetails)results.get(0);
            List casInvoiceInfos = m.getCasInvoiceInfos();
            MsCasInvoiceInfo info = null;
            if (casInvoiceInfos.size() == 1) {
                info = (MsCasInvoiceInfo)casInvoiceInfos.get(0);
            } else {
                for (MsCasInvoiceInfo item : casInvoiceInfos) {
                    if (item.getDefaultFlag() != 1) continue;
                    info = item;
                }
            }
            if (casInvoiceInfos.size() != 0) {
                BankModel bankModel = new BankModel();
                bankModel.setBankAccount(info.getBankAccount());
                bankModel.setBankAddres(info.getAddress());
                bankModel.setBankName(info.getBankName());
                bankModel.setBankTel(info.getTel());
                map.put("bankModel", bankModel);
            }
            CompanyModel companyModel = new CompanyModel();
            companyModel.setTaxNum(m.getCasTaxNo());
            companyModel.setCompanyName(m.getEnterpriseName());
            map.put("companyModel", companyModel);
        }
        return map;
    }
}

