/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.cache.taxcode;

import com.xforceplus.phoenix.bill.client.taxcode.GoodsClient;
import com.xforceplus.phoenix.bill.client.taxcode.TaxCodeClient;
import com.xforceplus.phoenix.bill.client.taxcode.TaxCodeNationalClient;
import com.xforceplus.phoenix.taxcode.client.model.GoodsDetailReponse;
import com.xforceplus.phoenix.taxcode.client.model.TaxCodeSerachModel;
import com.xforceplus.phoenix.taxcode.client.model.TaxConvertCodeModel;
import com.xforceplus.phoenix.taxcode.client.model.TaxNationalCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalTaxCodeCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    TaxCodeClient taxCodeClient;
    @Autowired
    TaxCodeNationalClient taxCodeNationalClient;
    @Autowired
    GoodsClient goodsClient;
    private static final String cacheName = "TAXCODE_LOCAL_CACHE";

    @Cacheable(cacheNames={"TAXCODE_LOCAL_CACHE"})
    public TaxNationalCode getNationalTaxCode(String goodsTaxNo) {
        this.logger.info("================goodsTaxNo-{}=====================", (Object)goodsTaxNo);
        TaxNationalCode nationalTaxCode = this.taxCodeNationalClient.getNationalTaxCode(goodsTaxNo);
        this.logger.info("================TaxNationalCode-{}=====================", (Object)nationalTaxCode);
        return nationalTaxCode;
    }

    @Cacheable(cacheNames={"TAXCODE_LOCAL_CACHE"})
    public TaxConvertCodeModel getTaxCodeByTaxConvertCode(Long groupId, String taxConvertCode) {
        this.logger.debug("=========getTaxCodeByTaxConvertCode,groupId:{},taxConvertCode:{}=================", (Object)groupId, (Object)taxConvertCode);
        TaxCodeSerachModel req = new TaxCodeSerachModel();
        req.setGroupId(groupId);
        req.setTaxConvertCode(taxConvertCode);
        TaxConvertCodeModel taxCodeByTaxConvertCode = this.taxCodeClient.getTaxCodeByTaxConvertCode(req);
        this.logger.debug("==================TaxConvertCodeModel-{}=============================================", (Object)taxCodeByTaxConvertCode);
        return taxCodeByTaxConvertCode;
    }

    @Cacheable(cacheNames={"TAXCODE_LOCAL_CACHE"})
    public GoodsDetailReponse getGoodsDetailById(String goodsId) {
        GoodsDetailReponse detailReponse = this.goodsClient.queryDetailById(goodsId);
        return detailReponse;
    }
}

