/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.component.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.component.AddHistoryLog;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryTargetType;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryDetailEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.coderbee.mybatis.batch.BatchParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mergeHistoryLog")
public class MergeHistoryLogImpl
implements AddHistoryLog {
    public static final String MERGE_FORMAT_STR = "%s";
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private SalesBillBatchDao billBatchDao;

    @Override
    public void addLog(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean, UserInfo userInfo, Long operationId) {
        BillOperationType billItemOperation = splitAndMergeLogOperationBean.getBillItemOperation();
        List<OrdSalesbillItemEntity> sourceList = splitAndMergeLogOperationBean.getSourceList();
        List<OrdSalesbillItemEntity> targetList = splitAndMergeLogOperationBean.getTargetList();
        OrdSalesbillEntity billTarge = splitAndMergeLogOperationBean.getBillTarge();
        ArrayList historyDetails = Lists.newArrayList();
        ArrayList historys = Lists.newArrayList();
        if (billItemOperation == BillOperationType.MERGE) {
            if (billTarge == null) {
                OrdSalesbillHistoryDetailEntity historyDetail;
                String customerNo;
                Long salesbillItemId;
                long historyId = this.idGenerator.nextId();
                OrdSalesbillItemEntity source = sourceList.get(0);
                OrdSalesbillHistoryEntity historyEntity = this.spellHistory(splitAndMergeLogOperationBean, source.getSalesbillId(), source.getCustomerNo(), userInfo, operationId, historyId);
                historys.add(historyEntity);
                int sort = 0;
                for (OrdSalesbillItemEntity ordSalesbillItemEntity : sourceList) {
                    salesbillItemId = ordSalesbillItemEntity.getSalesbillItemId();
                    customerNo = ordSalesbillItemEntity.getCustomerNo();
                    historyDetail = this.createHistoryDetail(salesbillItemId, BillHistoryTargetType.BILL_ITEM.value(), customerNo, userInfo, operationId, historyId, billItemOperation.value(), ++sort, String.valueOf(SalesBillStatus.NORMAL.value()), String.valueOf(SalesBillStatus.DELETED.value()));
                    historyDetails.add(historyDetail);
                }
                for (OrdSalesbillItemEntity ordSalesbillItemEntity : targetList) {
                    salesbillItemId = ordSalesbillItemEntity.getSalesbillItemId();
                    customerNo = ordSalesbillItemEntity.getCustomerNo();
                    historyDetail = this.createHistoryDetail(salesbillItemId, BillHistoryTargetType.BILL_ITEM.value(), customerNo, userInfo, operationId, historyId, billItemOperation.value(), sort, String.valueOf(SalesBillStatus.DELETED.value()), String.valueOf(SalesBillStatus.NORMAL.value()));
                    historyDetails.add(historyDetail);
                }
            } else {
                Set collect = sourceList.stream().map(m -> m.getSalesbillId()).collect(Collectors.toSet());
                for (Long salesBillId : collect) {
                    ArrayList tempItemList = Lists.newArrayList();
                    sourceList.stream().forEach(m -> {
                        if (m.getSalesbillId().equals(salesBillId)) {
                            tempItemList.add(m);
                        }
                    });
                    long historyId = this.idGenerator.nextId();
                    OrdSalesbillItemEntity tempItem = (OrdSalesbillItemEntity)((Object)tempItemList.get(0));
                    Long salesbillId = tempItem.getSalesbillId();
                    String customerNo = tempItem.getCustomerNo();
                    OrdSalesbillHistoryEntity historyEntity = this.spellHistory(splitAndMergeLogOperationBean, salesbillId, customerNo, userInfo, operationId, historyId);
                    historys.add(historyEntity);
                    int sort = 0;
                    for (OrdSalesbillItemEntity ordSalesbillItemEntity : tempItemList) {
                        Long salesbillItemId = ordSalesbillItemEntity.getSalesbillItemId();
                        String detailCustomerNo = ordSalesbillItemEntity.getCustomerNo();
                        OrdSalesbillHistoryDetailEntity historyDetail = this.createHistoryDetail(salesbillItemId, BillHistoryTargetType.BILL_ITEM.value(), detailCustomerNo, userInfo, operationId, historyId, billItemOperation.value(), ++sort, String.valueOf(SalesBillStatus.NORMAL.value()), String.valueOf(SalesBillStatus.DELETED.value()));
                        historyDetails.add(historyDetail);
                    }
                    OrdSalesbillHistoryDetailEntity historyDetail = this.createHistoryDetail(salesbillId, BillHistoryTargetType.BILL.value(), customerNo, userInfo, operationId, historyId, billItemOperation.value(), sort, String.valueOf(SalesBillStatus.NORMAL.value()), String.valueOf(SalesBillStatus.DELETED.value()));
                    historyDetails.add(historyDetail);
                }
                long targeHistoryId = this.idGenerator.nextId();
                OrdSalesbillItemEntity targe = targetList.get(0);
                OrdSalesbillHistoryEntity targeHistoryEntity = this.spellHistory(splitAndMergeLogOperationBean, targe.getSalesbillId(), targe.getCustomerNo(), userInfo, operationId, targeHistoryId);
                historys.add(targeHistoryEntity);
                for (OrdSalesbillItemEntity ordSalesbillItemEntity : targetList) {
                    Long salesbillItemId = ordSalesbillItemEntity.getSalesbillItemId();
                    String customerNo = ordSalesbillItemEntity.getCustomerNo();
                    OrdSalesbillHistoryDetailEntity historyDetail = this.createHistoryDetail(salesbillItemId, BillHistoryTargetType.BILL_ITEM.value(), customerNo, userInfo, operationId, targeHistoryId, billItemOperation.value(), 0, String.valueOf(SalesBillStatus.DELETED.value()), String.valueOf(SalesBillStatus.NORMAL.value()));
                    historyDetails.add(historyDetail);
                }
                OrdSalesbillHistoryDetailEntity historyDetail = this.createHistoryDetail(targe.getSalesbillId(), BillHistoryTargetType.BILL.value(), targe.getCustomerNo(), userInfo, operationId, targeHistoryId, billItemOperation.value(), 0, String.valueOf(SalesBillStatus.DELETED.value()), String.valueOf(SalesBillStatus.NORMAL.value()));
                historyDetails.add(historyDetail);
            }
            this.billBatchDao.historyBatchInsert((BatchParameter<OrdSalesbillHistoryEntity>)BatchParameter.wrap((List)historys));
            this.billBatchDao.historyDetailBatchInsert((BatchParameter<OrdSalesbillHistoryDetailEntity>)BatchParameter.wrap((List)historyDetails));
        }
    }

    private String spellHistoryDesc(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean) {
        BillOperationType billItemOperation = splitAndMergeLogOperationBean.getBillItemOperation();
        List<OrdSalesbillItemEntity> sourceList = splitAndMergeLogOperationBean.getSourceList();
        OrdSalesbillEntity billTarge = splitAndMergeLogOperationBean.getBillTarge();
        String desc = "";
        switch (billItemOperation) {
            case MERGE: {
                String remark = "";
                if (billTarge == null) {
                    OrdSalesbillItemEntity itemEntity = sourceList.get(0);
                    String salesbillNo = itemEntity.getSalesbillNo();
                    remark = "\u7531\u3010" + salesbillNo + "\u3011\u5185" + sourceList.size() + "\u6761\u660e\u7ec6\uff0c\u5408\u5e76\u4e3a\u4e00\u6761\u4e1a\u52a1\u5355\u660e\u7ec6";
                } else {
                    Set collect = sourceList.stream().map(m -> m.getSalesbillId()).collect(Collectors.toSet());
                    ArrayList list = Lists.newArrayList(collect);
                    remark = list.size() <= 5 ? "\u7531\u3010" + list + "\u3011\u5408\u5e76\u4e3a\u4e00\u6761\u660e\u7ec6" : "\u7531\u3010" + sourceList.size() + "\u3011\u6761\u660e\u7ec6\u5408\u5e76\u4e3a\u4e00\u6761\u660e\u7ec6";
                }
                desc = String.format(MERGE_FORMAT_STR, remark);
            }
        }
        return desc;
    }

    private OrdSalesbillHistoryEntity spellHistory(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean, Long salesBillId, String customerNo, UserInfo userInfo, Long operationId, Long historyId) {
        OrdSalesbillHistoryEntity ordSalesbillHistoryEntity = new OrdSalesbillHistoryEntity();
        ordSalesbillHistoryEntity.setSalesbillHistoryId(historyId);
        ordSalesbillHistoryEntity.setCreateTime(new Date());
        ordSalesbillHistoryEntity.setOpreateUserName(userInfo.getUserName());
        ordSalesbillHistoryEntity.setOperateUserId(userInfo.getUserId());
        ordSalesbillHistoryEntity.setCreateUser(userInfo.getUserId());
        ordSalesbillHistoryEntity.setAction(splitAndMergeLogOperationBean.getBillItemOperation().getDesc());
        ordSalesbillHistoryEntity.setActionBatch(operationId);
        ordSalesbillHistoryEntity.setCreateUser(splitAndMergeLogOperationBean.getUserId());
        ordSalesbillHistoryEntity.setOperateTime(ordSalesbillHistoryEntity.getCreateTime());
        ordSalesbillHistoryEntity.setOperateStatus(BillHistoryStatus.NORMAL.value());
        String desc = this.spellHistoryDesc(splitAndMergeLogOperationBean);
        ordSalesbillHistoryEntity.setOperateContext(desc);
        ordSalesbillHistoryEntity.setCustomerNo(customerNo);
        ordSalesbillHistoryEntity.setSourceSalesbillId(salesBillId);
        ordSalesbillHistoryEntity.setTargetSalesbillId(salesBillId);
        return ordSalesbillHistoryEntity;
    }

    public OrdSalesbillHistoryDetailEntity createHistoryDetail(Long id, Integer targetType, String customerNo, UserInfo userInfo, Long actionBatch, Long historyId, Integer actionType, Integer sort, String oldValue, String newValue) {
        OrdSalesbillHistoryDetailEntity ordSalesbillHistoryDetailEntity = new OrdSalesbillHistoryDetailEntity();
        ordSalesbillHistoryDetailEntity.setOrdSalesbillHistoryId(historyId);
        ordSalesbillHistoryDetailEntity.setCreateTime(new Date());
        ordSalesbillHistoryDetailEntity.setActionBatch(actionBatch);
        ordSalesbillHistoryDetailEntity.setSalesbillHistoryDetailId(this.idGenerator.nextId());
        ordSalesbillHistoryDetailEntity.setActionType(actionType);
        ordSalesbillHistoryDetailEntity.setFieldCname("\u72b6\u6001");
        ordSalesbillHistoryDetailEntity.setOldValue(oldValue);
        ordSalesbillHistoryDetailEntity.setNewValue(newValue);
        ordSalesbillHistoryDetailEntity.setFieldEname("status");
        ordSalesbillHistoryDetailEntity.setTargetId(id);
        ordSalesbillHistoryDetailEntity.setTargetType(targetType);
        ordSalesbillHistoryDetailEntity.setActionSort(sort);
        ordSalesbillHistoryDetailEntity.setCustomerNo(customerNo != null ? customerNo : "");
        ordSalesbillHistoryDetailEntity.setSellerTenantId(0L);
        ordSalesbillHistoryDetailEntity.setPurchaserTenantId(0L);
        ordSalesbillHistoryDetailEntity.setCreateUser(userInfo.getUserId());
        return ordSalesbillHistoryDetailEntity;
    }
}

