/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.component.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.component.AddHistoryLog;
import com.xforceplus.phoenix.bill.component.BillUpdateOperationBean;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryActionType;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryTargetType;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillHistoryDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillHistoryDetailDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryDetailEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.coderbee.mybatis.batch.BatchParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateHistoryLog")
public class UpdateHistoryLogImpl
implements AddHistoryLog {
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private OrdSalesbillHistoryDao ordSalesbillHistoryDao;
    @Autowired
    private OrdSalesbillHistoryDetailDao ordSalesbillHistoryDetailDao;
    @Autowired
    private SalesBillBatchDao billBatchDao;

    @Override
    public void addLog(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean, UserInfo userInfo, Long operationId) {
        OrdSalesbillHistoryDetailEntity ordSalesbillHistoryDetailEntity;
        List<BillUpdateOperationBean> billItemUpdateList = splitAndMergeLogOperationBean.getBillItemUpdateList();
        List<BillUpdateOperationBean> billUpdateList = splitAndMergeLogOperationBean.getBillUpdateList();
        int sort = 0;
        Long salesbillId = splitAndMergeLogOperationBean.getBillTarge().getSalesbillId();
        Long historyId = this.idGenerator.nextId();
        StringBuilder optMsg = new StringBuilder();
        optMsg.append("\u3010\u4fee\u6539\u8bb0\u5f55\u3011");
        ArrayList historyDetails = Lists.newArrayList();
        if (billUpdateList != null) {
            for (BillUpdateOperationBean billUpdateOperationBean : billUpdateList) {
                ordSalesbillHistoryDetailEntity = new OrdSalesbillHistoryDetailEntity();
                ordSalesbillHistoryDetailEntity.setCreateTime(new Date());
                ordSalesbillHistoryDetailEntity.setSalesbillHistoryDetailId(this.idGenerator.nextId());
                ordSalesbillHistoryDetailEntity.setActionBatch(operationId);
                ordSalesbillHistoryDetailEntity.setFieldEname(billUpdateOperationBean.getFieldName());
                ordSalesbillHistoryDetailEntity.setTargetId(billUpdateOperationBean.getId());
                ordSalesbillHistoryDetailEntity.setTargetType(BillHistoryTargetType.BILL.value());
                ordSalesbillHistoryDetailEntity.setActionType(BillHistoryActionType.UPDATE.value());
                ordSalesbillHistoryDetailEntity.setOldValue(String.valueOf(billUpdateOperationBean.getOldValue()));
                ordSalesbillHistoryDetailEntity.setFieldCname(billUpdateOperationBean.getFieldCname());
                ordSalesbillHistoryDetailEntity.setNewValue(String.valueOf(billUpdateOperationBean.getNewValue()));
                ordSalesbillHistoryDetailEntity.setActionSort(sort++);
                ordSalesbillHistoryDetailEntity.setCreateUser(userInfo.getUserId());
                ordSalesbillHistoryDetailEntity.setCustomerNo("");
                ordSalesbillHistoryDetailEntity.setOrdSalesbillHistoryId(historyId);
                if (optMsg.length() <= 200) {
                    String fieldCname = billUpdateOperationBean.getFieldCname();
                    String oldValue = billUpdateOperationBean.getOldValue();
                    String newValue = billUpdateOperationBean.getNewValue();
                    if (CommonTools.isEmpty(oldValue)) {
                        optMsg.append("\u3010").append(fieldCname).append("\u3011\u8865\u5168\u4e3a").append(newValue).append(";<br/>");
                    } else {
                        optMsg.append("\u3010").append(fieldCname).append("\u3011\u7531").append(oldValue).append("\u4fee\u6539\u4e3a").append(newValue).append(";<br/>");
                    }
                }
                historyDetails.add(ordSalesbillHistoryDetailEntity);
            }
        }
        if (billItemUpdateList != null) {
            for (BillUpdateOperationBean billUpdateOperationBean : billItemUpdateList) {
                ordSalesbillHistoryDetailEntity = new OrdSalesbillHistoryDetailEntity();
                ordSalesbillHistoryDetailEntity.setCreateTime(new Date());
                ordSalesbillHistoryDetailEntity.setSalesbillHistoryDetailId(this.idGenerator.nextId());
                ordSalesbillHistoryDetailEntity.setActionBatch(operationId);
                ordSalesbillHistoryDetailEntity.setFieldEname(billUpdateOperationBean.getFieldName());
                ordSalesbillHistoryDetailEntity.setTargetId(billUpdateOperationBean.getId());
                ordSalesbillHistoryDetailEntity.setTargetType(BillHistoryTargetType.BILL_ITEM.value());
                ordSalesbillHistoryDetailEntity.setActionType(BillHistoryActionType.UPDATE.value());
                ordSalesbillHistoryDetailEntity.setOldValue(String.valueOf(billUpdateOperationBean.getOldValue()));
                ordSalesbillHistoryDetailEntity.setFieldCname(billUpdateOperationBean.getFieldCname());
                ordSalesbillHistoryDetailEntity.setNewValue(String.valueOf(billUpdateOperationBean.getNewValue()));
                ordSalesbillHistoryDetailEntity.setCustomerNo("");
                ordSalesbillHistoryDetailEntity.setActionSort(sort++);
                ordSalesbillHistoryDetailEntity.setCreateUser(userInfo.getUserId());
                ordSalesbillHistoryDetailEntity.setOrdSalesbillHistoryId(historyId);
                ordSalesbillHistoryDetailEntity.setSellerTenantId(0L);
                ordSalesbillHistoryDetailEntity.setPurchaserTenantId(0L);
                if (optMsg.length() <= 200) {
                    String goodsName = billUpdateOperationBean.getGoodsName();
                    String fieldCname = billUpdateOperationBean.getFieldCname();
                    String oldValue = billUpdateOperationBean.getOldValue();
                    String newValue = billUpdateOperationBean.getNewValue();
                    if (CommonTools.isEmpty(goodsName)) {
                        optMsg.append("\u3010").append(fieldCname).append("\u3011").append("\u8865\u5168\u4e3a").append(newValue).append(";<br/>");
                    } else if (!CommonTools.isEmpty(oldValue)) {
                        optMsg.append("\u3010").append(goodsName).append("\u3011:").append("\u3010").append(fieldCname).append("\u3011\u7531").append(oldValue).append("\u4fee\u6539\u4e3a").append(newValue).append(";<br/>");
                    } else {
                        optMsg.append("\u3010").append(goodsName).append("\u3011:").append("\u3010").append(fieldCname).append("\u3011").append("\u8865\u5168\u4e3a").append(newValue).append(";<br/>");
                    }
                }
                historyDetails.add(ordSalesbillHistoryDetailEntity);
            }
        }
        this.billBatchDao.historyDetailBatchInsert((BatchParameter<OrdSalesbillHistoryDetailEntity>)BatchParameter.wrap((List)historyDetails));
        OrdSalesbillHistoryEntity ordSalesbillHistoryEntity = new OrdSalesbillHistoryEntity();
        ordSalesbillHistoryEntity.setSalesbillHistoryId(historyId);
        ordSalesbillHistoryEntity.setCreateTime(new Date());
        ordSalesbillHistoryEntity.setOpreateUserName(userInfo.getUserName());
        ordSalesbillHistoryEntity.setOperateUserId(userInfo.getUserId());
        ordSalesbillHistoryEntity.setCreateUser(userInfo.getUserId());
        ordSalesbillHistoryEntity.setCustomerNo("");
        ordSalesbillHistoryEntity.setAction(splitAndMergeLogOperationBean.getBillItemOperation().getDesc());
        ordSalesbillHistoryEntity.setActionBatch(operationId);
        ordSalesbillHistoryEntity.setCreateUser(splitAndMergeLogOperationBean.getUserId());
        ordSalesbillHistoryEntity.setOperateTime(ordSalesbillHistoryEntity.getCreateTime());
        ordSalesbillHistoryEntity.setOperateStatus(BillHistoryStatus.NORMAL.value());
        ordSalesbillHistoryEntity.setOperateContext(optMsg.toString());
        ordSalesbillHistoryEntity.setSourceSalesbillId(salesbillId);
        ordSalesbillHistoryEntity.setTargetSalesbillId(salesbillId);
        this.ordSalesbillHistoryDao.insertSelective(ordSalesbillHistoryEntity);
    }
}

