/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.configuration.rabbit;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitBindingConfiguration {
    @Bean
    public Queue invoiceRedQueue() {
        return new Queue("bill.red.invoice");
    }

    @Bean
    TopicExchange invoiceRedExchange() {
        return new TopicExchange("sellerInvoice.redflushInvoiceReleaseBillNotify");
    }

    @Bean
    Binding bindingInvoiceRedExchange(Queue invoiceRedQueue, TopicExchange invoiceRedExchange) {
        return BindingBuilder.bind((Queue)invoiceRedQueue).to(invoiceRedExchange).with("bill.red.invoice");
    }

    @Bean
    public Queue invoiceAbandonQueue() {
        return new Queue("bill.abandon.invoice");
    }

    @Bean
    TopicExchange invoiceAbandonExchange() {
        return new TopicExchange("sellerInvoice.abandonInvoiceReleaseBillNotify");
    }

    @Bean
    Binding bindingInvoiceAbandonExchange(Queue invoiceAbandonQueue, TopicExchange invoiceAbandonExchange) {
        return BindingBuilder.bind((Queue)invoiceAbandonQueue).to(invoiceAbandonExchange).with("bill.abandon.invoice");
    }

    @Bean
    public Queue invoiceCompleteQueue() {
        return new Queue("bill.invoice.makeOut");
    }

    @Bean
    TopicExchange invoiceCompleteExchange() {
        return new TopicExchange("sellerInvoice.makeOutInvoiceNotify");
    }

    @Bean
    Binding bindingInvoiceCompleteExchange(Queue invoiceCompleteQueue, TopicExchange invoiceCompleteExchange) {
        return BindingBuilder.bind((Queue)invoiceCompleteQueue).to(invoiceCompleteExchange).with("makeOutInvoiceNotice");
    }
}

