/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.configuration.threadpool;

import com.xforceplus.phoenix.bill.configuration.threadpool.ExecutorTraceDecorator;
import com.xforceplus.phoenix.bill.configuration.threadpool.TaskThreadPoolConfig;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class TaskExecutePool
implements AsyncConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TaskThreadPoolConfig config;

    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.config.getCorePoolSize());
        executor.setMaxPoolSize(this.config.getMaxPoolSize());
        executor.setQueueCapacity(this.config.getQueueCapacity());
        executor.setKeepAliveSeconds(this.config.getKeepAliveSeconds());
        executor.setThreadNamePrefix("Bill-Executor");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return new ExecutorTraceDecorator((Executor)executor);
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new AsyncUncaughtExceptionHandler(){

            public void handleUncaughtException(Throwable arg0, Method arg1, Object ... arg2) {
                TaskExecutePool.this.logger.error("==========================" + arg0.getMessage() + "=======================", arg0);
                TaskExecutePool.this.logger.error("exception method:" + arg1.getName());
            }
        };
    }
}

