/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.BillHistoryResponse;
import com.xforceplus.phoenix.bill.client.model.BillHistoryVO;
import com.xforceplus.phoenix.bill.component.BillHisotryBean;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.component.SplitMergeHistoryComponent;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryActionType;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryTargetType;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.core.service.BillHistoryService;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillHistoryDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillHistoryDetailDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillSourceRelDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillSourceRollbackLogDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillHistoryExtDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryDetailEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryDetailExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRelEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRelExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRollbackLogEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRollbackLogExample;
import com.xforceplus.phoenix.bill.utils.SqlUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BillHistoryServiceImpl
implements BillHistoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BillHistoryServiceImpl.class);
    private static final String SQL = "UPDATE %S set %s = %s where %s = %s";
    private static final String BILL_UPDATE_SQL = "UPDATE %S set %s = %s+%s where %s = %s";
    @Autowired
    private OrdSalesbillHistoryDao ordSalesbillHistoryDao;
    @Autowired
    private OrdSalesbillHistoryDetailDao ordSalesbillHistoryDetailDao;
    @Autowired
    private SalesBillHistoryExtDao salesBillHistoryExtDao;
    @Autowired
    private SplitMergeHistoryComponent splitMergeHistoryComponent;
    @Autowired
    private OrdSalesbillSourceRelDao ordSalesbillHistoryRelDao;
    @Autowired
    OrdSalesbillSourceRollbackLogDao ordSalesbillSourceRollbackLogDao;
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;

    @Override
    public BillHistoryResponse queryBillHistory(Long billId) {
        OrdSalesbillHistoryExample example = new OrdSalesbillHistoryExample();
        example.createCriteria().andTargetSalesbillIdEqualTo(billId);
        example.setOrderByClause("operate_time desc");
        List<OrdSalesbillHistoryEntity> targetHistoryEntitys = this.ordSalesbillHistoryDao.selectByExample(example);
        if (CollectionUtils.isEmpty(targetHistoryEntitys)) {
            BillHistoryResponse response = new BillHistoryResponse();
            response.setCode(Response.OK);
            return response;
        }
        boolean flag = false;
        Iterator<OrdSalesbillHistoryEntity> iterator = targetHistoryEntitys.iterator();
        ArrayList historyEntities = Lists.newArrayList();
        while (iterator.hasNext()) {
            OrdSalesbillHistoryEntity entry = iterator.next();
            BillHistoryVO vo = new BillHistoryVO();
            vo.operationDesc(entry.getOperateContext());
            vo.operationContent(entry.getOperateContext());
            vo.setId(String.valueOf(entry.getSalesbillHistoryId()));
            vo.setOperationUserName(entry.getOpreateUserName());
            vo.setOperationTime(String.valueOf(entry.getOperateTime().getTime()));
            if (BillOperationType.SPLIT.getDesc().equals(entry.getAction()) && !flag && entry.getOperateStatus().intValue() == BillHistoryStatus.NORMAL.value()) {
                vo.setCanRollBack(Integer.valueOf(1));
                flag = true;
            } else if (BillOperationType.UPDATE.getDesc().equals(entry.getAction()) && !flag && entry.getOperateStatus().intValue() == BillHistoryStatus.NORMAL.value()) {
                vo.setCanRollBack(Integer.valueOf(1));
                flag = true;
            } else if (BillOperationType.MERGE.getDesc().equals(entry.getAction()) && !flag && entry.getOperateStatus().intValue() == BillHistoryStatus.NORMAL.value()) {
                vo.setCanRollBack(Integer.valueOf(1));
                flag = true;
            } else {
                vo.setCanRollBack(Integer.valueOf(0));
            }
            historyEntities.add(vo);
        }
        BillHistoryResponse response = new BillHistoryResponse();
        response.setCode(Response.OK);
        response.setResult((List)historyEntities);
        return response;
    }

    @Override
    public Response historyRollBack(Long historyId) {
        LOGGER.debug("-------------\u56de\u64a4\u64cd\u4f5c--------------{}", (Object)historyId);
        OrdSalesbillHistoryEntity history = this.ordSalesbillHistoryDao.selectByPrimaryKey(historyId);
        if (history == null || BillHistoryStatus.NORMAL.value() != history.getOperateStatus().intValue()) {
            return Response.failed((String)"\u6b64\u64cd\u4f5c\u5df2\u88ab\u56de\u64a4\u6216\u4e0d\u5b58\u5728");
        }
        Long actionBatch = history.getActionBatch();
        this.salesBillHistoryExtDao.updateHistoryToRollBack(actionBatch);
        this.rollbackOper(actionBatch);
        ArrayList<BillHisotryBean> hisotryBeans = new ArrayList<BillHisotryBean>();
        BillHisotryBean billHisotryBean = new BillHisotryBean();
        billHisotryBean.setBillItemOperation(BillOperationType.ROLL_BACK);
        billHisotryBean.setSourceId(history.getSourceSalesbillId());
        billHisotryBean.setUserId(history.getCreateUser());
        billHisotryBean.setDesc("\u64cd\u4f5c\u56de\u64a4," + actionBatch);
        hisotryBeans.add(billHisotryBean);
        SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean = new SplitAndMergeHistoryOperationBean();
        splitAndMergeLogOperationBean.setBillItemOperation(BillOperationType.ROLL_BACK);
        splitAndMergeLogOperationBean.setHisotryBeans(hisotryBeans);
        this.splitMergeHistoryComponent.billHitoryOper(splitAndMergeLogOperationBean);
        return Response.from((Integer)Response.OK, (String)"\u56de\u64a4\u5b8c\u6210");
    }

    @Override
    public Response checkIsRollbackable(Long histoyId) {
        LOGGER.debug("-------------\u5f00\u59cb\u6267\u884c\u56de\u64a4\u68c0\u67e5hisroy\u5165\u53e3--------------{}", (Object)histoyId);
        OrdSalesbillHistoryEntity history = this.ordSalesbillHistoryDao.selectByPrimaryKey(histoyId);
        if (history == null || BillHistoryStatus.NORMAL.value() != history.getOperateStatus().intValue()) {
            return Response.failed((String)"\u6b64\u64cd\u4f5c\u5df2\u88ab\u56de\u64a4\u6216\u4e0d\u5b58\u5728");
        }
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        if (userInfo.getUserId() != history.getOperateUserId().longValue()) {
            return Response.failed((String)"\u64cd\u4f5c\u4eba\u53ea\u80fd\u56de\u64a4\u81ea\u5df1\u7684\u64cd\u4f5c");
        }
        Long actionBatch = history.getActionBatch();
        OrdSalesbillSourceRelExample ordSalesbillSourceRelExample = new OrdSalesbillSourceRelExample();
        ordSalesbillSourceRelExample.createCriteria().andActionBatchEqualTo(actionBatch).andRelStatusEqualTo(BillHistoryStatus.NORMAL.value());
        if (this.ordSalesbillHistoryRelDao.countByExample(ordSalesbillSourceRelExample) > 0L) {
            List<OrdSalesbillSourceRelEntity> ordSalesbillSourceRelEntities = this.ordSalesbillHistoryRelDao.selectByExample(ordSalesbillSourceRelExample);
            for (OrdSalesbillSourceRelEntity tmp : ordSalesbillSourceRelEntities) {
                if (tmp.getSourceSalesbillItemId() == 0L) continue;
                OrdSalesbillSourceRelExample tmpExample = new OrdSalesbillSourceRelExample();
                tmpExample.createCriteria().andSourceSalesbillItemIdEqualTo(tmp.getTargetSalesbillItemId()).andRelStatusEqualTo(BillHistoryStatus.NORMAL.value());
                if (this.ordSalesbillHistoryRelDao.countByExample(tmpExample) <= 0L) continue;
                return Response.failed((String)"\u6b64\u64cd\u4f5c\u5b58\u5728\u540e\u7eed\u64cd\u4f5c\uff0c\u4e0d\u80fd\u76f4\u63a5\u64a4\u56de\uff0c\u8bf7\u5148\u64a4\u56de\u540e\u7eed\u64cd\u4f5c");
            }
        }
        return Response.ok((String)"\u56de\u64a4\u6821\u9a8c\u901a\u8fc7");
    }

    @Transactional(rollbackFor={Exception.class})
    public void rollbackOper(Long batchNo) {
        LOGGER.debug("batchNo:{}----------------\u6267\u884c\u56de\u64a4\u65b9\u6cd5--------------------", (Object)batchNo);
        OrdSalesbillHistoryDetailExample example = new OrdSalesbillHistoryDetailExample();
        example.createCriteria().andActionBatchEqualTo(batchNo);
        List<OrdSalesbillHistoryDetailEntity> list = this.ordSalesbillHistoryDetailDao.selectByExample(example);
        StringBuilder sqlsb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            OrdSalesbillHistoryDetailEntity detailEntity = list.get(i);
            String colomnName = SqlUtils.camel2Underline(detailEntity.getFieldEname());
            Long targetid = detailEntity.getTargetId();
            String sql = "";
            if (BillHistoryTargetType.BILL.value() == detailEntity.getTargetType().intValue()) {
                try {
                    sql = "update ord_salesbill set " + colomnName + "=" + detailEntity.getOldValue() + " where salesbill_id = " + targetid;
                    this.salesBillHistoryExtDao.excutBatchSql(sql);
                }
                catch (Exception e) {
                    sql = "update ord_salesbill set " + colomnName + "='" + detailEntity.getOldValue() + "' where salesbill_id = " + targetid;
                    this.salesBillHistoryExtDao.excutBatchSql(sql);
                }
            } else if (BillHistoryTargetType.BILL_ITEM.value() == detailEntity.getTargetType().intValue()) {
                try {
                    sql = "update ord_salesbill_item set " + colomnName + "=" + detailEntity.getOldValue() + " where salesbill_item_id = " + targetid;
                    this.salesBillHistoryExtDao.excutBatchSql(sql);
                }
                catch (Exception e) {
                    sql = "update ord_salesbill_item set " + colomnName + "='" + detailEntity.getOldValue() + "' where salesbill_item_id = " + targetid;
                    this.salesBillHistoryExtDao.excutBatchSql(sql);
                }
            }
            sqlsb.append(sql).append("; ");
        }
        this.rollBackSource(batchNo);
        LOGGER.debug("\u6267\u884c\u56de\u64a4\u64cd\u4f5cBatchNo:{} \u6267\u884c\u7684sql\uff1a{}", (Object)batchNo, (Object)sqlsb.toString());
    }

    private String runRollBack(OrdSalesbillHistoryDetailEntity entity) {
        Integer targetType = entity.getTargetType();
        Integer actionType = entity.getActionType();
        BillHistoryActionType billHistoryActionType = BillHistoryActionType.fromValue(actionType);
        BillHistoryTargetType billHistoryTargetType = BillHistoryTargetType.fromValue(targetType);
        String sqlFormat = SQL;
        if (billHistoryTargetType == BillHistoryTargetType.BILL && billHistoryActionType == BillHistoryActionType.MINUS) {
            sqlFormat = BILL_UPDATE_SQL;
        }
        return this.rollbackOper(entity, billHistoryTargetType, sqlFormat);
    }

    private String rollbackOper(OrdSalesbillHistoryDetailEntity entity, BillHistoryTargetType billHistoryTargetType, String sqlFormat) {
        String filedName = entity.getFieldEname();
        Long targetId = entity.getTargetId();
        String oldValue = entity.getOldValue();
        String sql = String.format(sqlFormat, billHistoryTargetType.getTableName(), filedName, oldValue, billHistoryTargetType.getIdName(), targetId);
        return sql;
    }

    @Transactional(rollbackFor={Exception.class})
    public void rollBackSource(Long batchNo) {
        OrdSalesbillSourceRollbackLogExample example = new OrdSalesbillSourceRollbackLogExample();
        example.createCriteria().andActionBatchEqualTo(batchNo);
        List<OrdSalesbillSourceRollbackLogEntity> rollSourceList = this.ordSalesbillSourceRollbackLogDao.selectByExample(example);
        rollSourceList.stream().forEach(item -> {
            String sql = String.format(SQL, "ord_salesbill_source_rel", item.getFieldEname(), item.getOldValue(), "source_salesbill_rel_id", item.getTargetId());
            LOGGER.debug("\u56de\u6eda\u6eaf\u6e90\u8868\u8bb0\u5f55\u6267\u884csql===={}", (Object)sql);
            this.salesBillHistoryExtDao.excutBatchSql(sql);
        });
    }
}

