/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.core.service.BillImportService;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSaleBillImportExtDao;
import com.xforceplus.phoenix.bill.repository.model.modelext.OrdSaleBillImportExtEntity;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.apimodel.file.ImportResponse;
import com.xforceplus.xplatframework.apimodel.file.ImportResult;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillImportServiceImpl
implements BillImportService {
    private static final Logger logger = LoggerFactory.getLogger(BillImportServiceImpl.class);
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private OrdSaleBillImportExtDao ordSaleBillImportExtDao;
    @Autowired
    private RabbitmqService rabbitmqService;

    @Override
    public ImportResponse getImportResult(Long importBatchNo) {
        ImportResponse billImportResponse = new ImportResponse();
        billImportResponse.setCode(Response.OK);
        ImportResult billImportResult = new ImportResult();
        billImportResponse.setResult(billImportResult);
        billImportResult.setFail(Integer.valueOf(0));
        billImportResult.setSuccess(Integer.valueOf(0));
        List<OrdSaleBillImportExtEntity> resultList = null;
        try {
            resultList = this.ordSaleBillImportExtDao.queryBillProcessStatusByImportBatchNo(importBatchNo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u636e\u5bfc\u5165\u7ed3\u679c\u5931\u8d25:{}", (Object)importBatchNo, (Object)e);
        }
        billImportResult.setFail(Integer.valueOf(0));
        billImportResult.setSuccess(Integer.valueOf(0));
        if (resultList != null && !resultList.isEmpty()) {
            resultList.forEach(entity -> {
                switch (entity.getProcessFlag()) {
                    case "S": {
                        billImportResult.setSuccess(Integer.valueOf(entity.getTotal()));
                        break;
                    }
                    case "F": {
                        billImportResult.setFail(Integer.valueOf(entity.getTotal()));
                        break;
                    }
                }
            });
        }
        return billImportResponse;
    }

    @Override
    public Response geneateImportFailReasonExcel(Long importBatchNo, String fileOriginName) {
        logger.info("importBatchNo:{}", (Object)importBatchNo);
        logger.info("fileOriginName:{}", (Object)fileOriginName);
        HashMap headers = Maps.newHashMap();
        headers.put("importBatchNo", importBatchNo);
        headers.put("userInfo", JsonUtils.writeObjectToJson((Object)this.userInfoHolder.get()));
        headers.put("fileOriginName", fileOriginName);
        this.rabbitmqService.send("phoenix.bill.import.fail.reason", "", (Map)headers);
        return Response.from((Integer)Response.OK, (String)"");
    }
}

