/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.baidu.unbiz.fluentvalidator.FluentValidator;
import com.baidu.unbiz.fluentvalidator.Result;
import com.baidu.unbiz.fluentvalidator.ResultCollectors;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.model.BillDetailResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleRequest;
import com.xforceplus.phoenix.bill.client.model.GetPreMergeBillItemDataFromEsRequest;
import com.xforceplus.phoenix.bill.client.model.MergeBillItemRequest;
import com.xforceplus.phoenix.bill.client.model.MergeBillItemValidatePreviewRequest;
import com.xforceplus.phoenix.bill.client.model.PreMergeBillItemDataResponse;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.client.model.SplitBillItemPreviewRequest;
import com.xforceplus.phoenix.bill.client.model.SplitBillItemRequest;
import com.xforceplus.phoenix.bill.component.BillUpdateOperationBean;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.component.SplitMergeHistoryComponent;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryActionType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemMergeType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.service.BillItemSplitAndMergeService;
import com.xforceplus.phoenix.bill.core.service.BillQueryService;
import com.xforceplus.phoenix.bill.core.tools.CommonTools;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemMergeValidate;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitPreviewValidator;
import com.xforceplus.phoenix.bill.manager.SalesbillManager;
import com.xforceplus.phoenix.bill.manager.SalesbillMergeAndSplitManager;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BillItemSplitAndMergeServiceImpl
implements BillItemSplitAndMergeService {
    private static final Logger logger = LoggerFactory.getLogger(BillItemSplitAndMergeServiceImpl.class);
    private static final int SOURCE_BILL_ITEM_MERGE_MIN_NUM = 2;
    private IDGenerator idGenerator;
    private OrdSalesbillItemDao ordSalesbillItemDao;
    private OrdSalesbillDao ordSalesbillDao;
    private BillItemSplitPreviewValidator billItemSplitPreviewValidator;
    private BillItemMergeValidate billItemMergeValidate;
    private SplitMergeHistoryComponent splitMergeHistoryComponent;
    private BillQueryService billQueryService;
    private SalesbillManager salesbillManager;

    @Autowired
    public BillItemSplitAndMergeServiceImpl(IDGenerator idGenerator, OrdSalesbillItemDao ordSalesbillItemDao, OrdSalesbillDao ordSalesbillDao, BillItemSplitPreviewValidator billItemSplitPreviewValidator, BillItemMergeValidate billItemMergeValidate, SplitMergeHistoryComponent splitMergeHistoryComponent, BillQueryService billQueryService, SalesbillManager salesbillManager) {
        this.idGenerator = idGenerator;
        this.ordSalesbillItemDao = ordSalesbillItemDao;
        this.ordSalesbillDao = ordSalesbillDao;
        this.billItemSplitPreviewValidator = billItemSplitPreviewValidator;
        this.billItemMergeValidate = billItemMergeValidate;
        this.splitMergeHistoryComponent = splitMergeHistoryComponent;
        this.billQueryService = billQueryService;
        this.salesbillManager = salesbillManager;
    }

    @Override
    public Response splitBillItemPreview(SplitBillItemPreviewRequest splitBillItemPreviewRequest, UserInfo userInfo) {
        Long sourceSalesbillItemId;
        try {
            sourceSalesbillItemId = NumberUtils.createLong((String)splitBillItemPreviewRequest.getSourceSalesbillItemId());
        }
        catch (Exception e) {
            logger.warn("BillItemSplitAndMergeServiceImpl splitBillItemPreview msg:{}", (Object)e.getMessage());
            return Response.failed((String)"\u539f\u5355\u636e\u660e\u7ec6\u4f20\u9012\u9519\u8bef.");
        }
        OrdSalesbillItemEntity sourceOrdSalesbillItemEntity = this.salesbillManager.getOrdSalesbillItemEntityById(sourceSalesbillItemId);
        if (null == sourceOrdSalesbillItemEntity || !sourceOrdSalesbillItemEntity.getStatus().equals(BillItemStatus.NORMAL.value())) {
            return Response.failed((String)"\u5f85\u62c6\u5206\u5355\u636e\u660e\u7ec6\u4e0d\u5b58\u5728\u6216\u975e\u6b63\u5e38\u72b6\u6001.");
        }
        OrdSalesbillEntity sourceOrdSalesbillEntity = this.salesbillManager.getOrdSalesbillEntityById(sourceOrdSalesbillItemEntity.getSalesbillId());
        if (null == sourceOrdSalesbillEntity || !sourceOrdSalesbillEntity.getStatus().equals(SalesBillStatus.NORMAL.value())) {
            return Response.failed((String)"\u5f85\u62c6\u5206\u5355\u636e\u5934\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u975e\u6b63\u5e38\u72b6\u6001.");
        }
        Result checkResult = (Result)FluentValidator.checkAll().putAttribute2Context("sourceOrdSalesbillEntity", (Object)sourceOrdSalesbillEntity).putAttribute2Context("sourceOrdSalesbillItemEntity", (Object)sourceOrdSalesbillItemEntity).putAttribute2Context("groupId", (Object)userInfo.getGroupId()).on((Object)splitBillItemPreviewRequest, (Validator)this.billItemSplitPreviewValidator).doValidate().result(ResultCollectors.toSimple());
        if (!checkResult.isSuccess()) {
            return Response.failed((String)checkResult.getErrors().toString());
        }
        Response response = Response.ok((String)"\u9884\u89c8\u6821\u9a8c\u7ed3\u679c\u6210\u529f");
        response.setResult((Object)splitBillItemPreviewRequest.getSalesbillItemSplitList());
        return response;
    }

    @Override
    public Response splitBillItem(SplitBillItemRequest splitbillItemRequest, UserInfo userInfo) {
        SplitBillItemPreviewRequest request = new SplitBillItemPreviewRequest();
        request.setSalesbillItemSplitList(splitbillItemRequest.getSalesbillItemSplitList());
        request.setSourceSalesbillItemId(splitbillItemRequest.getSourceSalesbillItemId());
        request.setSplitByCalcType(splitbillItemRequest.getSplitByCalcType());
        request.setSplitType(splitbillItemRequest.getSplitType());
        request.setUserRole(splitbillItemRequest.getUserRole());
        Response response = this.splitBillItemPreview(request, userInfo);
        if (response.getCode().intValue() == Response.Fail.intValue()) {
            return response;
        }
        return this.processSplitBillItem(request, splitbillItemRequest, userInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    public Response processSplitBillItem(SplitBillItemPreviewRequest request, SplitBillItemRequest splitbillItemRequest, UserInfo userInfo) {
        OrdSalesbillItemEntity sourceOrdSalesbillItemEntity = this.salesbillManager.getOrdSalesbillItemEntityById(NumberUtils.createLong((String)splitbillItemRequest.getSourceSalesbillItemId()));
        if (null == sourceOrdSalesbillItemEntity) {
            return Response.failed((String)"\u539f\u5355\u636e\u660e\u7ec6\u72b6\u6001\u53d1\u751f\u53d8\u5316.");
        }
        List salesBillItemList = request.getSalesbillItemSplitList();
        ArrayList ordSalesbillItemEntityList = Lists.newArrayList();
        for (SalesbillItem item : salesBillItemList) {
            OrdSalesbillItemEntity targetBillItem = new OrdSalesbillItemEntity();
            CommonTools.copyProperties((Object)sourceOrdSalesbillItemEntity, (Object)targetBillItem);
            CommonTools.copyPropertiesIgnoreNull(item, (Object)targetBillItem);
            targetBillItem.setSalesbillItemId(this.idGenerator.nextId());
            targetBillItem.setSalesbillId(sourceOrdSalesbillItemEntity.getSalesbillId());
            targetBillItem.setCreateTime(new Date());
            targetBillItem.setCreateUser(userInfo.getUserId());
            targetBillItem.setUpdateTime(new Date());
            targetBillItem.setUpdateUser(userInfo.getUserId());
            targetBillItem.setOrigin(BillItemOrigin.SPLIT.value());
            targetBillItem.setLockFlag(0);
            ordSalesbillItemEntityList.add(targetBillItem);
        }
        sourceOrdSalesbillItemEntity.setStatus(BillItemStatus.DELETED.value());
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillItemIdEqualTo(sourceOrdSalesbillItemEntity.getSalesbillItemId());
        criteria.andStatusEqualTo(BillItemStatus.NORMAL.value());
        int updateResult = this.ordSalesbillItemDao.updateByExampleSelective(sourceOrdSalesbillItemEntity, ordSalesbillItemExample);
        if (updateResult != 1) {
            logger.warn("\u539f\u4e1a\u52a1\u5355\u660e\u7ec6Id\uff1a{},\u66f4\u65b0\u5931\u8d25.", (Object)sourceOrdSalesbillItemEntity.getSalesbillItemId());
            throw new RuntimeException("\u539f\u4e1a\u52a1\u5355\u660e\u7ec6Id\uff1a" + sourceOrdSalesbillItemEntity.getSalesbillItemId() + " ,\u66f4\u65b0\u5931\u8d25.");
        }
        for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
            int insertRet = this.ordSalesbillItemDao.insert(itemEntity);
            if (insertRet == 1) continue;
            logger.warn("\u62c6\u5206\u540e\u7684\u4e1a\u52a1\u5355\u63d2\u5165\u5931\u8d25.");
            throw new RuntimeException("\u62c6\u5206\u540e\u7684\u4e1a\u52a1\u5355\u63d2\u5165\u5931\u8d25.");
        }
        this.salesbillManager.updateCooperateModifyStatus(sourceOrdSalesbillItemEntity.getSalesbillId(), 1, -1);
        this.sendSplitOperationLog(ordSalesbillItemEntityList, sourceOrdSalesbillItemEntity, userInfo);
        return Response.ok((String)"\u62c6\u5206\u6210\u529f!");
    }

    @Override
    public Response mergeBillItemValidatePreview(MergeBillItemValidatePreviewRequest mergeBillItemValidatePreviewRequest) {
        if (Objects.isNull(mergeBillItemValidatePreviewRequest) || CollectionUtils.isEmpty((Collection)mergeBillItemValidatePreviewRequest.getSalesbillItemIdList())) {
            return Response.failed((String)"\u5408\u5e76\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        List<Long> itemIdList = mergeBillItemValidatePreviewRequest.getSalesbillItemIdList().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIdList) || itemIdList.size() < 2) {
            return Response.failed((String)"\u5f85\u5408\u5e76\u5355\u636e\u660e\u7ec6\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e2.");
        }
        List<OrdSalesbillItemEntity> ordSalesbillItemEntityList = this.salesbillManager.getOrdSalesbillItemEntityByIds(itemIdList);
        if (itemIdList.size() != ordSalesbillItemEntityList.size()) {
            return Response.failed((String)"\u5f85\u5408\u5e76\u5355\u636e\u660e\u7ec6\u4e0e\u53c2\u6570\u4f20\u9012\u6570\u91cf\u4e0d\u4e00\u81f4.");
        }
        List<Long> salesBillIdList = ordSalesbillItemEntityList.stream().filter(Objects::nonNull).map(OrdSalesbillItemEntity::getSalesbillId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesBillIdList) || salesBillIdList.size() < 1) {
            return Response.failed((String)"\u5f85\u5408\u5e76\u8bb0\u5f55\u5934\u4fe1\u606f\u4e0d\u5b58\u5728.");
        }
        List<OrdSalesbillEntity> ordSalesbillEntityList = this.salesbillManager.getOrdSalesbillEntityByIds(salesBillIdList, SalesBillStatus.NORMAL);
        if (CollectionUtils.isEmpty(ordSalesbillEntityList) || salesBillIdList.size() != ordSalesbillEntityList.size()) {
            return Response.failed((String)"\u5f85\u5408\u5e76\u8bb0\u5f55\u5934\u4fe1\u606f\u4e0d\u5168.");
        }
        Integer quantityPriceResult = mergeBillItemValidatePreviewRequest.getQuantityPriceResult();
        if (Objects.isNull(quantityPriceResult) || Stream.of(BillItemMergeType.values()).noneMatch(t -> t.value().equals(quantityPriceResult))) {
            return Response.failed((String)"\u91d1\u989d\u5408\u5e76\u65b9\u5f0f\u4e0d\u5408\u6cd5.");
        }
        Result checkResult = (Result)FluentValidator.checkAll().putAttribute2Context("ORD_SALESBILL_ENTITY_LIST", ordSalesbillEntityList).putAttribute2Context("ORD_SALESBILL_ITEM_ENTITY_LIST", ordSalesbillItemEntityList).on((Object)mergeBillItemValidatePreviewRequest, (Validator)this.billItemMergeValidate).doValidate().result(ResultCollectors.toSimple());
        if (!checkResult.isSuccess()) {
            return Response.failed((String)checkResult.getErrors().toString());
        }
        HashMap salesbillMap = Maps.newHashMap();
        salesbillMap.put("ORD_SALESBILL_ENTITY_LIST", ordSalesbillEntityList);
        salesbillMap.put("ORD_SALESBILL_ITEM_ENTITY_LIST", ordSalesbillItemEntityList);
        Response response = Response.ok((String)"\u5408\u5e76\u6821\u9a8c\u6210\u529f.");
        response.setResult((Object)salesbillMap);
        return response;
    }

    @Override
    public Response mergeBillItem(MergeBillItemRequest mergeBillItemRequest, UserInfo userInfo) {
        MergeBillItemValidatePreviewRequest validatePreviewRequest = new MergeBillItemValidatePreviewRequest();
        validatePreviewRequest.setQuantityPriceResult(mergeBillItemRequest.getQuantityPriceResult());
        validatePreviewRequest.setSalesbillItem(mergeBillItemRequest.getSalesbillItem());
        validatePreviewRequest.setSalesbillItemIdList(mergeBillItemRequest.getSalesbillItemIdList());
        Response response = this.mergeBillItemValidatePreview(validatePreviewRequest);
        if (response.getCode().intValue() == Response.Fail.intValue()) {
            return response;
        }
        Map salesbillMap = (Map)response.getResult();
        if (CollectionUtils.isEmpty((Map)salesbillMap)) {
            return Response.failed((String)"\u5f85\u5408\u5e76\u5355\u636e\u6570\u636e\u52a0\u8f7d\u5931\u8d25.");
        }
        List ordSalesbillEntityList = (List)salesbillMap.get("ORD_SALESBILL_ENTITY_LIST");
        List sourceOrdSalesbillItemEntityList = (List)salesbillMap.get("ORD_SALESBILL_ITEM_ENTITY_LIST");
        List<Long> salesBillItemIdList = sourceOrdSalesbillItemEntityList.stream().map(item -> item.getSalesbillItemId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return this.processMergeBillItem(ordSalesbillEntityList, sourceOrdSalesbillItemEntityList, mergeBillItemRequest, salesBillItemIdList, userInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    public Response processMergeBillItem(List<OrdSalesbillEntity> ordSalesbillEntityList, List<OrdSalesbillItemEntity> sourceOrdSalesbillItemEntityList, MergeBillItemRequest mergeBillItemRequest, List<Long> salesBillItemIdList, UserInfo userInfo) {
        logger.info("mergeBillItemRequest.getSalesbillItem():{}", (Object)JsonUtils.writeObjectToFastJson(mergeBillItemRequest.getSalesbillItem()));
        ArrayList billUpdateList = Lists.newArrayList();
        if (ordSalesbillEntityList.size() == 1) {
            OrdSalesbillItemEntity targetBillItem = this.generatorOrdSalesbillItemEntity(sourceOrdSalesbillItemEntityList.get(0), mergeBillItemRequest.getSalesbillItem(), userInfo);
            if (1 != this.ordSalesbillItemDao.insert(targetBillItem)) {
                throw new RuntimeException("\u5355\u636e\u5185\u5408\u5e76\uff1a\u751f\u6210\u65b0\u7684\u5355\u636e\u660e\u7ec6\u5931\u8d25!");
            }
            int affected = this.salesbillManager.updateOrdSalesbillItemEntityStatusByIds(salesBillItemIdList, SalesBillStatus.NORMAL.value(), SalesBillStatus.DELETED.value());
            if (affected != salesBillItemIdList.size()) {
                throw new RuntimeException("\u5355\u636e\u5185\u5408\u5e76\uff1a\u6279\u91cf\u66f4\u65b0\u5355\u636e\u660e\u7ec6\u5931\u8d25!");
            }
            this.sendMergeOperationLog(userInfo, targetBillItem, sourceOrdSalesbillItemEntityList, null, billUpdateList);
            return Response.ok((String)"\u5408\u5e76\u6210\u529f!");
        }
        Response response = this.checkBillHeaderFields(ordSalesbillEntityList);
        if (Objects.nonNull(response)) {
            return response;
        }
        this.mergeBillItemByHeaders(ordSalesbillEntityList, sourceOrdSalesbillItemEntityList, billUpdateList, mergeBillItemRequest.getUserRole(), userInfo.getUserId());
        int affected = this.salesbillManager.updateOrdSalesbillItemEntityStatusByIds(salesBillItemIdList, SalesBillStatus.NORMAL.value(), SalesBillStatus.DELETED.value());
        if (affected != salesBillItemIdList.size()) {
            throw new RuntimeException("\u8de8\u5355\u636e\u5408\u5e76\uff1a\u751f\u6210\u65b0\u7684\u5355\u636e\u660e\u7ec6\u5931\u8d25!");
        }
        OrdSalesbillItemEntity targetBillItem = this.generatorOrdSalesbillItemEntity(sourceOrdSalesbillItemEntityList.get(0), mergeBillItemRequest.getSalesbillItem(), userInfo);
        OrdSalesbillEntity targetSalesbillEntity = this.generatorOrdSalesbillEntity(ordSalesbillEntityList.get(0), targetBillItem, userInfo);
        targetBillItem.setSalesbillId(targetSalesbillEntity.getSalesbillId());
        targetBillItem.setSalesbillNo(targetSalesbillEntity.getSalesbillNo());
        if (1 != this.ordSalesbillItemDao.insert(targetBillItem)) {
            throw new RuntimeException("\u5355\u636e\u5408\u5e76\uff1a\u751f\u6210\u65b0\u7684\u5355\u636e\u660e\u7ec6\u5931\u8d25!");
        }
        if (1 != this.ordSalesbillDao.insert(targetSalesbillEntity)) {
            throw new RuntimeException("\u8de8\u5355\u636e\u5408\u5e76\uff1a\u751f\u6210\u65b0\u7684\u5355\u636e\u5934\u4fe1\u606f\u5931\u8d25!");
        }
        this.sendMergeOperationLog(userInfo, targetBillItem, sourceOrdSalesbillItemEntityList, targetSalesbillEntity, billUpdateList);
        return Response.ok((String)"\u5408\u5e76\u6210\u529f!");
    }

    @Override
    public PreMergeBillItemDataResponse getPreMergeBillItemDataFromEs(GetPreMergeBillItemDataFromEsRequest getPreMergeBillItemDataFromEsRequest, UserInfo userInfo) {
        PreMergeBillItemDataResponse preMergeBillItemDataResponse = new PreMergeBillItemDataResponse();
        preMergeBillItemDataResponse.setCode(Response.Fail);
        GetInvoiceSplitRuleRequest getInvoiceSplitRuleRequest = new GetInvoiceSplitRuleRequest();
        getInvoiceSplitRuleRequest.setUserRole(getPreMergeBillItemDataFromEsRequest.getUserRole());
        getInvoiceSplitRuleRequest.setIsAllSelected(getPreMergeBillItemDataFromEsRequest.getIsAllSelected());
        getInvoiceSplitRuleRequest.setConditions(getPreMergeBillItemDataFromEsRequest.getConditions());
        getInvoiceSplitRuleRequest.setExcludes(getPreMergeBillItemDataFromEsRequest.getExcludes());
        getInvoiceSplitRuleRequest.setIncludes(getPreMergeBillItemDataFromEsRequest.getIncludes());
        if (null == getInvoiceSplitRuleRequest) {
            preMergeBillItemDataResponse.setMessage("\u83b7\u53d6\u5355\u636e\u6570\u636e\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a.");
            return preMergeBillItemDataResponse;
        }
        BillSearchModel billSearchModel = this.salesbillManager.convertMakeoutInvoiceRequest2BillSearchModel(getInvoiceSplitRuleRequest);
        logger.debug("getBillItemInfoFromEs--billSearchModel: {}", (Object)JsonUtils.writeObjectToFastJson(billSearchModel));
        BillDetailResponse billDetailResponse = this.billQueryService.getBillListByDetail(billSearchModel);
        if (null == billDetailResponse || null == billDetailResponse.getResult()) {
            preMergeBillItemDataResponse.setMessage("\u52a0\u8f7d\u5f85\u5f00\u7968\u5355\u636e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a.");
            return preMergeBillItemDataResponse;
        }
        logger.debug("billDetailResponse--data--size:{} ", (Object)billDetailResponse.getResult().getTotal());
        if (billDetailResponse.getResult().getTotal() > 10000L) {
            preMergeBillItemDataResponse.setMessage("\u4e00\u6b21\u5f00\u5177\u660e\u7ec6\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc710000\u6761");
            return preMergeBillItemDataResponse;
        }
        List ordSalesbillDetailVOList = billDetailResponse.getResult().getList();
        if (ordSalesbillDetailVOList.stream().map(ordSalesbillDetailVO -> SalesbillMergeAndSplitManager.getSellerPurchaseInfoKey(ordSalesbillDetailVO)).distinct().count() > 1L) {
            preMergeBillItemDataResponse.setMessage("\u8d2d\u3001\u9500\u65b9\u6216\u53d1\u7968\u7c7b\u578b\u4fe1\u606f\u4e0d\u4e00\u81f4..");
            return preMergeBillItemDataResponse;
        }
        preMergeBillItemDataResponse.setResult(billDetailResponse.getResult().getList());
        preMergeBillItemDataResponse.setCode(Response.OK);
        preMergeBillItemDataResponse.setMessage("\u83b7\u53d6\u6210\u529f.");
        return preMergeBillItemDataResponse;
    }

    private Response checkBillHeaderFields(List<OrdSalesbillEntity> ordSalesbillEntityList) {
        for (OrdSalesbillEntity ordSalesbillEntity : ordSalesbillEntityList) {
            if (ordSalesbillEntity.getAlreadyMakeAmountWithoutTax().compareTo(BigDecimal.ZERO) <= 0) continue;
            return Response.failed((String)String.format("\u5355\u636e\u3010%s\u3011\u7684\u5df2\u5f00\u91d1\u989d\u5927\u4e8e0.", ordSalesbillEntity.getSalesbillNo()));
        }
        return null;
    }

    private void mergeBillItemByHeaders(List<OrdSalesbillEntity> ordSalesbillEntityList, List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, List<BillUpdateOperationBean> billUpdateList, Integer userRole, Long updateUser) {
        Map<Long, OrdSalesbillEntity> ordSalesbillEntityMap = ordSalesbillEntityList.stream().collect(Collectors.toMap(OrdSalesbillEntity::getSalesbillId, item -> item));
        Map<Long, List<OrdSalesbillItemEntity>> itemEntityMap = ordSalesbillItemEntityList.stream().collect(Collectors.groupingBy(OrdSalesbillItemEntity::getSalesbillId));
        for (Map.Entry<Long, List<OrdSalesbillItemEntity>> entry : itemEntityMap.entrySet()) {
            Long salesBillId = entry.getKey();
            List<OrdSalesbillItemEntity> itemEntityList = entry.getValue();
            OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
            OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
            criteria.andSalesbillIdEqualTo(salesBillId);
            criteria.andStatusEqualTo(BillItemStatus.NORMAL.value());
            List<OrdSalesbillItemEntity> allOrdSalesbillItemEntityList = this.ordSalesbillItemDao.selectByExample(ordSalesbillItemExample);
            if (allOrdSalesbillItemEntityList.size() == itemEntityList.size()) {
                this.salesbillManager.deleteOrdSalesbillEntityStatusByIds(Lists.newArrayList((Object[])new Long[]{salesBillId}), SalesBillStatus.NORMAL.value(), SalesBillStatus.DELETED.value(), 0L, userRole == 1 ? "AR" : "AP", updateUser);
                this.setBillStatusFieldList(salesBillId, BillHistoryActionType.UPDATE, String.valueOf(SalesBillStatus.NORMAL.value()), String.valueOf(SalesBillStatus.DELETED.value()), billUpdateList);
                continue;
            }
            OrdSalesbillEntity ordSalesbillEntity = ordSalesbillEntityMap.get(salesBillId);
            BigDecimal[] fields = this.calcAmountBySalesbillItemEntitiyList(itemEntityList, ordSalesbillEntity);
            OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
            OrdSalesbillExample.Criteria criteria1 = ordSalesbillExample.createCriteria();
            criteria1.andSalesbillIdEqualTo(ordSalesbillEntity.getSalesbillId());
            criteria.andStatusEqualTo(BillItemStatus.NORMAL.value());
            int affected = this.ordSalesbillDao.updateByExample(ordSalesbillEntity, ordSalesbillExample);
            if (affected != 1) {
                throw new RuntimeException("\u8de8\u5355\u636e\u5408\u5e76\uff1a\u5355\u636e\u5931\u8d25.");
            }
            this.fillBillUpdateOperationBeanList(fields, salesBillId, billUpdateList);
        }
    }

    private BigDecimal[] calcAmountBySalesbillItemEntitiyList(List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, OrdSalesbillEntity ordSalesbillEntity) {
        BigDecimal[] fields = new BigDecimal[15];
        BigDecimal outterDiscountWithTax = BigDecimal.ZERO;
        BigDecimal outterDiscountWithoutTax = BigDecimal.ZERO;
        BigDecimal outterDiscountTax = BigDecimal.ZERO;
        BigDecimal innerDiscountWithTax = BigDecimal.ZERO;
        BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO;
        BigDecimal innerDiscountTax = BigDecimal.ZERO;
        BigDecimal outterPrepayAmountWithTax = BigDecimal.ZERO;
        BigDecimal outterPrepayAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal outterPrepayAmountTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountWithTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountTax = BigDecimal.ZERO;
        BigDecimal amountWithTax = BigDecimal.ZERO;
        BigDecimal amountWithoutTax = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
            outterDiscountWithTax = outterDiscountWithTax.add(itemEntity.getOutterDiscountWithTax());
            outterDiscountWithoutTax = outterDiscountWithoutTax.add(itemEntity.getOutterDiscountWithoutTax());
            outterDiscountTax = outterDiscountTax.add(itemEntity.getOutterDiscountTax());
            innerDiscountWithTax = innerDiscountWithTax.add(itemEntity.getInnerDiscountWithTax());
            innerDiscountWithoutTax = innerDiscountWithoutTax.add(itemEntity.getInnerDiscountWithoutTax());
            innerDiscountTax = innerDiscountTax.add(itemEntity.getInnerDiscountTax());
            outterPrepayAmountWithTax = outterPrepayAmountWithTax.add(itemEntity.getOutterPrepayAmountWithTax());
            outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax.add(itemEntity.getOutterPrepayAmountWithoutTax());
            outterPrepayAmountTax = outterPrepayAmountTax.add(itemEntity.getOutterPrepayAmountTax());
            innerPrepayAmountWithTax = innerPrepayAmountWithTax.add(itemEntity.getInnerPrepayAmountWithTax());
            innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax.add(itemEntity.getInnerPrepayAmountWithoutTax());
            innerPrepayAmountTax = innerPrepayAmountTax.add(itemEntity.getInnerPrepayAmountTax());
            amountWithTax = amountWithTax.add(itemEntity.getAmountWithTax());
            amountWithoutTax = amountWithoutTax.add(itemEntity.getAmountWithoutTax());
            taxAmount = taxAmount.add(itemEntity.getTaxAmount());
        }
        fields[0] = outterDiscountWithTax;
        fields[1] = outterDiscountWithoutTax;
        fields[2] = outterDiscountTax;
        fields[3] = innerDiscountWithTax;
        fields[4] = innerDiscountWithoutTax;
        fields[5] = innerDiscountTax;
        fields[6] = outterPrepayAmountWithTax;
        fields[7] = outterPrepayAmountWithoutTax;
        fields[8] = outterPrepayAmountTax;
        fields[9] = innerPrepayAmountWithTax;
        fields[10] = innerPrepayAmountWithoutTax;
        fields[11] = innerPrepayAmountTax;
        fields[12] = amountWithTax;
        fields[13] = amountWithoutTax;
        fields[14] = taxAmount;
        this.updateOrdSalesbillEntityByFields(ordSalesbillEntity, fields);
        return fields;
    }

    private void fillBillUpdateOperationBeanList(BigDecimal[] fields, Long salesBillId, List<BillUpdateOperationBean> billUpdateList) {
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "outterDiscountWithTax", fields[0].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "outterDiscountWithoutTax", fields[1].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "innerDiscountWithTax", fields[3].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "innerDiscountWithoutTax", fields[4].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "outterPrepayAmountWithTax", fields[6].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "outterPrepayAmountWithoutTax", fields[7].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "innerPrepayAmountWithTax", fields[9].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "innerPrepayAmountWithoutTax", fields[10].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "amountWithTax", fields[12].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "amountWithoutTax", fields[13].toString(), billUpdateList);
        this.setBillUpdateList(salesBillId, BillHistoryActionType.MINUS, "taxAmount", fields[14].toString(), billUpdateList);
    }

    private void updateOrdSalesbillEntityByFields(OrdSalesbillEntity ordSalesbillEntity, BigDecimal[] fields) {
        ordSalesbillEntity.setOutterDiscountWithTax(ordSalesbillEntity.getOutterDiscountWithTax().subtract(fields[0]));
        ordSalesbillEntity.setOutterDiscountWithoutTax(ordSalesbillEntity.getOutterDiscountWithoutTax().subtract(fields[1]));
        ordSalesbillEntity.setInnerDiscountWithTax(ordSalesbillEntity.getInnerDiscountWithTax().subtract(fields[3]));
        ordSalesbillEntity.setInnerDiscountWithoutTax(ordSalesbillEntity.getInnerDiscountWithoutTax().subtract(fields[4]));
        ordSalesbillEntity.setOutterPrepayAmountWithTax(ordSalesbillEntity.getOutterPrepayAmountWithTax().subtract(fields[6]));
        ordSalesbillEntity.setOutterPrepayAmountWithoutTax(ordSalesbillEntity.getOutterPrepayAmountWithoutTax().subtract(fields[7]));
        ordSalesbillEntity.setInnerPrepayAmountWithTax(ordSalesbillEntity.getInnerPrepayAmountWithTax().subtract(fields[9]));
        ordSalesbillEntity.setInnerPrepayAmountWithoutTax(ordSalesbillEntity.getInnerPrepayAmountWithoutTax().subtract(fields[10]));
        ordSalesbillEntity.setAmountWithTax(ordSalesbillEntity.getAmountWithTax().subtract(fields[12]));
        ordSalesbillEntity.setAmountWithoutTax(ordSalesbillEntity.getAmountWithoutTax().subtract(fields[13]));
        ordSalesbillEntity.setTaxAmount(ordSalesbillEntity.getTaxAmount().subtract(fields[14]));
    }

    private OrdSalesbillItemEntity generatorOrdSalesbillItemEntity(OrdSalesbillItemEntity srcOrdSalesbillItemEntity, SalesbillItem salesbillItem, UserInfo userInfo) {
        OrdSalesbillItemEntity targetBillItem = new OrdSalesbillItemEntity();
        CommonTools.copyProperties((Object)srcOrdSalesbillItemEntity, (Object)targetBillItem);
        CommonTools.copyPropertiesIgnoreNull(salesbillItem, (Object)targetBillItem);
        targetBillItem.setSalesbillItemId(this.idGenerator.nextId());
        targetBillItem.setSalesbillId(srcOrdSalesbillItemEntity.getSalesbillId());
        targetBillItem.setCreateTime(new Date());
        targetBillItem.setCreateUser(userInfo.getUserId());
        targetBillItem.setUpdateTime(new Date());
        targetBillItem.setUpdateUser(userInfo.getUserId());
        targetBillItem.setStatus(BillItemStatus.NORMAL.value());
        targetBillItem.setOrigin(BillItemOrigin.MERGE.value());
        logger.info("generatorOrdSalesbillItemEntity targetBillItem:{}", (Object)JsonUtils.writeObjectToFastJson((Object)targetBillItem));
        logger.info("generatorOrdSalesbillItemEntity targetBillItem:{}", (Object)JsonUtils.writeObjectToFastJson((Object)targetBillItem));
        return targetBillItem;
    }

    private OrdSalesbillEntity generatorOrdSalesbillEntity(OrdSalesbillEntity srcOrdSalesbillEntity, OrdSalesbillItemEntity srcOrdSalesbillItemEntity, UserInfo userInfo) {
        OrdSalesbillEntity targetOrdSalesbillEntity = new OrdSalesbillEntity();
        CommonTools.copyProperties((Object)srcOrdSalesbillEntity, (Object)targetOrdSalesbillEntity);
        CommonTools.copyProperties((Object)srcOrdSalesbillItemEntity, (Object)targetOrdSalesbillEntity);
        targetOrdSalesbillEntity.setSalesbillId(this.idGenerator.nextId());
        targetOrdSalesbillEntity.setSalesbillNo(String.valueOf(this.idGenerator.nextId()));
        targetOrdSalesbillEntity.setCreateTime(new Date());
        targetOrdSalesbillEntity.setCreateUser(userInfo.getUserId());
        targetOrdSalesbillEntity.setUpdateTime(new Date());
        targetOrdSalesbillEntity.setUpdateUser(userInfo.getUserId());
        targetOrdSalesbillEntity.setSysOrgId(srcOrdSalesbillEntity.getSysOrgId());
        return targetOrdSalesbillEntity;
    }

    private void sendSplitOperationLog(List<OrdSalesbillItemEntity> targetBillItemList, OrdSalesbillItemEntity sourceOrdSalesbillItemEntity, UserInfo userInfo) {
        if (!CollectionUtils.isEmpty(targetBillItemList)) {
            targetBillItemList.forEach(ordSalesbillItemEntity -> {
                ordSalesbillItemEntity.setAmountWithTax(ordSalesbillItemEntity.getAmountWithTax().setScale(2, 4));
                ordSalesbillItemEntity.setAmountWithoutTax(ordSalesbillItemEntity.getAmountWithoutTax().setScale(2, 4));
            });
        }
        if (null != sourceOrdSalesbillItemEntity) {
            sourceOrdSalesbillItemEntity.setAmountWithTax(sourceOrdSalesbillItemEntity.getAmountWithTax().setScale(2, 4));
            sourceOrdSalesbillItemEntity.setAmountWithoutTax(sourceOrdSalesbillItemEntity.getAmountWithoutTax().setScale(2, 4));
        }
        SplitAndMergeHistoryOperationBean splitAndMergeHistoryOperationBean = new SplitAndMergeHistoryOperationBean();
        splitAndMergeHistoryOperationBean.setBillItemOperation(BillOperationType.SPLIT);
        splitAndMergeHistoryOperationBean.setTargetList(targetBillItemList);
        splitAndMergeHistoryOperationBean.setSourceList(Lists.newArrayList((Object[])new OrdSalesbillItemEntity[]{sourceOrdSalesbillItemEntity}));
        splitAndMergeHistoryOperationBean.setUserId(userInfo.getUserId());
        try {
            this.splitMergeHistoryComponent.billHitoryOper(splitAndMergeHistoryOperationBean);
        }
        catch (Exception e) {
            logger.warn("==================sendSplitOperationLog \u63a5\u53e3\u62c6\u5206\u65e5\u5fd7\u63d2\u5165\u5f02\u5e38!===================");
            logger.error("sendSplitOperationLog \u63a5\u53e3\u62c6\u5206\u65e5\u5fd7\u63d2\u5165\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void setBillUpdateList(Long salesBillId, BillHistoryActionType billHistoryActionType, String fieldName, String newValue, List<BillUpdateOperationBean> outBillUpdateList) {
        BillUpdateOperationBean billUpdateOperationBean = new BillUpdateOperationBean();
        billUpdateOperationBean.setId(salesBillId);
        billUpdateOperationBean.setBillHistoryOperation(billHistoryActionType);
        billUpdateOperationBean.setFieldName(fieldName);
        billUpdateOperationBean.setNewValue(newValue);
        outBillUpdateList.add(billUpdateOperationBean);
    }

    private void setBillStatusFieldList(Long salesBillId, BillHistoryActionType billHistoryActionType, String oldValue, String newValue, List<BillUpdateOperationBean> outBillUpdateList) {
        BillUpdateOperationBean billUpdateOperationBean = new BillUpdateOperationBean();
        billUpdateOperationBean.setId(salesBillId);
        billUpdateOperationBean.setBillHistoryOperation(billHistoryActionType);
        billUpdateOperationBean.setFieldName("status");
        billUpdateOperationBean.setOldValue(oldValue);
        billUpdateOperationBean.setNewValue(newValue);
        outBillUpdateList.add(billUpdateOperationBean);
    }

    private void sendMergeOperationLog(UserInfo userInfo, OrdSalesbillItemEntity targetOrdSalesbillItemEntity, List<OrdSalesbillItemEntity> sourceList, OrdSalesbillEntity targetBill, List<BillUpdateOperationBean> billUpdateList) {
        SplitAndMergeHistoryOperationBean splitAndMergeHistoryOperationBean = new SplitAndMergeHistoryOperationBean();
        splitAndMergeHistoryOperationBean.setBillItemOperation(BillOperationType.MERGE);
        splitAndMergeHistoryOperationBean.setTargetList(Lists.newArrayList((Object[])new OrdSalesbillItemEntity[]{targetOrdSalesbillItemEntity}));
        splitAndMergeHistoryOperationBean.setSourceList(sourceList);
        splitAndMergeHistoryOperationBean.setBillTarge(targetBill);
        splitAndMergeHistoryOperationBean.setBillUpdateList(billUpdateList);
        splitAndMergeHistoryOperationBean.setUserId(userInfo.getUserId());
        this.splitMergeHistoryComponent.billHitoryOper(splitAndMergeHistoryOperationBean);
    }
}

