/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.alibaba.fastjson.JSON;
import com.baidu.unbiz.fluentvalidator.FluentValidator;
import com.baidu.unbiz.fluentvalidator.Result;
import com.baidu.unbiz.fluentvalidator.ResultCollectors;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.phoenix.bill.cache.bssexternal.LocalBssExternalCacheManager;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.client.makeout.SellerInvoiceSalesClient;
import com.xforceplus.phoenix.bill.client.makeout.SplitAndMakeOutInvoiceClient;
import com.xforceplus.phoenix.bill.client.model.AbandonBillByParamRequest;
import com.xforceplus.phoenix.bill.client.model.BillDetailInfoResponse;
import com.xforceplus.phoenix.bill.client.model.BillDetailResponse;
import com.xforceplus.phoenix.bill.client.model.BillInvoiceItem;
import com.xforceplus.phoenix.bill.client.model.BillItemInfo;
import com.xforceplus.phoenix.bill.client.model.BillMainInfo;
import com.xforceplus.phoenix.bill.client.model.BillMainInfoResponse;
import com.xforceplus.phoenix.bill.client.model.BillQuerySellerInvoice;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.BillResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.BillSellerInvoiceInfo;
import com.xforceplus.phoenix.bill.client.model.BillSplitRuleInfo;
import com.xforceplus.phoenix.bill.client.model.DiscountRequest;
import com.xforceplus.phoenix.bill.client.model.GetBillDetailInfoRequest;
import com.xforceplus.phoenix.bill.client.model.GetBillMainInfoRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceByBillIdsRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceByBillItemIdsRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleResponse;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.MakePreviewInvoiceInfo;
import com.xforceplus.phoenix.bill.client.model.MakeoutInvoiceRequest;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.bill.client.model.PreiewInvoiceTask;
import com.xforceplus.phoenix.bill.client.model.ProductItem;
import com.xforceplus.phoenix.bill.client.model.ProductMainDiscount;
import com.xforceplus.phoenix.bill.client.model.PurchaseInfo;
import com.xforceplus.phoenix.bill.client.model.SalesbillInfo;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.client.model.SplitRuleInfo;
import com.xforceplus.phoenix.bill.client.splitconfig.ConfigApiClient;
import com.xforceplus.phoenix.bill.client.splitconfig.TempConfigClient;
import com.xforceplus.phoenix.bill.constant.BillConstants;
import com.xforceplus.phoenix.bill.constant.enums.BillItemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceMakeOutMode;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillCatalog;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.impl.domain.BatchMakePreviewInvoiceInfo;
import com.xforceplus.phoenix.bill.core.impl.domain.BatchNoMergeInfo;
import com.xforceplus.phoenix.bill.core.service.BillOperationService;
import com.xforceplus.phoenix.bill.core.service.BillQueryService;
import com.xforceplus.phoenix.bill.core.tools.BillSearchTools;
import com.xforceplus.phoenix.bill.core.validator.billoperation.BillOperationValidateTools;
import com.xforceplus.phoenix.bill.core.validator.discount.BillManualDiscountValidator;
import com.xforceplus.phoenix.bill.manager.SalesbillManager;
import com.xforceplus.phoenix.bill.manager.SalesbillMergeAndSplitManager;
import com.xforceplus.phoenix.bill.manager.domian.PageData;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtBean;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.bill.utils.ReflectUtil;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.ItemAssemble;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.NagertiveRuleEnum;
import com.xforceplus.seller.config.client.model.CombinationFieldBean;
import com.xforceplus.seller.config.client.model.ConfigItemDTO;
import com.xforceplus.seller.config.client.model.ItemDTO;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemResponse;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigResponse;
import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.seller.config.client.model.MsTmpConfigResponse;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.BillMergerRuleDTO;
import com.xforceplus.seller.config.client.parse.bean.InvoiceSplitrRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.BillMergeParser;
import com.xforceplus.seller.config.client.parse.impl.InvoiceSplitParser;
import com.xforceplus.seller.invoice.client.model.MsSplitAndMakeOutParams;
import com.xforceplus.seller.invoice.client.model.MsSplitAndMakeOutRequest;
import com.xforceplus.seller.invoice.client.model.QueryInvoicesBySaleItemIdsRequest;
import com.xforceplus.seller.invoice.client.model.QueryInvoicesBySaleItemIdsResponse;
import com.xforceplus.seller.invoice.client.model.QueryInvoicesBySaleItemIdsResult;
import com.xforceplus.xplatframework.apimodel.AsyncModel;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.javatuples.Quartet;
import org.javatuples.Triplet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class BillOperationServiceImpl
implements BillOperationService {
    private static final Logger logger = LoggerFactory.getLogger(BillOperationServiceImpl.class);
    private static final int MAX_ABANDON_BILL_NUMBER = 1000;
    private static final int START_INDEX = 1;
    private static final int MAX_PAGE_SIZE = 500;
    @Autowired
    private BillManualDiscountValidator billManualDiscountValidator;
    @Autowired
    private OrdSalesbillDao ordSalesbillDao;
    @Autowired
    private OrdSalesbillItemDao ordSalesbillItemDao;
    @Autowired
    private BillQueryService billQueryService;
    @Autowired
    private BillMergeParser billMergeParser;
    @Autowired
    private InvoiceSplitParser invoiceSplitParser;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private SplitAndMakeOutInvoiceClient splitAndMakeOutInvoiceClient;
    @Autowired
    private SellerInvoiceSalesClient sellerInvoiceSalesClient;
    @Autowired
    private TempConfigClient tempConfigClient;
    @Autowired
    private ItemAssemble itemAssemble;
    @Autowired
    private LocalConfigMetadataCacheManager localConfigMetadataCacheManager;
    @Autowired
    private SalesbillManager salesbillManager;
    @Autowired
    private SalesbillMergeAndSplitManager salesbillMergeAndSplitManager;
    @Autowired
    private ConfigApiClient configApiClient;
    @Autowired
    LocalBssExternalCacheManager localBssExternalCacheManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Response manualSplitDiscount(DiscountRequest discountRequest, UserInfo userInfo) {
        if (null == discountRequest || null == discountRequest.getMainDiscount()) {
            return Response.failed((String)"\u624b\u52a8\u6298\u6263\u5206\u644a\u5355\u636e\u5934\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        ProductMainDiscount productMainDiscount = discountRequest.getMainDiscount();
        OrdSalesbillEntity dbOrdSalesbillEntity = this.ordSalesbillDao.selectByPrimaryKey(productMainDiscount.getSalesbillId());
        if (null == dbOrdSalesbillEntity || !SalesBillStatus.NORMAL.value().equals(dbOrdSalesbillEntity.getStatus())) {
            return Response.failed((String)"\u624b\u52a8\u6298\u6263\u5206\u644a\u5355\u636e\u5934\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u6216\u975e\u6b63\u5e38\u72b6\u6001.");
        }
        List productItemList = discountRequest.getItemList();
        if (CollectionUtils.isEmpty((Collection)productItemList)) {
            return Response.failed((String)"\u624b\u52a8\u6298\u6263\u5206\u644a\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        List salesBillItemIdList = productItemList.stream().map(item -> item.getSalesbillItemId()).distinct().collect(Collectors.toList());
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillItemIdIn(salesBillItemIdList);
        criteria.andStatusEqualTo(BillItemStatus.NORMAL.value());
        List<OrdSalesbillItemEntity> dbOrdSalesbillItemEntityList = this.ordSalesbillItemDao.selectByExample(ordSalesbillItemExample);
        if (CollectionUtils.isEmpty(dbOrdSalesbillItemEntityList) || dbOrdSalesbillItemEntityList.size() != productItemList.size()) {
            return Response.failed((String)"\u624b\u52a8\u6298\u6263\u5206\u644a\u660e\u7ec6\u4fe1\u606f\u7f3a\u5931.");
        }
        Result checkResult = (Result)FluentValidator.checkAll().putAttribute2Context("dbOrdSalesbillEntity", (Object)dbOrdSalesbillEntity).putAttribute2Context("dbOrdSalesbillItemEntityList", dbOrdSalesbillItemEntityList).on((Object)discountRequest, (Validator)this.billManualDiscountValidator).doValidate().result(ResultCollectors.toSimple());
        if (!checkResult.isSuccess()) {
            return Response.failed((String)checkResult.getErrors().toString());
        }
        OrdSalesbillEntity ordSalesbillEntity = new OrdSalesbillEntity();
        com.xforceplus.phoenix.bill.core.tools.CommonTools.copyProperties((Object)dbOrdSalesbillEntity, (Object)ordSalesbillEntity);
        com.xforceplus.phoenix.bill.core.tools.CommonTools.copyProperties(productMainDiscount, (Object)ordSalesbillEntity);
        ordSalesbillEntity.setUpdateTime(new Date());
        ordSalesbillEntity.setUpdateUser(userInfo.getUserId());
        int affected = this.ordSalesbillDao.updateByPrimaryKey(ordSalesbillEntity);
        if (affected != 1) {
            throw new RuntimeException(String.format("\u5355\u636e\u5934\u3010%s\u3011\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u5e93\u5f02\u5e38.", productMainDiscount.getSalesbillId()));
        }
        Map<Long, ProductItem> productItemMap = productItemList.stream().collect(Collectors.toMap(ProductItem::getSalesbillItemId, item -> item));
        for (OrdSalesbillItemEntity dbOrdSalesbillItemEntity : dbOrdSalesbillItemEntityList) {
            OrdSalesbillItemEntity ordSalesbillItemEntity = new OrdSalesbillItemEntity();
            com.xforceplus.phoenix.bill.core.tools.CommonTools.copyProperties((Object)dbOrdSalesbillItemEntity, (Object)ordSalesbillItemEntity);
            com.xforceplus.phoenix.bill.core.tools.CommonTools.copyProperties(productItemMap.get(dbOrdSalesbillItemEntity.getSalesbillItemId()), (Object)ordSalesbillItemEntity);
            ordSalesbillItemEntity.setUpdateTime(new Date());
            ordSalesbillItemEntity.setUpdateUser(userInfo.getUserId());
            this.derivationDiscountTax(ordSalesbillItemEntity, dbOrdSalesbillEntity.getPriceMethod());
            affected = this.ordSalesbillItemDao.updateByPrimaryKey(ordSalesbillItemEntity);
            if (affected == 1) continue;
            throw new RuntimeException(String.format("\u624b\u52a8\u5206\u644a\uff1a\u5355\u636e\u660e\u7ec6\u3010%s\u3011\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u5e93\u5f02\u5e38.", ordSalesbillItemEntity.getSalesbillItemId()));
        }
        return Response.ok((String)"\u624b\u52a8\u5206\u644a\u6210\u529f.");
    }

    private void derivationDiscountTax(OrdSalesbillItemEntity ordSalesbillItemEntity, Integer priceMethod) {
        if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
            BigDecimal rate = ordSalesbillItemEntity.getTaxRate().add(BigDecimal.ONE);
            BigDecimal outterDiscountTax = ordSalesbillItemEntity.getOutterDiscountWithTax().subtract(ordSalesbillItemEntity.getOutterDiscountWithTax().divide(rate, 15, 4));
            ordSalesbillItemEntity.setOutterDiscountTax(outterDiscountTax);
            BigDecimal innerDiscountTax = ordSalesbillItemEntity.getInnerDiscountWithTax().subtract(ordSalesbillItemEntity.getInnerDiscountWithTax().divide(rate, 15, 4));
            ordSalesbillItemEntity.setInnerDiscountTax(innerDiscountTax);
            BigDecimal outterPrepayAmountTax = ordSalesbillItemEntity.getOutterPrepayAmountWithTax().subtract(ordSalesbillItemEntity.getOutterPrepayAmountWithTax().divide(rate, 15, 4));
            ordSalesbillItemEntity.setOutterPrepayAmountTax(outterPrepayAmountTax);
            BigDecimal innerPrepayAmountTax = ordSalesbillItemEntity.getInnerPrepayAmountWithTax().subtract(ordSalesbillItemEntity.getInnerPrepayAmountWithTax().divide(rate, 15, 4));
            ordSalesbillItemEntity.setInnerPrepayAmountTax(innerPrepayAmountTax);
        } else {
            ordSalesbillItemEntity.setOutterDiscountTax(ordSalesbillItemEntity.getOutterDiscountWithoutTax().multiply(ordSalesbillItemEntity.getTaxRate()));
            ordSalesbillItemEntity.setInnerDiscountTax(ordSalesbillItemEntity.getInnerDiscountWithoutTax().multiply(ordSalesbillItemEntity.getTaxRate()));
            ordSalesbillItemEntity.setOutterPrepayAmountTax(ordSalesbillItemEntity.getOutterPrepayAmountWithoutTax().multiply(ordSalesbillItemEntity.getTaxRate()));
            ordSalesbillItemEntity.setInnerPrepayAmountTax(ordSalesbillItemEntity.getInnerPrepayAmountWithoutTax().multiply(ordSalesbillItemEntity.getTaxRate()));
        }
    }

    @Override
    public Response abandonBill(BillRequest billRequest, String role, UserInfo userInfo) {
        if (null == billRequest || null == billRequest.getConditions()) {
            return Response.failed((String)"\u5355\u636e\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        BillSearchModel billSearchModel = BillSearchTools.getSearchCondition(billRequest, role);
        if (null == billSearchModel) {
            return Response.failed((String)"\u5f85\u4f5c\u5e9f\u7684\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        Integer total = billRequest.getTotal();
        if (total > 1000) {
            return Response.failed((String)String.format("\u4e00\u6b21\u4f5c\u5e9f\u5355\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u6761.", 1000));
        }
        billSearchModel.setPageNo(Integer.valueOf(1));
        billSearchModel.setPageSize(Integer.valueOf(500));
        int pages = total / 500 + 1;
        ArrayList succOrdSalesbillIdList = Lists.newArrayList();
        for (int i = 0; i < pages; ++i) {
            BillResponse queryServiceBillList = this.billQueryService.getBillList(billSearchModel);
            if (null == queryServiceBillList || null == queryServiceBillList.getResult()) {
                logger.info("abandonBill page index:{}, pageList is empty.", (Object)billSearchModel.getPageNo());
                continue;
            }
            List salesbillVOList = queryServiceBillList.getResult().getList();
            if (CollectionUtils.isEmpty((Collection)salesbillVOList)) {
                logger.info("abandonBill page index:{}, pageList is empty.", (Object)billSearchModel.getPageNo());
                continue;
            }
            List<OrdSalesbillEntity> processOrdSalesbillEntityList = BillSearchTools.convertVosToEntites(salesbillVOList);
            List<Long> succCheckBillList = this.preCheckAbandonBillList(processOrdSalesbillEntityList, role);
            if (succCheckBillList.size() > 0) {
                succOrdSalesbillIdList.addAll(succCheckBillList);
            }
            billSearchModel.setPageNo(Integer.valueOf(billSearchModel.getPageNo() + 1));
        }
        if (succOrdSalesbillIdList.size() <= 0) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u5f85\u4f5c\u5e9f\u7684\u5355\u636e.");
        }
        this.salesbillManager.abandonOrdSalesbillEntityStatusByIds(succOrdSalesbillIdList, SalesBillStatus.NORMAL.value(), SalesBillStatus.INVALID.value(), this.idGenerator.nextId(), role, userInfo.getUserId());
        return Response.ok((String)"\u4f5c\u5e9f\u6210\u529f.");
    }

    public List<Long> preCheckAbandonBillList(List<OrdSalesbillEntity> ordSalesbillEntityList, String role) {
        ArrayList succBillList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(ordSalesbillEntityList)) {
            return succBillList;
        }
        ordSalesbillEntityList.forEach(bill -> {
            if (SalesBillStatus.NORMAL.value().equals(bill.getStatus()) && bill.getBusinessBillType().equals(role) && (bill.getUploadConfirmFlag().equals(SalesBillCatalog.CONFIRMING.value()) || bill.getUploadConfirmFlag().equals(SalesBillCatalog.CHANGING.value()) || bill.getUploadConfirmFlag().equals(SalesBillCatalog.WAITING_MAKE_INVOICE.value())) && bill.getAlreadyMakeAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0) {
                long count = this.salesbillManager.countBatchNoSalesBillItemBySalesbillId(bill.getSalesbillId());
                logger.debug("salesbillId:{}, batchNo bill item size:{}", (Object)bill.getSalesbillId(), (Object)count);
                if (0L == count) {
                    succBillList.add(bill.getSalesbillId());
                }
            }
        });
        return succBillList;
    }

    @Override
    public GetInvoiceResponse getInvoiceByBillIds(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u83b7\u53d6\u53d1\u7968\u5217\u8868") @RequestBody GetInvoiceByBillIdsRequest getInvoiceByBillIdsRequest) {
        GetInvoiceResponse getInvoiceResponse = new GetInvoiceResponse();
        if (null == getInvoiceByBillIdsRequest || null == getInvoiceByBillIdsRequest.getBillIdList()) {
            getInvoiceResponse.setCode(Response.Fail);
            getInvoiceResponse.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
            return getInvoiceResponse;
        }
        List<Long> salesbillItemIdList = this.salesbillManager.getSalesBillItemIdList(getInvoiceByBillIdsRequest.getBillIdList(), BillItemStatus.INVOICED.value());
        return this.querySellerInvoiceSalesByItemIdList(salesbillItemIdList);
    }

    @Override
    public GetInvoiceResponse getInvoiceByBillItemIds(GetInvoiceByBillItemIdsRequest getInvoiceByBillItemIdsRequest) {
        GetInvoiceResponse getInvoiceResponse = new GetInvoiceResponse();
        if (null == getInvoiceByBillItemIdsRequest || null == getInvoiceByBillItemIdsRequest.getBillItemIdList()) {
            getInvoiceResponse.setCode(Response.Fail);
            getInvoiceResponse.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
            return getInvoiceResponse;
        }
        List saleItemIds = getInvoiceByBillItemIdsRequest.getBillItemIdList();
        return this.querySellerInvoiceSalesByItemIdList(saleItemIds);
    }

    @Override
    public Response abandonBillByParam(AbandonBillByParamRequest abandonBillByIdsRequest, UserInfo userInfo) {
        List<OrdSalesbillEntity> ordSalesbillList;
        logger.debug("====================abandonBillByParam-{}=======================================", (Object)abandonBillByIdsRequest);
        OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
        OrdSalesbillExample.Criteria criteria = ordSalesbillExample.createCriteria();
        if (StringUtils.isBlank((CharSequence)abandonBillByIdsRequest.getBusinessBillType())) {
            return Response.failed((String)"businessBillType\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (StringUtils.isBlank((CharSequence)abandonBillByIdsRequest.getSellerGroupCode()) && StringUtils.isBlank((CharSequence)abandonBillByIdsRequest.getPurchaserCode()) && StringUtils.isBlank((CharSequence)abandonBillByIdsRequest.getSalesbillNo())) {
            return Response.failed((String)"\u5355\u636e\u6761\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        abandonBillByIdsRequest.setBusinessBillType(abandonBillByIdsRequest.getBusinessBillType().toUpperCase());
        criteria.andBusinessBillTypeEqualTo(abandonBillByIdsRequest.getBusinessBillType());
        if (StringUtils.isNotBlank((CharSequence)abandonBillByIdsRequest.getSellerGroupCode())) {
            criteria.andSellerGroupIdEqualTo(Long.parseLong(abandonBillByIdsRequest.getSellerGroupCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)abandonBillByIdsRequest.getPurchaserCode())) {
            criteria.andPurchaserGroupIdEqualTo(Long.parseLong(abandonBillByIdsRequest.getPurchaserCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)abandonBillByIdsRequest.getSalesbillNo())) {
            criteria.andSalesbillNoEqualTo(abandonBillByIdsRequest.getSalesbillNo());
        }
        if ((ordSalesbillList = this.ordSalesbillDao.selectByExample(ordSalesbillExample)).size() > 1000) {
            return Response.failed((String)String.format("\u4e00\u6b21\u4f5c\u5e9f\u5355\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u6761.", 1000));
        }
        List<Long> succCheckBillList = this.preCheckAbandonBillList(ordSalesbillList, abandonBillByIdsRequest.getBusinessBillType());
        if (succCheckBillList.isEmpty()) {
            return Response.failed((String)"\u5f85\u4f5c\u5e9f\u7684\u4e1a\u52a1\u5355\u636e\u4e3a\u7a7a.");
        }
        this.salesbillManager.abandonOrdSalesbillEntityStatusByIds(succCheckBillList, SalesBillStatus.NORMAL.value(), SalesBillStatus.INVALID.value(), this.idGenerator.nextId(), abandonBillByIdsRequest.getBusinessBillType(), userInfo.getUserId());
        return Response.ok((String)"\u4f5c\u5e9f\u6210\u529f.");
    }

    private GetInvoiceResponse querySellerInvoiceSalesByItemIdList(List<Long> billItemIdList) {
        QueryInvoicesBySaleItemIdsRequest queryInvoicesBySaleItemIdsRequest = new QueryInvoicesBySaleItemIdsRequest();
        queryInvoicesBySaleItemIdsRequest.setSaleItemIds(billItemIdList);
        QueryInvoicesBySaleItemIdsResponse queryInvoicesBySaleItemIdsResponse = this.sellerInvoiceSalesClient.queryInvoicesBySaleItemIds(queryInvoicesBySaleItemIdsRequest);
        GetInvoiceResponse getInvoiceResponse = new GetInvoiceResponse();
        if (null == queryInvoicesBySaleItemIdsResponse || queryInvoicesBySaleItemIdsResponse.getCode().equals(Response.Fail)) {
            getInvoiceResponse.setCode(Response.Fail);
            getInvoiceResponse.setMessage("\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f.");
            return getInvoiceResponse;
        }
        getInvoiceResponse.setCode(queryInvoicesBySaleItemIdsResponse.getCode());
        getInvoiceResponse.setMessage(queryInvoicesBySaleItemIdsResponse.getMessage());
        QueryInvoicesBySaleItemIdsResult queryInvoicesBySaleItemIdsResult = (QueryInvoicesBySaleItemIdsResult)queryInvoicesBySaleItemIdsResponse.getResult();
        List querySellerInvoiceList = queryInvoicesBySaleItemIdsResult.getInvoices();
        ArrayList billQuerySellerInvoiceList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)querySellerInvoiceList)) {
            querySellerInvoiceList.forEach(sellerInvoiceItem -> {
                BillQuerySellerInvoice billQuerySellerInvoice = new BillQuerySellerInvoice();
                BillSellerInvoiceInfo invoice = new BillSellerInvoiceInfo();
                ArrayList items = Lists.newArrayList();
                BeanUtils.copyProperties(sellerInvoiceItem.getInvoice(), invoice);
                if (!CollectionUtils.isEmpty((Collection)sellerInvoiceItem.getItems())) {
                    sellerInvoiceItem.getItems().forEach(invoiceItem -> {
                        BillInvoiceItem billInvoiceItem = new BillInvoiceItem();
                        BeanUtils.copyProperties(invoiceItem, billInvoiceItem);
                        items.add(billInvoiceItem);
                    });
                }
                billQuerySellerInvoice.setInvoice(invoice);
                billQuerySellerInvoice.setItems((List)items);
                billQuerySellerInvoiceList.add(billQuerySellerInvoice);
            });
        }
        getInvoiceResponse.result((List)billQuerySellerInvoiceList);
        return getInvoiceResponse;
    }

    private Response getCombinationConfigRule(Map<String, List<OrdSalesbillDetailVO>> psKey2OrdSalesbillDetailVOMap, Map<List<OrdSalesbillDetailVO>, BaseRuleBean> outOrdSalesbillDetailVO2CombRuleMap, ConfigParser configParser) {
        if (CollectionUtils.isEmpty(psKey2OrdSalesbillDetailVOMap)) {
            return null;
        }
        for (Map.Entry<String, List<OrdSalesbillDetailVO>> groupEntry : psKey2OrdSalesbillDetailVOMap.entrySet()) {
            OrdSalesbillVO ordSalesbillVO = groupEntry.getValue().get(0).getOrdSalesbillVO();
            BaseRuleBean baseRuleBean = this.localConfigMetadataCacheManager.getBillGroupRuleBean(ordSalesbillVO, configParser);
            if (Objects.isNull(baseRuleBean)) {
                logger.warn("\u5355\u636e\u4e3b\u952e:{}\u83b7\u53d6\u89c4\u5219\u5931\u8d25.", (Object)ordSalesbillVO.getSalesbillId());
                return Response.failed((String)String.format("\u5355\u636e\u53f7\u3010%s\u3011\u83b7\u53d6\u5206\u7ec4\u914d\u7f6e\u89c4\u5219\u5931\u8d25.", ordSalesbillVO.getSalesbillNo()));
            }
            outOrdSalesbillDetailVO2CombRuleMap.put(groupEntry.getValue(), baseRuleBean);
        }
        return null;
    }

    private MakeOutInvoiceResponse sendMakeOutMessage(Long batchNo, MakeoutInvoiceRequest makeoutInvoiceRequest, Long ruleId, List<List<Long>> outGroupSalesbillIdList) {
        BaseAsyncResponse baseAsyncResponse;
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        MsSplitAndMakeOutRequest msSplitAndMakeOutRequest = new MsSplitAndMakeOutRequest();
        ArrayList paramList = Lists.newArrayList();
        MsSplitAndMakeOutParams msSplitAndMakeOutParams = new MsSplitAndMakeOutParams();
        msSplitAndMakeOutParams.setBatchNo(batchNo);
        msSplitAndMakeOutParams.setPurchaserAddress(makeoutInvoiceRequest.getPurchaserAddress());
        msSplitAndMakeOutParams.setPurchaserBankAccount(makeoutInvoiceRequest.getPurchaserBankAccount());
        msSplitAndMakeOutParams.setPurchaserBankName(makeoutInvoiceRequest.getPurchaserBankName());
        msSplitAndMakeOutParams.setPurchaserName(makeoutInvoiceRequest.getPurchaserName());
        msSplitAndMakeOutParams.setPurchaserTaxNo(makeoutInvoiceRequest.getPurchaserTaxNo());
        msSplitAndMakeOutParams.setPurchaserTel(makeoutInvoiceRequest.getPurchaserTel());
        msSplitAndMakeOutParams.setRuleId(ruleId);
        msSplitAndMakeOutParams.setMode(String.valueOf(InvoiceMakeOutMode.PRE_MAKEOUT.value()));
        msSplitAndMakeOutParams.setRemark(makeoutInvoiceRequest.getRemark());
        paramList.add(msSplitAndMakeOutParams);
        msSplitAndMakeOutRequest.setParamList((List)paramList);
        try {
            baseAsyncResponse = this.splitAndMakeOutInvoiceClient.makeOut(msSplitAndMakeOutRequest);
            if (null == baseAsyncResponse || baseAsyncResponse.getCode().equals(BaseResponse.Fail)) {
                logger.warn("\u9884\u5236\u53d1\u7968\u751f\u6210\u5931\u8d25.");
                throw new RuntimeException("\u9884\u5236\u53d1\u7968\u751f\u6210\u5931\u8d25.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("\u9884\u5236\u53d1\u7968\u751f\u6210\u5931\u8d25.");
            int affected = this.salesbillManager.updateOrdSalesbillItemEntityBatchNoByIds(outGroupSalesbillIdList.get(0), batchNo, 0L, 0L, BillItemStatus.PRE_INVOICED.value(), BillItemStatus.NORMAL.value());
            if (affected != outGroupSalesbillIdList.get(0).size()) {
                throw new RuntimeException("\u5355\u636e\u5f00\u7968:\u6e05\u7a7a\u6279\u6b21\u53f7\u5931\u8d25.");
            }
            throw new RuntimeException("\u9884\u5236\u53d1\u7968\u751f\u6210\u5931\u8d25.");
        }
        makeOutInvoiceResponse.setCode(Response.OK);
        makeOutInvoiceResponse.setMessage("\u5f00\u7968\u6d88\u606f\u5df2\u53d1\u51fa.");
        makeOutInvoiceResponse.setResult(baseAsyncResponse.getResult());
        logger.debug("makeOutResponse:" + makeOutInvoiceResponse.toString());
        return makeOutInvoiceResponse;
    }

    private boolean checkRollbackIsError(List<Long> salesbillItemIdList) {
        if (CollectionUtils.isEmpty(salesbillItemIdList)) {
            return true;
        }
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillItemIdIn((List)salesbillItemIdList);
        List<OrdSalesbillItemEntity> ordSalesbillItemEntityList = this.ordSalesbillItemDao.selectByExample(ordSalesbillItemExample);
        if (!CollectionUtils.isEmpty(ordSalesbillItemEntityList)) {
            for (OrdSalesbillItemEntity ordSalesbillItemEntity : ordSalesbillItemEntityList) {
                if (ordSalesbillItemEntity.getBatchNo() <= 0L && ordSalesbillItemEntity.getStatus().equals(BillItemStatus.NORMAL.value())) continue;
                return false;
            }
        }
        return true;
    }

    private PurchaseInfo getPurchaseInfo(OrdSalesbillVO ordSalesbillVO) {
        PurchaseInfo purchaseInfo = new PurchaseInfo();
        purchaseInfo.setPurchaserName(ordSalesbillVO.getPurchaserName());
        purchaseInfo.setPurchaserTaxNo(ordSalesbillVO.getPurchaserTaxNo());
        purchaseInfo.setPurchaserTel(ordSalesbillVO.getPurchaserTel());
        purchaseInfo.setPurchaserAddress(ordSalesbillVO.getPurchaserAddress());
        purchaseInfo.setPurchaserBankAccount(ordSalesbillVO.getPurchaserBankAccount());
        purchaseInfo.setPurchaserBankName(ordSalesbillVO.getPurchaserBankName());
        return purchaseInfo;
    }

    @Override
    public GetInvoiceSplitRuleResponse getInvoiceSplitRule(GetInvoiceSplitRuleRequest getInvoiceSplitRuleRequest, UserInfo userInfo) {
        GetInvoiceSplitRuleResponse getInvoiceSplitRuleResponse = new GetInvoiceSplitRuleResponse();
        getInvoiceSplitRuleResponse.setCode(Response.Fail);
        ArrayList outDetailVOBatchNoSplitRuleIdTripletList = Lists.newArrayList();
        MakeOutInvoiceResponse response = this.prepareMakeOutInvoiceDataInfo(getInvoiceSplitRuleRequest, outDetailVOBatchNoSplitRuleIdTripletList, userInfo.getGroupId());
        if (Objects.nonNull(response)) {
            getInvoiceSplitRuleResponse.setMessage(response.getMessage());
            return getInvoiceSplitRuleResponse;
        }
        if (CollectionUtils.isEmpty((Collection)outDetailVOBatchNoSplitRuleIdTripletList)) {
            getInvoiceSplitRuleResponse.setMessage("\u6570\u636e\u52a0\u8f7d\u5904\u7406\u6709\u8bef.");
            return getInvoiceSplitRuleResponse;
        }
        Triplet batchTripletEntity = (Triplet)outDetailVOBatchNoSplitRuleIdTripletList.get(0);
        OrdSalesbillVO ordSalesbillVO = ((OrdSalesbillDetailVO)((List)batchTripletEntity.getValue0()).get(0)).getOrdSalesbillVO();
        ConfigRequestModel configRequestModel = new ConfigRequestModel();
        BeanUtils.copyProperties(ordSalesbillVO, configRequestModel);
        SysConfigExtBean sysConfigExtBean = this.localConfigMetadataCacheManager.querySysInfoConfig(configRequestModel, ConfigTypeEnum.SYS_CONFIG_TYPE);
        if (Objects.isNull((Object)sysConfigExtBean)) {
            getInvoiceSplitRuleResponse.setMessage("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u6709\u8bef.");
            return getInvoiceSplitRuleResponse;
        }
        MakePreviewInvoiceInfo makePreviewInvoiceInfo = new MakePreviewInvoiceInfo();
        logger.debug("sysConfigExtBean--------------------:{}", (Object)JsonUtils.writeObjectToFastJson((Object)sysConfigExtBean));
        if (Objects.nonNull(sysConfigExtBean.getBill2PreviewInvoiceSkipFlag()) && 0 == sysConfigExtBean.getBill2PreviewInvoiceSkipFlag()) {
            if (outDetailVOBatchNoSplitRuleIdTripletList.size() > 1) {
                getInvoiceSplitRuleResponse.setMessage("\u5f53\u524d\u9009\u62e9\u7684\u5355\u636e\u4e0d\u80fd\u5728\u4e00\u4e2a\u6279\u6b21\u4e2d\u8fdb\u884c\u5f00\u7968.");
                return getInvoiceSplitRuleResponse;
            }
            BillSplitRuleInfo billSplitRuleInfo = new BillSplitRuleInfo();
            ArrayList invoiceTitleList = Lists.newArrayList();
            invoiceTitleList.add(this.getPurchaseInfo(ordSalesbillVO));
            String invoiceType = ordSalesbillVO.getInvoiceType();
            billSplitRuleInfo.setInvoiceTypeList((List)Lists.newArrayList((Object[])new String[]{invoiceType}));
            billSplitRuleInfo.setInvoiceType(invoiceType);
            billSplitRuleInfo.setInvoiceTitleList((List)invoiceTitleList);
            billSplitRuleInfo.setRemark("");
            billSplitRuleInfo.setConfigId((Long)batchTripletEntity.getValue1());
            String limitAmount = this.handleLimitAount(billSplitRuleInfo.getConfigId(), ordSalesbillVO);
            billSplitRuleInfo.setInvoiceLimit(limitAmount);
            getInvoiceSplitRuleResponse.setCode(Response.OK);
            makePreviewInvoiceInfo.setSkipFlag(BillConstants.SINGLE_BATCH_MAKEOUT_INVOICE);
            makePreviewInvoiceInfo.setData0(billSplitRuleInfo);
            getInvoiceSplitRuleResponse.setResult(makePreviewInvoiceInfo);
            return getInvoiceSplitRuleResponse;
        }
        MakeOutInvoiceResponse makeOutInvoiceResponse = this.processMakeOutInvoice(outDetailVOBatchNoSplitRuleIdTripletList, null, null, getInvoiceSplitRuleRequest.getConditions().getSort());
        getInvoiceSplitRuleResponse.setCode(makeOutInvoiceResponse.getCode());
        getInvoiceSplitRuleResponse.setMessage(makeOutInvoiceResponse.getMessage());
        makePreviewInvoiceInfo.setSkipFlag(BillConstants.MULTIPLE_BATCH_MAKEOUT_INVOICE);
        AsyncModel asyncModel = makeOutInvoiceResponse.getResult();
        logger.debug("asyncModel---------------->:{}", (Object)JsonUtils.writeObjectToFastJson(asyncModel));
        PreiewInvoiceTask preiewInvoiceTask = new PreiewInvoiceTask();
        BeanUtils.copyProperties(asyncModel, preiewInvoiceTask);
        logger.debug("preiewInvoiceTask---------------->:{}", (Object)JsonUtils.writeObjectToFastJson(preiewInvoiceTask));
        makePreviewInvoiceInfo.setData1(preiewInvoiceTask);
        getInvoiceSplitRuleResponse.setResult(makePreviewInvoiceInfo);
        logger.debug("getInvoiceSplitRule--getInvoiceSplitRuleResponse;{}", (Object)JsonUtils.writeObjectToFastJson(getInvoiceSplitRuleResponse));
        return getInvoiceSplitRuleResponse;
    }

    private String handleLimitAount(Long ruleId, OrdSalesbillVO ordSalesbillVO) {
        MsConfigItemQueryRequest itemRequest = new MsConfigItemQueryRequest();
        itemRequest.setConfigId(ruleId.toString());
        MsConfigItemResponse itemResponse = this.configApiClient.queryConfigDetailRule(itemRequest);
        List item = itemResponse.getResult();
        InvoiceSplitParser parser = new InvoiceSplitParser();
        InvoiceSplitrRuleDTO rule = parser.parse(item);
        MsConfigQueryRequestWithUserInfo request = new MsConfigQueryRequestWithUserInfo();
        request.setConfigId(ruleId);
        MsCommonUserInfo msCommonUserInfo = new MsCommonUserInfo();
        msCommonUserInfo.setUserId(Long.valueOf(1L));
        msCommonUserInfo.setGroupId(Long.valueOf(1L));
        request.setUserInfo(msCommonUserInfo);
        MsConfigResponse msConfigResponse = this.configApiClient.queryConfigRule(request);
        if (msConfigResponse != null) {
            List msConfigResponses = msConfigResponse.getResult().getItemDTOList();
            MsConfigBean msConfigBean = (MsConfigBean)msConfigResponses.get(0);
            Long sellerGroupId = msConfigBean.getSellerGroupId();
            Long purchaserGroupId = msConfigBean.getPurchaserGroupId();
            if (sellerGroupId != null && sellerGroupId == 0L && purchaserGroupId != null && purchaserGroupId == 0L) {
                this.handleInvoiceLimitAmount(ordSalesbillVO, rule);
            }
        }
        return rule == null ? "" : rule.getInvoiceLimit().toPlainString();
    }

    private void handleInvoiceLimitAmount(OrdSalesbillVO ordSalesbillVO, InvoiceSplitrRuleDTO rule) {
        String invoiceType;
        String companyTaxNo = ordSalesbillVO.getSellerTaxNo();
        CompanyModel companyModel = this.localBssExternalCacheManager.getCompanyMainInfoByTaxNo(companyTaxNo);
        if (companyModel != null && !CommonTools.isEmpty(invoiceType = ordSalesbillVO.getInvoiceType())) {
            if (InvoiceType.NORMAL.value().equals(invoiceType) && !CommonTools.isEmpty(companyModel.getCquota())) {
                rule.setInvoiceLimit(new BigDecimal(companyModel.getCquota()));
            } else if (InvoiceType.SPECIAL.value().equals(invoiceType) && !CommonTools.isEmpty(companyModel.getSquota())) {
                rule.setInvoiceLimit(new BigDecimal(companyModel.getSquota()));
            } else if (InvoiceType.ELECTRONIC.value().equals(invoiceType) && !CommonTools.isEmpty(companyModel.getCeQuota())) {
                rule.setInvoiceLimit(new BigDecimal(companyModel.getCeQuota()));
            } else if (InvoiceType.ROLL.value().equals(invoiceType) && !CommonTools.isEmpty(companyModel.getJuQuota())) {
                rule.setInvoiceLimit(new BigDecimal(companyModel.getJuQuota()));
            }
        }
        logger.info("-------------\u5904\u7406\u9ed8\u8ba4\u5f00\u7968\u9650\u989d----\u9650\u989d:{},", (Object)rule.getInvoiceLimit());
    }

    private MakeOutInvoiceResponse prepareMakeOutInvoiceDataInfo(GetInvoiceSplitRuleRequest getInvoiceSplitRuleRequest, List<Triplet<List<OrdSalesbillDetailVO>, Long, Long>> outDetailVOBatchNoSplitRuleIdTripletList, Long groupId) {
        HashMap outOrdSalesbillDetailVO2CombRuleMap;
        MakeOutInvoiceResponse failResponse = new MakeOutInvoiceResponse();
        failResponse.setCode(Response.Fail);
        BillSearchModel billSearchModel = this.salesbillManager.convertMakeoutInvoiceRequest2BillSearchModel(getInvoiceSplitRuleRequest);
        BillDetailResponse response = this.billQueryService.getBillListByDetail(billSearchModel);
        if (Objects.isNull(response) || Objects.isNull(response.getResult())) {
            failResponse.setMessage("\u67e5\u8be2ES\u5f85\u5f00\u7968\u5355\u636e\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a.");
            return failResponse;
        }
        logger.debug("BillDetailResponse--from--es--size:{} ", (Object)response.getResult().getTotal());
        if (response.getResult().getTotal() > 10000L) {
            failResponse.setMessage("\u4e00\u6b21\u5f00\u5177\u660e\u7ec6\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc710000\u6761.");
            return failResponse;
        }
        List ordSalesbillDetailVOList = response.getResult().getList();
        long invoiceTypeCount = ordSalesbillDetailVOList.stream().map(ordSalesbillDetailVO -> ordSalesbillDetailVO.getOrdSalesbillVO().getInvoiceType()).distinct().count();
        if (invoiceTypeCount > 1L) {
            failResponse.setMessage("\u5355\u636e\u53d1\u7968\u7c7b\u578b\u4e0d\u4e00\u81f4.");
            return failResponse;
        }
        failResponse = this.salesbillManager.checkMainAndItemList(ordSalesbillDetailVOList, groupId);
        if (Objects.nonNull(failResponse) && Response.Fail.equals(failResponse.getCode())) {
            return failResponse;
        }
        Map<String, List<OrdSalesbillDetailVO>> psKey2OrdSalesbillDetailVO = ordSalesbillDetailVOList.stream().collect(Collectors.groupingBy(SalesbillMergeAndSplitManager::getSellerPurchaseInfoKey));
        Response groupHeaderResponse = this.getCombinationConfigRule(psKey2OrdSalesbillDetailVO, outOrdSalesbillDetailVO2CombRuleMap = Maps.newHashMap(), (ConfigParser)this.billMergeParser);
        if (Objects.nonNull(groupHeaderResponse)) {
            failResponse.setMessage(groupHeaderResponse.getMessage());
            return failResponse;
        }
        HashMap batchKey2OrdSalesbillDetailVOMap = Maps.newHashMap();
        for (Map.Entry ruleEntry : outOrdSalesbillDetailVO2CombRuleMap.entrySet()) {
            BillMergerRuleDTO billMergerRuleDTO = (BillMergerRuleDTO)ruleEntry.getValue();
            List combinationFieldBeanList = billMergerRuleDTO.getAssociationCondition();
            for (OrdSalesbillDetailVO detailVO : (List)ruleEntry.getKey()) {
                String combinationKey = this.getCombinationKey(combinationFieldBeanList, detailVO);
                List ordSalesbillDetailVOBatchList = (List)batchKey2OrdSalesbillDetailVOMap.get(combinationKey);
                if (CollectionUtils.isEmpty((Collection)ordSalesbillDetailVOBatchList)) {
                    ordSalesbillDetailVOBatchList = Lists.newArrayList();
                }
                ordSalesbillDetailVOBatchList.add(detailVO);
                batchKey2OrdSalesbillDetailVOMap.put(combinationKey, ordSalesbillDetailVOBatchList);
            }
        }
        logger.debug("batchKey2OrdSalesbillDetailVOMap---------:{}", (Object)JsonUtils.writeObjectToFastJson(batchKey2OrdSalesbillDetailVOMap));
        for (Map.Entry batchEntry : batchKey2OrdSalesbillDetailVOMap.entrySet()) {
            List batchDetailVOList = (List)batchEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)batchDetailVOList)) continue;
            BaseRuleBean baseRuleBean = this.localConfigMetadataCacheManager.getInvoiceSplitRule(((OrdSalesbillDetailVO)batchDetailVOList.get(0)).getOrdSalesbillVO(), (ConfigParser)this.invoiceSplitParser);
            if (Objects.isNull(baseRuleBean)) {
                logger.warn("batchKey:{}---splitRuleDTO:null", batchEntry.getKey());
                failResponse.setMessage("\u62c6\u5206\u89c4\u5219\u83b7\u53d6\u5931\u8d25.");
                return failResponse;
            }
            InvoiceSplitrRuleDTO splitRuleDTO = (InvoiceSplitrRuleDTO)baseRuleBean;
            logger.debug("batchKey:{}---splitRuleDTO:{}", batchEntry.getKey(), (Object)JsonUtils.writeObjectToFastJson(splitRuleDTO));
            Triplet batchOrdSalesbillDetailVOTriplet = Triplet.with(batchEntry.getValue(), (Object)splitRuleDTO.getRuldId(), (Object)this.idGenerator.nextId());
            outDetailVOBatchNoSplitRuleIdTripletList.add((Triplet<List<OrdSalesbillDetailVO>, Long, Long>)batchOrdSalesbillDetailVOTriplet);
        }
        return null;
    }

    private String getCombinationKey(List<CombinationFieldBean> combinationFieldBeanList, OrdSalesbillDetailVO detailVO) {
        logger.debug("combinationFieldBeanList--------------:{}", (Object)JsonUtils.writeObjectToFastJson(combinationFieldBeanList));
        StringBuilder combinationKeyBuilder = new StringBuilder();
        combinationKeyBuilder.append(SalesbillMergeAndSplitManager.getSellerPurchaseInfoKey(detailVO));
        for (CombinationFieldBean combinationFieldBean : combinationFieldBeanList) {
            if (0 == combinationFieldBean.getFieldGroupIndex()) {
                combinationKeyBuilder.append(ReflectUtil.getValue(detailVO.getOrdSalesbillVO(), combinationFieldBean.getField()));
                continue;
            }
            combinationKeyBuilder.append(ReflectUtil.getValue(detailVO.getOrdSalesbillItemVO(), combinationFieldBean.getField()));
        }
        return combinationKeyBuilder.toString();
    }

    private MakeOutInvoiceResponse processMakeOutInvoice(List<Triplet<List<OrdSalesbillDetailVO>, Long, Long>> batchDetailVO2SplitRuleTripletList, MakeoutInvoiceRequest makeoutInvoiceRequest, Long tmpRuleId, SearchSort sort) {
        BaseAsyncResponse baseAsyncResponse;
        MakeOutInvoiceResponse makeOutInvoiceResponse = new MakeOutInvoiceResponse();
        List<BatchMakePreviewInvoiceInfo> batchMakePreviewInvoiceInfoList = this.generatorOrdSalesbillItemEntityBatchNo(batchDetailVO2SplitRuleTripletList, tmpRuleId);
        if (CollectionUtils.isEmpty(batchMakePreviewInvoiceInfoList)) {
            logger.warn("\u751f\u6210\u6279\u6b21\u53f7\u5931\u8d25.");
            throw new RuntimeException("\u751f\u6210\u6279\u6b21\u53f7\u5931\u8d25.");
        }
        logger.debug("processMakeOutInvoice_v1--tmpRuleId:{}--batchMakePreviewInvoiceInfoList:{}", (Object)tmpRuleId, (Object)JsonUtils.writeObjectToFastJson(batchMakePreviewInvoiceInfoList));
        try {
            baseAsyncResponse = this.sendPreMakeOutInvoiceMessage(makeoutInvoiceRequest, batchMakePreviewInvoiceInfoList, sort);
            if (null == baseAsyncResponse || baseAsyncResponse.getCode().equals(BaseResponse.Fail)) {
                logger.warn("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25.");
                throw new RuntimeException("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuilder msgTips = new StringBuilder();
            logger.warn("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5f02\u5e38\u5931\u8d25.batchNoList:{}", batchMakePreviewInvoiceInfoList.stream().map(batchInfo -> batchInfo.getBatchNoMergeInfo().getBatchNo()).collect(Collectors.toList()));
            for (BatchMakePreviewInvoiceInfo batchInfo2 : batchMakePreviewInvoiceInfoList) {
                int affected = this.salesbillManager.updateOrdSalesbillItemEntityBatchNoByIds(batchInfo2.getBatchSalesbillItemIdList(), batchInfo2.getBatchNoMergeInfo().getBatchNo(), 0L, 0L, BillItemStatus.PRE_INVOICED.value(), BillItemStatus.NORMAL.value());
                if (affected == batchInfo2.getBatchSalesbillItemIdList().size()) continue;
                logger.debug("\u56de\u6eda\u6279\u6b21\u53f7batchNo:{}--affected:{}--outGroupSalesbillIdList:{}", new Object[]{batchInfo2.getBatchNoMergeInfo().getBatchNo(), affected, JsonUtils.writeObjectToFastJson(batchInfo2.getBatchSalesbillItemIdList())});
                boolean isRollBack = this.checkRollbackIsError(batchInfo2.getBatchSalesbillItemIdList());
                if (!isRollBack) {
                    msgTips.append(String.format("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!\u56de\u6eda\u6279\u6b21\u53f7\u5931\u8d25,\u9700\u8981\u4eba\u5de5\u5904\u7406.batchNo:%s", batchInfo2.getBatchNoMergeInfo().getBatchNo()));
                    continue;
                }
                msgTips.append(String.format("\u9884\u5236\u53d1\u7968\u6d88\u606f\u53d1\u9001\u5931\u8d25!batchNo:%s \u5df2\u7ecf\u56de\u6eda! salesbillItemList:%s", batchInfo2.getBatchNoMergeInfo().getBatchNo(), batchInfo2.getBatchSalesbillItemIdList()));
            }
            makeOutInvoiceResponse.setCode(Response.Fail);
            makeOutInvoiceResponse.setMessage(msgTips.toString());
            return makeOutInvoiceResponse;
        }
        makeOutInvoiceResponse.setCode(Response.OK);
        makeOutInvoiceResponse.setMessage("\u5f00\u7968\u6d88\u606f\u5df2\u53d1\u51fa.");
        makeOutInvoiceResponse.setResult(baseAsyncResponse.getResult());
        logger.debug("makeOutResponse:" + makeOutInvoiceResponse.toString());
        return makeOutInvoiceResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<BatchMakePreviewInvoiceInfo> generatorOrdSalesbillItemEntityBatchNo(List<Triplet<List<OrdSalesbillDetailVO>, Long, Long>> batchDetailVO2SplitRuleTripletList, Long tempRuleId) {
        logger.debug("batchDetailVO2SplitRuleTripletList------------>{}", (Object)JsonUtils.writeObjectToFastJson(batchDetailVO2SplitRuleTripletList));
        ArrayList batchMakePreviewInvoiceInfoList = Lists.newArrayList();
        for (Triplet<List<OrdSalesbillDetailVO>, Long, Long> batchEntityTriplet : batchDetailVO2SplitRuleTripletList) {
            BatchMakePreviewInvoiceInfo batchMakePreviewInvoiceInfo = new BatchMakePreviewInvoiceInfo();
            BatchNoMergeInfo batchNoMergeInfo = new BatchNoMergeInfo();
            batchNoMergeInfo.setBatchNo((Long)batchEntityTriplet.getValue2());
            batchMakePreviewInvoiceInfo.setBatchNoMergeInfo(batchNoMergeInfo);
            batchMakePreviewInvoiceInfo.setRuleId(null == tempRuleId ? (Long)batchEntityTriplet.getValue1() : tempRuleId);
            ArrayList salesbillItemIdList = Lists.newArrayList();
            ((List)batchEntityTriplet.getValue0()).forEach(item -> salesbillItemIdList.add(item.getOrdSalesbillItemVO().getSalesbillItemId()));
            batchMakePreviewInvoiceInfo.setBatchSalesbillItemIdList(salesbillItemIdList.stream().distinct().collect(Collectors.toList()));
            PurchaseInfo purchaseInfo = new PurchaseInfo();
            BeanUtils.copyProperties(((OrdSalesbillDetailVO)((List)batchEntityTriplet.getValue0()).get(0)).getOrdSalesbillVO(), purchaseInfo);
            batchMakePreviewInvoiceInfo.setPurchaseInfo(purchaseInfo);
            batchMakePreviewInvoiceInfoList.add(batchMakePreviewInvoiceInfo);
        }
        for (BatchMakePreviewInvoiceInfo batchInfo : batchMakePreviewInvoiceInfoList) {
            logger.debug("batchInfo -------------->:{}", (Object)JsonUtils.writeObjectToFastJson(batchInfo));
            int affected = this.salesbillManager.updateOrdSalesbillItemEntityBatchNoByIds(batchInfo.getBatchSalesbillItemIdList(), 0L, batchInfo.getBatchNoMergeInfo().getBatchNo(), batchInfo.getRuleId(), BillItemStatus.NORMAL.value(), BillItemStatus.PRE_INVOICED.value());
            if (affected == batchInfo.getBatchSalesbillItemIdList().size()) continue;
            logger.debug("batchNo:{}---batchInfo.getBatchSalesbillItemIdList():{} \u66f4\u65b0\u5931\u8d25.", (Object)batchInfo.getBatchNoMergeInfo().getBatchNo(), batchInfo.getBatchSalesbillItemIdList());
            throw new RuntimeException("\u5355\u636e\u5f00\u7968:\u751f\u6210\u6279\u6b21\u53f7\u5931\u8d25.");
        }
        return batchMakePreviewInvoiceInfoList;
    }

    private BaseAsyncResponse sendPreMakeOutInvoiceMessage(MakeoutInvoiceRequest makeoutInvoiceRequest, List<BatchMakePreviewInvoiceInfo> batchMakePreviewInvoiceInfoList, SearchSort sort) {
        MsSplitAndMakeOutRequest msSplitAndMakeOutRequest = this.createMsSplitAndMakeOutRequest(makeoutInvoiceRequest, batchMakePreviewInvoiceInfoList, sort);
        logger.debug("\u5f00\u7968\u8bf7\u6c42\u53c2\u6570msSplitAndMakeOutRequest----:{}", (Object)JsonUtils.writeObjectToFastJson(msSplitAndMakeOutRequest));
        return this.splitAndMakeOutInvoiceClient.makeOut(msSplitAndMakeOutRequest);
    }

    private MsSplitAndMakeOutRequest createMsSplitAndMakeOutRequest(MakeoutInvoiceRequest makeoutInvoiceRequest, List<BatchMakePreviewInvoiceInfo> batchMakePreviewInvoiceInfoList, SearchSort sort) {
        MsSplitAndMakeOutRequest msSplitAndMakeOutRequest = new MsSplitAndMakeOutRequest();
        ArrayList paramList = Lists.newArrayList();
        for (BatchMakePreviewInvoiceInfo batchNoInfo : batchMakePreviewInvoiceInfoList) {
            MsSplitAndMakeOutParams msSplitAndMakeOutParams = new MsSplitAndMakeOutParams();
            msSplitAndMakeOutParams.setBatchNo(batchNoInfo.getBatchNoMergeInfo().getBatchNo());
            msSplitAndMakeOutParams.setPurchaserAddress(makeoutInvoiceRequest == null ? batchNoInfo.getPurchaseInfo().getPurchaserAddress() : makeoutInvoiceRequest.getPurchaserAddress());
            msSplitAndMakeOutParams.setPurchaserBankAccount(makeoutInvoiceRequest == null ? batchNoInfo.getPurchaseInfo().getPurchaserBankAccount() : makeoutInvoiceRequest.getPurchaserBankAccount());
            msSplitAndMakeOutParams.setPurchaserBankName(makeoutInvoiceRequest == null ? batchNoInfo.getPurchaseInfo().getPurchaserBankName() : makeoutInvoiceRequest.getPurchaserBankName());
            msSplitAndMakeOutParams.setPurchaserName(makeoutInvoiceRequest == null ? batchNoInfo.getPurchaseInfo().getPurchaserName() : makeoutInvoiceRequest.getPurchaserName());
            msSplitAndMakeOutParams.setPurchaserTaxNo(makeoutInvoiceRequest == null ? batchNoInfo.getPurchaseInfo().getPurchaserTaxNo() : makeoutInvoiceRequest.getPurchaserTaxNo());
            msSplitAndMakeOutParams.setPurchaserTel(makeoutInvoiceRequest == null ? batchNoInfo.getPurchaseInfo().getPurchaserTel() : makeoutInvoiceRequest.getPurchaserTel());
            msSplitAndMakeOutParams.setRuleId(batchNoInfo.getRuleId());
            msSplitAndMakeOutParams.setMode(String.valueOf(InvoiceMakeOutMode.PRE_MAKEOUT.value()));
            msSplitAndMakeOutParams.setRemark(makeoutInvoiceRequest == null ? "" : makeoutInvoiceRequest.getRemark());
            paramList.add(msSplitAndMakeOutParams);
        }
        msSplitAndMakeOutRequest.setParamList((List)paramList);
        msSplitAndMakeOutRequest.setSort(sort);
        return msSplitAndMakeOutRequest;
    }

    @Override
    public MakeOutInvoiceResponse makeOutInvoice(MakeoutInvoiceRequest makeoutInvoiceRequest, UserInfo userInfo) {
        MsTmpConfigResponse msTmpConfigResponse;
        logger.debug("makeOutInvoice-makeoutInvoiceRequest:{}", (Object)JsonUtils.writeObjectToFastJson(makeoutInvoiceRequest));
        GetInvoiceSplitRuleRequest getInvoiceSplitRuleRequest = new GetInvoiceSplitRuleRequest();
        getInvoiceSplitRuleRequest.setUserRole(makeoutInvoiceRequest.getUserRole());
        getInvoiceSplitRuleRequest.setIsAllSelected(makeoutInvoiceRequest.getIsAllSelected());
        getInvoiceSplitRuleRequest.setConditions(makeoutInvoiceRequest.getConditions());
        getInvoiceSplitRuleRequest.setExcludes(makeoutInvoiceRequest.getExcludes());
        getInvoiceSplitRuleRequest.setIncludes(makeoutInvoiceRequest.getIncludes());
        MakeOutInvoiceResponse ckeckResponse = BillOperationValidateTools.checkMakeOutInvoiceParams(makeoutInvoiceRequest);
        if (Response.Fail.equals(ckeckResponse.getCode())) {
            return ckeckResponse;
        }
        ArrayList outDetailVOBatchNoSplitRuleIdTripletList = Lists.newArrayList();
        MakeOutInvoiceResponse response = this.prepareMakeOutInvoiceDataInfo(getInvoiceSplitRuleRequest, outDetailVOBatchNoSplitRuleIdTripletList, userInfo.getGroupId());
        logger.debug("makeOutInvoice-getInvoiceSplitRuleRequest:{}", (Object)JsonUtils.writeObjectToFastJson(getInvoiceSplitRuleRequest));
        if (Objects.nonNull(response)) {
            return response;
        }
        response = new MakeOutInvoiceResponse();
        if (CollectionUtils.isEmpty((Collection)outDetailVOBatchNoSplitRuleIdTripletList)) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u9009\u62e9\u7684\u5355\u636e\u6570\u636e\u52a0\u8f7d\u5904\u7406\u6709\u8bef.");
            return response;
        }
        if (outDetailVOBatchNoSplitRuleIdTripletList.size() > 1) {
            response.setCode(Response.Fail);
            response.setMessage("\u5f53\u524d\u9009\u62e9\u7684\u5355\u636e\u4e0d\u80fd\u5728\u4e00\u4e2a\u6279\u6b21\u4e2d\u8fdb\u884c\u5f00\u7968.");
            return response;
        }
        List splitInvoiceRuleList = makeoutInvoiceRequest.getSplitInvoiceRules();
        if (outDetailVOBatchNoSplitRuleIdTripletList.size() == 1) {
            OrdSalesbillDetailVO ordSalesbillDetailVO = (OrdSalesbillDetailVO)((List)((Triplet)outDetailVOBatchNoSplitRuleIdTripletList.get(0)).getValue0()).get(0);
            OrdSalesbillVO ordSalesbillVO = ordSalesbillDetailVO.getOrdSalesbillVO();
            InvoiceSplitrRuleDTO invoiceSplitrRuleDTO = new InvoiceSplitrRuleDTO();
            this.handleInvoiceLimitAmount(ordSalesbillVO, invoiceSplitrRuleDTO);
            if (invoiceSplitrRuleDTO.getInvoiceLimit() != null) {
                for (ItemDTO item : splitInvoiceRuleList) {
                    if (!"invoiceLimit".equals(item.getItemName())) continue;
                    List values = item.getValue();
                    if (values.size() <= 0) break;
                    String s = (String)values.get(0);
                    try {
                        if (new BigDecimal(s).compareTo(invoiceSplitrRuleDTO.getInvoiceLimit()) > 0) {
                            InvoiceType invoiceType = InvoiceType.fromValue(ordSalesbillVO.getInvoiceType());
                            String error = "\u53d1\u7968\u7c7b\u578b\u4e3a" + invoiceType.description() + ",\u5f00\u7968\u9650\u989d\u3010" + s + "\u3011\u5927\u4e8e\u516c\u53f8\u914d\u7f6e\u7684\u5f00\u7968\u9650\u989d\u3010" + invoiceSplitrRuleDTO.getInvoiceLimit() + "\u3011";
                            response.setCode(Response.Fail);
                            response.setMessage(error);
                            return response;
                        }
                        break;
                    }
                    catch (Exception e) {
                        response.setCode(Response.Fail);
                        response.setMessage("\u5f00\u7968\u9650\u989d\u586b\u5199\u5fc5\u987b\u662f\u6570\u5b57");
                        return response;
                    }
                }
            }
        }
        ConfigItemDTO configItemDTO = new ConfigItemDTO();
        configItemDTO.setItemList(splitInvoiceRuleList);
        configItemDTO.setInvoiceType(makeoutInvoiceRequest.getInvoiceType());
        MsTmpConfigAddRequest msTmpConfigAddRequest = this.itemAssemble.convert2TmpConfigItemRequest(configItemDTO);
        msTmpConfigAddRequest.setUserId(Long.valueOf(userInfo.getUserId()));
        logger.debug("saveTmpConfigRule msTmpConfigAddRequest========={}", (Object)JsonUtils.writeObjectToFastJson(msTmpConfigAddRequest));
        try {
            msTmpConfigResponse = this.tempConfigClient.saveTmpConfigRule(msTmpConfigAddRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(Response.Fail);
            response.setMessage("\u62c6\u7968\u89c4\u5219\u4fdd\u5b58\u5931\u8d25.");
            return response;
        }
        if (null == msTmpConfigResponse || msTmpConfigResponse.getCode().equals(Response.Fail)) {
            response = new MakeOutInvoiceResponse();
            response.setCode(Response.Fail);
            response.setMessage(null == msTmpConfigResponse ? "\u4fdd\u5b58\u62c6\u7968\u5e94\u7528\u89c4\u5219\u5931\u8d25." : msTmpConfigResponse.getMessage());
            return response;
        }
        logger.debug("makeOutInvoice-save-return-save-ruleId:{}", (Object)msTmpConfigResponse.getResult());
        response = this.processMakeOutInvoice(outDetailVOBatchNoSplitRuleIdTripletList, makeoutInvoiceRequest, msTmpConfigResponse.getResult(), getInvoiceSplitRuleRequest.getConditions().getSort());
        return response;
    }

    @Override
    public BillDetailInfoResponse getBillDetailInfo(GetBillDetailInfoRequest getBillDetailInfoRequest) {
        BaseRuleBean baseRuleBean;
        Long ruleId;
        Long groupId;
        String salesbillNo;
        BillDetailInfoResponse billDetailInfoResponse = new BillDetailInfoResponse();
        if (null == getBillDetailInfoRequest) {
            billDetailInfoResponse.setCode(Response.Fail);
            billDetailInfoResponse.setMessage("\u53c2\u6570\u4f20\u9012\u9519\u8bef!");
            return billDetailInfoResponse;
        }
        SalesbillInfo salesbillInfo = new SalesbillInfo();
        Integer userRole = getBillDetailInfoRequest.getUserRole();
        BillMainInfo billMainInfo = this.salesbillManager.getBillMainInfo(userRole, salesbillNo = getBillDetailInfoRequest.getSalesbillNo(), groupId = getBillDetailInfoRequest.getGroupId());
        if (Objects.isNull(billMainInfo)) {
            billDetailInfoResponse.setCode(Response.Fail);
            billDetailInfoResponse.setMessage(String.format("\u96c6\u56e2Id:\u3010%s\u3011\u4e0b\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u4e0d\u5b58\u5728!", groupId, salesbillNo));
            return billDetailInfoResponse;
        }
        salesbillInfo.setBillMainInfo(billMainInfo);
        PageData<List<OrdSalesbillItemEntity>> salesbillItemPage = this.salesbillManager.querySalesBillItemPage(billMainInfo.getSalesbillId(), getBillDetailInfoRequest);
        salesbillInfo.setBillItemTotalCount(Integer.valueOf((int)salesbillItemPage.getCount()));
        salesbillInfo.setBillItemList(JSON.parseArray((String)JSON.toJSONString(salesbillItemPage.getData()), BillItemInfo.class));
        SplitRuleInfo splitRuleInfo = null;
        if (!CollectionUtils.isEmpty((Collection)salesbillInfo.getBillItemList()) && (ruleId = ((BillItemInfo)salesbillInfo.getBillItemList().get(0)).getRuleId()) != null && ruleId > 0L && !Objects.isNull(baseRuleBean = this.localConfigMetadataCacheManager.getInvoiceSplitRuleByRuleId(ruleId, (ConfigParser)this.invoiceSplitParser))) {
            InvoiceSplitrRuleDTO splitRuleDTO = (InvoiceSplitrRuleDTO)baseRuleBean;
            splitRuleInfo = new SplitRuleInfo();
            BeanUtils.copyProperties(splitRuleDTO, splitRuleInfo);
        }
        salesbillInfo.setSplitRuleInfo(splitRuleInfo);
        billDetailInfoResponse.setCode(Response.OK);
        billDetailInfoResponse.setMessage("\u83b7\u53d6\u6210\u529f!");
        billDetailInfoResponse.setResult(salesbillInfo);
        return billDetailInfoResponse;
    }

    @Override
    public BillMainInfoResponse getBillMainInfo(GetBillMainInfoRequest getBillMainInfoRequest) {
        BillMainInfoResponse billMainInfoResponse = new BillMainInfoResponse();
        Integer userRole = getBillMainInfoRequest.getUserRole();
        String salesbillNo = getBillMainInfoRequest.getSalesbillNo();
        Long groupId = getBillMainInfoRequest.getGroupId();
        BillMainInfo billMainInfo = this.salesbillManager.getBillMainInfo(userRole, salesbillNo, groupId);
        billMainInfoResponse.setCode(Response.OK);
        billMainInfoResponse.setMessage("\u83b7\u53d6\u6210\u529f!");
        billMainInfoResponse.setResult(billMainInfo);
        return billMainInfoResponse;
    }

    public List<Quartet<BillMergerRuleDTO, Long, Long, Map<String, List<OrdSalesbillDetailVO>>>> pendingAutoMergeSalesBillItemList(List<Triplet<List<OrdSalesbillDetailVO>, Long, Long>> batchDetailVO2SplitRuleTripletList) {
        ArrayList pendingMergeSalesbillItemInfoQuartetList = Lists.newArrayList();
        for (Triplet<List<OrdSalesbillDetailVO>, Long, Long> groupEntryTriplet : batchDetailVO2SplitRuleTripletList) {
            Quartet pendingMergeSalesbillItemInfoQuartet;
            List ordSalesbillDetailVOList = (List)groupEntryTriplet.getValue0();
            Long batchNo = (Long)groupEntryTriplet.getValue2();
            OrdSalesbillVO ordSalesbillVO = ((OrdSalesbillDetailVO)ordSalesbillDetailVOList.get(0)).getOrdSalesbillVO();
            BaseRuleBean baseRuleBean = this.localConfigMetadataCacheManager.getBillItemMergeRuleBean(ordSalesbillVO, (ConfigParser)this.billMergeParser);
            logger.debug("pendingAutoMergeSalesBillItemList--baseRuleBean:{}", (Object)JsonUtils.writeObjectToFastJson(baseRuleBean));
            if (Objects.isNull(baseRuleBean) || !((BillMergerRuleDTO)baseRuleBean).getAutoMergeFlag().booleanValue()) {
                HashMap oneBatchMap = Maps.newHashMap();
                oneBatchMap.put("onebatch", ordSalesbillDetailVOList);
                Quartet pendingMergeSalesbillItemInfoQuartet2 = Quartet.with(null, (Object)groupEntryTriplet.getValue1(), (Object)batchNo, (Object)oneBatchMap);
                pendingMergeSalesbillItemInfoQuartetList.add(pendingMergeSalesbillItemInfoQuartet2);
                continue;
            }
            BillMergerRuleDTO billMergerRuleDTO = (BillMergerRuleDTO)baseRuleBean;
            HashMap pendingMergeKey2SalesbillItemMap = Maps.newHashMap();
            ArrayList positiveList = Lists.newArrayList();
            ArrayList negativeList = Lists.newArrayList();
            NagertiveRuleEnum nagertiveRuleEnum = billMergerRuleDTO.getNagertiveRule();
            if (nagertiveRuleEnum.getvalue().equals(NagertiveRuleEnum.positive_negative_not_merge.getvalue())) {
                for (OrdSalesbillDetailVO ordSalesbillDetailVO : ordSalesbillDetailVOList) {
                    if (ordSalesbillDetailVO.getOrdSalesbillItemVO().getAmountWithTax().compareTo(BigDecimal.ZERO) < 0) {
                        negativeList.add(ordSalesbillDetailVO);
                        continue;
                    }
                    positiveList.add(ordSalesbillDetailVO);
                }
                if (positiveList.size() > 0) {
                    pendingMergeKey2SalesbillItemMap.putAll(this.pendingMergeKey2SalesbillItem(positiveList, billMergerRuleDTO, 1));
                }
                if (negativeList.size() > 0) {
                    pendingMergeKey2SalesbillItemMap.putAll(this.pendingMergeKey2SalesbillItem(negativeList, billMergerRuleDTO, 0));
                }
                pendingMergeSalesbillItemInfoQuartet = Quartet.with((Object)billMergerRuleDTO, (Object)groupEntryTriplet.getValue1(), (Object)batchNo, (Object)pendingMergeKey2SalesbillItemMap);
                pendingMergeSalesbillItemInfoQuartetList.add(pendingMergeSalesbillItemInfoQuartet);
                continue;
            }
            pendingMergeKey2SalesbillItemMap.putAll(this.pendingMergeKey2SalesbillItem(ordSalesbillDetailVOList, billMergerRuleDTO, 1));
            pendingMergeSalesbillItemInfoQuartet = Quartet.with((Object)billMergerRuleDTO, (Object)groupEntryTriplet.getValue1(), (Object)batchNo, (Object)pendingMergeKey2SalesbillItemMap);
            pendingMergeSalesbillItemInfoQuartetList.add(pendingMergeSalesbillItemInfoQuartet);
        }
        return pendingMergeSalesbillItemInfoQuartetList;
    }

    private Map<String, List<OrdSalesbillDetailVO>> pendingMergeKey2SalesbillItem(List<OrdSalesbillDetailVO> ordSalesbillDetailVOList, BillMergerRuleDTO billMergerRuleDTO, Integer isPositive) {
        HashMap pendingMergeKey2SalesbillItemMap = Maps.newHashMap();
        OrdSalesbillVO mergedOrdSalesbillMain = ordSalesbillDetailVOList.get(0).getOrdSalesbillVO();
        for (OrdSalesbillDetailVO ordSalesbillDetailVO : ordSalesbillDetailVOList) {
            List mergedFieldBeanList = billMergerRuleDTO.getMergerCondition();
            StringBuilder mergedKeyBuilder = new StringBuilder();
            for (CombinationFieldBean mergedFieldBean : mergedFieldBeanList) {
                if (0 == mergedFieldBean.getFieldGroupIndex()) {
                    mergedKeyBuilder.append(ReflectUtil.getValue(mergedOrdSalesbillMain, mergedFieldBean.getField()));
                    continue;
                }
                mergedKeyBuilder.append(ReflectUtil.getValue(ordSalesbillDetailVO.getOrdSalesbillItemVO(), mergedFieldBean.getField()));
            }
            mergedKeyBuilder.append(isPositive);
            String mergeKey = mergedKeyBuilder.toString();
            List mergedOrdSalesbillItemList = (List)pendingMergeKey2SalesbillItemMap.get(mergeKey);
            if (Objects.isNull(mergedOrdSalesbillItemList)) {
                mergedOrdSalesbillItemList = Lists.newArrayList();
            }
            mergedOrdSalesbillItemList.add(ordSalesbillDetailVO);
            pendingMergeKey2SalesbillItemMap.put(mergeKey, mergedOrdSalesbillItemList);
        }
        return pendingMergeKey2SalesbillItemMap;
    }

    public Map<BatchNoMergeInfo, List<OrdSalesbillItemEntity>> autoMergeSalesbillItem(List<Quartet<BillMergerRuleDTO, Long, Long, Map<String, List<OrdSalesbillDetailVO>>>> pendingMergeSalesbillItemInfoQuartetList, Long tempRuleId) {
        HashMap batchMergedOrdSalesbillItemEntityMap = Maps.newHashMap();
        for (Quartet<BillMergerRuleDTO, Long, Long, Map<String, List<OrdSalesbillDetailVO>>> quartet : pendingMergeSalesbillItemInfoQuartetList) {
            BillMergerRuleDTO billMergeRuleDTO = (BillMergerRuleDTO)quartet.getValue0();
            Long splitRuleId = null == tempRuleId ? (Long)quartet.getValue1() : tempRuleId;
            Long batchNo = (Long)quartet.getValue2();
            BatchNoMergeInfo batchNoMergeInfo = new BatchNoMergeInfo();
            batchNoMergeInfo.setBatchNo(batchNo);
            batchNoMergeInfo.setMerge(false);
            Map pendingMergeSalesbillItemMap = (Map)quartet.getValue3();
            ArrayList mergedSalesbillItemList = Lists.newArrayList();
            if (Objects.isNull(billMergeRuleDTO) || !billMergeRuleDTO.getAutoMergeFlag().booleanValue()) {
                List ordSalesbillDetailVOList = (List)pendingMergeSalesbillItemMap.entrySet().iterator().next().getValue();
                mergedSalesbillItemList.addAll(this.convertVO2SalesbillItem(ordSalesbillDetailVOList, batchNo, splitRuleId));
            } else {
                for (Map.Entry pendingMergeSalesbillItem : pendingMergeSalesbillItemMap.entrySet()) {
                    List ordSalesbillDetailVOList = (List)pendingMergeSalesbillItem.getValue();
                    if (ordSalesbillDetailVOList.size() > 1) {
                        OrdSalesbillItemEntity mergedOrdSalesbillItemEntity = this.processMergeSalesbillItemList(this.convertVO2SalesbillItem(ordSalesbillDetailVOList, batchNo, splitRuleId), billMergeRuleDTO);
                        if (Objects.isNull((Object)mergedOrdSalesbillItemEntity)) {
                            logger.warn("\u81ea\u52a8\u5408\u5e76\u660e\u7ec6\u7ed3\u679c\u4e3anull");
                            continue;
                        }
                        mergedSalesbillItemList.add(mergedOrdSalesbillItemEntity);
                        if (batchNoMergeInfo.isMerge()) continue;
                        batchNoMergeInfo.setMerge(true);
                        continue;
                    }
                    if (ordSalesbillDetailVOList.size() != 1) continue;
                    mergedSalesbillItemList.addAll(this.convertVO2SalesbillItem(ordSalesbillDetailVOList, batchNo, splitRuleId));
                }
            }
            batchMergedOrdSalesbillItemEntityMap.put(batchNoMergeInfo, mergedSalesbillItemList);
        }
        return batchMergedOrdSalesbillItemEntityMap;
    }

    private List<OrdSalesbillItemEntity> convertVO2SalesbillItem(List<OrdSalesbillDetailVO> ordSalesbillDetailVOList, Long batchNo, Long ruleId) {
        ArrayList ordSalesbillItemEntityList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(ordSalesbillDetailVOList)) {
            return ordSalesbillItemEntityList;
        }
        for (OrdSalesbillDetailVO ordSalesbillDetailVO : ordSalesbillDetailVOList) {
            OrdSalesbillItemEntity ordSalesbillItemEntity = new OrdSalesbillItemEntity();
            BeanUtils.copyProperties(ordSalesbillDetailVO.getOrdSalesbillItemVO(), (Object)ordSalesbillItemEntity);
            ordSalesbillItemEntity.setBatchNo(batchNo);
            ordSalesbillItemEntity.setRuleId(ruleId);
            ordSalesbillItemEntityList.add(ordSalesbillItemEntity);
        }
        return ordSalesbillItemEntityList;
    }

    private OrdSalesbillItemEntity processMergeSalesbillItemList(List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, BillMergerRuleDTO billMergeRuleDTO) {
        if (CollectionUtils.isEmpty(ordSalesbillItemEntityList)) {
            return null;
        }
        List salesbillItemIdList = ordSalesbillItemEntityList.stream().map(item -> item.getSalesbillItemId()).collect(Collectors.toList());
        SalesbillItem salesbillItem = new SalesbillItem();
        OrdSalesbillItemEntity ordSalesbillItemEntity = ordSalesbillItemEntityList.get(0);
        BeanUtils.copyProperties((Object)ordSalesbillItemEntity, salesbillItem);
        SalesbillMergeAndSplitManager.fillMergedSalesbillItemFields(ordSalesbillItemEntityList, salesbillItem);
        BigDecimal amountWithTax = ordSalesbillItemEntityList.stream().map(OrdSalesbillItemEntity::getAmountWithTax).reduce(BigDecimal::add).get();
        BigDecimal amountWithoutTax = ordSalesbillItemEntityList.stream().map(OrdSalesbillItemEntity::getAmountWithoutTax).reduce(BigDecimal::add).get();
        salesbillItem.setAmountWithTax(amountWithTax);
        salesbillItem.setAmountWithoutTax(amountWithoutTax);
        switch (billMergeRuleDTO.getMergeRule()) {
            case quantity_add: {
                BigDecimal quantity = ordSalesbillItemEntityList.stream().map(OrdSalesbillItemEntity::getQuantity).reduce(BigDecimal::add).get();
                BigDecimal unitPriceWithTax = amountWithTax.divide(quantity, 15, 4);
                BigDecimal unitPrice = amountWithoutTax.divide(quantity, 15, 4);
                salesbillItem.setQuantity(quantity);
                salesbillItem.setUnitPriceWithTax(unitPriceWithTax);
                salesbillItem.setUnitPrice(unitPrice);
                break;
            }
            case quantity_merge_To_One: {
                BigDecimal unitPriceWithTax = amountWithTax.divide(BigDecimal.ONE, 15, 4);
                BigDecimal unitPrice = amountWithoutTax.divide(BigDecimal.ONE, 15, 4);
                salesbillItem.setQuantity(BigDecimal.ONE);
                salesbillItem.setUnitPriceWithTax(unitPriceWithTax);
                salesbillItem.setUnitPrice(unitPrice);
                break;
            }
            case save_price: {
                BigDecimal unitPrice = salesbillItem.getUnitPrice();
                BigDecimal quantity = amountWithoutTax.divide(unitPrice, 15, 4);
                salesbillItem.setQuantity(quantity);
                break;
            }
            case no_quantity_no_Price: {
                salesbillItem.setQuantity(BigDecimal.ZERO);
                salesbillItem.setUnitPrice(BigDecimal.ZERO);
                salesbillItem.setUnitPriceWithTax(BigDecimal.ZERO);
                salesbillItem.setAmountWithTax(amountWithTax);
                salesbillItem.setAmountWithoutTax(amountWithoutTax);
                break;
            }
            default: {
                logger.warn("no match merge rule.");
            }
        }
        OrdSalesbillItemEntity mergedOrdSalesbillItemEntity = new OrdSalesbillItemEntity();
        BeanUtils.copyProperties(salesbillItem, (Object)mergedOrdSalesbillItemEntity);
        Long mergedSalesbillItemId = this.idGenerator.nextId();
        logger.info("auto pre merged salesbillItemIdList:{}, after mergedSalesbillItemId:{}, batchNo:{}", new Object[]{JsonUtils.writeObjectToFastJson(salesbillItemIdList), mergedSalesbillItemId, ordSalesbillItemEntity.getBatchNo()});
        mergedOrdSalesbillItemEntity.setSalesbillItemId(mergedSalesbillItemId);
        mergedOrdSalesbillItemEntity.setSalesbillId(0L);
        mergedOrdSalesbillItemEntity.setCreateTime(new Date());
        mergedOrdSalesbillItemEntity.setUpdateTime(new Date());
        mergedOrdSalesbillItemEntity.setOrigin(BillItemOrigin.AUTO_MERGE.value());
        mergedOrdSalesbillItemEntity.setBatchNo(ordSalesbillItemEntity.getBatchNo());
        mergedOrdSalesbillItemEntity.setRuleId(ordSalesbillItemEntity.getRuleId());
        mergedOrdSalesbillItemEntity.setSalesbillNo(ordSalesbillItemEntity.getSalesbillNo());
        mergedOrdSalesbillItemEntity.setSalesbillItemNo(ordSalesbillItemEntity.getSalesbillItemNo());
        mergedOrdSalesbillItemEntity.setSplitCode(ordSalesbillItemEntity.getSplitCode());
        return mergedOrdSalesbillItemEntity;
    }

    public Map<Long, Boolean> autoMergeSaveSalesbillItem2db(Map<BatchNoMergeInfo, List<OrdSalesbillItemEntity>> batchMergedOrdSalesbillItemEntityMap) {
        if (CollectionUtils.isEmpty(batchMergedOrdSalesbillItemEntityMap)) {
            logger.warn("batchMergedOrdSalesbillItemEntityMap empty.");
            return null;
        }
        for (Map.Entry<BatchNoMergeInfo, List<OrdSalesbillItemEntity>> batchMergedEntry : batchMergedOrdSalesbillItemEntityMap.entrySet()) {
            BatchNoMergeInfo batchNoMergeInfo = batchMergedEntry.getKey();
            if (batchNoMergeInfo.isMerge()) {
                List<OrdSalesbillItemEntity> ordSalesbillItemEntityList = batchMergedEntry.getValue();
                int affectedCount = this.salesbillMergeAndSplitManager.autoBillItemBatchInsert(ordSalesbillItemEntityList);
                if (affectedCount == ordSalesbillItemEntityList.size()) continue;
                logger.warn("ordSalesbillItemEntityList.size():{}, affectedCount:{}", (Object)ordSalesbillItemEntityList.size(), (Object)affectedCount);
                throw new RuntimeException("\u6279\u91cf\u63d2\u5165\u81ea\u52a8\u5408\u5e76\u660e\u7ec6\u5931\u8d25!");
            }
            logger.info("batchNo:{}----isAutoMerge:{}", (Object)batchNoMergeInfo.getBatchNo(), (Object)batchNoMergeInfo.isMerge());
        }
        Map<Long, Boolean> batchNo2MergeMap = batchMergedOrdSalesbillItemEntityMap.keySet().stream().collect(Collectors.toMap(BatchNoMergeInfo::getBatchNo, item -> item.isMerge()));
        return batchNo2MergeMap;
    }
}

