/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.cache.ucenter.LocalUcenterExternalCacheManager;
import com.xforceplus.phoenix.bill.client.makeout.InvoiceSalesClient;
import com.xforceplus.phoenix.bill.client.model.BillDetailResponse;
import com.xforceplus.phoenix.bill.client.model.BillItemResponse;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.BillResponse;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.BillSummaryResponse;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillDetailVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.bill.client.model.QueryDisplayNone;
import com.xforceplus.phoenix.bill.client.model.RequestSource;
import com.xforceplus.phoenix.bill.client.model.ResSummary;
import com.xforceplus.phoenix.bill.client.model.SearchModelResponse;
import com.xforceplus.phoenix.bill.client.model.UserRole;
import com.xforceplus.phoenix.bill.constant.enums.BillFieldName;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.CooperateFlag;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillCatalog;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.service.BillQueryService;
import com.xforceplus.phoenix.bill.core.tools.BillSearchTools;
import com.xforceplus.phoenix.bill.es.entity.BillItemDocument;
import com.xforceplus.phoenix.bill.es.entity.BillMainDocument;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.esutils.EsPageQueryUtils;
import com.xforceplus.phoenix.esutils.bean.ResPageList;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.bean.SearchModel;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import com.xforceplus.phoenix.esutils.enums.FieldSource;
import com.xforceplus.phoenix.esutils.enums.Operator;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.invoice.client.model.QuerySaleItemIdsByInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.QuerySaleItemIdsByInvoiceResponse;
import com.xforceplus.seller.invoice.client.model.QuerySaleItemIdsByInvoiceResult;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BillQueryServiceImpl
implements BillQueryService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ES_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS+0800";
    @Autowired
    ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    OrdSalesbillItemDao ordSalesbillItemDao;
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    InvoiceSalesClient invoiceSalesClient;
    @Autowired
    private LocalUcenterExternalCacheManager ucenterExternalCacheManager;
    @Autowired
    IDGenerator iDGenerator;

    @Override
    public SearchModelResponse getSearchModelResponse(BillRequest billRequest) {
        BillSearchModel billSearchModel = BillSearchTools.getSearchCondition(billRequest, billRequest.getUserRole());
        List<OrgModel> orgModelList = this.orgModelList((UserInfo)this.userInfoHolder.get());
        billSearchModel.setCompanyIdList(orgModelList.stream().filter(e -> !Objects.equals(0, e.getOrgType())).map(OrgModel::getCompanyId).collect(Collectors.toList()));
        billSearchModel.setSysOrgIdList(orgModelList.stream().map(orgModel -> String.valueOf(orgModel.getOrgStructId())).collect(Collectors.toList()));
        billSearchModel.setRequestSource(RequestSource.APP.value());
        SearchModel searchModel = this.buildHasSearchModel(billSearchModel);
        SearchModelResponse searchModelResponse = new SearchModelResponse();
        searchModelResponse.setSearchModel(searchModel);
        return searchModelResponse;
    }

    public List<OrgModel> orgModelList(UserInfo userInfo) {
        return this.ucenterExternalCacheManager.getOrgList(userInfo.getGroupId(), userInfo.getUserId());
    }

    @Override
    public BillResponse getBillList(BillSearchModel billSearchModel) {
        try {
            this.logger.debug("getBillList \u5165\u53c2 billSearchModel\uff1a{}", (Object)billSearchModel);
            if (Objects.isNull(billSearchModel)) {
                throw new RuntimeException("getBillList\uff1abillSearchModel is null");
            }
            if (billSearchModel.getSort() == null || billSearchModel.getSort().getFieldName() == null) {
                SearchSort sort = new SearchSort();
                sort.setFieldName("salesbillId");
                sort.setSort("1");
                billSearchModel.setSort(sort);
            }
            SearchModel searchModel = this.buildHasSearchModel(billSearchModel);
            List fields = Arrays.stream(BillMainDocument.class.getDeclaredFields()).filter(e -> Objects.isNull(e.getAnnotation(QueryDisplayNone.class))).map(Field::getName).collect(Collectors.toList());
            NativeSearchQuery searchQuery = EsPageQueryUtils.hasChildPageQuery((SearchModel)searchModel, fields);
            ResPageList result = (ResPageList)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> {
                long totalHits = response.getHits().getTotalHits();
                ArrayList<OrdSalesbillVO> results = new ArrayList<OrdSalesbillVO>();
                for (SearchHit hit : response.getHits()) {
                    if (hit == null) continue;
                    BillMainDocument billMainDocument = JsonUtils.writeFastJsonToObject(hit.getSourceAsString(), BillMainDocument.class);
                    OrdSalesbillVO billVO = new OrdSalesbillVO();
                    BeanUtils.copyProperties(billMainDocument, billVO);
                    results.add(billVO);
                }
                return new ResPageList(totalHits, results);
            });
            if (Objects.equals(RequestSource.APP.value(), billSearchModel.getRequestSource())) {
                Map<Long, Long> countMap = this.countBySalesbillId(searchModel);
                for (OrdSalesbillVO bill : result.getList()) {
                    bill.setUnMakeAmountWithTax(bill.getAmountWithTax().subtract(bill.getAlreadyMakeAmountTaxAmount()));
                    bill.setUnMakeAmountWithoutTax(bill.getAmountWithoutTax().subtract(bill.getAlreadyMakeAmountWithoutTax()));
                    bill.setDetailsCount(countMap.getOrDefault(bill.getSalesbillId(), 0L));
                }
                result.setTotalDetailsCount(this.getItemCount(searchModel));
                result.setTotalAmountWithTax(this.aggAmount(searchModel, BillItemPriceMethod.WITH_TAX));
                result.setTotalAmountWithoutTax(this.aggAmount(searchModel, BillItemPriceMethod.WITHOUT_TAX));
            }
            return BillResponse.from((Integer)Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (ResPageList)result);
        }
        catch (NumberFormatException ne) {
            this.logger.warn("\u5355\u636e\u5217\u8868\u67e5\u8be2\u5931\u8d25getBillList\uff1a{}", (Object)ne.getMessage());
            return BillResponse.from((Integer)Response.Fail, (String)"\u67e5\u8be2\u6761\u4ef6\u6709\u8bef\uff0c\u68c0\u67e5\u8f93\u5165\u662f\u5426\u4e3a\u6570\u5b57\u7c7b\u578b");
        }
        catch (Exception e2) {
            this.logger.warn("\u5355\u636e\u5217\u8868\u67e5\u8be2\u5931\u8d25getBillList\uff1a{}", (Object)e2.getMessage());
            return BillResponse.from((Integer)Response.Fail, (String)e2.getMessage());
        }
    }

    @Override
    public BillDetailResponse getBillListByDetail(BillSearchModel billSearchModel) {
        try {
            this.logger.debug("getBillListByDetail \u5165\u53c2 billSearchModel\uff1a{}", (Object)billSearchModel);
            if (Objects.isNull(billSearchModel)) {
                throw new RuntimeException("getBillListByDetail\uff1abillSearchModel is null");
            }
            SearchModel searchModel = this.buildHasSearchModel(billSearchModel);
            List fields = Arrays.stream(OrdSalesbillItemVO.class.getDeclaredFields()).filter(e -> Objects.isNull(e.getAnnotation(QueryDisplayNone.class))).map(Field::getName).collect(Collectors.toList());
            NativeSearchQuery searchQuery = EsPageQueryUtils.hasParentPageQuery((SearchModel)searchModel, fields);
            ResPageList resPageList = (ResPageList)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> {
                long totalHits = response.getHits().getTotalHits();
                ArrayList<OrdSalesbillDetailVO> results = new ArrayList<OrdSalesbillDetailVO>();
                for (SearchHit hit : response.getHits()) {
                    OrdSalesbillDetailVO detailVO = new OrdSalesbillDetailVO();
                    if (hit != null) {
                        BillItemDocument itemDocument = JsonUtils.writeFastJsonToObject(hit.getSourceAsString(), BillItemDocument.class);
                        OrdSalesbillItemVO billItemVO = new OrdSalesbillItemVO();
                        BeanUtils.copyProperties(itemDocument, billItemVO);
                        detailVO.setOrdSalesbillItemVO(billItemVO);
                        SearchHits innerHits = (SearchHits)hit.getInnerHits().get("bill_main");
                        if (innerHits != null) {
                            for (SearchHit innerHit : innerHits) {
                                BillMainDocument billMainDocument = JsonUtils.writeFastJsonToObject(innerHit.getSourceAsString(), BillMainDocument.class);
                                OrdSalesbillVO billVO = new OrdSalesbillVO();
                                BeanUtils.copyProperties(billMainDocument, billVO);
                                detailVO.setOrdSalesbillVO(billVO);
                            }
                        }
                    }
                    results.add(detailVO);
                }
                return new ResPageList(totalHits, results);
            });
            if (Objects.equals(RequestSource.APP.value(), billSearchModel.getRequestSource())) {
                if (!CollectionUtils.isEmpty((Collection)resPageList.getList())) {
                    Map<Long, Long> countMap = this.countBySalesbillId(searchModel);
                    for (OrdSalesbillDetailVO ordSalesbillDetailVO : resPageList.getList()) {
                        OrdSalesbillVO bill = ordSalesbillDetailVO.getOrdSalesbillVO();
                        OrdSalesbillItemVO item = ordSalesbillDetailVO.getOrdSalesbillItemVO();
                        bill.setUnMakeAmountWithTax(bill.getAmountWithTax().subtract(bill.getAlreadyMakeAmountTaxAmount()));
                        bill.setUnMakeAmountWithoutTax(bill.getAmountWithoutTax().subtract(bill.getAlreadyMakeAmountWithoutTax()));
                        bill.setDetailsCount(countMap.getOrDefault(bill.getSalesbillId(), 0L));
                    }
                }
                resPageList.setTotalBillCount(this.getMainCount(searchModel));
                resPageList.setTotalDetailsCount(Long.valueOf(resPageList.getTotal()));
                resPageList.setTotalAmountWithTax(this.aggAmount(searchModel, BillItemPriceMethod.WITH_TAX));
                resPageList.setTotalAmountWithoutTax(this.aggAmount(searchModel, BillItemPriceMethod.WITHOUT_TAX));
            }
            return BillDetailResponse.from((Integer)BillDetailResponse.OK, (String)"\u67e5\u8be2\u6210\u529f", (ResPageList)resPageList);
        }
        catch (NumberFormatException ne) {
            this.logger.warn("\u5355\u636e\u660e\u7ec6\u6a21\u5f0f\u67e5\u8be2\u5f02\u5e38getBillListByDetail\uff1a{}", (Object)ne.getMessage());
            return BillDetailResponse.from((Integer)Response.Fail, (String)"\u67e5\u8be2\u6761\u4ef6\u6709\u8bef\uff0c\u68c0\u67e5\u8f93\u5165\u662f\u5426\u4e3a\u6570\u5b57\u7c7b\u578b");
        }
        catch (Exception e2) {
            this.logger.warn("\u5355\u636e\u660e\u7ec6\u6a21\u5f0f\u67e5\u8be2\u5f02\u5e38getBillListByDetail:{}", (Object)e2.getMessage());
            return BillDetailResponse.from((Integer)BillDetailResponse.Fail, (String)e2.getMessage());
        }
    }

    @Override
    public BillSummaryResponse summaryBill(BillSearchModel billSearchModel) {
        try {
            this.logger.debug("summaryBill \u5165\u53c2 billSearchModel\uff1a{}", (Object)billSearchModel);
            if (Objects.isNull(billSearchModel)) {
                throw new RuntimeException("summaryBill\uff1abillSearchModel is null");
            }
            ArrayList resSummaryList = Lists.newArrayList();
            for (SalesBillCatalog billCatalog : SalesBillCatalog.values()) {
                if (Objects.equals((Object)SalesBillCatalog.NO_EFFECT, (Object)billCatalog)) continue;
                billSearchModel.setBillStatus(String.valueOf(billCatalog.value()));
                NativeSearchQuery searchQuery = EsPageQueryUtils.hasChildCountQuery((SearchModel)this.buildHasSearchModel(billSearchModel));
                ResSummary resSummary = (ResSummary)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> {
                    long totalHits = response.getHits().getTotalHits();
                    return new ResSummary(String.valueOf(billCatalog.value()), Long.valueOf(totalHits), billCatalog.description());
                });
                resSummaryList.add(resSummary);
            }
            return BillSummaryResponse.from((Integer)Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (List)resSummaryList);
        }
        catch (NumberFormatException ne) {
            this.logger.warn("\u7edf\u8ba1\u5355\u636e\u6570\u91cf\u67e5\u8be2\u5931\u8d25summaryBill\uff1a{}", (Object)ne.getMessage());
            return BillSummaryResponse.from((Integer)Response.Fail, (String)"\u67e5\u8be2\u6761\u4ef6\u6709\u8bef\uff0c\u68c0\u67e5\u8f93\u5165\u662f\u5426\u4e3a\u6570\u5b57\u7c7b\u578b");
        }
        catch (Exception e) {
            this.logger.warn("\u7edf\u8ba1\u5355\u636e\u6570\u91cf\u67e5\u8be2\u5931\u8d25summaryBill\uff1a{}", (Object)e.getMessage());
            return BillSummaryResponse.from((Integer)Response.Fail, (String)e.getMessage());
        }
    }

    @Override
    public BillSummaryResponse summaryByDetail(BillSearchModel billSearchModel) {
        try {
            this.logger.debug("summaryByDetail \u5165\u53c2 billSearchModel\uff1a{}", (Object)billSearchModel);
            if (Objects.isNull(billSearchModel)) {
                throw new RuntimeException("summaryByDetail\uff1abillSearchModel is null");
            }
            ArrayList resSummaryList = Lists.newArrayList();
            for (SalesBillCatalog billCatalog : SalesBillCatalog.values()) {
                if (Objects.equals((Object)SalesBillCatalog.NO_EFFECT, (Object)billCatalog)) continue;
                billSearchModel.setBillStatus(String.valueOf(billCatalog.value()));
                NativeSearchQuery searchQuery = EsPageQueryUtils.hasParentCountQuery((SearchModel)this.buildHasSearchModel(billSearchModel));
                ResSummary resSummary = (ResSummary)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> {
                    long totalHits = response.getHits().getTotalHits();
                    return new ResSummary(String.valueOf(billCatalog.value()), Long.valueOf(totalHits), billCatalog.description());
                });
                resSummaryList.add(resSummary);
            }
            return BillSummaryResponse.from((Integer)BillDetailResponse.OK, (String)"\u67e5\u8be2\u6210\u529f", (List)resSummaryList);
        }
        catch (NumberFormatException ne) {
            this.logger.warn("\u7edf\u8ba1\u5355\u636e\u660e\u7ec6\u6a21\u5f0f\u5f02\u5e38summaryByDetail\uff1a{}", (Object)ne.getMessage());
            return BillSummaryResponse.from((Integer)Response.Fail, (String)"\u67e5\u8be2\u6761\u4ef6\u6709\u8bef\uff0c\u68c0\u67e5\u8f93\u5165\u662f\u5426\u4e3a\u6570\u5b57\u7c7b\u578b");
        }
        catch (Exception e) {
            this.logger.warn("\u7edf\u8ba1\u5355\u636e\u660e\u7ec6\u6a21\u5f0f\u5f02\u5e38summaryByDetail:{}", (Object)e.getMessage());
            return BillSummaryResponse.from((Integer)BillDetailResponse.Fail, (String)e.getMessage());
        }
    }

    @Override
    public BillItemResponse getBillDetailList(BillSearchModel billSearchModel) {
        try {
            this.logger.debug("getBillDetailList \u5165\u53c2 billSearchModel\uff1a{}", (Object)billSearchModel);
            if (Objects.isNull(billSearchModel)) {
                throw new RuntimeException("getBillDetailList\uff1abillSearchModel is null");
            }
            if (billSearchModel.getSort() == null || billSearchModel.getSort().getFieldName() == null) {
                ArrayList sorts = Lists.newArrayList();
                SearchSort sort = new SearchSort();
                sort.setFieldName("salesbillItemNo");
                sort.setSort("0");
                sorts.add(sort);
                SearchSort sort1 = new SearchSort();
                sort1.setFieldName("salesbillItemId");
                sort1.setSort("1");
                sorts.add(sort1);
                SearchSort searchSort = new SearchSort();
                searchSort.setSearchSort((List)sorts);
                billSearchModel.setSort(searchSort);
            }
            SearchModel searchModel = this.buildHasSearchModel(billSearchModel);
            List fields = Arrays.stream(OrdSalesbillItemVO.class.getDeclaredFields()).filter(e -> Objects.isNull(e.getAnnotation(QueryDisplayNone.class))).map(Field::getName).collect(Collectors.toList());
            NativeSearchQuery searchQuery = EsPageQueryUtils.hasParentPageQuery((SearchModel)searchModel, fields);
            ResPageList resPageList = (ResPageList)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> {
                long totalHits = response.getHits().getTotalHits();
                ArrayList<OrdSalesbillItemVO> results = new ArrayList<OrdSalesbillItemVO>();
                for (SearchHit hit : response.getHits()) {
                    if (hit == null) continue;
                    BillItemDocument billItemDocument = JsonUtils.writeFastJsonToObject(hit.getSourceAsString(), BillItemDocument.class);
                    OrdSalesbillItemVO itemVO = new OrdSalesbillItemVO();
                    BeanUtils.copyProperties(billItemDocument, itemVO);
                    SearchHits innerHits = (SearchHits)hit.getInnerHits().get("bill_main");
                    if (innerHits != null) {
                        for (SearchHit innerHit : innerHits) {
                            OrdSalesbillVO billVO = JsonUtils.writeFastJsonToObject(innerHit.getSourceAsString(), OrdSalesbillVO.class);
                            if (!Objects.equals(RequestSource.APP.value(), billSearchModel.getRequestSource())) continue;
                            itemVO.setSalesbillNo(billVO.getSalesbillNo());
                            itemVO.setPriceMethod(billVO.getPriceMethod());
                        }
                    }
                    results.add(itemVO);
                }
                return new ResPageList(totalHits, results);
            });
            return BillItemResponse.from((Integer)Response.OK, (String)"\u67e5\u8be2\u6210\u529f", (ResPageList)resPageList);
        }
        catch (NumberFormatException ne) {
            this.logger.warn("\u5355\u636e\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u5931\u8d25getBillDetailList\uff1a{}", (Object)ne.getMessage());
            return BillItemResponse.from((Integer)Response.Fail, (String)"\u67e5\u8be2\u6761\u4ef6\u6709\u8bef\uff0c\u68c0\u67e5\u8f93\u5165\u662f\u5426\u4e3a\u6570\u5b57\u7c7b\u578b", null);
        }
        catch (Exception e2) {
            this.logger.warn("\u5355\u636e\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u5931\u8d25getBillDetailList\uff1a{}", (Object)e2.getMessage());
            return BillItemResponse.from((Integer)Response.Fail, (String)e2.getMessage(), null);
        }
    }

    public BigDecimal aggAmount(SearchModel searchModel, BillItemPriceMethod billItemPriceMethod) {
        String amountKey = "key1";
        String alreadyMakeAmountKey = "key2";
        SumAggregationBuilder amountSumAggregationBuilder = null;
        SumAggregationBuilder alreadySumAggregationBuilder = null;
        if (BillItemPriceMethod.WITH_TAX == billItemPriceMethod) {
            amountSumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)amountKey).field(BillFieldName.amountWithTax.value());
            alreadySumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)alreadyMakeAmountKey).field(BillFieldName.alreadyMakeAmountWithTax.value());
        } else {
            amountSumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)amountKey).field(BillFieldName.amountWithoutTax.value());
            alreadySumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)alreadyMakeAmountKey).field(BillFieldName.alreadyMakeAmountWithoutTax.value());
        }
        SearchResponse searchResponse1 = EsPageQueryUtils.aggregationQueryResponse((ElasticsearchTemplate)this.elasticsearchTemplate, (SearchQuery)EsPageQueryUtils.hasChildCountQuery((SearchModel)searchModel), (AbstractAggregationBuilder)amountSumAggregationBuilder);
        SearchResponse searchResponse2 = EsPageQueryUtils.aggregationQueryResponse((ElasticsearchTemplate)this.elasticsearchTemplate, (SearchQuery)EsPageQueryUtils.hasChildCountQuery((SearchModel)searchModel), (AbstractAggregationBuilder)alreadySumAggregationBuilder);
        double sum1 = ((InternalSum)searchResponse1.getAggregations().get(amountKey)).getValue();
        double sum2 = ((InternalSum)searchResponse2.getAggregations().get(alreadyMakeAmountKey)).getValue();
        return BigDecimal.valueOf(sum1).subtract(BigDecimal.valueOf(sum2));
    }

    public Map<Long, Long> countBySalesbillId(SearchModel searchModel) {
        String termsKey = "key1";
        TermsAggregationBuilder salesbillIdBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)termsKey).field(BillFieldName.salesbillId.value())).size(Integer.MAX_VALUE);
        SearchResponse searchResponse = EsPageQueryUtils.aggregationQueryResponse((ElasticsearchTemplate)this.elasticsearchTemplate, (SearchQuery)EsPageQueryUtils.hasParentCountQuery((SearchModel)searchModel), (AbstractAggregationBuilder)salesbillIdBuilder);
        Terms agg = (Terms)searchResponse.getAggregations().get(termsKey);
        HashMap map = Maps.newHashMap();
        for (Terms.Bucket entry : agg.getBuckets()) {
            Long salesbillId = Long.valueOf(entry.getKey().toString());
            Long count = entry.getDocCount();
            map.put(salesbillId, count);
        }
        return map;
    }

    private Long getItemCount(SearchModel searchModel) {
        NativeSearchQuery searchQuery = EsPageQueryUtils.hasParentCountQuery((SearchModel)searchModel);
        return (Long)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getHits().getTotalHits());
    }

    private Long getMainCount(SearchModel searchModel) {
        NativeSearchQuery searchQuery = EsPageQueryUtils.hasChildCountQuery((SearchModel)searchModel);
        return (Long)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getHits().getTotalHits());
    }

    private SearchModel buildHasSearchModel(BillSearchModel billSearchModel) {
        this.setGroupsFieldSource(billSearchModel.getGroups());
        SearchModel searchModel = new SearchModel();
        searchModel.setGroups(this.buildBillMainGroups(billSearchModel));
        searchModel.setChildGroups(this.buildBillItemGroups(billSearchModel));
        searchModel.setAuthorizationGroups(BillQueryServiceImpl.getAuthorizationGroups(billSearchModel));
        searchModel.setIndex("ord_sales_bill");
        searchModel.setType("bill_main");
        searchModel.setChildType("bill_item");
        searchModel.setSort(billSearchModel.getSort());
        searchModel.setPageSize(billSearchModel.getPageSize());
        searchModel.setPageNo(billSearchModel.getPageNo());
        this.logger.debug("searchModel:{}", (Object)JsonUtils.writeObjectToFastJson(searchModel));
        return searchModel;
    }

    private void setGroupsFieldSource(List<List<SearchFilter>> groups) {
        if (!CollectionUtils.isEmpty(groups)) {
            for (List<SearchFilter> group : groups) {
                for (SearchFilter filter : group) {
                    if (Objects.equals(BillFieldName.invoicerName.value(), filter.getFieldName())) {
                        filter.setVirtual(FieldSource.item.value());
                    }
                    if (Objects.equals(BillFieldName.redBlueInvoice.value(), filter.getFieldName())) {
                        SearchFilter searchFilter;
                        if (filter.getValue().contains(BillFieldName.blueInvoice.value())) {
                            searchFilter = new SearchFilter(BillFieldName.amountWithTax.value(), (List)Lists.newArrayList((Object[])new Serializable[]{Integer.valueOf(0), ""}), Operator.range);
                            searchFilter.setVirtual(FieldSource.main.value());
                            group.set(group.indexOf(filter), searchFilter);
                        } else {
                            searchFilter = new SearchFilter(BillFieldName.amountWithTax.value(), (List)Lists.newArrayList((Object[])new Serializable[]{"", Integer.valueOf(0)}), Operator.range);
                            searchFilter.setVirtual(FieldSource.main.value());
                            group.set(group.indexOf(filter), searchFilter);
                        }
                    }
                    if (!Objects.equals(BillFieldName.createTime.value(), filter.getFieldName())) continue;
                    SimpleDateFormat sdf = new SimpleDateFormat(ES_DATE_PATTERN);
                    String createTime1 = String.valueOf(filter.getValue().get(0));
                    String createTime2 = String.valueOf(filter.getValue().get(1));
                    try {
                        sdf.parse(createTime1);
                    }
                    catch (ParseException e) {
                        String date1 = sdf.format(Long.valueOf(createTime1));
                        String date2 = sdf.format(Long.valueOf(createTime2));
                        SearchFilter searchFilter = new SearchFilter(BillFieldName.createTime.value(), (List)Lists.newArrayList((Object[])new String[]{date1, date2}), Operator.range);
                        searchFilter.setVirtual(FieldSource.main.value());
                        group.set(group.indexOf(filter), searchFilter);
                    }
                }
            }
        }
    }

    private List<List<SearchFilter>> getCustomGroups(BillSearchModel billSearchModel) {
        SalesBillCatalog salesBillCatalog = null;
        try {
            salesBillCatalog = SalesBillCatalog.fromValue(Integer.valueOf(billSearchModel.getBillStatus()));
        }
        catch (Exception e) {
            this.logger.warn("billSearchModel.getBillStatus()\uff1a{}", (Object)billSearchModel.getBillStatus());
            throw new RuntimeException("\u67e5\u8be2\u72b6\u6001billStatus\u8f6c\u6362SalesBillCatalog\u679a\u4e3e\u5931\u8d25,\u68c0\u67e5billStatus\u662f\u5426\u5408\u6cd5");
        }
        String userSide = BusinessBillType.AR.value();
        String otherSide = BusinessBillType.AP.value();
        String userSideGroupId = BillFieldName.sellerGroupId.value();
        String otherSideGroupId = BillFieldName.purchaserGroupId.value();
        if (Objects.equals(UserRole.PURCHASER.value(), billSearchModel.getUserRole())) {
            userSide = BusinessBillType.AP.value();
            otherSide = BusinessBillType.AR.value();
            userSideGroupId = BillFieldName.purchaserGroupId.value();
            otherSideGroupId = BillFieldName.sellerGroupId.value();
        }
        ArrayList groups = Lists.newArrayList();
        SearchFilter usingStatusFilter = SearchFilter.getEqFilter((String)BillFieldName.usingStatus.value(), (List)Lists.newArrayList((Object[])new String[]{billSearchModel.getBillForInvoice()}));
        SearchFilter salesbillTypeFilter = SearchFilter.getEqFilter((String)BillFieldName.salesbillType.value(), (List)Lists.newArrayList((Object[])new String[]{billSearchModel.getBillType()}));
        SearchFilter statusFilter = this.getStatusFilter(salesBillCatalog);
        if (Objects.equals(userSide, billSearchModel.getUploadSide())) {
            ArrayList group1 = Lists.newArrayList();
            group1.add(statusFilter);
            group1.add(usingStatusFilter);
            group1.add(salesbillTypeFilter);
            group1.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{userSide})));
            UserInfo userInfo = null;
            userInfo = Objects.isNull(this.userInfoHolder) || Objects.isNull(this.userInfoHolder.get()) ? billSearchModel.getUserInfo() : (UserInfo)this.userInfoHolder.get();
            group1.add(SearchFilter.getEqFilter((String)userSideGroupId, (List)Lists.newArrayList((Object[])new Long[]{userInfo.getGroupId()})));
            group1.add(this.getConfirmFlagFilter(salesBillCatalog, BillFieldName.uploadConfirmFlag.value()));
            groups.add(group1);
        } else if (Objects.equals(otherSide, billSearchModel.getUploadSide())) {
            ArrayList group2 = Lists.newArrayList();
            group2.add(statusFilter);
            group2.add(usingStatusFilter);
            group2.add(salesbillTypeFilter);
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{otherSide})));
            group2.add(SearchFilter.getEqFilter((String)otherSideGroupId, (List)Lists.newArrayList((Object[])new String[]{billSearchModel.getOtherSideCompanyGroupId()})));
            group2.add(this.getConfirmFlagFilter(salesBillCatalog, BillFieldName.receiveConfirmFlag.value()));
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.cooperateFlag.value(), (List)Lists.newArrayList((Object[])new String[]{String.valueOf(CooperateFlag.COOPERATE.value())})));
            groups.add(group2);
        } else {
            ArrayList group1 = Lists.newArrayList();
            group1.add(statusFilter);
            group1.add(usingStatusFilter);
            group1.add(salesbillTypeFilter);
            group1.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{userSide})));
            UserInfo userInfo = null;
            userInfo = Objects.isNull(this.userInfoHolder) || Objects.isNull(this.userInfoHolder.get()) ? billSearchModel.getUserInfo() : (UserInfo)this.userInfoHolder.get();
            group1.add(SearchFilter.getEqFilter((String)userSideGroupId, (List)Lists.newArrayList((Object[])new Long[]{userInfo.getGroupId()})));
            group1.add(this.getConfirmFlagFilter(salesBillCatalog, BillFieldName.uploadConfirmFlag.value()));
            groups.add(group1);
            ArrayList group2 = Lists.newArrayList();
            group2.add(statusFilter);
            group2.add(usingStatusFilter);
            group2.add(salesbillTypeFilter);
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{otherSide})));
            group2.add(SearchFilter.getEqFilter((String)otherSideGroupId, (List)Lists.newArrayList((Object[])new String[]{billSearchModel.getOtherSideCompanyGroupId()})));
            group2.add(this.getConfirmFlagFilter(salesBillCatalog, BillFieldName.receiveConfirmFlag.value()));
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.cooperateFlag.value(), (List)Lists.newArrayList((Object[])new String[]{String.valueOf(CooperateFlag.COOPERATE.value())})));
            groups.add(group2);
        }
        return groups;
    }

    private static List<List<SearchFilter>> getAuthorizationGroups(BillSearchModel billSearchModel) {
        if (!Objects.equals(RequestSource.APP.value(), billSearchModel.getRequestSource())) {
            return Lists.newArrayList();
        }
        SearchFilter sysOrgIdFilter = new SearchFilter(BillFieldName.sysOrgId.value(), billSearchModel.getSysOrgIdList(), Operator.checkbox);
        sysOrgIdFilter.setClazz(Integer.class);
        String userSide = BusinessBillType.AR.value();
        String otherSide = BusinessBillType.AP.value();
        String otherSideTaxNo = BillFieldName.purchaserTaxNo.value();
        String userCompanyId = BillFieldName.sellerId.value();
        if (Objects.equals(UserRole.PURCHASER.value(), billSearchModel.getUserRole())) {
            userSide = BusinessBillType.AP.value();
            otherSide = BusinessBillType.AR.value();
            otherSideTaxNo = BillFieldName.sellerTaxNo.value();
            userCompanyId = BillFieldName.purchaserId.value();
        }
        ArrayList groups = Lists.newArrayList();
        if (Objects.equals(userSide, billSearchModel.getUploadSide())) {
            ArrayList group1 = Lists.newArrayList();
            group1.add(sysOrgIdFilter);
            group1.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{userSide})));
            groups.add(group1);
        } else if (Objects.equals(otherSide, billSearchModel.getUploadSide())) {
            ArrayList group2 = Lists.newArrayList();
            SearchFilter userCompanyIdFilter = new SearchFilter(userCompanyId, billSearchModel.getCompanyIdList(), Operator.checkbox);
            userCompanyIdFilter.setClazz(Long.class);
            group2.add(userCompanyIdFilter);
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{otherSide})));
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.cooperateFlag.value(), (List)Lists.newArrayList((Object[])new String[]{String.valueOf(CooperateFlag.COOPERATE.value())})));
            groups.add(group2);
        } else {
            ArrayList group1 = Lists.newArrayList();
            group1.add(sysOrgIdFilter);
            group1.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{userSide})));
            groups.add(group1);
            ArrayList group2 = Lists.newArrayList();
            group2.add(new SearchFilter(otherSideTaxNo, billSearchModel.getTaxNoList(), Operator.checkbox));
            SearchFilter userCompanyIdFilter = new SearchFilter(userCompanyId, billSearchModel.getCompanyIdList(), Operator.checkbox);
            userCompanyIdFilter.setClazz(Long.class);
            group2.add(userCompanyIdFilter);
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.businessBillType.value(), (List)Lists.newArrayList((Object[])new String[]{otherSide})));
            group2.add(SearchFilter.getEqFilter((String)BillFieldName.cooperateFlag.value(), (List)Lists.newArrayList((Object[])new String[]{String.valueOf(CooperateFlag.COOPERATE.value())})));
            groups.add(group2);
        }
        return groups;
    }

    private SearchFilter getStatusFilter(SalesBillCatalog salesBillCatalog) {
        SearchFilter statusFilter = new SearchFilter();
        statusFilter.setFieldName(BillFieldName.bill_status.value());
        statusFilter.setFieldQueryType(Operator.checkbox);
        switch (salesBillCatalog) {
            case CONFIRMING: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.NORMAL.value()}));
                break;
            }
            case CHANGING: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.NORMAL.value()}));
                break;
            }
            case OPPOSITE_CONFIRMING: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.NORMAL.value()}));
                break;
            }
            case WAITING_MAKE_INVOICE: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.NORMAL.value()}));
                break;
            }
            case PENDING_MAKE_INVOICE: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.NORMAL.value()}));
                break;
            }
            case ALREADY_MAKE: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.NORMAL.value()}));
                break;
            }
            case ABANDONED: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.INVALID.value()}));
                break;
            }
            case ALL: {
                statusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillStatus.INVALID.value(), SalesBillStatus.NORMAL.value()}));
                break;
            }
            default: {
                return null;
            }
        }
        return statusFilter;
    }

    private SearchFilter getConfirmFlagFilter(SalesBillCatalog salesBillCatalog, String confirmFlagPropertyName) {
        SearchFilter confirmFlagFilter = new SearchFilter();
        confirmFlagFilter.setFieldName(confirmFlagPropertyName);
        confirmFlagFilter.setFieldQueryType(Operator.checkbox);
        switch (salesBillCatalog) {
            case CONFIRMING: {
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.CONFIRMING.value()}));
                break;
            }
            case CHANGING: {
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.CHANGING.value()}));
                break;
            }
            case OPPOSITE_CONFIRMING: {
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.OPPOSITE_CONFIRMING.value()}));
                break;
            }
            case WAITING_MAKE_INVOICE: {
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.WAITING_MAKE_INVOICE.value()}));
                break;
            }
            case PENDING_MAKE_INVOICE: {
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.WAITING_MAKE_INVOICE.value()}));
                break;
            }
            case ALREADY_MAKE: {
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.WAITING_MAKE_INVOICE.value(), SalesBillCatalog.ALREADY_MAKE.value()}));
                break;
            }
            case ABANDONED: {
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.ABANDONED.value()}));
                break;
            }
            case ALL: {
                confirmFlagFilter.setFieldQueryType(Operator.not_in);
                confirmFlagFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{SalesBillCatalog.NO_EFFECT.value()}));
                break;
            }
            default: {
                return null;
            }
        }
        return confirmFlagFilter;
    }

    private SearchFilter getItemStatusFilter(SalesBillCatalog salesBillCatalog) {
        SearchFilter itemStatusFilter = new SearchFilter();
        itemStatusFilter.setFieldQueryType(Operator.eq);
        itemStatusFilter.setFieldName(BillFieldName.item_status.value());
        switch (salesBillCatalog) {
            case CONFIRMING: {
                itemStatusFilter.setFieldQueryType(Operator.not_in);
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.DELETED.value()}));
                break;
            }
            case CHANGING: {
                itemStatusFilter.setFieldQueryType(Operator.not_in);
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.DELETED.value()}));
                break;
            }
            case OPPOSITE_CONFIRMING: {
                itemStatusFilter.setFieldQueryType(Operator.not_in);
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.DELETED.value()}));
                break;
            }
            case WAITING_MAKE_INVOICE: {
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.NORMAL.value()}));
                break;
            }
            case ALREADY_MAKE: {
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.INVOICED.value()}));
                break;
            }
            case PENDING_MAKE_INVOICE: {
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.PRE_INVOICED.value()}));
                break;
            }
            case ABANDONED: {
                itemStatusFilter.setFieldQueryType(Operator.not_in);
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.DELETED.value()}));
                break;
            }
            case ALL: {
                itemStatusFilter.setFieldQueryType(Operator.not_in);
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.DELETED.value()}));
                break;
            }
            default: {
                itemStatusFilter.setFieldQueryType(Operator.not_in);
                itemStatusFilter.setValue((List)Lists.newArrayList((Object[])new Integer[]{BillItemStatus.DELETED.value()}));
            }
        }
        return itemStatusFilter;
    }

    private List<List<SearchFilter>> buildBillMainGroups(BillSearchModel billSearchModel) {
        List<List<SearchFilter>> newGroups = this.getCustomGroups(billSearchModel);
        List<List<SearchFilter>> groups = billSearchModel.getGroups();
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            groups = this.getBillMainGroups(groups);
        }
        return EsPageQueryUtils.mergeGroups(newGroups, (List)groups);
    }

    private List<List<SearchFilter>> buildBillItemGroups(BillSearchModel billSearchModel) {
        List newGroups = this.getItemCustomGroups(billSearchModel);
        List itemGroups = billSearchModel.getChildGroups();
        List<List<SearchFilter>> groups = billSearchModel.getGroups();
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            try {
                this.transInvoiceFilter(groups);
            }
            catch (Exception e) {
                throw new RuntimeException("\u53d1\u7968\u6761\u4ef6\u8f6c\u6362salesbillItemId\u67e5\u8be2\u5931\u8d25");
            }
            groups = this.getItemGroups(groups);
        }
        newGroups = EsPageQueryUtils.mergeGroups(newGroups, (List)itemGroups);
        newGroups = EsPageQueryUtils.mergeGroups((List)newGroups, (List)groups);
        return newGroups;
    }

    private void transInvoiceFilter(List<List<SearchFilter>> groups) {
        for (List<SearchFilter> group : groups) {
            ArrayList virtualFilters = Lists.newArrayList();
            for (SearchFilter filter : group) {
                if (!Lists.newArrayList((Object[])new String[]{BillFieldName.invoiceNo.value(), BillFieldName.invoiceCode.value()}).contains(filter.getFieldName())) continue;
                virtualFilters.add(filter);
            }
            if (virtualFilters.size() <= 0) continue;
            QuerySaleItemIdsByInvoiceRequest request = this.getRequestByFilters(virtualFilters);
            QuerySaleItemIdsByInvoiceResponse response = this.invoiceSalesClient.querySaleItemIdsByInvoice(request);
            List saleItemIds = null;
            if (Objects.nonNull(response) && Objects.nonNull(response.getResult())) {
                saleItemIds = ((QuerySaleItemIdsByInvoiceResult)response.getResult()).getSaleItemIds();
            }
            SearchFilter searchFilter = new SearchFilter(BillFieldName.salesbillItemId.value(), saleItemIds, Operator.checkbox);
            searchFilter.setVirtual(FieldSource.item.value());
            for (SearchFilter virtualFilter : virtualFilters) {
                group.set(group.indexOf(virtualFilter), searchFilter);
            }
        }
    }

    private List<List<SearchFilter>> getItemGroups(List<List<SearchFilter>> billGroups) {
        return billGroups.stream().map(group -> group.stream().filter(filter -> Objects.equals(FieldSource.item.value(), filter.getVirtual())).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<List<SearchFilter>> getBillMainGroups(List<List<SearchFilter>> billGroups) {
        return billGroups.stream().map(group -> group.stream().filter(filter -> Objects.equals(FieldSource.main.value(), filter.getVirtual())).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private QuerySaleItemIdsByInvoiceRequest getRequestByFilters(List<SearchFilter> virtualFilters) {
        QuerySaleItemIdsByInvoiceRequest request = new QuerySaleItemIdsByInvoiceRequest();
        Optional<SearchFilter> invoiceNoFilter = virtualFilters.stream().filter(filter -> Objects.equals(BillFieldName.invoiceNo.value(), filter.getFieldName())).findFirst();
        invoiceNoFilter.ifPresent(searchFilter -> {
            List value = searchFilter.getValue();
            if (!CollectionUtils.isEmpty((Collection)value)) {
                request.setInvoiceNo(String.valueOf(value.get(0)));
            }
        });
        Optional<SearchFilter> invoiceCodeFilter = virtualFilters.stream().filter(filter -> Objects.equals(BillFieldName.invoiceCode.value(), filter.getFieldName())).findFirst();
        invoiceCodeFilter.ifPresent(searchFilter -> {
            List value = searchFilter.getValue();
            if (!CollectionUtils.isEmpty((Collection)value)) {
                request.setInvoiceCode(String.valueOf(value.get(0)));
            }
        });
        return request;
    }

    private List<List<SearchFilter>> getItemCustomGroups(BillSearchModel billSearchModel) {
        ArrayList customGroups = Lists.newArrayList();
        ArrayList group = Lists.newArrayList();
        customGroups.add(group);
        SalesBillCatalog salesBillCatalog = SalesBillCatalog.fromValue(Integer.valueOf(billSearchModel.getBillStatus()));
        SearchFilter itemStatusFilter = this.getItemStatusFilter(salesBillCatalog);
        if (Objects.nonNull(itemStatusFilter)) {
            group.add(itemStatusFilter);
        }
        if (Objects.nonNull(billSearchModel.getSalesbillId())) {
            group.add(SearchFilter.getEqFilter((String)BillFieldName.salesbillId.value(), (List)Lists.newArrayList((Object[])new String[]{String.valueOf(billSearchModel.getSalesbillId())})));
        }
        return customGroups;
    }
}

