/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.runtime.Settings;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.SimpleBillItem;
import com.xforceplus.phoenix.bill.client.model.SimpleBillItemResponse;
import com.xforceplus.phoenix.bill.client.model.SimpleBillMain;
import com.xforceplus.phoenix.bill.client.model.SimpleBillMainResponse;
import com.xforceplus.phoenix.bill.core.service.CooperationService;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.daoext.OrdSalesbillItemExtDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import com.xforceplus.phoenix.bill.sqs.model.BillStatusChangeModel;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.sqs.SQSSender;
import com.xforceplus.xplatframework.model.Response;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CooperationServiceImpl
implements CooperationService {
    private Logger logger = LoggerFactory.getLogger(CooperationServiceImpl.class);
    @Autowired
    private OrdSalesbillDao ordSalesbillDao;
    @Autowired
    private OrdSalesbillItemDao ordSalesbillItemDao;
    @Autowired
    private SalesBillBatchDao salesBillBatchDao;
    @Autowired
    private OrdSalesbillItemExtDao ordSalesbillItemExtDao;

    @Override
    public SimpleBillMainResponse querySimpleBillMain(List<Long> salesBillIdList) {
        SimpleBillMainResponse response = new SimpleBillMainResponse();
        response.setCode(Response.Fail);
        if (CollectionUtils.isEmpty(salesBillIdList)) {
            response.setMessage("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            List<List<Long>> list = this.splitList(salesBillIdList, 10000);
            for (List<Long> idList : list) {
                OrdSalesbillExample example = new OrdSalesbillExample();
                example.createCriteria().andSalesbillIdIn((List)idList);
                List<OrdSalesbillEntity> entityList = this.ordSalesbillDao.selectByExample(example);
                if (CollectionUtils.isEmpty(entityList)) continue;
                entityList.forEach(entity -> {
                    SimpleBillMain billMain = new SimpleBillMain();
                    billMain.setAlreadyAmountWithTax(entity.getAlreadyMakeAmountWithTax());
                    billMain.setAmountWithTax(entity.getAmountWithTax());
                    billMain.setSalesbillId(entity.getSalesbillId());
                    billMain.setSalesbillNo(entity.getSalesbillNo());
                    response.addBillMain(billMain);
                });
            }
            response.setCode(Response.OK);
        }
        return response;
    }

    @Override
    public SimpleBillItemResponse querySimpleBillItem(List<Long> itemIdList) {
        SimpleBillItemResponse response = new SimpleBillItemResponse();
        if (CollectionUtils.isEmpty(itemIdList)) {
            response.setCode(Response.Fail);
            response.setMessage("\u660e\u7ec6id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            response.setCode(Response.OK);
            List<List<Long>> list = this.splitList(itemIdList, 10000);
            for (List<Long> idList : list) {
                OrdSalesbillItemExample example = new OrdSalesbillItemExample();
                example.createCriteria().andSalesbillItemIdIn((List)idList);
                List<OrdSalesbillItemEntity> itemList = this.ordSalesbillItemDao.selectByExample(example);
                if (CollectionUtils.isEmpty(itemList)) continue;
                itemList.forEach(item -> {
                    SimpleBillItem billItem = new SimpleBillItem();
                    billItem.setAlreayAmountWithTax(item.getAlreadyAmountWithTax());
                    billItem.setAmountWithTax(item.getAmountWithTax());
                    billItem.setSalesbillItemNo(item.getSalesbillItemNo());
                    billItem.setSalesbillItemId(item.getSalesbillItemId());
                    response.addItem(billItem);
                });
            }
        }
        return response;
    }

    @Override
    public void sendSalesbill(List<OrdSalesbillEntity> successMains, List<OrdSalesbillItemEntity> successItems, Map<String, Object> headers) {
        HashMap map = new HashMap();
        successItems.forEach(item -> {
            if (map.get(item.getSalesbillNo()) == null) {
                LinkedList<OrdSalesbillItemEntity> itemEntities = new LinkedList<OrdSalesbillItemEntity>();
                itemEntities.add((OrdSalesbillItemEntity)((Object)item));
                map.put(item.getSalesbillNo(), itemEntities);
            } else {
                LinkedList temp = (LinkedList)map.get(item.getSalesbillNo());
                temp.add(item);
                map.put(item.getSalesbillNo(), temp);
            }
        });
        StringBuilder sb = new StringBuilder();
        LinkedList list = new LinkedList();
        successMains.forEach(main -> {
            HashMap<String, Object> salesbillWapper = new HashMap<String, Object>();
            LinkedList temp = (LinkedList)map.get(main.getSalesbillNo());
            sb.append(main.getSalesbillNo()).append(",\u4e1a\u52a1\u5355\u660e\u7ec6\u6570\u91cf,").append(temp.size()).append("||");
            salesbillWapper.put("salesBillMain", main);
            salesbillWapper.put("salesBillDetails", temp);
            list.add(salesbillWapper);
        });
        HashMap reqMap = new HashMap();
        headers.keySet().forEach(key -> reqMap.put(key, String.valueOf(headers.get(key))));
        DslJson dslJson = new DslJson(Settings.withRuntime().allowArrayFormat(true).includeServiceLoader());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            dslJson.serialize(list, (OutputStream)os);
            this.logger.info("\u53d1\u9001\u4e1a\u52a1\u5355\u7ed9\u534f\u540c\u4ea7\u54c1\u7ebf---\u4e1a\u52a1\u5355\u53f7:{}", (Object)sb.toString());
            Result result = SQSSender.sendStrMsg((String)"phx-ant-settlement-import", (String)os.toString("utf-8"), reqMap, (boolean)true);
            if (!result.isSuc()) {
                this.logger.info("\u53d1\u9001\u4e1a\u52a1\u5355\u7ed9\u534f\u540c\u4ea7\u54c1\u7ebf\u53d1\u9001\u5931\u8d25-\u4e1a\u52a1\u5355\u53f7:{}", (Object)sb.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001ap\u534f\u540c\u4e1a\u52a1\u5355\u6570\u636e:{}", list, (Object)e);
        }
    }

    @Override
    public void sendSalesBillResult() {
    }

    @Override
    public void updateSalesBillStatus(BillStatusChangeModel billStatusChangeModel) {
    }

    @Override
    public void updateSalesBillAndItems(List<OrdSalesbillEntity> billMainList, List<OrdSalesbillItemEntity> billItemList) {
        ArrayList<OrdSalesbillEntity> tempList;
        int size;
        if (!CommonTools.isEmpty(billMainList)) {
            size = 0;
            tempList = new ArrayList<OrdSalesbillEntity>(1000);
            for (OrdSalesbillEntity ordSalesbillEntity : billMainList) {
                tempList.add(ordSalesbillEntity);
                if (++size <= 1000) continue;
                this.salesBillBatchDao.updateSalesBillBatchSelective(tempList);
                size = 0;
                tempList.clear();
            }
            if (size > 0) {
                this.salesBillBatchDao.updateSalesBillBatchSelective(tempList);
                tempList.clear();
            }
        }
        if (!CommonTools.isEmpty(billItemList)) {
            size = 0;
            tempList = new ArrayList(1000);
            for (OrdSalesbillItemEntity ordSalesbillItemEntity : billItemList) {
                tempList.add((OrdSalesbillEntity)((Object)ordSalesbillItemEntity));
                if (++size <= 1000) continue;
                this.ordSalesbillItemExtDao.updateBatchSelective(tempList);
                size = 0;
                tempList.clear();
            }
            if (size > 0) {
                this.ordSalesbillItemExtDao.updateBatchSelective(tempList);
                tempList.clear();
            }
        }
    }

    private List<List<Long>> splitList(List<Long> idList, int pageSize) {
        ArrayList resultList = Lists.newArrayList();
        int start = 0;
        while (start < idList.size()) {
            int end = start + pageSize;
            if (end > idList.size()) {
                end = idList.size();
            }
            resultList.add(idList.subList(start, end));
            start = end;
        }
        return resultList;
    }
}

