/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.confirm;

import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.core.impl.confirm.tools.BillConfirmTools;
import com.xforceplus.phoenix.bill.core.service.BillConfirmService;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.xplatframework.model.Response;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillConfirmServiceImpl
implements BillConfirmService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BillConfirmTools confirmTools;
    @Autowired
    private OrdSalesbillDao salesbillDao;

    @Override
    public Response confirmBillByCondition(BillRequest billRequest, String role) {
        this.logger.info("===========\u8fdb\u5165confirmBillByCondition\u65b9\u6cd5-request-{}==role-{}=========================", (Object)billRequest, (Object)role);
        Response response = this.confirmTools.preRejectAndConfirmByCondition(billRequest, role, BillOperationType.CONFIRM);
        if (Response.Fail.equals(response.getCode())) {
            return response;
        }
        Map map = (Map)response.getResult();
        List ordSalesbillEntities = (List)map.get("successSalesBill");
        return this.confirmTools.confirmBill(ordSalesbillEntities, role);
    }

    @Override
    public Response rejectBillByCondition(BillRequest billRequest, String role) {
        this.logger.info("===========\u8fdb\u5165rejectBillByCondition\u65b9\u6cd5-request-{}==role-{}========================", (Object)billRequest, (Object)role);
        Response response = this.confirmTools.preRejectAndConfirmByCondition(billRequest, role, BillOperationType.REJECT);
        if (Response.Fail.equals(response.getCode())) {
            return response;
        }
        Map map = (Map)response.getResult();
        List ordSalesbillEntities = (List)map.get("successSalesBill");
        String desc = billRequest.getDesc();
        return this.confirmTools.rejectBill(ordSalesbillEntities, role, desc);
    }
}

