/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.discount.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.constant.enums.DiscountType;
import com.xforceplus.phoenix.bill.exception.DiscountHandleException;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.Tuple2;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DiscountTools {
    private static final Logger logger = LoggerFactory.getLogger(DiscountTools.class);

    public void splitDiscountByType(List<OrdSalesbillInterfaceItemEntity> discountItems, DiscountType type) {
        LinkedHashMap<String, List<OrdSalesbillInterfaceItemEntity>> splitOrdSalesbillInterfaceItemEntity = this.splitByTaxRate(discountItems, type.containTax());
        Map<String, Tuple2<BigDecimal[], BigDecimal[]>> splitResult = this.splitAmount(splitOrdSalesbillInterfaceItemEntity, type.value(), type.containTax());
        for (Map.Entry entry : splitOrdSalesbillInterfaceItemEntity.entrySet()) {
            Tuple2<BigDecimal[], BigDecimal[]> result = splitResult.get(entry.getKey());
            List items = (List)splitOrdSalesbillInterfaceItemEntity.get(entry.getKey());
            for (int i = 0; i < items.size(); ++i) {
                this.getItemDiscountAmount((OrdSalesbillInterfaceItemEntity)((Object)items.get(i)), type, ((BigDecimal[])result.one)[i]);
            }
        }
    }

    private void getItemDiscountAmount(OrdSalesbillInterfaceItemEntity item, DiscountType type, BigDecimal result) {
        switch (type) {
            case inner_discount_with_tax: {
                BigDecimal amountWithTax = item.getInnerDiscountWithTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithoutTax = amountWithTax.subtract(taxAmount);
                item.setInnerDiscountWithTax(amountWithTax);
                item.setInnerDiscountWithoutTax(amountWithoutTax);
                item.setInnerDiscountTax(taxAmount);
                break;
            }
            case outter_discount_with_tax: {
                BigDecimal amountWithTax = item.getOutterDiscountWithTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithoutTax = amountWithTax.subtract(taxAmount);
                item.setOutterDiscountWithoutTax(amountWithoutTax);
                item.setOutterDiscountTax(taxAmount);
                item.setOutterDiscountWithTax(amountWithTax);
                break;
            }
            case inner_discount_without_tax: {
                BigDecimal amountWithoutTax = item.getInnerDiscountWithoutTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithoutTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithTax = amountWithoutTax.add(taxAmount);
                item.setInnerDiscountWithTax(amountWithTax);
                item.setInnerDiscountWithoutTax(amountWithoutTax);
                item.setInnerDiscountTax(taxAmount);
                break;
            }
            case outter_discount_without_tax: {
                BigDecimal amountWithoutTax = item.getOutterDiscountWithoutTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithoutTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithTax = amountWithoutTax.add(taxAmount);
                item.setOutterDiscountWithoutTax(amountWithoutTax);
                item.setOutterDiscountTax(taxAmount);
                item.setOutterDiscountWithTax(amountWithTax);
                break;
            }
            case inner_prepay_amount_with_tax: {
                BigDecimal amountWithTax = item.getInnerPrepayAmountWithTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithoutTax = amountWithTax.subtract(taxAmount);
                item.setInnerPrepayAmountWithTax(amountWithTax);
                item.setInnerPrepayAmountWithoutTax(amountWithoutTax);
                item.setInnerPrepayAmountTax(taxAmount);
                break;
            }
            case outter_prepay_amount_with_tax: {
                BigDecimal amountWithTax = item.getOutterPrepayAmountWithTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithoutTax = amountWithTax.subtract(taxAmount);
                item.setOutterPrepayAmountWithTax(amountWithTax);
                item.setOutterPrepayAmountWithoutTax(amountWithoutTax);
                item.setOutterPrepayAmountTax(taxAmount);
                break;
            }
            case inner_prepay_amount_without_tax: {
                BigDecimal amountWithoutTax = item.getInnerPrepayAmountWithoutTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithoutTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithTax = amountWithoutTax.add(taxAmount);
                item.setInnerPrepayAmountWithoutTax(amountWithoutTax);
                item.setInnerPrepayAmountTax(taxAmount);
                item.setInnerPrepayAmountWithTax(amountWithTax);
                break;
            }
            case outter_prepay_amount_without_tax: {
                BigDecimal amountWithoutTax = item.getOutterPrepayAmountWithoutTax().add(result);
                BigDecimal taxAmount = DiscountTools.computerTaxAmount(amountWithoutTax, item.getTaxRate(), type.containTax());
                BigDecimal amountWithTax = amountWithoutTax.add(taxAmount);
                item.setOutterPrepayAmountWithoutTax(amountWithoutTax);
                item.setOutterPrepayAmountTax(taxAmount);
                item.setOutterPrepayAmountWithTax(amountWithTax);
                break;
            }
        }
    }

    public LinkedHashMap<String, List<OrdSalesbillInterfaceItemEntity>> splitByTaxRate(List<OrdSalesbillInterfaceItemEntity> items, boolean containTax) {
        LinkedHashMap<String, List<OrdSalesbillInterfaceItemEntity>> result = new LinkedHashMap<String, List<OrdSalesbillInterfaceItemEntity>>();
        for (OrdSalesbillInterfaceItemEntity ordSalesbillInterfaceItemEntity : items) {
            String taxRate = CommonTools.formatDecimal(ordSalesbillInterfaceItemEntity.getTaxRate(), 2);
            if (result.containsKey(taxRate)) {
                ((List)result.get(taxRate)).add(ordSalesbillInterfaceItemEntity);
                continue;
            }
            result.put(taxRate, Lists.newArrayList((Object[])new OrdSalesbillInterfaceItemEntity[]{ordSalesbillInterfaceItemEntity}));
        }
        for (Map.Entry entry : result.entrySet()) {
            Collections.sort((List)entry.getValue(), (a, b) -> this.getActualPay((OrdSalesbillInterfaceItemEntity)((Object)((Object)a)), containTax).compareTo(this.getActualPay((OrdSalesbillInterfaceItemEntity)((Object)((Object)b)), containTax)));
        }
        ArrayList tmpList = Lists.newArrayList(result.entrySet());
        Collections.sort(tmpList, (a, b) -> {
            List aItems = (List)a.getValue();
            List bItems = (List)b.getValue();
            BigDecimal tmpa = aItems.stream().map(item -> this.getActualPay((OrdSalesbillInterfaceItemEntity)((Object)((Object)((Object)item))), containTax)).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            BigDecimal tmpb = bItems.stream().map(item -> this.getActualPay((OrdSalesbillInterfaceItemEntity)((Object)((Object)((Object)item))), containTax)).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            return tmpa.compareTo(tmpb);
        });
        result.clear();
        for (Map.Entry entry : tmpList) {
            result.put((String)entry.getKey(), (List<OrdSalesbillInterfaceItemEntity>)entry.getValue());
        }
        return result;
    }

    private BigDecimal getActualPay(OrdSalesbillInterfaceItemEntity item, boolean containTax) {
        BigDecimal pay = BigDecimal.ZERO;
        pay = !containTax ? item.getAmountWithoutTax().subtract(Optional.ofNullable(item.getOutterDiscountWithoutTax()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getOutterPrepayAmountWithoutTax()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getInnerPrepayAmountWithoutTax()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getInnerDiscountWithoutTax()).orElse(BigDecimal.ZERO)) : item.getAmountWithTax().subtract(Optional.ofNullable(item.getOutterDiscountWithTax()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getOutterPrepayAmountWithTax()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getInnerPrepayAmountWithTax()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getInnerDiscountWithTax()).orElse(BigDecimal.ZERO));
        if (pay.compareTo(BigDecimal.ZERO) < 0) {
            throw new DiscountHandleException("\u660e\u7ec6\u6263\u9664\u6298\u6263\u540e\u5df2\u6210\u8d1f\u503c\uff01");
        }
        return pay;
    }

    public Map<String, Tuple2<BigDecimal[], BigDecimal[]>> splitAmount(Map<String, List<OrdSalesbillInterfaceItemEntity>> result, BigDecimal waitForSplit, boolean constainTax) {
        ArrayList list = Lists.newArrayList();
        HashMap splitResult = Maps.newHashMap();
        ArrayList subList = Lists.newArrayList();
        BigDecimal total = BigDecimal.ZERO;
        for (List<OrdSalesbillInterfaceItemEntity> dicountItems : result.values()) {
            BigDecimal tmp = dicountItems.stream().map(item -> this.getActualPay((OrdSalesbillInterfaceItemEntity)((Object)item), constainTax)).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
            subList.add(tmp);
            total = total.add(tmp);
        }
        BigDecimal[] sublistArray = subList.toArray(new BigDecimal[subList.size()]);
        int originLength = sublistArray.length;
        BigDecimal[] toSplitSublist = this.preSplitWithDiffRate(sublistArray, waitForSplit, result.keySet().toArray(new String[result.keySet().size()]));
        Tuple2<BigDecimal[], BigDecimal[]> ret = this.splitAmountWithRate(toSplitSublist, waitForSplit, BigDecimal.ZERO, constainTax);
        ret = this.fillResult(ret, originLength);
        BigDecimal[] toSplit = (BigDecimal[])ret.one;
        int i = 0;
        for (Map.Entry<String, List<OrdSalesbillInterfaceItemEntity>> entry : result.entrySet()) {
            String taxRate = entry.getKey();
            BigDecimal[] item2 = entry.getValue().stream().map(m -> this.getActualPay((OrdSalesbillInterfaceItemEntity)((Object)m), constainTax)).collect(Collectors.toList()).toArray(new BigDecimal[entry.getValue().size()]);
            int origin = item2.length;
            BigDecimal[] toSplitItem = this.preSplit(item2, toSplit[i], taxRate);
            Tuple2<BigDecimal[], BigDecimal[]> subResult = this.splitAmountWithRate(toSplitItem, toSplit[i], new BigDecimal(taxRate), constainTax);
            Tuple2<BigDecimal[], BigDecimal[]> filledResult = this.fillResult(subResult, origin);
            splitResult.put(entry.getKey(), filledResult);
            ++i;
        }
        return splitResult;
    }

    private BigDecimal[] preSplit(BigDecimal[] item, BigDecimal toSplit, String taxRate) {
        BigDecimal[] maxItem = new BigDecimal[]{item[item.length - 1]};
        BigDecimal subTotal = DiscountTools.total(item);
        if (subTotal.compareTo(BigDecimal.ZERO) != 0) {
            while (item.length > 0 && item[0].multiply(toSplit).multiply(new BigDecimal(taxRate)).divide(subTotal, 4).compareTo(new BigDecimal("0.01")) < 0 && new BigDecimal(taxRate).compareTo(BigDecimal.ZERO) != 0) {
                logger.warn("\u53ef\u80fd\u4f1a\u51fa\u73b0\u96f6\u7a0e\u7387\uff0c\u5254\u9664\u96f6\u7a0e\u7387\u660e\u7ec6\uff0c\u660e\u7ec6\u91d1\u989d{}", (Object)item[0]);
                BigDecimal[] tmp = new BigDecimal[item.length - 1];
                System.arraycopy(item, 1, tmp, 0, item.length - 1);
                item = tmp;
            }
        }
        BigDecimal[] toSplitItem = item.length > 0 ? item : maxItem;
        return toSplitItem;
    }

    public static BigDecimal computerTaxAmount(BigDecimal amount, BigDecimal taxRate, boolean containsTax) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (!containsTax) {
            taxAmount = amount.multiply(taxRate).setScale(2, 4);
        } else {
            taxAmount = amount.multiply(taxRate).divide(taxRate.add(BigDecimal.ONE), 10, 4).setScale(2, 4);
            if (taxAmount.compareTo(BigDecimal.ZERO) == 0) {
                logger.warn("\u51fa\u73b0\u96f6\u7a0e\u989d,\u9700\u91cd\u65b0\u8c03\u6574\u7a0e\u989d..");
                taxAmount = amount.multiply(taxRate).setScale(2, 4);
                logger.info("\u8c03\u6574\u540e\u7684\u7a0e\u989d {}", (Object)CommonTools.formatDecimal(taxAmount, 2));
            }
        }
        return taxAmount;
    }

    private BigDecimal[] preSplitWithDiffRate(BigDecimal[] item, BigDecimal toSplit, String[] taxRate) {
        BigDecimal[] maxItem = new BigDecimal[]{item[item.length - 1]};
        BigDecimal subTotal = DiscountTools.total(item);
        ArrayList checkedSplit = Lists.newArrayList();
        for (int i = 0; i < item.length; ++i) {
            if (item[i].multiply(toSplit).multiply(new BigDecimal(taxRate[i])).divide(subTotal, 4).compareTo(new BigDecimal("0.01")) < 0 && new BigDecimal(taxRate[i]).compareTo(BigDecimal.ZERO) != 0) {
                logger.warn("\u53ef\u80fd\u4f1a\u51fa\u73b0\u96f6\u7a0e\u989d\uff0c\u5254\u9664\u96f6\u7a0e\u989d\u660e\u7ec6\uff0c\u660e\u7ec6\u91d1\u989d{}", (Object)item[0]);
                continue;
            }
            checkedSplit.add(item[i]);
        }
        BigDecimal[] toSplitItem = checkedSplit.size() > 0 ? checkedSplit.toArray(new BigDecimal[checkedSplit.size()]) : maxItem;
        return toSplitItem;
    }

    public static BigDecimal total(BigDecimal[] list) {
        return Arrays.stream(list).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
    }

    public Tuple2<BigDecimal[], BigDecimal[]> fillResult(Tuple2<BigDecimal[], BigDecimal[]> subResult, int origin) {
        BigDecimal[] discount = (BigDecimal[])subResult.one;
        BigDecimal[] discountTax = (BigDecimal[])subResult.two;
        BigDecimal[] discountRet = new BigDecimal[origin];
        BigDecimal[] discountTaxRet = new BigDecimal[origin];
        for (int j = 0; j < origin - discount.length; ++j) {
            discountRet[j] = BigDecimal.ZERO;
            discountTaxRet[j] = BigDecimal.ZERO;
        }
        System.arraycopy(discount, 0, discountRet, origin - discount.length, discount.length);
        System.arraycopy(discountTax, 0, discountTaxRet, origin - discountTax.length, discountTax.length);
        return Tuple2.of(discountRet, discountTaxRet);
    }

    public Tuple2<BigDecimal[], BigDecimal[]> splitAmountWithRate(BigDecimal[] infoArea, BigDecimal waitForSplit, BigDecimal taxRate, boolean constainTax) {
        int i;
        int i2;
        BigDecimal[] repairAhouAmt = new BigDecimal[infoArea.length];
        BigDecimal[] repairTaxAmt = new BigDecimal[infoArea.length];
        BigDecimal factRepairAmt = new BigDecimal("0");
        BigDecimal factRepairTax = BigDecimal.ZERO;
        BigDecimal ftTax = !constainTax ? waitForSplit.multiply(taxRate).setScale(2, 4) : waitForSplit.subtract(waitForSplit.divide(BigDecimal.ONE.add(taxRate), 4));
        int count = repairAhouAmt.length;
        BigDecimal totalArea = BigDecimal.ZERO;
        for (i2 = 0; i2 < count; ++i2) {
            totalArea = totalArea.add(infoArea[i2]);
        }
        for (i2 = 0; i2 < count; ++i2) {
            BigDecimal oaHouArea = infoArea[i2];
            repairAhouAmt[i2] = totalArea.compareTo(BigDecimal.ZERO) != 0 ? oaHouArea.multiply(waitForSplit).divide(totalArea, 2, 1) : BigDecimal.ZERO;
            repairTaxAmt[i2] = !constainTax ? repairAhouAmt[i2].multiply(taxRate).setScale(2, 1) : repairAhouAmt[i2].subtract(repairAhouAmt[i2].divide(BigDecimal.ONE.add(taxRate), 4));
            factRepairAmt = factRepairAmt.add(repairAhouAmt[i2]);
            factRepairTax = factRepairTax.add(repairTaxAmt[i2]);
        }
        BigDecimal repairOddmentAmt = factRepairAmt.subtract(waitForSplit);
        BigDecimal repariOddmentTax = factRepairTax.subtract(ftTax);
        int repairInt = repairOddmentAmt.multiply(new BigDecimal("100")).abs().intValue();
        int repairTaxInt = repariOddmentTax.multiply(new BigDecimal("100")).abs().intValue();
        if (repairInt <= count && repairInt > 0) {
            if (repairOddmentAmt.compareTo(BigDecimal.ZERO) < 0) {
                for (i = 0; i < count && repairInt > 0; ++i) {
                    if (infoArea[i].compareTo(repairAhouAmt[i].add(new BigDecimal("0.01"))) == 0) continue;
                    repairAhouAmt[i] = repairAhouAmt[i].add(new BigDecimal("0.01"));
                    --repairInt;
                }
            } else {
                for (i = 0; i < count && repairInt > 0; ++i) {
                    if (infoArea[i].compareTo(repairAhouAmt[i].subtract(new BigDecimal("0.01"))) == 0) continue;
                    repairAhouAmt[i] = repairAhouAmt[i].subtract(new BigDecimal("0.01"));
                    --repairInt;
                }
            }
        } else if (repairInt != 0) {
            throw new DiscountHandleException("\u975e\u6cd5\u64cd\u4f5c\uff01");
        }
        if (repairTaxInt <= count && repairTaxInt > 0) {
            if (repariOddmentTax.compareTo(BigDecimal.ZERO) < 0) {
                for (i = 0; i < repairTaxInt; ++i) {
                    repairTaxAmt[i] = repairTaxAmt[i].add(new BigDecimal("0.01"));
                }
            } else {
                for (i = 0; i < repairTaxInt; ++i) {
                    repairTaxAmt[i] = repairTaxAmt[i].subtract(new BigDecimal("0.01"));
                }
            }
        } else if (repairTaxInt != 0) {
            throw new DiscountHandleException("\u62c6\u5206\u6298\u6263\u5931\u8d25\uff01");
        }
        ArrayList adjust = Lists.newArrayList();
        ArrayList adjustIndex = Lists.newArrayList();
        ArrayList normalIndex = Lists.newArrayList();
        for (int i3 = 0; i3 < repairAhouAmt.length; ++i3) {
            if (repairAhouAmt[i3].multiply(repairTaxAmt[i3]).compareTo(BigDecimal.ZERO) == 0) {
                if (repairAhouAmt[i3].add(repairTaxAmt[i3]).compareTo(BigDecimal.ZERO) == 0) continue;
                adjust.add(Tuple2.of(repairAhouAmt[i3], repairTaxAmt[i3]));
                adjustIndex.add(i3);
                continue;
            }
            normalIndex.add(i3);
        }
        if (adjustIndex.size() > normalIndex.size()) {
            int k = 0;
            while (k < adjustIndex.size() && normalIndex.size() != 0) {
                for (int i4 = 0; i4 < normalIndex.size() && k < adjustIndex.size(); ++k, ++i4) {
                    repairAhouAmt[((Integer)normalIndex.get((int)i4)).intValue()] = repairAhouAmt[(Integer)normalIndex.get(i4)].add(repairAhouAmt[(Integer)adjustIndex.get(k)]);
                    repairTaxAmt[((Integer)normalIndex.get((int)i4)).intValue()] = repairTaxAmt[(Integer)normalIndex.get(i4)].add(repairTaxAmt[(Integer)adjustIndex.get(k)]);
                    repairAhouAmt[((Integer)adjustIndex.get((int)k)).intValue()] = BigDecimal.ZERO;
                    repairTaxAmt[((Integer)adjustIndex.get((int)k)).intValue()] = BigDecimal.ZERO;
                }
            }
        } else {
            int j = 0;
            for (int i5 = 0; i5 < adjustIndex.size(); ++i5) {
                repairAhouAmt[((Integer)normalIndex.get((int)j)).intValue()] = repairAhouAmt[(Integer)normalIndex.get(j)].add(repairAhouAmt[(Integer)adjustIndex.get(i5)]);
                repairTaxAmt[((Integer)normalIndex.get((int)j)).intValue()] = repairTaxAmt[(Integer)normalIndex.get(j)].add(repairTaxAmt[(Integer)adjustIndex.get(i5)]);
                repairAhouAmt[((Integer)adjustIndex.get((int)i5)).intValue()] = BigDecimal.ZERO;
                repairTaxAmt[((Integer)adjustIndex.get((int)i5)).intValue()] = BigDecimal.ZERO;
                ++j;
            }
        }
        return Tuple2.of(repairAhouAmt, repairTaxAmt);
    }
}

