/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl.upload;

import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.model.UploadMessage;
import com.xforceplus.phoenix.bill.core.service.BillUploadService;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillUploadServiceImpl
implements BillUploadService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private RabbitmqService rabbitmqService;

    @Override
    public Response uploadBill(UploadMessage uploadMessage, UserInfo userInfo) {
        HashMap headers = Maps.newHashMap();
        headers.put("versionNo", uploadMessage.getVersionNo());
        headers.put("systemOrig", uploadMessage.getSystemOrig());
        headers.put("status", uploadMessage.getStatus());
        headers.put("customNo", uploadMessage.getCustomNo());
        headers.put("groupId", userInfo.getGroupId());
        headers.put("orgId", userInfo.getOrgId());
        headers.put("orgCode", userInfo.getOrgCode());
        headers.put("userId", userInfo.getUserId());
        headers.put("userName", userInfo.getUserName());
        headers.put("mobile", userInfo.getMobile());
        headers.put("businessBillType", uploadMessage.getBusinessBillType());
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.getHeaders().putAll(headers);
        String json = JsonUtils.writeObjectToFastJson(uploadMessage.getMessage());
        this.rabbitmqService.send("phoenix.bill.upload", json.toString(), (Map)headers);
        return Response.from((Integer)Response.OK, (String)"\u5bfc\u5165\u5355\u636e\u6d88\u606f\u53d1\u9001\u6210\u529f");
    }
}

