/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.tools;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.BillSearchModel;
import com.xforceplus.phoenix.bill.client.model.Exclude;
import com.xforceplus.phoenix.bill.client.model.Include;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.bill.client.model.UserRole;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.esutils.EsPageQueryUtils;
import com.xforceplus.phoenix.esutils.bean.SearchFilter;
import com.xforceplus.phoenix.esutils.enums.FieldSource;
import com.xforceplus.phoenix.esutils.enums.Operator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class BillSearchTools {
    private static final String SALES_BILL_ID_FIELD = "salesbillId";
    private static final String SALES_BILL_ITEM_ID_FIELD = "salesbillItemId";

    public static void setExcludeFilterGroups(List<Exclude> excludeList, List<List<SearchFilter>> outFilterGroups) {
        if (!CollectionUtils.isEmpty(excludeList)) {
            for (Exclude exclude : excludeList) {
                ArrayList group = Lists.newArrayList();
                BillSearchTools.fillItemGroup(group, exclude.getIsAllSelected(), exclude.getSalesbillId(), exclude.getIncludes(), exclude.getExcludes());
                if (CollectionUtils.isEmpty((Collection)group)) continue;
                outFilterGroups.add(group);
            }
            SearchFilter searchFilter = new SearchFilter(SALES_BILL_ID_FIELD, excludeList.stream().map(Exclude::getSalesbillId).collect(Collectors.toList()), Operator.not_in);
            outFilterGroups.add(Lists.newArrayList((Object[])new SearchFilter[]{searchFilter}));
        }
    }

    public static void setIncluceFilterGroups(List<Include> includeList, List<List<SearchFilter>> outFilterGroups) {
        if (!CollectionUtils.isEmpty(includeList)) {
            for (Include include : includeList) {
                ArrayList group = Lists.newArrayList();
                BillSearchTools.fillItemGroup(group, include.getIsAllSelected(), include.getSalesbillId(), include.getIncludes(), include.getExcludes());
                if (CollectionUtils.isEmpty((Collection)group)) continue;
                outFilterGroups.add(group);
            }
        }
    }

    private static void fillItemGroup(List<SearchFilter> group, boolean isAll, String salesbillId, List<String> includes, List<String> excludes) {
        if (isAll) {
            BillSearchTools.setSearchFilterLongValue(SALES_BILL_ID_FIELD, Lists.newArrayList((Object[])new String[]{salesbillId}), Operator.eq, group);
            if (!CollectionUtils.isEmpty(excludes)) {
                BillSearchTools.setSearchFilterLongValue(SALES_BILL_ITEM_ID_FIELD, excludes, Operator.not_in, group);
            }
        } else if (!CollectionUtils.isEmpty(includes)) {
            BillSearchTools.setSearchFilterLongValue(SALES_BILL_ID_FIELD, Lists.newArrayList((Object[])new String[]{salesbillId}), Operator.eq, group);
            BillSearchTools.setSearchFilterLongValue(SALES_BILL_ITEM_ID_FIELD, includes, Operator.checkbox, group);
        }
    }

    private static void setSearchFilterLongValue(String fieldName, List<String> value, Operator operator, List<SearchFilter> group) {
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setFieldName(fieldName);
        searchFilter.setFieldQueryType(operator);
        searchFilter.setVirtual(FieldSource.item.value());
        searchFilter.setValue(value);
        group.add(searchFilter);
    }

    public static BillSearchModel getSearchCondition(BillRequest billRequest, String role) {
        if (null == billRequest || null == billRequest.getConditions()) {
            return null;
        }
        BillSearchModel billSearchModel = billRequest.getConditions();
        billSearchModel.setUserRole(BusinessBillType.AR.value().equals(role) ? UserRole.SELLER.value() : UserRole.PURCHASER.value());
        ArrayList searchFilters = Lists.newArrayList();
        SearchFilter searchFilter = new SearchFilter();
        searchFilter.setFieldName(SALES_BILL_ID_FIELD);
        if (!billRequest.getIsAllSelected().booleanValue()) {
            List includes = billRequest.getIncludes();
            searchFilter.setValue(includes);
            searchFilter.setFieldQueryType(Operator.checkbox);
            searchFilter.setVirtual(FieldSource.main.value());
        } else {
            List excludes = billRequest.getExcludes();
            searchFilter.setValue(excludes);
            searchFilter.setFieldQueryType(Operator.not_in);
            searchFilter.setVirtual(FieldSource.main.value());
        }
        searchFilters.add(searchFilter);
        List groups = EsPageQueryUtils.mergeGroups((List)billSearchModel.getGroups(), Arrays.asList(searchFilters));
        billSearchModel.setGroups(groups);
        return billSearchModel;
    }

    public static List<OrdSalesbillEntity> convertVosToEntites(List<OrdSalesbillVO> salesbillVOList) {
        ArrayList entities = Lists.newArrayList();
        salesbillVOList.stream().forEach(m -> {
            OrdSalesbillEntity ordSalesbillEntity = new OrdSalesbillEntity();
            BeanUtils.copyProperties(m, (Object)ordSalesbillEntity);
            entities.add(ordSalesbillEntity);
        });
        return entities;
    }
}

