/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.billitem;

import com.baidu.unbiz.fluentvalidator.ValidationError;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.google.common.collect.Sets;
import com.xforceplus.phoenix.bill.client.model.MergeBillItemValidatePreviewRequest;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.constant.enums.BillItemMergeType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitByMoneyValidator;
import com.xforceplus.phoenix.bill.manager.SalesbillMergeAndSplitManager;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BillItemMergeValidate
extends ValidatorHandler<MergeBillItemValidatePreviewRequest>
implements Validator<MergeBillItemValidatePreviewRequest> {
    private static final Logger logger = LoggerFactory.getLogger(BillItemSplitByMoneyValidator.class);

    public boolean accept(ValidatorContext validatorContext, MergeBillItemValidatePreviewRequest request) {
        return true;
    }

    public boolean validate(ValidatorContext context, MergeBillItemValidatePreviewRequest request) {
        BillItemMergeType billItemMergeType;
        List ordSalesbillItemEntityList = (List)context.getAttribute("ORD_SALESBILL_ITEM_ENTITY_LIST", List.class);
        List ordSalesbillEntityList = (List)context.getAttribute("ORD_SALESBILL_ENTITY_LIST", List.class);
        Map<Long, OrdSalesbillEntity> ordSalesbillEntityMap = ordSalesbillEntityList.stream().collect(Collectors.toMap(OrdSalesbillEntity::getSalesbillId, item -> item));
        if (ordSalesbillItemEntityList.stream().map(OrdSalesbillItemEntity::getTaxRate).distinct().count() > 1L) {
            context.addError(ValidationError.create((String)"\u5f85\u5408\u5e76\u5355\u636e\u660e\u7ec6\u3010\u7a0e\u7387\u3011\u4e0d\u4e00\u81f4."));
            return false;
        }
        boolean billCheckResult = this.checkBillFieldsEqual(context, ordSalesbillEntityList, ordSalesbillEntityMap);
        if (!billCheckResult) {
            return false;
        }
        Integer priceMethod = ((OrdSalesbillEntity)((Object)ordSalesbillEntityList.get(0))).getPriceMethod();
        if (!this.checkSalesbillItemListEqual(context, ordSalesbillItemEntityList, request, priceMethod, billItemMergeType = BillItemMergeType.fromValue(request.getQuantityPriceResult()))) {
            return false;
        }
        SalesbillMergeAndSplitManager.fillMergedSalesbillItemFields(ordSalesbillItemEntityList, request.getSalesbillItem());
        return true;
    }

    public void onException(Exception e, ValidatorContext context, MergeBillItemValidatePreviewRequest request) {
    }

    private boolean checkBillFieldsEqual(ValidatorContext context, List<OrdSalesbillEntity> ordSalesbillEntityList, Map<Long, OrdSalesbillEntity> ordSalesbillEntityMap) {
        String diff = null;
        String businessBillTypeDiff = null;
        Integer priceMethod = null;
        for (OrdSalesbillEntity salesbillEntity : ordSalesbillEntityList) {
            String salesBillNo = salesbillEntity.getSalesbillNo();
            String sellerName = salesbillEntity.getSellerName();
            String sellerTaxNo = salesbillEntity.getSellerTaxNo();
            String purchaserName = salesbillEntity.getPurchaserName();
            String purchaserTaxNo = salesbillEntity.getPurchaserTaxNo();
            String businessBillType = salesbillEntity.getBusinessBillType();
            if (Objects.isNull((Object)ordSalesbillEntityMap.get(salesbillEntity.getSalesbillId()))) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u5934\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.", salesBillNo)));
                return false;
            }
            if (StringUtils.isEmpty((String)sellerTaxNo)) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u8865\u5168\u4fe1\u606f\u540e\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c.", salesBillNo)));
                return false;
            }
            if (StringUtils.isEmpty((String)sellerName)) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u9500\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u8865\u5168\u4fe1\u606f\u540e\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c.", salesBillNo)));
                return false;
            }
            if (StringUtils.isEmpty((String)purchaserName)) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u8865\u5168\u4fe1\u606f\u540e\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c.", salesBillNo)));
                return false;
            }
            if (StringUtils.isEmpty((String)purchaserTaxNo)) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u8865\u5168\u4fe1\u606f\u540e\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c.", salesBillNo)));
                return false;
            }
            String sellerPurchaserStr = sellerName + sellerTaxNo + purchaserName + purchaserTaxNo;
            if (StringUtils.isEmpty(diff)) {
                diff = sellerPurchaserStr;
            } else if (!diff.equals(sellerPurchaserStr) && !StringUtils.isEmpty((String)diff)) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u4e0e\u5176\u5b83\u5355\u636e\u7f16\u8d2d\u9500\u65b9\u4e0d\u4e00\u81f4.", salesBillNo)));
                return false;
            }
            if (StringUtils.isEmpty(businessBillTypeDiff)) {
                businessBillTypeDiff = businessBillType;
            } else if (!businessBillTypeDiff.equals(businessBillType)) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u4e0e\u5176\u5b83\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u4e00\u81f4.", salesBillNo)));
                return false;
            }
            if (null == priceMethod) {
                priceMethod = salesbillEntity.getPriceMethod();
                continue;
            }
            if (priceMethod.equals(salesbillEntity.getPriceMethod())) continue;
            context.addError(ValidationError.create((String)String.format("\u5355\u636e\u7f16\u53f7:\u3010%s\u3011\u4e0e\u5176\u5b83\u5355\u636e\u5355\u4ef7\u683c\u65b9\u5f0f\u4e0d\u4e00\u81f4.", salesBillNo)));
            return false;
        }
        return true;
    }

    private boolean checkSalesbillItemListEqual(ValidatorContext context, List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, MergeBillItemValidatePreviewRequest request, Integer priceMethod, BillItemMergeType quantityPriceResult) {
        BigDecimal totalAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal totalAmountWithTax = BigDecimal.ZERO;
        BigDecimal quantity = BigDecimal.ZERO;
        HashSet quantityUnitSet = Sets.newHashSet();
        if (ordSalesbillItemEntityList.stream().map(OrdSalesbillItemEntity::getTaxRate).distinct().count() > 1L) {
            context.addError(ValidationError.create((String)"\u5f85\u5408\u5e76\u660e\u7ec6\u3010\u7a0e\u7387\u3011\u4e0d\u4e00\u81f4."));
            return false;
        }
        for (OrdSalesbillItemEntity salesbillItemEntity : ordSalesbillItemEntityList) {
            if (BillItemOrigin.SPLIT.value().equals(salesbillItemEntity.getOrigin())) {
                context.addError(ValidationError.create((String)String.format("\u5355\u636e\u660e\u7ec6ID:\u3010%s\u3011\u5df2\u53c2\u4e0e\u8fc7\u62c6\u5206\uff0c\u4e0d\u80fd\u8fdb\u884c\u5408\u5e76\u64cd\u4f5c.", salesbillItemEntity.getSalesbillId())));
                return false;
            }
            quantity = quantity.add(salesbillItemEntity.getQuantity());
            totalAmountWithoutTax = totalAmountWithoutTax.add(salesbillItemEntity.getAmountWithoutTax());
            totalAmountWithTax = totalAmountWithTax.add(salesbillItemEntity.getAmountWithTax());
            quantityUnitSet.add(salesbillItemEntity.getQuantityUnit());
        }
        if (!quantityPriceResult.equals(BillItemMergeType.CLEAR_QUANTITY_PRICE.value()) && BigDecimal.ZERO.compareTo(quantity) == 0) {
            context.addError(ValidationError.create((String)"\u975e\u6e05\u7a7a\u6570\u91cf\u548c\u5355\u4ef7\u65b9\u5f0f\uff0c\u6570\u91cf\u7d2f\u52a0\u548c\u4e0d\u80fd\u4e3a0."));
            return false;
        }
        if (request.getSalesbillItem().getTaxRate().compareTo(ordSalesbillItemEntityList.get(0).getTaxRate()) != 0) {
            context.addError(ValidationError.create((String)"\u5408\u5e76\u540e\u660e\u7ec6\u3010\u7a0e\u7387\u3011\u4e0e\u539f\u660e\u7ec6\u7a0e\u7387\u4e0d\u4e00\u81f4."));
            return false;
        }
        if (totalAmountWithoutTax.compareTo(request.getSalesbillItem().getAmountWithoutTax()) != 0) {
            context.addError(ValidationError.create((String)"\u660e\u7ec6\u7684\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u7d2f\u52a0\u603b\u989d\u4e0d\u4e00\u81f4."));
            return false;
        }
        if (totalAmountWithTax.compareTo(request.getSalesbillItem().getAmountWithTax()) != 0) {
            context.addError(ValidationError.create((String)"\u660e\u7ec6\u7684\u3010\u542b\u7a0e\u91d1\u989d\u3011\u7d2f\u52a0\u603b\u989d\u4e0d\u4e00\u81f4."));
            return false;
        }
        if (!this.mergeBillItemByQuantityPriceCheck(context, ordSalesbillItemEntityList, priceMethod, request, quantityPriceResult)) {
            return false;
        }
        if (!quantityPriceResult.equals(BillItemMergeType.CLEAR_QUANTITY_PRICE.value()) && !quantityUnitSet.contains("") && quantityUnitSet.contains(null) && StringUtils.isEmpty((String)request.getSalesbillItem().getQuantityUnit())) {
            context.addError(ValidationError.create((String)"\u5408\u5e76\u524d\u660e\u7ec6\u5355\u4f4d\u5982\u679c\u4efb\u610f\u4e00\u6761\u4e0d\u4e3a\u7a7a\uff0c\u5408\u5e76\u540e\u7684\u5355\u4f4d\u4e5f\u4e0d\u80fd\u4e3a\u7a7a."));
            return false;
        }
        return true;
    }

    private boolean mergeBillItemByQuantityPriceCheck(ValidatorContext context, List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, Integer priceMethod, MergeBillItemValidatePreviewRequest request, BillItemMergeType quantityPriceResult) {
        boolean quantityPriceCheckResult = false;
        switch (quantityPriceResult) {
            case QUANTITY_ADD: {
                quantityPriceCheckResult = this.mergeBillItemByQuantityAddCheck(context, ordSalesbillItemEntityList, request);
                break;
            }
            case QUANTITY_MERGE_ONE: {
                quantityPriceCheckResult = this.mergeBillItemByQuantityMergeOneCheck(ordSalesbillItemEntityList, request);
                break;
            }
            case RESERVED_PRICE: {
                quantityPriceCheckResult = this.mergeBillItemByReservedPriceCheck(context, ordSalesbillItemEntityList, priceMethod, request.getSalesbillItem());
                break;
            }
            case CLEAR_QUANTITY_PRICE: {
                quantityPriceCheckResult = this.mergeBillItemByClearQuantityAndPriceCheck(context, priceMethod, request.getSalesbillItem());
                break;
            }
            default: {
                context.addError(ValidationError.create((String)"\u91d1\u989d\u5408\u5e76\u65b9\u5f0f\u53c2\u6570\u6709\u8bef."));
            }
        }
        if (!quantityPriceCheckResult) {
            return quantityPriceCheckResult;
        }
        return true;
    }

    private boolean mergeBillItemByQuantityAddCheck(ValidatorContext context, List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, MergeBillItemValidatePreviewRequest request) {
        BigDecimal totalQuantity = BigDecimal.ZERO;
        BigDecimal amountWithTax = BigDecimal.ZERO;
        BigDecimal amountWithoutTax = BigDecimal.ZERO;
        for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
            totalQuantity = totalQuantity.add(itemEntity.getQuantity());
            amountWithTax = amountWithTax.add(itemEntity.getAmountWithTax());
            amountWithoutTax = amountWithoutTax.add(itemEntity.getAmountWithoutTax());
        }
        if (totalQuantity.compareTo(request.getSalesbillItem().getQuantity()) != 0) {
            context.addError(ValidationError.create((String)"\u5408\u5e76\u540e\u6570\u91cf\u4e0e\u539f\u660e\u7ec6\u7d2f\u52a0\u548c\u4e0d\u4e00\u81f4."));
            return false;
        }
        BigDecimal unitPriceWithTax = amountWithTax.divide(totalQuantity, 15, 4);
        BigDecimal unitPrice = amountWithoutTax.divide(totalQuantity, 15, 4);
        logger.info("calc unitPriceWithTax---------------->{}", (Object)unitPriceWithTax);
        logger.info("calc unitPrice---------------->{}", (Object)unitPrice);
        if (request.getSalesbillItem().getUnitPriceWithTax().compareTo(unitPriceWithTax) != 0) {
            logger.info("salesbillItem unitPriceWithTax:{}", (Object)request.getSalesbillItem().getUnitPriceWithTax());
            request.getSalesbillItem().setUnitPriceWithTax(unitPriceWithTax);
        }
        if (request.getSalesbillItem().getUnitPrice().compareTo(unitPrice) != 0) {
            logger.info("salesbillItem unitPrice:{}", (Object)request.getSalesbillItem().getUnitPrice());
            request.getSalesbillItem().setUnitPrice(unitPrice);
        }
        return true;
    }

    private boolean mergeBillItemByQuantityMergeOneCheck(List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, MergeBillItemValidatePreviewRequest request) {
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal amountWithTax = BigDecimal.ZERO;
        BigDecimal amountWithoutTax = BigDecimal.ZERO;
        for (OrdSalesbillItemEntity itemEntity : ordSalesbillItemEntityList) {
            amountWithTax = amountWithTax.add(itemEntity.getAmountWithTax());
            amountWithoutTax = amountWithoutTax.add(itemEntity.getAmountWithoutTax());
        }
        if (request.getSalesbillItem().getQuantity().compareTo(quantity) != 0) {
            request.getSalesbillItem().setQuantity(quantity);
        }
        if (request.getSalesbillItem().getUnitPrice().compareTo(amountWithTax) != 0) {
            request.getSalesbillItem().setAmountWithTax(amountWithTax);
        }
        if (request.getSalesbillItem().getAmountWithoutTax().compareTo(amountWithoutTax) != 0) {
            request.getSalesbillItem().setAmountWithoutTax(amountWithoutTax);
        }
        return true;
    }

    private boolean mergeBillItemByReservedPriceCheck(ValidatorContext context, List<OrdSalesbillItemEntity> ordSalesbillItemEntityList, Integer priceMethod, SalesbillItem salesbillItem) {
        BigDecimal price;
        if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
            if (salesbillItem.getUnitPriceWithTax().compareTo(BigDecimal.ZERO) == 0) {
                context.addError(ValidationError.create((String)"\u5408\u5e76\u540e\u4fdd\u7559\u3010\u542b\u7a0e\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a0."));
                return false;
            }
            price = salesbillItem.getUnitPriceWithTax().setScale(15);
        } else {
            if (salesbillItem.getUnitPrice().compareTo(BigDecimal.ZERO) == 0) {
                context.addError(ValidationError.create((String)"\u5408\u5e76\u540e\u4fdd\u7559\u3010\u4e0d\u542b\u7a0e\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a0."));
                return false;
            }
            price = salesbillItem.getUnitPrice().setScale(15);
        }
        HashSet priceSet = Sets.newHashSet();
        ordSalesbillItemEntityList.forEach(item -> {
            if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
                priceSet.add(item.getUnitPriceWithTax());
            } else {
                priceSet.add(item.getUnitPrice());
            }
        });
        logger.info("priceSet-------------------->{}, price:{}", (Object)JsonUtils.writeObjectToFastJson(priceSet), (Object)price);
        if (!priceSet.contains(price)) {
            context.addError(ValidationError.create((String)"\u5408\u5e76\u540e\u4fdd\u7559\u7684\u5355\u4ef7\u5728\u539f\u660e\u7ec6\u5217\u8868\u4e2d\u4e0d\u5b58\u5728."));
            return false;
        }
        return true;
    }

    private boolean mergeBillItemByClearQuantityAndPriceCheck(ValidatorContext context, Integer priceMethod, SalesbillItem salesbillItem) {
        if (salesbillItem.getQuantity() == null) {
            salesbillItem.setQuantity(BigDecimal.ZERO);
        }
        if (BigDecimal.ZERO.compareTo(salesbillItem.getQuantity()) != 0) {
            context.addError(ValidationError.create((String)"\u6e05\u7a7a\u6570\u91cf\u548c\u5355\u4ef7\u65b9\u5f0f\u3010\u6570\u91cf\u3011\u5fc5\u987b\u4e3a0."));
            return false;
        }
        if (BillItemPriceMethod.WITH_TAX.value().equals(priceMethod)) {
            if (BigDecimal.ZERO.compareTo(salesbillItem.getUnitPriceWithTax()) != 0) {
                context.addError(ValidationError.create((String)"\u6e05\u7a7a\u6570\u91cf\u548c\u5355\u4ef7\u65b9\u5f0f\u3010\u542b\u7a0e\u5355\u4ef7\u3011\u5fc5\u987b\u4e3a0."));
                return false;
            }
        } else if (BigDecimal.ZERO.compareTo(salesbillItem.getUnitPrice()) != 0) {
            context.addError(ValidationError.create((String)"\u6e05\u7a7a\u6570\u91cf\u548c\u5355\u4ef7\u65b9\u5f0f\u3010\u4e0d\u542b\u7a0e\u5355\u4ef7\u3011\u5fc5\u987b\u4e3a0."));
            return false;
        }
        return true;
    }
}

