/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.billitem;

import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.client.model.SplitBillItemPreviewRequest;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitByMoneyCalcType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitType;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitBaseValidator;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitMergeTools;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BillItemSplitByMoneyValidator
extends BillItemSplitBaseValidator {
    private static final Logger logger = LoggerFactory.getLogger(BillItemSplitByMoneyValidator.class);

    @Override
    public boolean validate(ValidatorContext context, SplitBillItemPreviewRequest request) {
        OrdSalesbillEntity sourceOrdSalesbillEntity = (OrdSalesbillEntity)((Object)context.getAttribute("sourceOrdSalesbillEntity", OrdSalesbillEntity.class));
        Integer priceMethod = sourceOrdSalesbillEntity.getPriceMethod();
        OrdSalesbillItemEntity sourceBillItem = (OrdSalesbillItemEntity)((Object)context.getAttribute("sourceOrdSalesbillItemEntity", OrdSalesbillItemEntity.class));
        if (request.getSplitByCalcType().equals(BillItemSplitByMoneyCalcType.RESERVED_UNIT_PRICE.value())) {
            Boolean checkResult = this.checkMustFieldsByMoneyReservedPrice(priceMethod, sourceBillItem, request.getSalesbillItemSplitList(), context);
            if (!checkResult.booleanValue()) {
                return checkResult;
            }
            this.derivationFieldsByMoneyReservedPrice(priceMethod, request.getSalesbillItemSplitList(), sourceBillItem);
        } else if (request.getSplitByCalcType().equals(BillItemSplitByMoneyCalcType.RESERVED_QUANTITY.value())) {
            Boolean checkResult = this.checkMustFieldsByMoneyReservedQuantity(priceMethod, sourceBillItem, request.getSalesbillItemSplitList(), context);
            if (!checkResult.booleanValue()) {
                return checkResult;
            }
            this.derivationFieldsByMoneyReservedQuantity(priceMethod, request.getSalesbillItemSplitList(), sourceBillItem);
        } else if (request.getSplitByCalcType().equals(BillItemSplitByMoneyCalcType.CLEAN_QUANTITY$UNIT_PRICE.value())) {
            Boolean checkResult = this.handleFieldsByMoneyCleanQuantityAndPrice(priceMethod, sourceBillItem, request.getSalesbillItemSplitList(), context);
            if (!checkResult.booleanValue()) {
                return false;
            }
        } else {
            logger.info("\u9519\u8bef\u7684\u8ba1\u7b97\u65b9\u5f0f!");
            context.addErrorMsg("\u6309\u91d1\u989d\u62c6\u5206\u65f6\uff0c\u91d1\u989d\u62c6\u5206\u89c4\u5219\u4e0d\u5b58\u5728!");
            return false;
        }
        this.apportionFieldsByFormula(sourceBillItem, request.getSalesbillItemSplitList(), BillItemSplitType.fromValue(request.getSplitType()), priceMethod);
        return true;
    }

    private boolean checkMustFieldsByMoneyReservedPrice(Integer priceMethod, OrdSalesbillItemEntity sourceBillItem, List<SalesbillItem> targetSplitSalesbillItemList, ValidatorContext context) {
        ArrayList errorList = Lists.newArrayList();
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
            if (sourceBillItem.getAmountWithTax().compareTo(BigDecimal.ZERO) == 0) {
                errorList.add("\u539f\u5355\u636e\u660e\u7ec6\u3010\u542b\u7a0e\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a0");
            }
        } else if (sourceBillItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0) {
            errorList.add("\u539f\u5355\u636e\u660e\u7ec6\u3010\u4e0d\u542b\u7a0e\u5355\u4ef7\u3011\u4e0d\u80fd\u4e3a0");
        }
        for (SalesbillItem item : targetSplitSalesbillItemList) {
            if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
                int amountWithTaxPositiveOrNot = sourceBillItem.getAmountWithTax().compareTo(BigDecimal.ZERO);
                if (item.getAmountWithTax().compareTo(BigDecimal.ZERO) != amountWithTaxPositiveOrNot) {
                    errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u542b\u7a0e\u91d1\u989d\u3011\u6b63\u8d1f\u5fc5\u987b\u548c\u539f\u5355\u4fdd\u6301\u4e00\u81f4.");
                }
                BigDecimal itemUnitPriceWithTax = item.getUnitPriceWithTax().setScale(6, 4);
                BigDecimal sourceUnitPriceWithTax = sourceBillItem.getUnitPriceWithTax().setScale(6, 4);
                logger.info("checkMustFieldsByMoneyReservedPrice item--------->{}, {}", (Object)item.getUnitPriceWithTax(), (Object)itemUnitPriceWithTax);
                logger.info("checkMustFieldsByMoneyReservedPrice sourceBillItem--------->{}, {}", (Object)sourceBillItem.getUnitPriceWithTax(), (Object)sourceUnitPriceWithTax);
                if (sourceUnitPriceWithTax.compareTo(itemUnitPriceWithTax) != 0) {
                    errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u542b\u7a0e\u5355\u4ef7\u3011\u5fc5\u987b\u548c\u539f\u5355\u76f8\u7b49");
                }
                totalAmount = totalAmount.add(item.getAmountWithTax());
            } else {
                int amountWithoutTaxPositiveOrNot = sourceBillItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO);
                if (item.getAmountWithoutTax().compareTo(BigDecimal.ZERO) != amountWithoutTaxPositiveOrNot) {
                    errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u6b63\u8d1f\u5fc5\u987b\u548c\u539f\u5355\u4fdd\u6301\u4e00\u81f4.");
                }
                BigDecimal unitPrice = item.getUnitPriceWithTax().setScale(6, 4);
                BigDecimal sourceUnitPrice = sourceBillItem.getUnitPriceWithTax().setScale(6, 4);
                logger.info("checkMustFieldsByMoneyReservedPrice unitPrice--------->{}, {}", (Object)item.getUnitPriceWithTax(), (Object)unitPrice);
                logger.info("checkMustFieldsByMoneyReservedPrice sourceUnitPrice--------->{}, {}", (Object)sourceBillItem.getUnitPriceWithTax(), (Object)sourceUnitPrice);
                if (sourceUnitPrice.compareTo(unitPrice) != 0) {
                    errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u4e0d\u542b\u7a0e\u5355\u4ef7\u3011\u5fc5\u987b\u548c\u539f\u5355\u76f8\u7b49.");
                }
                totalAmount = totalAmount.add(item.getAmountWithoutTax());
            }
            if (item.getTaxRate().compareTo(sourceBillItem.getTaxRate()) == 0) continue;
            errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u7a0e\u7387\u3011\u5fc5\u987b\u548c\u539f\u5355\u76f8\u7b49.");
        }
        String checkMsg = this.checkTotalAmountEqualOrNot(priceMethod, sourceBillItem, totalAmount);
        if (checkMsg != null) {
            errorList.add(checkMsg);
        }
        if (errorList.size() > 0) {
            errorList.forEach(t -> context.addErrorMsg(t));
            return false;
        }
        return true;
    }

    private void derivationFieldsByMoneyReservedPrice(Integer priceMethod, List<SalesbillItem> outTargetSalesBillItemList, OrdSalesbillItemEntity sourceBillItem) {
        if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
            for (SalesbillItem item : outTargetSalesBillItemList) {
                BigDecimal amountWithTax = item.getAmountWithTax();
                BigDecimal unitPriceWithTax = sourceBillItem.getUnitPriceWithTax();
                BillItemSplitMergeTools.fillDeductionsField(priceMethod, sourceBillItem, item, BillItemSplitType.SPLIT_BY_MONEY);
                BigDecimal taxAmount = amountWithTax.subtract(item.getDeductions()).multiply(sourceBillItem.getTaxRate()).divide(BigDecimal.ONE.add(sourceBillItem.getTaxRate()), 6, 4);
                BigDecimal amountWithoutTax = amountWithTax.subtract(taxAmount);
                BigDecimal quantity = amountWithTax.divide(unitPriceWithTax, 15, 4);
                BigDecimal unitPrice = amountWithoutTax.divide(quantity, 15, 4);
                item.setQuantity(quantity);
                item.setAmountWithoutTax(amountWithoutTax);
                item.setUnitPrice(unitPrice);
                item.setTaxAmount(taxAmount);
                item.setUnitPriceWithTax(unitPriceWithTax);
                item.setTaxRate(sourceBillItem.getTaxRate());
                logger.info("WITH_TAX quantity:-------------------------->" + quantity + " amountWithoutTax:" + amountWithoutTax + " unitPrice:" + unitPrice + " taxAmount:" + taxAmount);
            }
            return;
        }
        for (SalesbillItem item : outTargetSalesBillItemList) {
            BigDecimal amountWithoutTax = item.getAmountWithoutTax();
            BigDecimal unitPrice = sourceBillItem.getUnitPrice();
            BigDecimal quantity = amountWithoutTax.divide(unitPrice, 15, 4);
            BillItemSplitMergeTools.fillDeductionsField(priceMethod, sourceBillItem, item, BillItemSplitType.SPLIT_BY_MONEY);
            BigDecimal taxAmount = amountWithoutTax.subtract(item.getDeductions()).multiply(item.getTaxRate());
            BigDecimal amountWithTax = amountWithoutTax.add(taxAmount);
            BigDecimal unitPriceWithTax = amountWithTax.divide(quantity, 15, 4);
            item.setQuantity(quantity);
            item.setAmountWithTax(amountWithTax);
            item.setTaxAmount(taxAmount);
            item.setUnitPriceWithTax(unitPriceWithTax);
            item.setUnitPrice(unitPrice);
            item.setTaxRate(sourceBillItem.getTaxRate());
            logger.info("WITH_OUT_TAX quantity:----------------------------->" + quantity + " amountWithTax:" + amountWithTax + " taxAmount:" + taxAmount + " unitPriceWithTax:" + unitPriceWithTax);
        }
    }

    private boolean checkMustFieldsByMoneyReservedQuantity(Integer priceMethod, OrdSalesbillItemEntity sourceBillItem, List<SalesbillItem> targetSplitSalesbillItemList, ValidatorContext context) {
        ArrayList errorList = Lists.newArrayList();
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (sourceBillItem.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
            errorList.add("\u539f\u5355\u636e\u660e\u7ec6\u3010\u6570\u91cf\u3011\u4e0d\u80fd\u4e3a0.");
        }
        for (SalesbillItem item : targetSplitSalesbillItemList) {
            if (item.getQuantity().compareTo(sourceBillItem.getQuantity()) != 0) {
                item.setQuantity(sourceBillItem.getQuantity());
            }
            if (item.getTaxRate().compareTo(sourceBillItem.getTaxRate()) != 0) {
                errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u7a0e\u7387\u3011\u5fc5\u987b\u548c\u539f\u5355\u76f8\u7b49.");
            }
            if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
                int amountWithTaxPositiveOrNot = sourceBillItem.getAmountWithTax().compareTo(BigDecimal.ZERO);
                if (item.getAmountWithTax().compareTo(BigDecimal.ZERO) != amountWithTaxPositiveOrNot) {
                    errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u542b\u7a0e\u91d1\u989d\u3011\u6b63\u8d1f\u5fc5\u987b\u548c\u539f\u5355\u4fdd\u6301\u4e00\u81f4.");
                }
                totalAmount = totalAmount.add(item.getAmountWithTax());
                continue;
            }
            int amountWithoutTaxPositiveOrNot = sourceBillItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO);
            if (item.getAmountWithoutTax().compareTo(BigDecimal.ZERO) != amountWithoutTaxPositiveOrNot) {
                errorList.add("\u62c6\u5206\u540e\u7684\u5355\u636e\u660e\u7ec6\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u6b63\u8d1f\u5fc5\u987b\u548c\u539f\u5355\u4fdd\u6301\u4e00\u81f4.");
            }
            totalAmount = totalAmount.add(item.getAmountWithoutTax());
        }
        String checkMsg = this.checkTotalAmountEqualOrNot(priceMethod, sourceBillItem, totalAmount);
        if (checkMsg != null) {
            errorList.add(checkMsg);
        }
        if (errorList.size() > 0) {
            errorList.forEach(t -> context.addErrorMsg(t));
            return false;
        }
        return true;
    }

    private String checkTotalAmountEqualOrNot(Integer priceMethod, OrdSalesbillItemEntity sourceBillItem, BigDecimal totalAmount) {
        if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
            if (totalAmount.compareTo(sourceBillItem.getAmountWithTax()) != 0) {
                return "\u62c6\u5206\u540e\u7684\u3010\u542b\u7a0e\u91d1\u989d\u3011\u7d2f\u52a0\u548c\u539f\u5355\u636e\u660e\u7ec6\u3010\u542b\u7a0e\u91d1\u989d\u3011\u5fc5\u987b\u76f8\u7b49.";
            }
        } else if (totalAmount.compareTo(sourceBillItem.getAmountWithoutTax()) != 0) {
            return "\u62c6\u5206\u540e\u7684\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u7d2f\u52a0\u548c\u539f\u5355\u636e\u660e\u7ec6\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u5fc5\u987b\u76f8\u7b49.";
        }
        return null;
    }

    private void derivationFieldsByMoneyReservedQuantity(Integer priceMethod, List<SalesbillItem> outTargetSalesbillItemList, OrdSalesbillItemEntity sourceBillItem) {
        if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
            for (SalesbillItem item : outTargetSalesbillItemList) {
                BigDecimal amountWithTax = item.getAmountWithTax();
                BigDecimal quantity = sourceBillItem.getQuantity();
                BillItemSplitMergeTools.fillDeductionsField(priceMethod, sourceBillItem, item, BillItemSplitType.SPLIT_BY_MONEY);
                BigDecimal taxAmount = amountWithTax.subtract(item.getDeductions()).multiply(sourceBillItem.getTaxRate()).divide(BigDecimal.ONE.add(sourceBillItem.getTaxRate()), 6, 4);
                BigDecimal unitPriceWithTax = amountWithTax.divide(quantity, 15, 4);
                BigDecimal amountWithoutTax = amountWithTax.subtract(taxAmount);
                BigDecimal unitPrice = amountWithoutTax.divide(quantity, 15, 4);
                item.setQuantity(quantity);
                item.setUnitPriceWithTax(unitPriceWithTax);
                item.setUnitPrice(unitPrice);
                item.setAmountWithoutTax(amountWithoutTax);
                item.setTaxAmount(taxAmount);
            }
            return;
        }
        for (SalesbillItem item : outTargetSalesbillItemList) {
            BigDecimal amountWithoutTax = item.getAmountWithoutTax();
            BigDecimal quantity = sourceBillItem.getQuantity();
            BigDecimal unitPrice = amountWithoutTax.divide(quantity, 15, 4);
            BillItemSplitMergeTools.fillDeductionsField(priceMethod, sourceBillItem, item, BillItemSplitType.SPLIT_BY_MONEY);
            BigDecimal taxAmount = amountWithoutTax.subtract(item.getDeductions()).multiply(item.getTaxRate());
            BigDecimal amountWithTax = item.getAmountWithTax();
            BigDecimal unitPriceWithTax = amountWithTax.divide(quantity, 15, 4);
            item.setQuantity(quantity);
            item.setUnitPrice(unitPrice);
            item.setUnitPriceWithTax(unitPriceWithTax);
            item.setAmountWithTax(amountWithTax);
            item.setTaxAmount(taxAmount);
        }
    }

    private boolean handleFieldsByMoneyCleanQuantityAndPrice(Integer priceMethod, OrdSalesbillItemEntity sourceBillItem, List<SalesbillItem> targetSplitSalesbillItemList, ValidatorContext context) {
        boolean checkResult = true;
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
            if (sourceBillItem.getAmountWithTax().compareTo(BigDecimal.ZERO) == 0) {
                context.addErrorMsg("\u6309\u91d1\u989d\u62c6\u5206\uff0c\u539f\u5355\u3010\u542b\u7a0e\u91d1\u989d\u3011\u4e0d\u80fd\u662f0.");
                checkResult = false;
            }
            for (SalesbillItem item : targetSplitSalesbillItemList) {
                int amountWithTaxPositiveOrNot = sourceBillItem.getAmountWithTax().compareTo(BigDecimal.ZERO);
                if (item.getAmountWithTax().compareTo(BigDecimal.ZERO) != amountWithTaxPositiveOrNot) {
                    context.addErrorMsg("\u62c6\u5206\u540e\u7684\u3010\u542b\u7a0e\u91d1\u989d\u3011\u4e0e\u539f\u5355\u6b63\u8d1f\u6027\u4e0d\u4e00\u81f4.");
                    checkResult = false;
                }
                if (item.getTaxRate().compareTo(sourceBillItem.getTaxRate()) != 0) {
                    context.addErrorMsg("\u62c6\u5206\u540e\u7684\u3010\u7a0e\u7387\u3011\u4e0e\u539f\u5355\u4e0d\u76f8\u7b49.");
                    checkResult = false;
                }
                totalAmount = totalAmount.add(item.getAmountWithTax());
            }
            if (totalAmount.compareTo(sourceBillItem.getAmountWithTax()) != 0) {
                context.addErrorMsg("\u62c6\u5206\u540e\u7684\u3010\u542b\u7a0e\u91d1\u989d\u3011\u7d2f\u52a0\u548c\u4e0e\u539f\u5355\u4e0d\u76f8\u7b49.");
                checkResult = false;
            }
        } else {
            if (sourceBillItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0) {
                context.addErrorMsg("\u6309\u91d1\u989d\u62c6\u5206\uff0c\u539f\u5355\u3010\u4e0d\u542b\u91d1\u989d\u3011\u4e0d\u80fd\u662f0.");
                checkResult = false;
            }
            for (SalesbillItem item : targetSplitSalesbillItemList) {
                int amountWithoutTaxPositiveOrNot = sourceBillItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO);
                if (item.getAmountWithoutTax().compareTo(BigDecimal.ZERO) != amountWithoutTaxPositiveOrNot) {
                    context.addErrorMsg("\u62c6\u5206\u540e\u7684\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u4e0e\u539f\u5355\u6b63\u8d1f\u6027\u4e0d\u4e00\u81f4.");
                    checkResult = false;
                }
                if (item.getTaxRate().compareTo(sourceBillItem.getTaxRate()) != 0) {
                    context.addErrorMsg("\u62c6\u5206\u540e\u7684\u3010\u7a0e\u7387\u3011\u4e0e\u539f\u5355\u4e0d\u76f8\u7b49.");
                    checkResult = false;
                }
                totalAmount = totalAmount.add(item.getAmountWithoutTax());
            }
            if (totalAmount.compareTo(sourceBillItem.getAmountWithoutTax()) != 0) {
                context.addErrorMsg("\u62c6\u5206\u540e\u7684\u3010\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u7d2f\u52a0\u548c\u4e0e\u539f\u5355\u4e0d\u76f8\u7b49.");
                checkResult = false;
            }
        }
        if (!checkResult) {
            return false;
        }
        if (priceMethod.equals(BillItemPriceMethod.WITH_TAX.value())) {
            for (SalesbillItem item : targetSplitSalesbillItemList) {
                BigDecimal amountWithTax = item.getAmountWithTax();
                BillItemSplitMergeTools.fillDeductionsField(priceMethod, sourceBillItem, item, BillItemSplitType.SPLIT_BY_MONEY);
                BigDecimal taxAmount = amountWithTax.subtract(item.getDeductions()).multiply(item.getTaxRate()).divide(BigDecimal.ONE.add(item.getTaxRate()), 6, 4);
                BigDecimal amountWithoutTax = amountWithTax.subtract(taxAmount);
                item.setAmountWithoutTax(amountWithoutTax);
                item.setTaxAmount(taxAmount);
                this.clearUnitPriceAndQuantity(item);
            }
        } else {
            for (SalesbillItem item : targetSplitSalesbillItemList) {
                BigDecimal amountWithoutTax = item.getAmountWithoutTax();
                BillItemSplitMergeTools.fillDeductionsField(priceMethod, sourceBillItem, item, BillItemSplitType.SPLIT_BY_MONEY);
                BigDecimal taxAmount = amountWithoutTax.subtract(item.getDeductions()).multiply(item.getTaxRate());
                BigDecimal amountWithTax = amountWithoutTax.add(taxAmount);
                item.setAmountWithTax(amountWithTax);
                item.setTaxAmount(taxAmount);
                this.clearUnitPriceAndQuantity(item);
            }
        }
        return true;
    }

    private void clearUnitPriceAndQuantity(SalesbillItem outSalesbillItem) {
        outSalesbillItem.setUnitPriceWithTax(BigDecimal.ZERO);
        outSalesbillItem.setUnitPrice(BigDecimal.ZERO);
        outSalesbillItem.quantity(BigDecimal.ZERO);
    }
}

