/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.billitem;

import com.baidu.unbiz.fluentvalidator.FluentValidator;
import com.baidu.unbiz.fluentvalidator.Result;
import com.baidu.unbiz.fluentvalidator.ResultCollectors;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.model.SalesbillItem;
import com.xforceplus.phoenix.bill.client.model.SplitBillItemPreviewRequest;
import com.xforceplus.phoenix.bill.constant.enums.BillItemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BillItemPriceMethod;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitByMoneyCalcType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemSplitType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemStatus;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.core.service.BillValidateService;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitByMoneyValidator;
import com.xforceplus.phoenix.bill.core.validator.billitem.BillItemSplitByQuantityValidator;
import com.xforceplus.phoenix.bill.core.validator.billitem.error.BillItemSplitMergeValidateError;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillItemDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemExample;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillItemSplitPreviewValidator
extends ValidatorHandler<SplitBillItemPreviewRequest>
implements Validator<SplitBillItemPreviewRequest> {
    private static final Logger logger = LoggerFactory.getLogger(BillItemSplitPreviewValidator.class);
    private static final int SPLIT_NUM = 2;
    private OrdSalesbillItemDao ordSalesbillItemDao;
    private BillItemSplitByQuantityValidator billItemSplitByQuantityValidator;
    private BillItemSplitByMoneyValidator billItemSplitByMoneyValidator;
    private BillValidateService billValidateService;

    @Autowired
    public BillItemSplitPreviewValidator(OrdSalesbillItemDao ordSalesbillItemDao, BillItemSplitByQuantityValidator billItemSplitByQuantityValidator, BillItemSplitByMoneyValidator billItemSplitByMoneyValidator, BillValidateService billValidateService) {
        this.ordSalesbillItemDao = ordSalesbillItemDao;
        this.billItemSplitByQuantityValidator = billItemSplitByQuantityValidator;
        this.billItemSplitByMoneyValidator = billItemSplitByMoneyValidator;
        this.billValidateService = billValidateService;
    }

    public boolean accept(ValidatorContext validatorContext, SplitBillItemPreviewRequest request) {
        return true;
    }

    public boolean validate(ValidatorContext context, SplitBillItemPreviewRequest request) {
        if (StringUtils.isEmpty((String)request.getSourceSalesbillItemId()) || !NumberUtils.isNumber((String)request.getSourceSalesbillItemId())) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_ID_ILLEGAL_ERROR.getMessage());
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)request.getSalesbillItemSplitList()) || request.getSalesbillItemSplitList().size() != 2) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_NUM_BELOW_MIN_ERROR.getMessage());
            return false;
        }
        Integer splitType = request.getSplitType();
        if (null == splitType || Stream.of(BillItemSplitType.values()).noneMatch(t -> t.value().equals(splitType))) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_SPLIT_STATUS_ERROR.getMessage());
            return false;
        }
        Integer splitByCalcType = request.getSplitByCalcType();
        if (BillItemSplitType.SPLIT_BY_MONEY.value().equals(splitType) && Stream.of(BillItemSplitByMoneyCalcType.values()).noneMatch(t -> t.value().equals(splitByCalcType))) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_SPLIT_CALC_TYPE_ERROR.getMessage());
            return false;
        }
        OrdSalesbillEntity ordSalesbillEntity = (OrdSalesbillEntity)((Object)context.getAttribute("sourceOrdSalesbillEntity", OrdSalesbillEntity.class));
        if (null == ordSalesbillEntity || BillItemPriceMethod.getAllPriceMethodWithoutNone().stream().noneMatch(t -> t.value().equals(ordSalesbillEntity.getPriceMethod()))) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_PRICE_METHOD_NOT_FOUND_ERROR.getMessage());
            return false;
        }
        OrdSalesbillItemEntity sourceOrdSalesbillItemEntity = (OrdSalesbillItemEntity)((Object)context.getAttribute("sourceOrdSalesbillItemEntity", OrdSalesbillItemEntity.class));
        if (sourceOrdSalesbillItemEntity == null) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_NOT_FOUND_ERROR.getMessage());
            return false;
        }
        if (!BillItemOrigin.ORIGINAL.value().equals(sourceOrdSalesbillItemEntity.getOrigin()) && !BillItemOrigin.SPLIT.value().equals(sourceOrdSalesbillItemEntity.getOrigin())) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_ORIGIN_ERROR.getMessage());
            return false;
        }
        if (this.isNeedCheckMainAndItem(splitType, splitByCalcType, ordSalesbillEntity, sourceOrdSalesbillItemEntity) && !this.checkMainAndItem(context, ordSalesbillEntity, sourceOrdSalesbillItemEntity)) {
            return false;
        }
        if (!this.baseFieldsCheck(context, sourceOrdSalesbillItemEntity, request.getSalesbillItemSplitList())) {
            return false;
        }
        OrdSalesbillItemExample ordSalesbillItemExample = new OrdSalesbillItemExample();
        OrdSalesbillItemExample.Criteria criteria = ordSalesbillItemExample.createCriteria();
        criteria.andSalesbillIdEqualTo(sourceOrdSalesbillItemEntity.getSalesbillId());
        criteria.andStatusEqualTo(BillItemStatus.NORMAL.value());
        long count = this.ordSalesbillItemDao.countByExample(ordSalesbillItemExample);
        if (count >= 10000L) {
            context.addErrorMsg(BillItemSplitMergeValidateError.SALESBILL_ITEM_NUM_OVER_MAX_ERROR.getMessage());
            return false;
        }
        Result checkResult = (Result)FluentValidator.checkAll().putAttribute2Context("sourceOrdSalesbillEntity", (Object)ordSalesbillEntity).putAttribute2Context("sourceOrdSalesbillItemEntity", (Object)sourceOrdSalesbillItemEntity).on((Object)request, (Validator)(BillItemSplitType.SPLIT_BY_AMOUNT.value().equals(splitType) ? this.billItemSplitByQuantityValidator : this.billItemSplitByMoneyValidator)).doValidate().result(ResultCollectors.toSimple());
        if (!checkResult.isSuccess()) {
            context.addErrorMsg(Joiner.on((String)";").join((Iterable)checkResult.getErrors()));
            return false;
        }
        return true;
    }

    public void onException(Exception e, ValidatorContext validatorContext, SplitBillItemPreviewRequest splitBillItemPreviewRequest) {
    }

    private boolean baseFieldsCheck(ValidatorContext context, OrdSalesbillItemEntity sourceOrdSalesbillItemEntity, List<SalesbillItem> salesbillItemSplitList) {
        if (!CollectionUtils.isEmpty(salesbillItemSplitList)) {
            for (SalesbillItem salesbillItem : salesbillItemSplitList) {
                if (!sourceOrdSalesbillItemEntity.getItemName().equals(salesbillItem.getItemName())) {
                    context.addErrorMsg("\u62c6\u5206\u540e\u7684\u660e\u7ec6\u3010\u8d27\u7269\u53ca\u670d\u52a1\u540d\u79f0\u3011 \u4e0e \u539f\u660e\u7ec6\u4e0d\u4e00\u81f4.");
                    return false;
                }
                if (!sourceOrdSalesbillItemEntity.getItemSpec().equals(salesbillItem.getItemSpec())) {
                    context.addErrorMsg("\u62c6\u5206\u540e\u7684\u660e\u7ec6\u3010\u578b\u53f7\u89c4\u683c\u3011 \u4e0e \u539f\u660e\u7ec6\u4e0d\u4e00\u81f4.");
                    return false;
                }
                logger.info(salesbillItem.getSalesbillItemId() + "\uff1a" + salesbillItem.getQuantityUnit() + "-- sourceOrdSalesbillItemEntity\uff1a" + sourceOrdSalesbillItemEntity.getQuantityUnit());
                if (!sourceOrdSalesbillItemEntity.getQuantityUnit().equals(salesbillItem.getQuantityUnit())) {
                    context.addErrorMsg("\u62c6\u5206\u540e\u7684\u660e\u7ec6\u3010\u6570\u91cf\u5355\u4f4d\u3011 \u4e0e \u539f\u660e\u7ec6\u4e0d\u4e00\u81f4.");
                    return false;
                }
                if (sourceOrdSalesbillItemEntity.getGoodsTaxNo().equals(salesbillItem.getGoodsTaxNo())) continue;
                context.addErrorMsg("\u62c6\u5206\u540e\u7684\u660e\u7ec6\u3010\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u3011 \u4e0e \u539f\u660e\u7ec6\u4e0d\u4e00\u81f4.");
                return false;
            }
        }
        return true;
    }

    private boolean checkMainAndItem(ValidatorContext context, OrdSalesbillEntity ordSalesbillEntity, OrdSalesbillItemEntity ordSalesbillItemEntity) {
        Long groupId = (Long)context.getAttribute("groupId", Long.class);
        HashMap groupIdMap = Maps.newHashMap();
        groupIdMap.put("groupId", groupId);
        OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity = new OrdSalesbillInterfaceEntity();
        BeanUtils.copyProperties((Object)((Object)ordSalesbillEntity), (Object)((Object)ordSalesbillInterfaceEntity));
        StringBuilder stringBuilder = this.billValidateService.allMainChecks(ordSalesbillInterfaceEntity, groupIdMap, ValidateType.UPDATE);
        if (stringBuilder.length() > 0) {
            context.addErrorMsg(stringBuilder.toString());
            logger.info("checkMainAndItem main check tips============{}", (Object)stringBuilder.toString());
            return false;
        }
        OrdSalesbillInterfaceItemEntity ordSalesbillInterfaceItemEntity = new OrdSalesbillInterfaceItemEntity();
        BeanUtils.copyProperties((Object)((Object)ordSalesbillItemEntity), (Object)((Object)ordSalesbillInterfaceItemEntity));
        stringBuilder = new StringBuilder();
        boolean checkItemResult = this.billValidateService.checkItems(ordSalesbillInterfaceEntity, Lists.newArrayList((Object[])new OrdSalesbillInterfaceItemEntity[]{ordSalesbillInterfaceItemEntity}), stringBuilder, groupIdMap, ValidateType.UPDATE.value());
        if (stringBuilder.length() > 0) {
            context.addErrorMsg(stringBuilder.toString());
            logger.info("checkMainAndItem main check tips============{}", (Object)stringBuilder.toString());
            return false;
        }
        if (!checkItemResult) {
            context.addErrorMsg(ordSalesbillInterfaceItemEntity.getProcessRemark());
            logger.info("checkMainAndItem items check tips============{}", (Object)stringBuilder.toString());
            return false;
        }
        return true;
    }

    private boolean isNeedCheckMainAndItem(Integer splitType, Integer splitByCalcType, OrdSalesbillEntity ordSalesbillEntity, OrdSalesbillItemEntity ordSalesbillItemEntity) {
        return !BillItemSplitType.SPLIT_BY_MONEY.value().equals(splitType) || !BillItemSplitByMoneyCalcType.CLEAN_QUANTITY$UNIT_PRICE.value().equals(splitByCalcType) || BillItemOrigin.ORIGINAL.value().equals(ordSalesbillItemEntity.getOrigin()) || ordSalesbillItemEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0 || !(BillItemPriceMethod.WITH_TAX.value().equals(ordSalesbillEntity.getPriceMethod()) ? ordSalesbillItemEntity.getUnitPriceWithTax().compareTo(BigDecimal.ZERO) == 0 : ordSalesbillItemEntity.getUnitPrice().compareTo(BigDecimal.ZERO) == 0);
    }
}

