/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.billoperation;

import com.baidu.unbiz.fluentvalidator.ValidationError;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.xforceplus.phoenix.bill.client.model.AbandonBillByIdsRequest;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillCatalog;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.manager.SalesbillManager;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillSourceRelDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRelExample;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BillAbandonValidate
extends ValidatorHandler<AbandonBillByIdsRequest>
implements Validator<AbandonBillByIdsRequest> {
    @Autowired
    private OrdSalesbillSourceRelDao ordSalesbillSourceRelDao;
    @Autowired
    private SalesbillManager salesbillManager;

    public boolean accept(ValidatorContext validatorContext, AbandonBillByIdsRequest abandonBillByIdsRequest) {
        return true;
    }

    public boolean validate(ValidatorContext context, AbandonBillByIdsRequest abandonBillByIdsRequest) {
        List<OrdSalesbillEntity> ordSalesbillEntityList;
        if (null == abandonBillByIdsRequest) {
            context.addError(ValidationError.create((String)"\u4f5c\u5e9f\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a."));
            return false;
        }
        abandonBillByIdsRequest.setDesc(abandonBillByIdsRequest.getDesc().trim());
        if (StringUtils.isEmpty((String)abandonBillByIdsRequest.getDesc())) {
            context.addError(ValidationError.create((String)"\u4f5c\u5e9f\u5931\u8d25,\u4f5c\u5e9f\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a."));
            return false;
        }
        List salesBillIdList = abandonBillByIdsRequest.getBillIdList().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesBillIdList)) {
            context.addError(ValidationError.create((String)"\u4f5c\u5e9f\u5931\u8d25,\u8bf7\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5355\u636e."));
            return false;
        }
        if (salesBillIdList.size() != salesBillIdList.size()) {
            abandonBillByIdsRequest.setBillIdList(salesBillIdList);
        }
        if (CollectionUtils.isEmpty(ordSalesbillEntityList = this.salesbillManager.getOrdSalesbillEntityByIds(abandonBillByIdsRequest.getBillIdList(), SalesBillStatus.NORMAL))) {
            context.addError(ValidationError.create((String)"\u4f5c\u5e9f\u5931\u8d25,\u5f85\u4f5c\u5e9f\u7684\u5355\u636e\u65e0\u6cd5\u627e\u5230."));
            return false;
        }
        if (ordSalesbillEntityList.size() != salesBillIdList.size()) {
            context.addError(ValidationError.create((String)"\u4f5c\u5e9f\u5931\u8d25,\u5f85\u4f5c\u5e9f\u7684\u5355\u636e\u4fe1\u606f\u4e0d\u80fd\u5168\u90e8\u627e\u5230."));
            return false;
        }
        for (OrdSalesbillEntity ordSalesbillEntity : ordSalesbillEntityList) {
            if (!ordSalesbillEntity.getUploadConfirmFlag().equals(SalesBillCatalog.CONFIRMING.value())) {
                context.addError(ValidationError.create((String)String.format("\u4f5c\u5e9f\u5931\u8d25,\u5f85\u4f5c\u5e9f\u7684\u5355\u636e\u3010%s\u3011\u975e\u3010\u5f85\u5904\u7406\u3011\u72b6\u6001.", ordSalesbillEntity.getSalesbillId().toString())));
                return false;
            }
            OrdSalesbillSourceRelExample ordSalesbillSourceRelExample = new OrdSalesbillSourceRelExample();
            OrdSalesbillSourceRelExample.Criteria criteria = ordSalesbillSourceRelExample.createCriteria();
            criteria.andSourceSalesbillIdEqualTo(ordSalesbillEntity.getSalesbillId());
            criteria.andRelStatusEqualTo(BillHistoryStatus.NORMAL.value());
            criteria.andRelTypeEqualTo(BillOperationType.MERGE.value());
            long count = this.ordSalesbillSourceRelDao.countByExample(ordSalesbillSourceRelExample);
            if (count <= 0L) continue;
            context.addError(ValidationError.create((String)String.format("\u4f5c\u5e9f\u5931\u8d25,\u5f85\u4f5c\u5e9f\u7684\u5355\u636e\u3010%s\u3011\u7ecf\u5386\u8fc7\u8de8\u5355\u636e\u5408\u5e76\u64cd\u4f5c.", ordSalesbillEntity.getSalesbillId().toString())));
            return false;
        }
        return true;
    }

    public void onException(Exception e, ValidatorContext context, AbandonBillByIdsRequest abandonBillByIdsRequest) {
    }
}

