/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.company;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.phoenix.bill.cache.bssexternal.LocalBssExternalCacheManager;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.CompanyDataStatus;
import com.xforceplus.phoenix.bill.constant.enums.CooperateFlag;
import com.xforceplus.phoenix.bill.constant.enums.InfoFillType;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceType;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.core.validator.company.tools.CompanyValidateTools;
import com.xforceplus.phoenix.bill.core.vo.BankModel;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesBillCheckCompanyValidator
extends ValidatorHandler<OrdSalesbillInterfaceEntity>
implements Validator<OrdSalesbillInterfaceEntity> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private LocalConfigMetadataCacheManager metadataCacheManager;
    @Autowired
    private LocalBssExternalCacheManager bssExternalCacheManager;
    @Autowired
    CompanyValidateTools companyValidateTools;

    public boolean accept(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        return true;
    }

    public void onException(Exception e, ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        context.addErrorMsg(e.getMessage());
    }

    public boolean validate(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        this.logger.info("=========================SalesBillCheckCompanyValidator-\u5355\u636e\u53f7-{}=========================", (Object)ordSalesbillInterfaceEntity.getSalesbillNo());
        String businessBillType = ordSalesbillInterfaceEntity.getBusinessBillType();
        String validateType = String.valueOf(context.getAttribute("validateType"));
        boolean flag = false;
        if (BusinessBillType.AP.value().equals(businessBillType)) {
            flag = this.purchaserImportCheck(context, ordSalesbillInterfaceEntity);
        } else if (BusinessBillType.AR.value().equals(businessBillType)) {
            flag = this.sellerImportCheck(context, ordSalesbillInterfaceEntity);
        }
        if (!ValidateType.IMPORT.value().equals(validateType)) {
            OrdSalesbillInterfaceEntity tempSalesBillInterface = (OrdSalesbillInterfaceEntity)((Object)context.getAttribute("tempSalesBillInterface"));
            BeanUtils.copyProperties((Object)tempSalesBillInterface, (Object)ordSalesbillInterfaceEntity);
        }
        this.companyValidateTools.completePersonInfo(ordSalesbillInterfaceEntity);
        String invoiceInfoMsg = this.checkInvoiceInfo(ordSalesbillInterfaceEntity);
        if (!CommonTools.isEmpty(invoiceInfoMsg)) {
            context.addErrorMsg(invoiceInfoMsg);
            return false;
        }
        return flag;
    }

    public boolean purchaserImportCheck(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        CompanyModel tempcompanyModel;
        String sellerInfoFill = (String)context.getAttribute("sellerInfoFill");
        String sellerCompanyDataStatus = (String)context.getAttribute("sellerCompanyDataStatus");
        String purchaserCompanyDataStatus = (String)context.getAttribute("purchaserCompanyDataStatus");
        CompanyModel sellerCompanyMode = (CompanyModel)context.getAttribute("sellerCompanyMode");
        CompanyModel purchaserCompanyMode = (CompanyModel)context.getAttribute("purchaserCompanyMode");
        boolean cs = false;
        StringBuilder msg = new StringBuilder();
        boolean cp = this.checkPurchaser(context, ordSalesbillInterfaceEntity, purchaserCompanyMode, purchaserCompanyDataStatus, msg);
        if (!cp) {
            return cp;
        }
        Object config = context.getAttribute("sysInfoRuleDTO");
        if (config != null) {
            SysInfoRuleDTO sysInfoRuleDTO = (SysInfoRuleDTO)config;
            if (sysInfoRuleDTO != null && sysInfoRuleDTO.getCheckAPBillSellerInfoFalg() != null && sysInfoRuleDTO.getCheckAPBillSellerInfoFalg().booleanValue()) {
                cs = true;
            }
        } else {
            this.logger.warn("---\u5355\u53f7:{}---\u6ca1\u6709\u83b7\u53d6\u5230 \u662f\u5426\u67e5\u9a8c\u5bf9\u65b9\u914d\u7f6e----------", (Object)ordSalesbillInterfaceEntity.getSalesbillNo());
        }
        if (sellerCompanyMode != null && sellerCompanyMode.getGroupId() == null && (tempcompanyModel = this.bssExternalCacheManager.getCompanyMainInfoByTaxNo(sellerCompanyMode.getTaxNum())) != null) {
            ordSalesbillInterfaceEntity.setSellerId(tempcompanyModel.getCompanyId());
            ordSalesbillInterfaceEntity.setSellerGroupId(tempcompanyModel.getGroupId());
        }
        if (cs) {
            boolean b = this.checkMerchantCompany(sellerCompanyMode, ordSalesbillInterfaceEntity, msg);
            if (!b) {
                context.addErrorMsg(msg.toString());
                return false;
            }
            return this.checkSeller(context, ordSalesbillInterfaceEntity, sellerCompanyMode, sellerCompanyDataStatus, msg);
        }
        return true;
    }

    public boolean sellerImportCheck(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        CompanyModel tempcompanyModel;
        String purchaserInfoFill = (String)context.getAttribute("purchaserInfoFill");
        String purchaserCompanyDataStatus = (String)context.getAttribute("purchaserCompanyDataStatus");
        String sellerCompanyDataStatus = (String)context.getAttribute("sellerCompanyDataStatus");
        CompanyModel sellerCompanyMode = (CompanyModel)context.getAttribute("sellerCompanyMode");
        CompanyModel purchaserCompanyMode = (CompanyModel)context.getAttribute("purchaserCompanyMode");
        boolean cp = false;
        StringBuilder msg = new StringBuilder();
        boolean cs = this.checkSeller(context, ordSalesbillInterfaceEntity, sellerCompanyMode, sellerCompanyDataStatus, msg);
        if (!cs) {
            return cs;
        }
        Object config = context.getAttribute("sysInfoRuleDTO");
        if (config != null) {
            SysInfoRuleDTO sysInfoRuleDTO = (SysInfoRuleDTO)config;
            if (sysInfoRuleDTO != null && sysInfoRuleDTO.getCheckARBillPurchaseInfoFalg() != null && sysInfoRuleDTO.getCheckARBillPurchaseInfoFalg().booleanValue()) {
                cp = true;
            }
        } else {
            this.logger.warn("---\u5355\u53f7:{}---\u6ca1\u6709\u83b7\u53d6\u5230 \u662f\u5426\u67e5\u9a8c\u5bf9\u65b9\u914d\u7f6e----------", (Object)ordSalesbillInterfaceEntity.getSalesbillNo());
        }
        if (purchaserCompanyMode != null && purchaserCompanyMode.getGroupId() == null && (tempcompanyModel = this.bssExternalCacheManager.getCompanyMainInfoByTaxNo(purchaserCompanyMode.getTaxNum())) != null) {
            ordSalesbillInterfaceEntity.setPurchaserId(tempcompanyModel.getCompanyId());
            ordSalesbillInterfaceEntity.setPurchaserGroupId(tempcompanyModel.getGroupId());
        }
        if (cp) {
            boolean b = this.checkMerchantCompany(purchaserCompanyMode, ordSalesbillInterfaceEntity, msg);
            if (!b) {
                context.addErrorMsg(msg.toString());
                return false;
            }
            return this.checkPurchaser(context, ordSalesbillInterfaceEntity, purchaserCompanyMode, purchaserCompanyDataStatus, msg);
        }
        return true;
    }

    private boolean checkMerchantCompany(CompanyModel companyModel, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, StringBuilder msg) {
        CompanyModel tempcompanyModel;
        if (companyModel != null && companyModel.getGroupId() == null && (tempcompanyModel = this.bssExternalCacheManager.getCompanyMainInfoByTaxNo(companyModel.getTaxNum())) == null) {
            if (ordSalesbillInterfaceEntity.getSellerId() == null) {
                msg.append("--\u914d\u7f6e\u4e3a\u8d2d\u65b9\u67e5\u9a8c\u9500\u65b9,\u901a\u8fc7\u5ba2\u5546\u7ba1\u7406\u8865\u5168\u516c\u53f8\u4fe1\u606f,\u5728\u8fd0\u8425\u6ca1\u6709\u7ef4\u62a4--");
            } else {
                msg.append("--\u914d\u7f6e\u4e3a\u9500\u65b9\u67e5\u9a8c\u8d2d\u65b9,\u901a\u8fc7\u5ba2\u5546\u7ba1\u7406\u8865\u5168\u516c\u53f8\u4fe1\u606f,\u5728\u8fd0\u8425\u6ca1\u6709\u7ef4\u62a4--");
            }
            return false;
        }
        return true;
    }

    public boolean checkPurchaser(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, CompanyModel purchaserCompanyMode, String companyDataStatus, StringBuilder msg) {
        String purchaserInfoFill = (String)context.getAttribute("purchaserInfoFill");
        String validateType = String.valueOf(context.getAttribute("validateType"));
        if (purchaserCompanyMode != null) {
            String type = "";
            String taxNoOrNo = "";
            if (InfoFillType.BY_TAX_NO.value().equals(purchaserInfoFill)) {
                type = "\u7a0e\u53f7";
                taxNoOrNo = ordSalesbillInterfaceEntity.getPurchaserTaxNo();
            } else if (InfoFillType.BY_NO.value().equals(purchaserInfoFill)) {
                type = "\u7f16\u53f7";
                taxNoOrNo = ordSalesbillInterfaceEntity.getPurchaserNo();
            }
            if (!ValidateType.MAKE_INVOICE.value().equals(validateType)) {
                if (!purchaserCompanyMode.getTaxNum().equals(ordSalesbillInterfaceEntity.getPurchaserTaxNo())) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u8d2d\u65b9").append(type).append("\u3010").append(taxNoOrNo).append("\u3011\u8bc6\u522b\u65f6\u7a0e\u53f7\u4e0d\u4e00\u81f4,\u67e5\u8be2\u5230\u7684\u7a0e\u53f7\u3010").append(purchaserCompanyMode.getTaxNum()).append("\u3011\u4f20\u5165\u7684\u7a0e\u53f7\u3010").append(ordSalesbillInterfaceEntity.getPurchaserTaxNo()).append("\u3011--").toString());
                    return false;
                }
                if (!purchaserCompanyMode.getCompanyName().equals(ordSalesbillInterfaceEntity.getPurchaserName())) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u8d2d\u65b9").append(type).append("\u3010").append(taxNoOrNo).append("\u3011\u8bc6\u522b\u65f6\u540d\u79f0\u4e0d\u4e00\u81f4,\u67e5\u8be2\u5230\u7684\u540d\u79f0\u3010").append(purchaserCompanyMode.getCompanyName()).append("\u3011\u4f20\u5165\u7684\u540d\u79f0\u3010").append(ordSalesbillInterfaceEntity.getPurchaserName()).append("\u3011--").toString());
                    return false;
                }
            }
        }
        if (context.getAttribute("sellerBankModel") != null && BusinessBillType.AP.value().equals(ordSalesbillInterfaceEntity.getBusinessBillType())) {
            BankModel bankModel = (BankModel)context.getAttribute("sellerBankModel");
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerAddress())) {
                ordSalesbillInterfaceEntity.setSellerAddress(bankModel.getBankAddres());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerTel())) {
                ordSalesbillInterfaceEntity.setSellerTel(bankModel.getBankTel());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankName())) {
                ordSalesbillInterfaceEntity.setSellerBankName(bankModel.getBankName());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankAccount())) {
                ordSalesbillInterfaceEntity.setSellerBankAccount(bankModel.getBankAccount());
            }
            this.checkSellerAddresTel(context, ordSalesbillInterfaceEntity, msg);
        }
        return this.completionPurchaserInformation(context, ordSalesbillInterfaceEntity, companyDataStatus, msg);
    }

    public boolean completionPurchaserInformation(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, String companyStatus, StringBuilder msg) {
        if (ordSalesbillInterfaceEntity.getPurchaserGroupId() == null) {
            return true;
        }
        if (CompanyDataStatus.NO_HAVING_COMPANY_INFO.value().equals(companyStatus)) {
            InvoiceInfoRuleDTO purchaserInvoiceInfoObj = null;
            if (InvoiceType.NORMAL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType()) || InvoiceType.ELECTRONIC.value().equals(ordSalesbillInterfaceEntity.getInvoiceType()) || InvoiceType.ROLL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType())) {
                if (CooperateFlag.COOPERATE.value().equals(ordSalesbillInterfaceEntity.getCooperateFlag())) {
                    ConfigRequestModel configRequestModel = new ConfigRequestModel();
                    BeanUtils.copyProperties((Object)ordSalesbillInterfaceEntity, configRequestModel);
                    purchaserInvoiceInfoObj = this.metadataCacheManager.queryInvoiceInfoRuleDTO(configRequestModel, ConfigTypeEnum.INVOICE_CONFIG_TYPE, BusinessBillType.AP.value());
                }
            } else if (InvoiceType.SPECIAL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType())) {
                ConfigRequestModel configRequestModel = new ConfigRequestModel();
                BeanUtils.copyProperties((Object)ordSalesbillInterfaceEntity, configRequestModel);
                purchaserInvoiceInfoObj = this.metadataCacheManager.queryInvoiceInfoRuleDTO(configRequestModel, ConfigTypeEnum.INVOICE_CONFIG_TYPE, BusinessBillType.AP.value());
            }
            if (purchaserInvoiceInfoObj != null) {
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserAddress())) {
                    ordSalesbillInterfaceEntity.setPurchaserAddress(purchaserInvoiceInfoObj.getPurchaserAddress());
                }
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserTel())) {
                    ordSalesbillInterfaceEntity.setPurchaserTel(purchaserInvoiceInfoObj.getPurchaserTel());
                }
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankName())) {
                    ordSalesbillInterfaceEntity.setPurchaserBankName(purchaserInvoiceInfoObj.getPurchaserBankName());
                }
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankAccount())) {
                    ordSalesbillInterfaceEntity.setPurchaserBankAccount(purchaserInvoiceInfoObj.getPurchaserBankAccount());
                }
                return this.checkPurchaseAddressTel(context, ordSalesbillInterfaceEntity, msg);
            }
        }
        return true;
    }

    private boolean checkPurchaseAddressTel(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, StringBuilder msg) {
        String purchaserAddress = ordSalesbillInterfaceEntity.getPurchaserAddress();
        String purchaserTel = ordSalesbillInterfaceEntity.getPurchaserTel();
        StringBuilder purchaserAddrTel = new StringBuilder();
        purchaserAddrTel.append(purchaserAddress).append(purchaserTel);
        if (CommonTools.exceedMaxLength(purchaserAddrTel.toString(), 101)) {
            context.addErrorMsg(msg.append("--\u8d2d\u65b9\u5730\u5740\u3010").append(purchaserAddress).append("\u3011,\u8d2d\u65b9\u7535\u8bdd\u3010").append(purchaserTel).append("\u3011,\u5bf9\u5e94\u7684\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc7100--").toString());
            return false;
        }
        return true;
    }

    public boolean checkSeller(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, CompanyModel sellerCompanyMode, String companyStatus, StringBuilder msg) {
        String sellerInfoFill = (String)context.getAttribute("sellerInfoFill");
        String validateType = String.valueOf(context.getAttribute("validateType"));
        if (sellerCompanyMode != null) {
            String type = "";
            String taxNoOrNo = "";
            if (InfoFillType.BY_TAX_NO.value().equals(sellerInfoFill)) {
                type = "\u7a0e\u53f7";
                taxNoOrNo = ordSalesbillInterfaceEntity.getSellerTaxNo();
            } else if (InfoFillType.BY_NO.value().equals(sellerInfoFill)) {
                type = "\u7f16\u53f7";
                taxNoOrNo = ordSalesbillInterfaceEntity.getSellerNo();
            }
            if (!ValidateType.MAKE_INVOICE.value().equals(validateType)) {
                if (!sellerCompanyMode.getTaxNum().equals(ordSalesbillInterfaceEntity.getSellerTaxNo())) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u9500\u65b9").append(type).append("\u3010").append(taxNoOrNo).append("\u3011\u8bc6\u522b\u65f6\u7a0e\u53f7\u4e0d\u4e00\u81f4,\u67e5\u8be2\u5230\u7684\u7a0e\u53f7\u3010").append(sellerCompanyMode.getTaxNum()).append("\u3011\u4f20\u5165\u7684\u7a0e\u53f7\u3010").append(ordSalesbillInterfaceEntity.getSellerTaxNo()).append("\u3011--").toString());
                    return false;
                }
                if (!sellerCompanyMode.getCompanyName().equals(ordSalesbillInterfaceEntity.getSellerName())) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u9500\u65b9").append(type).append("\u3010").append(taxNoOrNo).append("\u3011\u8bc6\u522b\u65f6\u540d\u79f0\u4e0d\u4e00\u81f4,\u67e5\u8be2\u5230\u7684\u540d\u79f0\u3010").append(sellerCompanyMode.getCompanyName()).append("\u3011\u4f20\u5165\u7684\u540d\u79f0\u3010").append(ordSalesbillInterfaceEntity.getSellerName()).append("\u3011--").toString());
                    return false;
                }
            }
        }
        if (context.getAttribute("purchaseBankModel") != null && BusinessBillType.AR.value().equals(ordSalesbillInterfaceEntity.getBusinessBillType())) {
            BankModel bankModel = (BankModel)context.getAttribute("purchaseBankModel");
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserAddress())) {
                ordSalesbillInterfaceEntity.setPurchaserAddress(bankModel.getBankAddres());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserTel())) {
                ordSalesbillInterfaceEntity.setPurchaserTel(bankModel.getBankTel());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankName())) {
                ordSalesbillInterfaceEntity.setPurchaserBankName(bankModel.getBankName());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankAccount())) {
                ordSalesbillInterfaceEntity.setPurchaserBankAccount(bankModel.getBankAccount());
            }
            this.checkPurchaseAddressTel(context, ordSalesbillInterfaceEntity, msg);
        }
        return this.completionSellerInformation(context, ordSalesbillInterfaceEntity, companyStatus, msg);
    }

    public boolean completionSellerInformation(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, String companyStatus, StringBuilder msg) {
        if (ordSalesbillInterfaceEntity.getSellerGroupId() == null) {
            return true;
        }
        if (CompanyDataStatus.NO_HAVING_COMPANY_INFO.value().equals(companyStatus)) {
            ConfigRequestModel configRequestModel = new ConfigRequestModel();
            BeanUtils.copyProperties((Object)ordSalesbillInterfaceEntity, configRequestModel);
            InvoiceInfoRuleDTO sellerInvoiceInfoObj = this.metadataCacheManager.queryInvoiceInfoRuleDTO(configRequestModel, ConfigTypeEnum.INVOICE_CONFIG_TYPE, BusinessBillType.AR.value());
            if (sellerInvoiceInfoObj != null) {
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerAddress())) {
                    ordSalesbillInterfaceEntity.setSellerAddress(sellerInvoiceInfoObj.getSellerAddress());
                }
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerTel())) {
                    ordSalesbillInterfaceEntity.setSellerTel(sellerInvoiceInfoObj.getSellerTel());
                }
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankName())) {
                    ordSalesbillInterfaceEntity.setSellerBankName(sellerInvoiceInfoObj.getSellerBankName());
                }
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankAccount())) {
                    ordSalesbillInterfaceEntity.setSellerBankAccount(sellerInvoiceInfoObj.getSellerBankAccount());
                }
                return this.checkSellerAddresTel(context, ordSalesbillInterfaceEntity, msg);
            }
        }
        return true;
    }

    private boolean checkSellerAddresTel(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, StringBuilder msg) {
        String sellerAddress = ordSalesbillInterfaceEntity.getSellerAddress();
        String sellerTel = ordSalesbillInterfaceEntity.getSellerTel();
        StringBuilder sellerAddrTel = new StringBuilder();
        sellerAddrTel.append(sellerAddress).append(sellerTel);
        if (CommonTools.exceedMaxLength(sellerAddrTel.toString(), 101)) {
            context.addErrorMsg(msg.append("--\u9500\u65b9\u5730\u5740\u3010").append(sellerAddress).append("\u3011,\u9500\u65b9\u7535\u8bdd\u3010").append(sellerTel).append("\u3011,\u5bf9\u5e94\u7684\u9500\u65b9\u5730\u5740\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc7100--").toString());
            return false;
        }
        return true;
    }

    private String checkInvoiceInfo(OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        Integer cooperateFlag = ordSalesbillInterfaceEntity.getCooperateFlag();
        StringBuilder msg = new StringBuilder();
        if (CooperateFlag.COOPERATE.value().equals(cooperateFlag)) {
            if (BusinessBillType.AR.value().equals(ordSalesbillInterfaceEntity.getBusinessBillType())) {
                if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankName()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankAccount()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerTel()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerAddress())) {
                    msg.append("--\u8d2d\u9500\u65b9\u534f\u540c\u65f6\uff0c\u9500\u65b9\u7968\u9762\u4fe1\u606f\u5fc5\u987b\u5168\u90e8\u586b\u5199--");
                }
            } else if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankName()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankAccount()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserTel()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserAddress())) {
                msg.append("--\u8d2d\u9500\u65b9\u534f\u540c\u65f6\uff0c\u8d2d\u65b9\u7968\u9762\u4fe1\u606f\u5fc5\u987b\u5168\u90e8\u586b\u5199--");
            }
        } else if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankName()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerBankAccount()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerTel()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerAddress()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankName()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserBankAccount()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserTel()) || CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserAddress())) {
            msg.append("--\u8d2d\u9500\u65b9\u975e\u534f\u540c\u65f6\uff0c\u8d2d\u9500\u65b9\u7968\u9762\u4fe1\u606f\u90fd\u5fc5\u987b\u5168\u90e8\u586b\u5199--");
        }
        return msg.toString();
    }
}

