/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.company;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.core.validator.company.tools.CompanyValidateTools;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtBean;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesBillInitCheckCompanyValidator
extends ValidatorHandler<OrdSalesbillInterfaceEntity>
implements Validator<OrdSalesbillInterfaceEntity> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private CompanyValidateTools companyValidateTools;
    @Autowired
    private LocalConfigMetadataCacheManager metadataCacheManager;

    public boolean accept(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        return true;
    }

    public void onException(Exception e, ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        context.addErrorMsg(e.getMessage());
    }

    public boolean validate(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        this.logger.info("=========================SalesBillInitCheckCompanyValidator-\u5355\u636e\u53f7-{}==================", (Object)ordSalesbillInterfaceEntity.getSalesbillNo());
        OrdSalesbillInterfaceEntity tempInterfaceEntity = new OrdSalesbillInterfaceEntity();
        BeanUtils.copyProperties((Object)ordSalesbillInterfaceEntity, (Object)tempInterfaceEntity);
        context.setAttribute("tempSalesBillInterface", (Object)tempInterfaceEntity);
        String businessBillType = ordSalesbillInterfaceEntity.getBusinessBillType();
        long groupId = (Long)context.getAttribute("groupId");
        StringBuilder msg = new StringBuilder();
        boolean flag = this.companyValidateTools.handleFillType(context, ordSalesbillInterfaceEntity);
        if (!flag) {
            return false;
        }
        this.companyValidateTools.putCompanyStatus(context, ordSalesbillInterfaceEntity);
        flag = this.companyValidateTools.getSellerCompanyModel(context, ordSalesbillInterfaceEntity, businessBillType, msg);
        if (!flag) {
            return false;
        }
        flag = this.companyValidateTools.getPurchaserCompanyModel(context, ordSalesbillInterfaceEntity, businessBillType, msg);
        if (!flag) {
            return false;
        }
        flag = this.companyValidateTools.checkOwnerTenantId(context, ordSalesbillInterfaceEntity, groupId, businessBillType, msg);
        if (!flag) {
            return false;
        }
        this.companyValidateTools.initCooperateAndUsingStatus(ordSalesbillInterfaceEntity, businessBillType);
        flag = this.companyValidateTools.completeOrgId(context, ordSalesbillInterfaceEntity, msg);
        if (!flag) {
            return false;
        }
        ConfigRequestModel configRequestModel = new ConfigRequestModel();
        BeanUtils.copyProperties((Object)ordSalesbillInterfaceEntity, configRequestModel);
        SysConfigExtBean SysConfigExtBean2 = this.metadataCacheManager.querySysInfoConfig(configRequestModel, ConfigTypeEnum.SYS_CONFIG_TYPE);
        context.setAttribute("sysInfoRuleDTO", (Object)SysConfigExtBean2);
        flag = this.companyValidateTools.checkSellerAndPurchaerTaxNo(context, ordSalesbillInterfaceEntity);
        return flag;
    }
}

