/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.company.tools;

import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.bss.external.client.model.CoordinationModel;
import com.xforceplus.bss.external.client.model.GroupModel;
import com.xforceplus.phoenix.bill.cache.bssexternal.LocalBssExternalCacheManager;
import com.xforceplus.phoenix.bill.cache.casm.LocalCasmCacheManager;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.cache.ucenter.LocalUcenterExternalCacheManager;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.CompanyDataStatus;
import com.xforceplus.phoenix.bill.constant.enums.CooperateFlag;
import com.xforceplus.phoenix.bill.constant.enums.InfoFillType;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillCatalog;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.constant.enums.UsingStatus;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.core.vo.BankModel;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtBean;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.CooperationUtils;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.ucenter.external.client.model.GetOrgInfoRequest;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyValidateTools {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LocalBssExternalCacheManager bssExternalCacheManager;
    @Autowired
    private LocalConfigMetadataCacheManager metadataCacheManager;
    @Autowired
    private CooperationUtils cooperationUtils;
    @Autowired
    private LocalUcenterExternalCacheManager ucenterExternalCacheManager;
    @Autowired
    LocalCasmCacheManager localCasmCacheManager;

    public boolean getSellerCompanyModel(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, String businessBillType, StringBuilder msg) {
        Map<String, Object> companyInfoFromMerchant;
        String salesbillNo = ordSalesbillInterfaceEntity.getSalesbillNo();
        String sellerNo = ordSalesbillInterfaceEntity.getSellerNo();
        String sellerTaxNo = ordSalesbillInterfaceEntity.getSellerTaxNo();
        String sellerName = ordSalesbillInterfaceEntity.getSellerName();
        String sellerInfoFill = (String)context.getAttribute("sellerInfoFill");
        CompanyModel sellerCompanyMode = null;
        BankModel sellerBankModel = null;
        long groupId = (Long)context.getAttribute("groupId");
        String validType = (String)context.getAttribute("validateType");
        if (!ValidateType.IMPORT.value().equals(validType)) {
            groupId = BusinessBillType.AR.value().equals(ordSalesbillInterfaceEntity.getBusinessBillType()) ? ordSalesbillInterfaceEntity.getSellerGroupId().longValue() : ordSalesbillInterfaceEntity.getPurchaserGroupId().longValue();
        }
        if (InfoFillType.BY_NO.value().equals(sellerInfoFill)) {
            if (CommonTools.isEmpty(sellerNo)) {
                context.addErrorMsg("--\u9500\u65b9\u516c\u53f8\u6309\u7f16\u53f7\u8bc6\u522b\u65f6\uff0c\u9500\u65b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
                return false;
            }
            sellerCompanyMode = this.bssExternalCacheManager.getCompanyMainInfoByNo(sellerNo, groupId);
            if (BusinessBillType.AP.value().equals(businessBillType) && !(companyInfoFromMerchant = this.localCasmCacheManager.getCompanyInfoFromMerchant(sellerNo, null, null, groupId)).isEmpty()) {
                sellerBankModel = (BankModel)companyInfoFromMerchant.get("bankModel");
                if (sellerCompanyMode == null) {
                    this.logger.info("\u7f16\u53f7\u65b9\u5f0f,\u8fd0\u8425\u67e5\u8be2\u9500\u65b9\u516c\u53f8\u4e3a\u7a7a,\u5ba2\u5546\u7ba1\u7406\u8865\u5168:salesbillNo:{}", (Object)salesbillNo);
                    sellerCompanyMode = (CompanyModel)companyInfoFromMerchant.get("companyModel");
                }
            }
            if (sellerCompanyMode == null && BusinessBillType.AR.value().equals(businessBillType)) {
                context.addErrorMsg(msg.append("--\u6839\u636e\u9500\u65b9\u7f16\u53f7\u3010").append(sellerNo).append("\u3011\u672a\u5339\u914d\u5230\u9500\u65b9\u516c\u53f8\u4fe1\u606f\u3002").toString());
                return false;
            }
        }
        if (InfoFillType.BY_TAX_NO.value().equals(sellerInfoFill)) {
            if (CommonTools.isEmpty(sellerTaxNo)) {
                context.addErrorMsg("--\u9500\u65b9\u516c\u53f8\u6309\u7a0e\u53f7\u8bc6\u522b\u65f6\uff0c\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
                return false;
            }
            sellerCompanyMode = this.bssExternalCacheManager.getCompanyMainInfoByTaxNo(sellerTaxNo);
            if (BusinessBillType.AP.value().equals(businessBillType) && !(companyInfoFromMerchant = this.localCasmCacheManager.getCompanyInfoFromMerchant(null, sellerName, sellerTaxNo, groupId)).isEmpty()) {
                sellerBankModel = (BankModel)companyInfoFromMerchant.get("bankModel");
                if (sellerCompanyMode == null) {
                    this.logger.info("\u7a0e\u53f7\u65b9\u5f0f,\u8fd0\u8425\u67e5\u8be2\u9500\u65b9\u516c\u53f8\u4e3a\u7a7a,\u5ba2\u5546\u7ba1\u7406\u8865\u5168:salesbillNo:{}", (Object)salesbillNo);
                    sellerCompanyMode = (CompanyModel)companyInfoFromMerchant.get("companyModel");
                }
            }
            if (sellerCompanyMode == null && BusinessBillType.AR.value().equals(businessBillType)) {
                context.addErrorMsg(msg.append("--\u6839\u636e\u9500\u65b9\u7a0e\u53f7\u3010").append(sellerTaxNo).append("\u3011\u672a\u5339\u914d\u5230\u9500\u65b9\u516c\u53f8\u4fe1\u606f--").toString());
                return false;
            }
        }
        if (sellerCompanyMode != null) {
            if (ordSalesbillInterfaceEntity.getSellerId() == null || ordSalesbillInterfaceEntity.getSellerId() == 0L) {
                ordSalesbillInterfaceEntity.setSellerId(sellerCompanyMode.getCompanyId());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerTaxNo())) {
                ordSalesbillInterfaceEntity.setSellerTaxNo(sellerCompanyMode.getTaxNum());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getSellerName())) {
                ordSalesbillInterfaceEntity.setSellerName(sellerCompanyMode.getCompanyName());
            }
        }
        context.setAttribute("sellerCompanyMode", (Object)sellerCompanyMode);
        context.setAttribute("sellerBankModel", sellerBankModel);
        return true;
    }

    public boolean getPurchaserCompanyModel(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, String businessBillType, StringBuilder msg) {
        Map<String, Object> companyInfoFromMerchant;
        String salesbillNo = ordSalesbillInterfaceEntity.getSalesbillNo();
        String purchaserNo = ordSalesbillInterfaceEntity.getPurchaserNo();
        String purchaserTaxNo = ordSalesbillInterfaceEntity.getPurchaserTaxNo();
        String invoiceType = ordSalesbillInterfaceEntity.getInvoiceType();
        String purchaserName = ordSalesbillInterfaceEntity.getPurchaserName();
        String purchaserInfoFill = (String)context.getAttribute("purchaserInfoFill");
        CompanyModel purchaserCompanyMode = null;
        BankModel purchaseBankModel = null;
        long groupId = (Long)context.getAttribute("groupId");
        String validType = (String)context.getAttribute("validateType");
        if (!ValidateType.IMPORT.value().equals(validType)) {
            groupId = BusinessBillType.AR.value().equals(ordSalesbillInterfaceEntity.getBusinessBillType()) ? ordSalesbillInterfaceEntity.getSellerGroupId().longValue() : ordSalesbillInterfaceEntity.getPurchaserGroupId().longValue();
        }
        if (InfoFillType.BY_NO.value().equals(purchaserInfoFill)) {
            if (CommonTools.isEmpty(purchaserNo)) {
                context.addErrorMsg("--\u8d2d\u65b9\u516c\u53f8\u6309\u7f16\u53f7\u8bc6\u522b\u65f6\uff0c\u8d2d\u65b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            purchaserCompanyMode = this.bssExternalCacheManager.getCompanyMainInfoByNo(purchaserNo, groupId);
            if (BusinessBillType.AR.value().equals(businessBillType) && !(companyInfoFromMerchant = this.localCasmCacheManager.getCompanyInfoFromMerchant(purchaserNo, null, null, groupId)).isEmpty()) {
                purchaseBankModel = (BankModel)companyInfoFromMerchant.get("bankModel");
                if (purchaserCompanyMode == null) {
                    this.logger.info("\u7f16\u53f7\u65b9\u5f0f,\u8fd0\u8425\u67e5\u8be2\u8d2d\u65b9\u516c\u53f8\u4e3a\u7a7a,\u5ba2\u5546\u7ba1\u7406\u8865\u5168:salesbillNo:{}", (Object)salesbillNo);
                    purchaserCompanyMode = (CompanyModel)companyInfoFromMerchant.get("companyModel");
                }
            }
            if (purchaserCompanyMode == null && BusinessBillType.AP.value().equals(businessBillType)) {
                context.addErrorMsg(msg.append("--\u6839\u636e\u8d2d\u65b9\u7f16\u53f7\u3010").append(purchaserNo).append("\u3011\u672a\u5339\u914d\u5230\u8d2d\u65b9\u516c\u53f8\u4fe1\u606f--").toString());
                return false;
            }
        }
        if (InfoFillType.BY_TAX_NO.value().equals(purchaserInfoFill)) {
            if (CommonTools.isEmpty(purchaserTaxNo) && invoiceType.equals(InvoiceType.SPECIAL.value())) {
                context.addErrorMsg("--\u8d2d\u65b9\u516c\u53f8\u6309\u7a0e\u53f7\u8bc6\u522b\u65f6\uff0c\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
                return false;
            }
            purchaserCompanyMode = this.bssExternalCacheManager.getCompanyMainInfoByTaxNo(purchaserTaxNo);
            if (BusinessBillType.AR.value().equals(businessBillType) && !(companyInfoFromMerchant = this.localCasmCacheManager.getCompanyInfoFromMerchant(null, purchaserName, purchaserTaxNo, groupId)).isEmpty()) {
                purchaseBankModel = (BankModel)companyInfoFromMerchant.get("bankModel");
                if (purchaserCompanyMode == null) {
                    this.logger.info("\u7a0e\u53f7\u65b9\u5f0f,\u8fd0\u8425\u67e5\u8be2\u8d2d\u65b9\u516c\u53f8\u4e3a\u7a7a,\u5ba2\u5546\u7ba1\u7406\u8865\u5168:salesbillNo:{}", (Object)salesbillNo);
                    purchaserCompanyMode = (CompanyModel)companyInfoFromMerchant.get("companyModel");
                }
            }
            if (purchaserCompanyMode == null && BusinessBillType.AP.value().equals(businessBillType)) {
                context.addErrorMsg(msg.append("--\u6839\u636e\u8d2d\u65b9\u7a0e\u53f7\u3010").append(purchaserTaxNo).append("\u3011\u672a\u5339\u914d\u5230\u8d2d\u65b9\u516c\u53f8\u4fe1\u606f--").toString());
                return false;
            }
        }
        if (purchaserCompanyMode != null) {
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserId() + "") || ordSalesbillInterfaceEntity.getPurchaserId() == 0L) {
                ordSalesbillInterfaceEntity.setPurchaserId(purchaserCompanyMode.getCompanyId());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserTaxNo())) {
                ordSalesbillInterfaceEntity.setPurchaserTaxNo(purchaserCompanyMode.getTaxNum());
            }
            if (CommonTools.isEmpty(ordSalesbillInterfaceEntity.getPurchaserName())) {
                ordSalesbillInterfaceEntity.setPurchaserName(purchaserCompanyMode.getCompanyName());
            }
        }
        context.setAttribute("purchaserCompanyMode", (Object)purchaserCompanyMode);
        context.setAttribute("purchaseBankModel", purchaseBankModel);
        return true;
    }

    public void putCompanyStatus(ValidatorContext context, OrdSalesbillInterfaceEntity interfaceEntity) {
        String sellerAddress = interfaceEntity.getSellerAddress();
        String sellerTel = interfaceEntity.getSellerTel();
        String sellerBankAccount = interfaceEntity.getSellerBankAccount();
        String sellerBankName = interfaceEntity.getSellerBankName();
        String purchaserAddress = interfaceEntity.getPurchaserAddress();
        String purchaserTel = interfaceEntity.getPurchaserTel();
        String purchaserBankAccount = interfaceEntity.getPurchaserBankAccount();
        String purchaserBankName = interfaceEntity.getPurchaserBankName();
        if (CommonTools.isEmpty(sellerAddress) && CommonTools.isEmpty(sellerTel) && CommonTools.isEmpty(sellerBankAccount) && CommonTools.isEmpty(sellerBankName)) {
            context.setAttribute("sellerCompanyDataStatus", (Object)CompanyDataStatus.NO_HAVING_COMPANY_INFO.value());
        } else if (!(CommonTools.isEmpty(sellerAddress) || CommonTools.isEmpty(sellerTel) || CommonTools.isEmpty(sellerBankAccount) || CommonTools.isEmpty(sellerBankName))) {
            context.setAttribute("sellerCompanyDataStatus", (Object)CompanyDataStatus.HAVING_COMPANY_INFO.value());
        }
        if (CommonTools.isEmpty(purchaserAddress) && CommonTools.isEmpty(purchaserTel) && CommonTools.isEmpty(purchaserBankName) && CommonTools.isEmpty(purchaserBankAccount)) {
            context.setAttribute("purchaserCompanyDataStatus", (Object)CompanyDataStatus.NO_HAVING_COMPANY_INFO.value());
        } else if (!(CommonTools.isEmpty(purchaserAddress) || CommonTools.isEmpty(purchaserTel) || CommonTools.isEmpty(purchaserBankName) || CommonTools.isEmpty(purchaserBankAccount))) {
            context.setAttribute("purchaserCompanyDataStatus", (Object)CompanyDataStatus.HAVING_COMPANY_INFO.value());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean handleFillType(ValidatorContext context, OrdSalesbillInterfaceEntity interfaceEntity) {
        String sellerNo = interfaceEntity.getSellerNo();
        String sellerTaxNo = interfaceEntity.getSellerTaxNo();
        String purchaserNo = interfaceEntity.getPurchaserNo();
        String purchaserTaxNo = interfaceEntity.getPurchaserTaxNo();
        if (CommonTools.isEmpty(sellerNo)) {
            if (CommonTools.isEmpty(sellerTaxNo)) {
                context.addErrorMsg("--\u9500\u65b9\u65b9\u516c\u53f8\u6309\u7a0e\u53f7\u8bc6\u522b\u65f6\uff0c\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
                return false;
            }
            context.setAttribute("sellerInfoFill", (Object)InfoFillType.BY_TAX_NO.value());
        } else {
            context.setAttribute("sellerInfoFill", (Object)InfoFillType.BY_NO.value());
        }
        if (!CommonTools.isEmpty(purchaserNo)) {
            context.setAttribute("purchaserInfoFill", (Object)InfoFillType.BY_NO.value());
            return true;
        }
        if (!CommonTools.isEmpty(purchaserTaxNo)) {
            context.setAttribute("purchaserInfoFill", (Object)InfoFillType.BY_TAX_NO.value());
            return true;
        }
        context.addErrorMsg("--\u8d2d\u65b9\u516c\u53f8\u6309\u7a0e\u53f7\u8bc6\u522b\u65f6\uff0c\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
        return false;
    }

    public void completePersonInfo(OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        String invoicerName = ordSalesbillInterfaceEntity.getInvoicerName();
        String checkerName = ordSalesbillInterfaceEntity.getCheckerName();
        String cashierName = ordSalesbillInterfaceEntity.getCashierName();
        String businessBillType = ordSalesbillInterfaceEntity.getBusinessBillType();
        if (CommonTools.isEmpty(invoicerName) || CommonTools.isEmpty(checkerName) || CommonTools.isEmpty(cashierName)) {
            ConfigRequestModel configRequestModel = new ConfigRequestModel();
            BeanUtils.copyProperties((Object)ordSalesbillInterfaceEntity, configRequestModel);
            InvoiceInfoRuleDTO invoiceInfoObj = this.metadataCacheManager.queryInvoiceInfoRuleDTO(configRequestModel, ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE, businessBillType);
            if (invoiceInfoObj != null) {
                if (CommonTools.isEmpty(checkerName)) {
                    ordSalesbillInterfaceEntity.setCheckerName(invoiceInfoObj.getCheckerName());
                }
                if (CommonTools.isEmpty(cashierName)) {
                    ordSalesbillInterfaceEntity.setCashierName(invoiceInfoObj.getCashierName());
                }
                if (CommonTools.isEmpty(invoicerName)) {
                    ordSalesbillInterfaceEntity.setInvoicerName(invoiceInfoObj.getInvoicerName());
                }
            }
        }
    }

    public boolean checkSellerAndPurchaerTaxNo(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        Object config = context.getAttribute("sysInfoRuleDTO");
        SysConfigExtBean sysConfigExtBean = null;
        if (config != null) {
            sysConfigExtBean = (SysConfigExtBean)((Object)config);
        }
        boolean nomalSame = false;
        boolean specialSame = false;
        if (sysConfigExtBean != null) {
            if (sysConfigExtBean.getNomalInvoicePurchaserSellerSame() != null) {
                nomalSame = sysConfigExtBean.getNomalInvoicePurchaserSellerSame();
            }
            if (sysConfigExtBean.getSpecialInvoicePurchaserSellerSame() != null) {
                specialSame = sysConfigExtBean.getSpecialInvoicePurchaserSellerSame();
            }
        }
        if ((ordSalesbillInterfaceEntity.getSellerTaxNo() + "").equals(ordSalesbillInterfaceEntity.getPurchaserTaxNo())) {
            if (InvoiceType.SPECIAL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType()) && !specialSame) {
                context.addErrorMsg("--\u4e13\u7968\u8d2d\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u76f8\u540c--");
                return false;
            }
            if ((InvoiceType.NORMAL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType()) || InvoiceType.ROLL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType()) || InvoiceType.ELECTRONIC.value().equals(ordSalesbillInterfaceEntity.getInvoiceType())) && !nomalSame) {
                context.addErrorMsg("--\u666e\u7968\u8d2d\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u76f8\u540c--");
                return false;
            }
        }
        return true;
    }

    public boolean checkOwnerTenantId(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, long groupId, String businessBillType, StringBuilder msg) {
        Long sellerId = ordSalesbillInterfaceEntity.getSellerId();
        Long purchaserId = ordSalesbillInterfaceEntity.getPurchaserId();
        Long sellerGroupId = 0L;
        Long purchaserGroupId = 0L;
        String validateType = String.valueOf(context.getAttribute("validateType"));
        if (BusinessBillType.AP.value().equals(businessBillType)) {
            if (ValidateType.IMPORT.value().equals(validateType)) {
                GroupModel purchaserGroupModel = this.bssExternalCacheManager.getTenantCodeByCompanyId(purchaserId);
                if (purchaserGroupModel == null) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u8d2d\u65b9\u516c\u53f8id\u3010").append(purchaserId).append("\u3011\u672a\u5339\u914d\u5230\u8d2d\u65b9\u79df\u6237\u4fe1\u606f--").toString());
                    return false;
                }
                purchaserGroupId = purchaserGroupModel.getGroupId();
                if (purchaserGroupId != groupId) {
                    context.addErrorMsg(msg.append("--\u5bf9\u5e94\u8d2d\u65b9\u516c\u53f8\u3010").append(ordSalesbillInterfaceEntity.getPurchaserName()).append("\u3011\u7684\u96c6\u56e2\u3010").append(purchaserGroupId).append("\u3011\u4e0e\u60a8\u7684\u96c6\u56e2\u3010").append(groupId).append("\u3011\u4e0d\u4e00\u81f4--").toString());
                    return false;
                }
                ordSalesbillInterfaceEntity.setPurchaserTenantId(purchaserGroupModel.getTenantId());
            }
            if ((ValidateType.IMPORT.value().equals(validateType) || ValidateType.MAKE_INVOICE.value().equals(validateType)) && sellerId != null) {
                GroupModel sellerGroupModel = this.bssExternalCacheManager.getTenantCodeByCompanyId(sellerId);
                if (sellerGroupModel == null) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u9500\u65b9\u516c\u53f8id\u3010").append(purchaserId).append("\u3011\u672a\u5339\u914d\u5230\u9500\u65b9\u79df\u6237\u4fe1\u606f--").toString());
                    return false;
                }
                sellerGroupId = sellerGroupModel.getGroupId();
                ordSalesbillInterfaceEntity.setSellerGroupId(sellerGroupId);
                ordSalesbillInterfaceEntity.setSellerTenantId(sellerGroupModel.getTenantId());
            }
        } else {
            if (ValidateType.IMPORT.value().equals(validateType) || ValidateType.MAKE_INVOICE.value().equals(validateType)) {
                GroupModel sellerGroupModel = this.bssExternalCacheManager.getTenantCodeByCompanyId(sellerId);
                if (sellerGroupModel == null) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u9500\u65b9\u516c\u53f8id\u3010").append(purchaserId).append("\u3011\u672a\u5339\u914d\u5230\u9500\u65b9\u79df\u6237\u4fe1\u606f--").toString());
                    return false;
                }
                sellerGroupId = sellerGroupModel.getGroupId();
                if (sellerGroupId != groupId) {
                    context.addErrorMsg(msg.append("--\u5bf9\u5e94\u9500\u65b9\u516c\u53f8\u3010").append(ordSalesbillInterfaceEntity.getSellerName()).append("\u3011\u7684\u96c6\u56e2\u3010").append(sellerGroupId).append("\u3011\u4e0e\u60a8\u7684\u96c6\u56e2\u3010").append(groupId).append("\u3011\u4e0d\u4e00\u81f4--").toString());
                    return false;
                }
                ordSalesbillInterfaceEntity.setSellerTenantId(sellerGroupModel.getTenantId());
            }
            if (ValidateType.IMPORT.value().equals(validateType) && purchaserId != null) {
                GroupModel purchaserGroupModel = this.bssExternalCacheManager.getTenantCodeByCompanyId(purchaserId);
                if (purchaserGroupModel == null) {
                    context.addErrorMsg(msg.append("--\u6839\u636e\u8d2d\u65b9\u516c\u53f8id\u3010").append(purchaserId).append("\u3011\u672a\u5339\u914d\u5230\u8d2d\u65b9\u79df\u6237\u4fe1\u606f--").toString());
                    return false;
                }
                purchaserGroupId = purchaserGroupModel.getGroupId();
                ordSalesbillInterfaceEntity.setPurchaserGroupId(purchaserGroupId);
                ordSalesbillInterfaceEntity.setPurchaserTenantId(purchaserGroupModel.getTenantId());
            }
        }
        return true;
    }

    public void initCooperateAndUsingStatus(OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, String businessBillType) {
        String salesbillType;
        int cooperateFlag = CooperateFlag.NO_COOPERATE.value();
        String businessUploadPartType = BusinessBillType.AR.value();
        Long sellerId = ordSalesbillInterfaceEntity.getSellerId();
        Long sellerGroupId = ordSalesbillInterfaceEntity.getSellerGroupId();
        Long purchaserId = ordSalesbillInterfaceEntity.getPurchaserId();
        Long purchaserGroupId = ordSalesbillInterfaceEntity.getPurchaserGroupId();
        CoordinationModel coordiantion = this.bssExternalCacheManager.getBssExternalCoordiantion(sellerGroupId, sellerId, purchaserGroupId, purchaserId, salesbillType = ordSalesbillInterfaceEntity.getSalesbillType(), businessBillType);
        if (coordiantion != null) {
            cooperateFlag = CooperateFlag.COOPERATE.value();
            businessUploadPartType = coordiantion.getBusinessUploadPartType();
        }
        ordSalesbillInterfaceEntity.setCooperateFlag(cooperateFlag);
        this.completeUsingStatus(ordSalesbillInterfaceEntity, businessUploadPartType, businessBillType);
        ordSalesbillInterfaceEntity.setStatus(SalesBillStatus.NORMAL.value());
        ordSalesbillInterfaceEntity.setUploadConfirmFlag(SalesBillCatalog.CONFIRMING.value());
        ordSalesbillInterfaceEntity.setReceiveConfirmFlag(SalesBillCatalog.NO_EFFECT.value());
        this.cooperationUtils.handlUploadAutoFlag(ordSalesbillInterfaceEntity, businessBillType, BillOperationType.UPLOAD, coordiantion);
    }

    public void completeUsingStatus(OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, String businessUploadPartType, String businessBillType) {
        if (BusinessBillType.AP.value().equals(businessBillType) && CooperateFlag.COOPERATE.value().equals(ordSalesbillInterfaceEntity.getCooperateFlag()) && BusinessBillType.AR.value().equals(businessUploadPartType)) {
            ordSalesbillInterfaceEntity.setUsingStatus(UsingStatus.NOT_USING.value());
        }
        if (BusinessBillType.AP.value().equals(businessBillType) && CooperateFlag.COOPERATE.value().equals(ordSalesbillInterfaceEntity.getCooperateFlag()) && BusinessBillType.AP.value().equals(businessUploadPartType)) {
            ordSalesbillInterfaceEntity.setUsingStatus(UsingStatus.USING.value());
        }
        if (BusinessBillType.AP.value().equals(businessBillType) && CooperateFlag.NO_COOPERATE.value().equals(ordSalesbillInterfaceEntity.getCooperateFlag())) {
            ordSalesbillInterfaceEntity.setUsingStatus(UsingStatus.NOT_USING.value());
        }
        if (BusinessBillType.AR.value().equals(businessBillType) && CooperateFlag.COOPERATE.value().equals(ordSalesbillInterfaceEntity.getCooperateFlag()) && BusinessBillType.AR.value().equals(businessUploadPartType)) {
            ordSalesbillInterfaceEntity.setUsingStatus(UsingStatus.USING.value());
        }
        if (BusinessBillType.AR.value().equals(businessBillType) && CooperateFlag.COOPERATE.value().equals(ordSalesbillInterfaceEntity.getCooperateFlag()) && BusinessBillType.AP.value().equals(businessUploadPartType)) {
            ordSalesbillInterfaceEntity.setUsingStatus(UsingStatus.NOT_USING.value());
        }
        if (BusinessBillType.AR.value().equals(businessBillType) && CooperateFlag.NO_COOPERATE.value().equals(ordSalesbillInterfaceEntity.getCooperateFlag())) {
            ordSalesbillInterfaceEntity.setUsingStatus(UsingStatus.USING.value());
        }
    }

    public boolean completeOrgId(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity, StringBuilder msg) {
        String orgCode = ordSalesbillInterfaceEntity.getSysOrgCode();
        Long sellerCompanyId = ordSalesbillInterfaceEntity.getSellerId();
        Long purchaserCompanyId = ordSalesbillInterfaceEntity.getPurchaserId();
        String businessBillType = ordSalesbillInterfaceEntity.getBusinessBillType();
        Long sellerGroupId = ordSalesbillInterfaceEntity.getSellerGroupId();
        Long purchaserGroupId = ordSalesbillInterfaceEntity.getPurchaserGroupId();
        String value = "";
        Long groupId = 0L;
        GetOrgInfoRequest.DataTypeEnum dataTypeEnum = null;
        if (BusinessBillType.AR.value().equals(businessBillType)) {
            value = String.valueOf(sellerCompanyId);
            groupId = sellerGroupId;
        } else {
            value = String.valueOf(purchaserCompanyId);
            groupId = purchaserGroupId;
        }
        if (!CommonTools.isEmpty(orgCode)) {
            dataTypeEnum = GetOrgInfoRequest.DataTypeEnum.ORGCODE;
            value = orgCode;
        } else {
            dataTypeEnum = GetOrgInfoRequest.DataTypeEnum.COMPANYID;
        }
        OrgModel orgInfoByOrgCode = null;
        if (!CommonTools.isEmpty(value) && dataTypeEnum != null) {
            orgInfoByOrgCode = this.ucenterExternalCacheManager.getOrgInfoByOrgCode(groupId, dataTypeEnum, value);
        }
        if (orgInfoByOrgCode == null) {
            context.addErrorMsg(msg.append("--\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f--").toString());
        } else {
            ordSalesbillInterfaceEntity.setSysOrgId(orgInfoByOrgCode.getOrgStructId());
        }
        return CommonTools.isEmpty(msg.toString());
    }
}

