/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.detail;

import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.core.validator.detail.BaseValidator;
import com.xforceplus.phoenix.bill.core.validator.detail.SupplementDetail;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AmtValidator
extends BaseValidator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SupplementDetail supplementDetail;
    private final BigDecimal buleDevetion = new BigDecimal("0.01");

    @Override
    public boolean check(ValidatorContext context, OrdSalesbillInterfaceItemEntity billItem, OrdSalesbillInterfaceEntity billEntity, StringBuilder itemCheckAll) {
        BigDecimal amountWithTaxTmp;
        String amountWithTax;
        String amountWithoutTax;
        String billNo;
        block4: {
            String validType = (String)context.getAttribute("validType");
            billNo = billEntity.getSalesbillNo();
            amountWithoutTax = billItem.getAmountWithoutTax() + "";
            amountWithTax = billItem.getAmountWithTax() + "";
            this.normalAmtFormartCheck(billItem, billNo, itemCheckAll, validType);
            boolean checkNormalAmt = this.checkNormalAmt(billItem, itemCheckAll, billNo, billEntity.getPriceMethod(), validType);
            if (checkNormalAmt) {
                this.supplementDetail.supplementTaxAmount(billItem, billEntity);
                try {
                    this.supplementDetail.supplementQuantityorPrice(billItem, billEntity);
                }
                catch (Exception e) {
                    if (CommonTools.isEmpty(e.getMessage())) break block4;
                    itemCheckAll.append(e.getMessage());
                }
            }
        }
        if (billItem.getAmountWithoutTax() != null && billItem.getAmountWithTax() != null && billItem.getTaxAmount() != null && (amountWithTaxTmp = billItem.getAmountWithoutTax().add(billItem.getTaxAmount()).setScale(2, 4)).compareTo(new BigDecimal(amountWithTax).setScale(2, 4)) != 0) {
            itemCheckAll.append("--\u91d1\u989d\u6570\u636e[\u4e0d\u542b\u7a0e\u91d1\u989d+\u7a0e\u989d=\u542b\u7a0e\u91d1\u989d]->[").append(amountWithoutTax).append("+").append(billItem.getTaxAmount()).append("=").append(amountWithTaxTmp).append("]\uff0c\u5b9e\u9645\u4f20\u5165\u503c\u4e3a[").append(amountWithTax).append("]--");
        }
        this.checkSameData(billItem, itemCheckAll, billNo);
        this.checkAccuracy(billItem, itemCheckAll);
        this.checkDiscountAmt(billItem, itemCheckAll, billNo, billEntity);
        this.checktaxDedunction(billItem, itemCheckAll, billNo, billEntity);
        return true;
    }

    private void normalAmtFormartCheck(OrdSalesbillInterfaceItemEntity billItem, String billNo, StringBuilder itemCheckAll, String validType) {
        String amountWithTax;
        String quantity = billItem.getQuantity() != null ? billItem.getQuantity().toPlainString() : "null";
        String unitPrice = billItem.getUnitPrice() != null ? billItem.getUnitPrice().toPlainString() : "null";
        String unitPriceWithTax = billItem.getUnitPriceWithTax() != null ? billItem.getUnitPriceWithTax().toPlainString() : "null";
        String taxRate = billItem.getTaxRate() != null ? billItem.getTaxRate().toPlainString() : "null";
        String amountWithoutTax = billItem.getAmountWithoutTax() != null ? billItem.getAmountWithoutTax().toPlainString() : "null";
        String string = amountWithTax = billItem.getAmountWithTax() != null ? billItem.getAmountWithTax().toPlainString() : "null";
        if (ValidateType.IMPORT.value().equals(validType)) {
            if (!CommonTools.isEmpty(quantity) && BigDecimal.ZERO.compareTo(new BigDecimal(quantity)) == 0) {
                itemCheckAll.append("\u5355\u636e\u660e\u7ec6\u4e2d\u6570\u91cf\u3010").append(quantity).append("\u3011\u4e0d\u80fd\u4e3a0 \u6216 \u683c\u5f0f\u4e0d\u6b63\u786e--");
            }
        } else if (!CommonTools.isEmpty(quantity) && BigDecimal.ZERO.compareTo(new BigDecimal(quantity)) == 0) {
            if (!CommonTools.isEmpty(unitPriceWithTax) && BigDecimal.ZERO.compareTo(new BigDecimal(unitPriceWithTax)) != 0) {
                itemCheckAll.append("--\u542b\u7a0e\u5355\u4ef7,\u6570\u91cf\u8981\u4e48\u5168\u90e8\u586b\u5199\uff0c\u8981\u4e48\u5168\u90e8\u4e0d\u586b\u5199--");
            }
            if (!CommonTools.isEmpty(unitPrice) && BigDecimal.ZERO.compareTo(new BigDecimal(unitPrice)) != 0) {
                itemCheckAll.append("--\u4e0d\u542b\u7a0e\u5355\u4ef7,\u6570\u91cf\u8981\u4e48\u5168\u90e8\u586b\u5199\uff0c\u8981\u4e48\u5168\u90e8\u4e0d\u586b\u5199--");
            }
        }
        if (!CommonTools.isEmpty(unitPrice) && BigDecimal.ZERO.compareTo(new BigDecimal(unitPrice)) > 0) {
            itemCheckAll.append("\u5355\u636e\u660e\u7ec6\u4e2d\u5355\u4ef7\u3010").append(unitPrice).append("\u3011\u4e0d\u80fd\u5c0f\u4e8e0--");
        }
        if (!CommonTools.isEmpty(unitPriceWithTax) && BigDecimal.ZERO.compareTo(new BigDecimal(unitPriceWithTax)) > 0) {
            itemCheckAll.append("\u5355\u636e\u660e\u7ec6\u4e2d\u542b\u7a0e\u5355\u4ef7\u3010").append(unitPriceWithTax).append("\u3011\u4e0d\u80fd\u5c0f\u4e8e0--");
        }
        if (!CommonTools.isEmpty(taxRate) && BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) > 0) {
            itemCheckAll.append("\u5355\u636e\u660e\u7ec6\u4e2d\u7a0e\u7387\u3010").append(taxRate).append("\u3011\u4e0d\u80fd\u5c0f\u4e8e0--");
        }
        if (!CommonTools.isEmpty(amountWithoutTax) && billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) == 0) {
            itemCheckAll.append("\u5355\u636e\u660e\u7ec6\u4e2d\u4e0d\u542b\u7a0e\u91d1\u989d\u3010").append(amountWithoutTax).append("\u3011\u4e0d\u80fd\u7b49\u4e8e0 \u6216\u683c\u5f0f\u4e0d\u6b63\u786e--");
        }
        if (!CommonTools.isEmpty(amountWithTax) && billItem.getAmountWithTax().compareTo(BigDecimal.ZERO) == 0) {
            itemCheckAll.append("\u5355\u636e\u660e\u7ec6\u4e2d\u542b\u7a0e\u91d1\u989d\u3010").append(amountWithTax).append("\u3011\u4e0d\u80fd\u7b49\u4e8e0 \u6216 \u683c\u5f0f\u4e0d\u6b63\u786e--");
        }
    }

    private void checkSameData(OrdSalesbillInterfaceItemEntity billItem, StringBuilder itemCheckAll, String billNo) {
        boolean amountWithTaxFlag;
        boolean taxFlag;
        boolean withTaxFlag;
        boolean withoutTaxeFalg;
        BigDecimal zero = BigDecimal.ZERO;
        if (billItem.getQuantity() != null && billItem.getAmountWithoutTax() != null && billItem.getAmountWithTax() != null && billItem.getQuantity().compareTo(BigDecimal.ZERO) != 0 && billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) != 0 && billItem.getAmountWithTax().compareTo(BigDecimal.ZERO) != 0) {
            boolean amountWithoutTaxFlag;
            boolean amountWithTaxFlag2 = billItem.getAmountWithTax().compareTo(zero) > 0;
            boolean quatityFlag = billItem.getQuantity().compareTo(zero) > 0;
            boolean bl = amountWithoutTaxFlag = billItem.getAmountWithoutTax().compareTo(zero) > 0;
            if (quatityFlag != amountWithTaxFlag2 || quatityFlag != amountWithoutTaxFlag) {
                itemCheckAll.append("--\u6570\u91cf\u3001\u4e0d\u542b\u7a0e\u91d1\u989d\u3001\u542b\u7a0e\u91d1\u989d\u3002\u5e94\u540c\u4e3a\u6b63\u6216\u540c\u4e3a\u8d1f\uff1b\u5b9e\u9645\u4f20\u5165\u6570\u636e\uff1a\u6570\u91cf\u3010").append(billItem.getQuantity().toPlainString()).append("\u3011\u3001\u4e0d\u542b\u7a0e\u91d1\u989d\u3010").append(billItem.getAmountWithoutTax().toPlainString()).append("\u3011\u3001\u542b\u7a0e\u91d1\u989d[").append(billItem.getAmountWithTax().toPlainString()).append("\u3011--");
            }
        }
        if (billItem.getInnerDiscountWithoutTax() != null && billItem.getInnerDiscountWithTax() != null && billItem.getInnerDiscountTax() != null && zero.compareTo(billItem.getInnerDiscountWithoutTax()) != 0 && zero.compareTo(billItem.getInnerDiscountWithTax()) != 0) {
            withoutTaxeFalg = billItem.getInnerDiscountWithoutTax().compareTo(zero) > 0;
            withTaxFlag = billItem.getInnerDiscountWithTax().compareTo(zero) > 0;
            taxFlag = billItem.getInnerDiscountTax().compareTo(zero) > 0;
            boolean bl = amountWithTaxFlag = billItem.getAmountWithTax().compareTo(zero) > 0;
            if (withoutTaxeFalg != withTaxFlag || withTaxFlag != taxFlag || amountWithTaxFlag != taxFlag) {
                itemCheckAll.append("--\u4ef7\u5185\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u4ef7\u5185\u6298\u6263\u7a0e\u989d \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f--");
            }
        }
        if (billItem.getOutterDiscountTax() != null && billItem.getOutterDiscountWithoutTax() != null && billItem.getOutterDiscountWithTax() != null && zero.compareTo(billItem.getOutterDiscountTax()) != 0 && zero.compareTo(billItem.getOutterDiscountWithoutTax()) != 0) {
            withoutTaxeFalg = billItem.getOutterDiscountWithoutTax().compareTo(zero) > 0;
            withTaxFlag = billItem.getOutterDiscountWithTax().compareTo(zero) > 0;
            taxFlag = billItem.getOutterDiscountTax().compareTo(zero) > 0;
            boolean bl = amountWithTaxFlag = billItem.getAmountWithTax().compareTo(zero) > 0;
            if (withoutTaxeFalg != withTaxFlag || withTaxFlag != taxFlag || amountWithTaxFlag != taxFlag) {
                itemCheckAll.append("--\u4ef7\u5916\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u4ef7\u5916\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u4ef7\u5916\u6298\u6263\u7a0e\u989d \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f--");
            }
        }
        if (billItem.getInnerPrepayAmountTax() != null && billItem.getInnerPrepayAmountWithoutTax() != null && billItem.getInnerPrepayAmountWithTax() != null && zero.compareTo(billItem.getInnerPrepayAmountTax()) != 0 && zero.compareTo(billItem.getInnerPrepayAmountWithoutTax()) != 0) {
            withoutTaxeFalg = billItem.getInnerPrepayAmountWithoutTax().compareTo(zero) > 0;
            withTaxFlag = billItem.getInnerPrepayAmountWithoutTax().compareTo(zero) > 0;
            taxFlag = billItem.getInnerPrepayAmountTax().compareTo(zero) > 0;
            boolean bl = amountWithTaxFlag = billItem.getAmountWithTax().compareTo(zero) > 0;
            if (withoutTaxeFalg != withTaxFlag || withTaxFlag != taxFlag || amountWithTaxFlag != taxFlag) {
                itemCheckAll.append("--\u9884\u4ed8\u4ef7\u5185\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5185\u6298\u6263\u7a0e\u989d \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f--");
            }
        }
        if (billItem.getOutterPrepayAmountTax() != null && billItem.getOutterPrepayAmountWithoutTax() != null && billItem.getOutterPrepayAmountWithTax() != null && zero.compareTo(billItem.getOutterPrepayAmountTax()) != 0 && zero.compareTo(billItem.getOutterPrepayAmountWithoutTax()) != 0) {
            withoutTaxeFalg = billItem.getOutterPrepayAmountWithoutTax().compareTo(zero) > 0;
            withTaxFlag = billItem.getOutterPrepayAmountWithoutTax().compareTo(zero) > 0;
            taxFlag = billItem.getOutterPrepayAmountTax().compareTo(zero) > 0;
            boolean bl = amountWithTaxFlag = billItem.getAmountWithTax().compareTo(zero) > 0;
            if (withoutTaxeFalg != withTaxFlag || withTaxFlag != taxFlag || amountWithTaxFlag != taxFlag) {
                itemCheckAll.append("--\u9884\u4ed8\u4ef7\u5916\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5916\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5916\u6298\u6263\u7a0e\u989d \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f--");
            }
        }
    }

    private boolean checkNormalAmt(OrdSalesbillInterfaceItemEntity billItem, StringBuilder itemCheckAll, String billNo, Integer priceMethod, String validType) {
        boolean isImportType = ValidateType.IMPORT.value().equals(validType);
        String taxDedunction = billItem.getDeductions() + "";
        String amountWithTax = billItem.getAmountWithTax() + "";
        String amountWithoutTax = billItem.getAmountWithoutTax() + "";
        StringBuilder errorMsg = new StringBuilder();
        if (priceMethod == null) {
            errorMsg.append("\u4ef7\u683c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a \uff01--");
        } else if (priceMethod == 0) {
            if (isImportType && CommonTools.isEmpty(amountWithoutTax)) {
                errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a0,\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (billItem.getTaxAmount() == null && billItem.getAmountWithTax() != null || billItem.getTaxAmount() != null && billItem.getAmountWithTax() == null) {
                errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a0,\u7a0e\u989d\u4e0e\u542b\u7a0e\u91d1\u989d\uff0c\u8981\u4e48\u90fd\u586b\u5199\uff0c\u8981\u4e48\u90fd\u4e0d\u586b\u5199--");
            }
            if (billItem.getTaxRate() == null && (billItem.getTaxAmount() != null || billItem.getAmountWithTax() != null)) {
                errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a0,\u6ca1\u6709\u586b\u5199\u3010\u7a0e\u7387\u3011\u65f6\uff0c\u7a0e\u989d\u4e0e\u542b\u7a0e\u91d1\u989d\u90fd\u4e0d\u80fd\u586b\u5199--");
            }
            if (!CommonTools.isEmpty(amountWithoutTax) && billItem.getTaxRate() != null && billItem.getTaxAmount() != null) {
                BigDecimal taxAmountTemp = CommonTools.isEmpty(taxDedunction) ? billItem.getTaxRate().multiply(billItem.getAmountWithoutTax()).setScale(2, 4) : billItem.getTaxRate().multiply(billItem.getAmountWithoutTax().subtract(billItem.getDeductions())).setScale(2, 4);
                if (billItem.getTaxAmount().setScale(2, 4).compareTo(taxAmountTemp) != 0) {
                    errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a0,\u3010\u4e0d\u542b\u7a0e\u91d1\u989d*\u7a0e\u7387=\u7a0e\u989d\u3011\u6216\u8005\u3010\uff08\u4e0d\u542b\u7a0e\u91d1\u989d-\u6263\u9664\u989d\uff09*\u7a0e\u7387=\u7a0e\u989d\u3011 \u4e0d\u7b26\u5408--");
                }
            }
        } else {
            if (isImportType && CommonTools.isEmpty(amountWithTax)) {
                errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a1,\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (billItem.getTaxAmount() == null && billItem.getAmountWithoutTax() != null || billItem.getTaxAmount() != null && billItem.getAmountWithoutTax() == null) {
                errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a1,\u7a0e\u989d\u4e0e\u4e0d\u542b\u7a0e\u91d1\u989d\uff0c\u8981\u4e48\u90fd\u586b\u5199\uff0c\u8981\u4e48\u90fd\u4e0d\u586b\u5199--");
            }
            if (billItem.getTaxRate() == null && (billItem.getTaxAmount() != null || billItem.getAmountWithoutTax() != null)) {
                errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a1,\u6ca1\u6709\u586b\u5199\u3010\u7a0e\u7387\u3011\u65f6\uff0c\u7a0e\u989d\u4e0e\u4e0d\u542b\u7a0e\u91d1\u989d\u90fd\u4e0d\u80fd\u586b\u5199--");
            }
            if (!CommonTools.isEmpty(amountWithoutTax) && billItem.getTaxRate() != null && billItem.getTaxAmount() != null) {
                BigDecimal tempRate = BigDecimal.ONE.add(billItem.getTaxRate());
                BigDecimal dif = new BigDecimal("0.01");
                BigDecimal taxAmountTemp = CommonTools.isEmpty(taxDedunction) ? billItem.getAmountWithTax().multiply(billItem.getTaxRate()).divide(tempRate, 6, RoundingMode.HALF_UP) : billItem.getAmountWithTax().subtract(billItem.getDeductions()).multiply(billItem.getTaxRate()).divide(tempRate, 2, RoundingMode.HALF_UP);
                if (billItem.getTaxAmount().subtract(taxAmountTemp).abs().compareTo(dif) > 0) {
                    errorMsg.append("--\u4ef7\u683c\u65b9\u5f0f\u4e3a1,\u3010\u542b\u7a0e\u91d1\u989d*\u7a0e\u7387/(1+\u7a0e\u7387)=\u7a0e\u989d\u3011\u6216\u8005\u3010\uff08\u542b\u7a0e\u91d1\u989d-\u6263\u9664\u989d\uff09*\u7a0e\u7387/(1+\u7a0e\u7387)=\u7a0e\u989d\u3011 \u4e0d\u7b26\u5408--");
                }
            }
        }
        itemCheckAll.append((CharSequence)errorMsg);
        return CommonTools.isEmpty(errorMsg.toString());
    }

    private void checkAccuracy(OrdSalesbillInterfaceItemEntity billItem, StringBuilder itemCheckAll) {
        BigDecimal blueDeviation = new BigDecimal("0.01");
        BigDecimal itemQuantity = billItem.getQuantity();
        BigDecimal itemUnitPrice = billItem.getUnitPrice();
        BigDecimal itemUnitPriceWithTax = billItem.getUnitPriceWithTax();
        BigDecimal amountWithoutTax = billItem.getAmountWithoutTax();
        BigDecimal amountWithTax = billItem.getAmountWithTax();
        if (!CommonTools.isEmpty(String.valueOf(itemQuantity)) && itemQuantity.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal amountWithTaxTmp;
            BigDecimal amountWithoutTaxTmp;
            if (!CommonTools.isEmpty(String.valueOf(itemUnitPrice)) && itemUnitPrice.compareTo(BigDecimal.ZERO) != 0 && amountWithoutTax != null && (amountWithoutTaxTmp = itemQuantity.multiply(itemUnitPrice)).abs().subtract(amountWithoutTax.abs()).abs().compareTo(blueDeviation) == 1) {
                itemCheckAll.append("\u91d1\u989d\u6570\u636e[\u6570\u91cf*\u5355\u4ef7=\u4e0d\u542b\u7a0e\u91d1\u989d]->[").append(itemQuantity).append("*").append(itemUnitPrice).append("=").append(amountWithoutTaxTmp).append("]\uff0c\u5b9e\u9645\u4f20\u5165\u503c\u4e3a[").append(amountWithoutTax).append("]. \u8bef\u5dee\u5927\u4e8e 0.01");
            }
            if (!CommonTools.isEmpty(String.valueOf(itemUnitPriceWithTax)) && itemUnitPriceWithTax.compareTo(BigDecimal.ZERO) != 0 && amountWithTax != null && (amountWithTaxTmp = itemQuantity.multiply(itemUnitPriceWithTax)).abs().subtract(amountWithTax.abs()).abs().compareTo(blueDeviation) == 1) {
                itemCheckAll.append("\u91d1\u989d\u6570\u636e[\u6570\u91cf*\u542b\u7a0e\u5355\u4ef7=\u542b\u7a0e\u91d1\u989d]->[").append(itemQuantity).append("*").append(itemUnitPriceWithTax).append("=").append(amountWithTaxTmp).append("]\uff0c\u5b9e\u9645\u4f20\u5165\u503c\u4e3a[").append(amountWithTax).append("]. \u8bef\u5dee\u5927\u4e8e 0.01");
            }
        }
    }

    public void checkDiscountAmt(OrdSalesbillInterfaceItemEntity billItem, StringBuilder itemCheckAll, String billNo, OrdSalesbillInterfaceEntity billEntity) {
        BigDecimal innerDiscoutTax;
        BigDecimal tempTaxRate;
        BigDecimal innerDiscoutTax2;
        BigDecimal tempTaxRate2;
        BigDecimal zero = BigDecimal.ZERO;
        BigDecimal blueDeviation = new BigDecimal("0.01");
        String taxRate = String.valueOf(billItem.getTaxRate());
        Integer priceMethod = billEntity.getPriceMethod() == null ? 0 : billEntity.getPriceMethod();
        if (billItem.getInnerDiscountTax() != null && billItem.getInnerDiscountWithoutTax() != null && billItem.getInnerDiscountWithTax() != null) {
            BigDecimal innerDiscountWithTax = billItem.getInnerDiscountWithTax();
            BigDecimal innerDiscountWithoutTax = billItem.getInnerDiscountWithoutTax();
            BigDecimal innerDiscountAmount = billItem.getInnerDiscountTax();
            BigDecimal tempInnerDiscountWithTax = innerDiscountAmount.add(innerDiscountWithoutTax);
            if (innerDiscountWithTax.compareTo(tempInnerDiscountWithTax) != 0) {
                itemCheckAll.append("---\u4ef7\u5185\u7a0e\u989d+\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263 \u4e0d\u7b49\u4e8e\u4ef7\u5185\u542b\u7a0e\u6298\u6263---");
            }
            if (!CommonTools.isEmpty(taxRate)) {
                if (priceMethod == 0) {
                    BigDecimal innerDiscoutTax3 = billItem.getInnerDiscountWithoutTax().multiply(billItem.getTaxRate());
                    if (innerDiscountAmount.subtract(innerDiscoutTax3).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a0\uff0c\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263*\u7a0e\u7387 \u4e0d\u7b49\u4e8e \u4ef7\u5185\u6298\u6263\u7a0e\u989d---");
                    }
                } else {
                    tempTaxRate2 = BigDecimal.ONE.add(billItem.getTaxRate());
                    innerDiscoutTax2 = billItem.getInnerDiscountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate2, 6, 4);
                    if (innerDiscountAmount.subtract(innerDiscoutTax2).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a1\uff0c\u4ef7\u5185\u542b\u7a0e\u6298\u6263*\u7a0e\u7387/\uff081+\u7a0e\u7387\uff09 \u4e0d\u7b49\u4e8e \u4ef7\u5185\u6298\u6263\u7a0e\u989d---");
                    }
                }
            }
        } else if (!CommonTools.isEmpty(taxRate)) {
            if (priceMethod == 0 && billItem.getInnerDiscountWithoutTax() != null) {
                BigDecimal innerDiscoutTax4 = billItem.getInnerDiscountWithoutTax().multiply(billItem.getTaxRate());
                BigDecimal innerDiscoutWithTax = billItem.getInnerDiscountWithoutTax().add(innerDiscoutTax4);
                billItem.setInnerDiscountTax(innerDiscoutTax4);
                billItem.setInnerDiscountWithTax(innerDiscoutWithTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f0 ,\u6839\u636e\u4ef7\u4e0d\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u4ef7\u5185\u7a0e\u989d \uff0c\u4ef7\u5185\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            } else if (priceMethod == 1 && billItem.getInnerDiscountWithTax() != null) {
                tempTaxRate = BigDecimal.ONE.add(billItem.getTaxRate());
                innerDiscoutTax = billItem.getInnerDiscountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate, 6, 4);
                BigDecimal innerDiscountWithoutTax = billItem.getInnerDiscountWithTax().subtract(innerDiscoutTax);
                billItem.setInnerDiscountTax(innerDiscoutTax);
                billItem.setInnerDiscountWithoutTax(innerDiscountWithoutTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f1 ,\u6839\u636e\u4ef7\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u4ef7\u5185\u7a0e\u989d \uff0c\u4ef7\u5185\u4e0d\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            }
        }
        if (billItem.getOutterDiscountTax() != null && billItem.getOutterDiscountWithoutTax() != null && billItem.getOutterDiscountWithTax() != null) {
            BigDecimal outterdiscountWithTax = billItem.getOutterDiscountWithTax();
            BigDecimal outterDiscountWithoutTax = billItem.getOutterDiscountWithoutTax();
            BigDecimal outterdiscountAmount = billItem.getOutterDiscountTax();
            BigDecimal tempOutterDiscountWithTax = outterdiscountAmount.add(outterDiscountWithoutTax);
            if (outterdiscountWithTax.compareTo(tempOutterDiscountWithTax) != 0) {
                itemCheckAll.append("---\u4ef7\u5916\u6298\u6263\u7a0e\u989d+\u4ef7\u5916\u4e0d\u542b\u7a0e\u91d1\u989d\u6298\u6263 \u4e0d\u7b49\u4e8e\u4ef7\u5916\u542b\u7a0e\u6298\u6263---");
            }
            if (!CommonTools.isEmpty(taxRate)) {
                if (priceMethod == 0) {
                    BigDecimal outterDiscoutTax = billItem.getOutterDiscountWithoutTax().multiply(billItem.getTaxRate());
                    if (outterdiscountAmount.subtract(outterDiscoutTax).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a0\uff0c\u4ef7\u5916\u4e0d\u542b\u7a0e\u6298\u6263*\u7a0e\u7387 \u4e0d\u7b49\u4e8e \u4ef7\u5916\u6298\u6263\u7a0e\u989d---");
                    }
                } else {
                    tempTaxRate2 = BigDecimal.ONE.add(billItem.getTaxRate());
                    BigDecimal outterDiscoutTax = billItem.getOutterDiscountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate2, 6, 4);
                    if (outterdiscountAmount.subtract(outterDiscoutTax).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a1\uff0c\u4ef7\u5916\u542b\u7a0e\u6298\u6263*\u7a0e\u7387/\uff081+\u7a0e\u7387\uff09 \u4e0d\u7b49\u4e8e \u4ef7\u5916\u6298\u6263\u7a0e\u989d---");
                    }
                }
            }
        } else if (!CommonTools.isEmpty(taxRate)) {
            if (priceMethod == 0 && billItem.getOutterDiscountWithoutTax() != null) {
                BigDecimal outterDiscoutTax = billItem.getOutterDiscountWithoutTax().multiply(billItem.getTaxRate());
                BigDecimal outterDiscoutWithTax = billItem.getOutterDiscountWithoutTax().add(outterDiscoutTax);
                billItem.setOutterDiscountTax(outterDiscoutTax);
                billItem.setOutterDiscountWithTax(outterDiscoutWithTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f0 ,\u6839\u636e\u4ef7\u5916\u4e0d\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u4ef7\u5916\u7a0e\u989d \uff0c\u4ef7\u5916\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            } else if (priceMethod == 1 && billItem.getOutterDiscountWithTax() != null) {
                tempTaxRate = BigDecimal.ONE.add(billItem.getTaxRate());
                BigDecimal outterDiscoutTax = billItem.getOutterDiscountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate, 6, 4);
                BigDecimal outterDiscountWithoutTax = billItem.getOutterDiscountWithTax().subtract(outterDiscoutTax);
                billItem.setOutterDiscountTax(outterDiscoutTax);
                billItem.setOutterDiscountWithoutTax(outterDiscountWithoutTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f1 ,\u6839\u636e\u4ef7\u5916\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u4ef7\u5916\u7a0e\u989d \uff0c\u4ef7\u5916\u4e0d\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            }
        }
        if (billItem.getInnerPrepayAmountTax() != null && billItem.getInnerPrepayAmountWithoutTax() != null && billItem.getInnerPrepayAmountWithTax() != null) {
            BigDecimal innererPrepayAmountWithTax = billItem.getInnerPrepayAmountWithTax();
            BigDecimal innerPrepayAmountWithoutTax = billItem.getInnerPrepayAmountWithoutTax();
            BigDecimal innerPrePayDiscountAmount = billItem.getInnerPrepayAmountTax();
            BigDecimal tempInnerPrepayAmountWithTax = innerPrePayDiscountAmount.add(innerPrepayAmountWithoutTax);
            if (innererPrepayAmountWithTax.compareTo(tempInnerPrepayAmountWithTax) != 0) {
                itemCheckAll.append("---\u4ef7\u5185\u9884\u4ed8\u7a0e\u989d+\u4ef7\u5185\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d \u4e0d\u7b49\u4e8e\u9884\u4ed8\u4ef7\u5185\u542b\u7a0e---");
            }
            if (!CommonTools.isEmpty(taxRate)) {
                if (priceMethod == 0) {
                    BigDecimal innerPrePayTax = billItem.getInnerPrepayAmountWithoutTax().multiply(billItem.getTaxRate());
                    if (innerPrePayDiscountAmount.subtract(innerPrePayTax).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a0\uff0c\u4ef7\u5185\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u91d1\u989d*\u7a0e\u7387 \u4e0d\u7b49\u4e8e \u4ef7\u5185\u9884\u4ed8\u5361\u7a0e\u989d---");
                    }
                } else {
                    tempTaxRate2 = BigDecimal.ONE.add(billItem.getTaxRate());
                    innerDiscoutTax2 = billItem.getInnerPrepayAmountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate2, 6, 4);
                    if (innerPrePayDiscountAmount.subtract(innerDiscoutTax2).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a1\uff0c\u4ef7\u5185\u9884\u4ed8\u5361\u542b\u7a0e\u91d1\u989d*\u7a0e\u7387/\uff081+\u7a0e\u7387\uff09 \u4e0d\u7b49\u4e8e \u4ef7\u5185\u9884\u4ed8\u5361\u7a0e\u989d---");
                    }
                }
            }
        } else if (!CommonTools.isEmpty(taxRate)) {
            if (priceMethod == 0 && billItem.getInnerPrepayAmountWithoutTax() != null) {
                BigDecimal innerPrePayTax = billItem.getInnerPrepayAmountWithoutTax().multiply(billItem.getTaxRate());
                BigDecimal innerPrepayWithTax = billItem.getInnerPrepayAmountWithoutTax().add(innerPrePayTax);
                billItem.setInnerPrepayAmountTax(innerPrePayTax);
                billItem.setInnerPrepayAmountWithTax(innerPrepayWithTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f0 ,\u6839\u636e\u4ef7\u5185\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u4ef7\u5185\u9884\u4ed8\u7a0e\u989d \uff0c\u4ef7\u5185\u9884\u4ed8\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            } else if (priceMethod == 1 && billItem.getInnerPrepayAmountWithTax() != null) {
                tempTaxRate = BigDecimal.ONE.add(billItem.getTaxRate());
                innerDiscoutTax = billItem.getInnerPrepayAmountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate, 6, 4);
                BigDecimal innerPrepayAmountWithoutTax = billItem.getInnerPrepayAmountWithTax().subtract(innerDiscoutTax);
                billItem.setInnerPrepayAmountTax(innerDiscoutTax);
                billItem.setInnerPrepayAmountWithoutTax(innerPrepayAmountWithoutTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f1 ,\u6839\u636e\u4ef7\u5185\u9884\u4ed8\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u4ef7\u5185\u9884\u4ed8\u7a0e\u989d \uff0c\u4ef7\u5185\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            }
        }
        if (billItem.getOutterPrepayAmountTax() != null && billItem.getOutterPrepayAmountWithoutTax() != null && billItem.getOutterPrepayAmountWithTax() != null) {
            BigDecimal outtererPrePayWithTax = billItem.getOutterPrepayAmountWithTax();
            BigDecimal outterPrepayAmountWithoutTax = billItem.getOutterPrepayAmountWithoutTax();
            BigDecimal outtererPrePayAmount = billItem.getOutterPrepayAmountTax();
            BigDecimal tempOutterPrepayAmountWithTax = outtererPrePayAmount.add(outterPrepayAmountWithoutTax);
            if (outtererPrePayWithTax.compareTo(tempOutterPrepayAmountWithTax) != 0) {
                itemCheckAll.append("--\u4ef7\u5916\u9884\u4ed8\u7a0e\u989d+\u4ef7\u5916\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d \u4e0d\u7b49\u4e8e\u9884\u4ed8\u542b\u7a0e\u4ef7\u5916\u91d1\u989d--");
            }
            if (!CommonTools.isEmpty(taxRate)) {
                if (priceMethod == 0) {
                    BigDecimal outtererPrePayTax = billItem.getOutterPrepayAmountWithoutTax().multiply(billItem.getTaxRate());
                    if (outtererPrePayAmount.subtract(outtererPrePayTax).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a0\uff0c\u4ef7\u5916\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u91d1\u989d*\u7a0e\u7387 \u4e0d\u7b49\u4e8e \u4ef7\u5916\u9884\u4ed8\u5361\u7a0e\u989d---");
                    }
                } else {
                    tempTaxRate2 = BigDecimal.ONE.add(billItem.getTaxRate());
                    BigDecimal outtererPrePayTax = billItem.getOutterPrepayAmountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate2, 6, 4);
                    if (outtererPrePayAmount.subtract(outtererPrePayTax).abs().compareTo(this.buleDevetion) > 0) {
                        itemCheckAll.append("---\u4ef7\u683c\u65b9\u5f0f\u4e3a1\uff0c\u4ef7\u5916\u9884\u4ed8\u5361\u542b\u7a0e\u91d1\u989d*\u7a0e\u7387/\uff081+\u7a0e\u7387\uff09 \u4e0d\u7b49\u4e8e \u4ef7\u5916\u9884\u4ed8\u5361\u7a0e\u989d---");
                    }
                }
            }
        } else if (!CommonTools.isEmpty(taxRate)) {
            if (priceMethod == 0 && billItem.getOutterPrepayAmountWithoutTax() != null) {
                BigDecimal outtererPrePayTax = billItem.getOutterPrepayAmountWithoutTax().multiply(billItem.getTaxRate());
                BigDecimal outtererPrePayWithTax = billItem.getOutterPrepayAmountWithoutTax().add(outtererPrePayTax);
                billItem.setOutterPrepayAmountTax(outtererPrePayTax);
                billItem.setOutterPrepayAmountWithTax(outtererPrePayWithTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f0 ,\u6839\u636e\u9884\u4ed8\u4ef7\u5916\u4e0d\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u9884\u4ed8\u4ef7\u5916\u7a0e\u989d \uff0c\u9884\u4ed8\u4ef7\u5916\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            } else if (priceMethod == 1 && billItem.getOutterPrepayAmountWithTax() != null) {
                tempTaxRate = BigDecimal.ONE.add(billItem.getTaxRate());
                BigDecimal outtererPrePayTax = billItem.getOutterPrepayAmountWithTax().multiply(billItem.getTaxRate()).divide(tempTaxRate, 6, 4);
                BigDecimal outterPrepayAmountWithoutTax = billItem.getOutterPrepayAmountWithTax().subtract(outtererPrePayTax);
                billItem.setOutterPrepayAmountTax(outtererPrePayTax);
                billItem.setOutterPrepayAmountWithoutTax(outterPrepayAmountWithoutTax);
                this.logger.info("\u5355\u636e {}\u4ef7\u683c\u65b9\u5f0f1 ,\u6839\u636e\u9884\u4ed8\u4ef7\u5916\u542b\u7a0e\u91d1\u989d \uff0c\u7a0e\u7387\u63a8\u7b97\u9884\u4ed8\u4ef7\u5916\u5916\u7a0e\u989d \uff0c\u9884\u4ed8\u4ef7\u5916\u4e0d\u542b\u7a0e\u91d1\u989d ", (Object)billEntity.getSalesbillNo());
            }
        }
        BigDecimal innerDiscountTaxAmountWithTax = billItem.getInnerDiscountWithTax() != null ? billItem.getInnerDiscountWithTax() : zero;
        BigDecimal innerDiscountTaxAmountWithOutTax = billItem.getInnerDiscountWithoutTax() != null ? billItem.getInnerDiscountWithoutTax() : zero;
        BigDecimal innerDiscountTaxAmount = billItem.getInnerDiscountTax() != null ? billItem.getInnerDiscountTax() : zero;
        BigDecimal outterDiscountTaxAmountWithTax = billItem.getOutterDiscountWithTax() != null ? billItem.getOutterDiscountWithTax() : zero;
        BigDecimal outterDiscountTaxAmountWithOutTax = billItem.getOutterDiscountWithoutTax() != null ? billItem.getOutterDiscountWithoutTax() : zero;
        BigDecimal outterDiscountTaxAmount = billItem.getOutterDiscountTax() != null ? billItem.getOutterDiscountTax() : zero;
        BigDecimal innerPrepayTaxAmountWithTax = billItem.getInnerPrepayAmountWithTax() != null ? billItem.getInnerPrepayAmountWithTax() : zero;
        BigDecimal innerPrepayTaxAmountWithOutTax = billItem.getInnerPrepayAmountWithoutTax() != null ? billItem.getInnerPrepayAmountWithoutTax() : zero;
        BigDecimal innerPrepayTaxAmount = billItem.getInnerPrepayAmountTax() != null ? billItem.getInnerPrepayAmountTax() : zero;
        BigDecimal outterPrepayTaxAmountWithTax = billItem.getOutterPrepayAmountWithTax() != null ? billItem.getOutterPrepayAmountWithTax() : zero;
        BigDecimal outterPrepayTaxAmountWithOutTax = billItem.getOutterPrepayAmountWithoutTax() != null ? billItem.getOutterPrepayAmountWithoutTax() : zero;
        BigDecimal outterPrepayTaxAmount = billItem.getOutterPrepayAmountTax() != null ? billItem.getOutterPrepayAmountTax() : zero;
        BigDecimal totalAmountwithTax = innerDiscountTaxAmountWithTax.add(outterDiscountTaxAmountWithTax).add(innerPrepayTaxAmountWithTax).add(outterPrepayTaxAmountWithTax);
        BigDecimal totalAmountWithoutTax = innerDiscountTaxAmountWithOutTax.add(outterDiscountTaxAmountWithOutTax).add(innerPrepayTaxAmountWithOutTax).add(outterPrepayTaxAmountWithOutTax);
        BigDecimal totalTaxAmount = innerDiscountTaxAmount.add(outterDiscountTaxAmount).add(innerPrepayTaxAmount).add(outterPrepayTaxAmount);
        if (billItem.getTaxAmount() != null && billItem.getTaxAmount().abs().compareTo(totalTaxAmount.abs()) <= 0 && zero.compareTo(billItem.getTaxAmount()) != 0) {
            itemCheckAll.append("--\u4ef7\u5185\u6298\u6263\u7a0e\u989d+\u4ef7\u5916\u6298\u6263\u7a0e\u989d +\u4ef7\u5185\u9884\u4ed8\u7a0e\u989d+\u4ef7\u5916\u9884\u4ed8\u7a0e\u989d \u4e0d\u80fd\u5927\u4e8e\u6216\u7b49\u4e8e\u7a0e\u989d---");
        }
        if (billItem.getAmountWithTax() != null && billItem.getAmountWithTax().abs().compareTo(totalAmountwithTax.abs()) <= 0) {
            itemCheckAll.append("--\u4ef7\u5185\u6298\u6263\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u6298\u6263\u542b\u7a0e\u91d1\u989d +\u4ef7\u5185\u9884\u4ed8\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u9884\u4ed8\u542b\u7a0e\u91d1\u989d \u4e0d\u80fd\u5927\u4e8e\u6216\u7b49\u4e8e\u542b\u7a0e\u91d1\u989d---");
        }
        if (billItem.getAmountWithoutTax() != null && billItem.getAmountWithoutTax().abs().compareTo(totalAmountWithoutTax.abs()) <= 0) {
            itemCheckAll.append("--\u4ef7\u5185\u6298\u6263\u4e0d\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u6298\u6263\u4e0d\u542b\u7a0e\u91d1\u989d +\u4ef7\u5185\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d \u4e0d\u80fd\u5927\u4e8e\u6216\u7b49\u4e8e\u4e0d\u542b\u7a0e\u91d1\u989d---");
        }
    }

    public void checktaxDedunction(OrdSalesbillInterfaceItemEntity billItem, StringBuilder itemCheckAll, String billNo, OrdSalesbillInterfaceEntity billEntity) {
        String taxDedunction = billItem.getDeductions() + "";
        String amountWithoutTax = billItem.getAmountWithoutTax() + "";
        if (!CommonTools.isEmpty(taxDedunction) && BigDecimal.ZERO.compareTo(billItem.getDeductions()) != 0) {
            BigDecimal mainAmount;
            BigDecimal bigDecimal = mainAmount = billEntity.getAmountWithoutTax() != null ? billEntity.getAmountWithoutTax() : billEntity.getAmountWithTax();
            if (mainAmount != null && mainAmount.compareTo(BigDecimal.ZERO) > 0) {
                if (billItem.getDeductions().compareTo(BigDecimal.ZERO) < 0) {
                    itemCheckAll.append("--\u84dd\u5b57\u5355\u636e\u5dee\u989d\u5f81\u7a0e\u6263\u9664\u989d\u5e94\u4e0e\u4e0d\u542b\u7a0e\u989d\u540c\u65f6\u5927\u4e8e\u96f6--");
                }
                if (CommonTools.isNum(amountWithoutTax).booleanValue() && new BigDecimal(taxDedunction).compareTo(new BigDecimal(amountWithoutTax)) >= 0) {
                    itemCheckAll.append("---\u84dd\u5b57\u5355\u636e\u5dee\u989d\u5f81\u7a0e\u6263\u9664\u989d\u5e94\u5c0f\u4e8e\u4e0d\u542b\u7a0e\u91d1\u989d--");
                }
            } else if (mainAmount != null && mainAmount.compareTo(BigDecimal.ZERO) < 0) {
                if (billItem.getDeductions().compareTo(BigDecimal.ZERO) > 0) {
                    itemCheckAll.append("--\u5dee\u989d\u5f81\u7a0e\u7ea2\u5b57\u5355\u636e\u6263\u9664\u989d\u5e94\u4e0e\u4e0d\u542b\u7a0e\u989d\u540c\u65f6\u5c0f\u4e8e\u96f6--");
                }
                if (CommonTools.isNum(amountWithoutTax).booleanValue() && new BigDecimal(taxDedunction).compareTo(new BigDecimal(amountWithoutTax)) <= 0) {
                    itemCheckAll.append("--\u5dee\u989d\u5f81\u7a0e\u7ea2\u5b57\u5355\u636e\u6263\u9664\u989d\u5e94\u5927\u4e8e\u4e0d\u542b\u7a0e\u91d1\u989d--");
                }
            }
        }
    }
}

