/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.detail;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.cache.LocalCacheManager;
import com.xforceplus.phoenix.bill.cache.bssexternal.LocalBssExternalCacheManager;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.cache.invoice.LocalInvoiceCacheManager;
import com.xforceplus.phoenix.bill.constant.enums.BillSystemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.FieldGroupIndex;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceType;
import com.xforceplus.phoenix.bill.constant.enums.ValidateType;
import com.xforceplus.phoenix.bill.core.validator.detail.AmtValidator;
import com.xforceplus.phoenix.bill.core.validator.detail.BillEntityWrapper;
import com.xforceplus.phoenix.bill.core.validator.detail.SupplementDetail;
import com.xforceplus.phoenix.bill.core.validator.detail.TaxCodeValidator;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtBean;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.MetaDataUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import com.xforceplus.seller.invoice.client.model.MsQueryInvoiceResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesBillDetailValidator
extends ValidatorHandler<BillEntityWrapper>
implements Validator<BillEntityWrapper> {
    private Logger logger = LoggerFactory.getLogger(SalesBillDetailValidator.class);
    @Autowired
    SupplementDetail supplementDetail;
    @Autowired
    LocalBssExternalCacheManager localZuesCacheManager;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    TaxCodeValidator taxCodeValidator;
    @Autowired
    AmtValidator amtValidator;
    @Autowired
    LocalConfigMetadataCacheManager localConfigMetadataCacheManager;
    @Autowired
    private LocalCacheManager localCacheManager;
    @Autowired
    LocalInvoiceCacheManager localInvoiceCacheManager;

    public boolean accept(ValidatorContext context, BillEntityWrapper billEntityWrapper) {
        return true;
    }

    public void onException(Exception e, ValidatorContext context, BillEntityWrapper billEntityWrapper) {
        context.addErrorMsg(e.getMessage());
    }

    public boolean validate(ValidatorContext context, BillEntityWrapper billEntityWrapper) {
        this.logger.info("================================SalesBillDetailValidator=========================================");
        OrdSalesbillInterfaceEntity bill = billEntityWrapper.getBill();
        List<OrdSalesbillInterfaceItemEntity> billItemList = billEntityWrapper.getBillItemList();
        if (bill == null || billItemList == null) {
            context.addErrorMsg("\u5355\u636e\u4e3b\u4fe1\u606f,\u660e\u7ec6\u4fe1\u606f\u5747\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        BigDecimal totalTaxAmt = BigDecimal.ZERO;
        BigDecimal totalAmtWithTax = BigDecimal.ZERO;
        BigDecimal totalAmtWithoutTax = BigDecimal.ZERO;
        BigDecimal sumDiscountTaxAmt = BigDecimal.ZERO;
        BigDecimal sumDiscountAmtWithTax = BigDecimal.ZERO;
        BigDecimal sumDiscountAmtWithoutTax = BigDecimal.ZERO;
        if (billItemList.size() > 10000) {
            context.addErrorMsg("\u5355\u636e\u53f7[" + bill.getSalesbillNo() + "]\u660e\u7ec6\u8d85\u8fc710000\u6761");
            return false;
        }
        String validType = (String)context.getAttribute("validType");
        ConfigRequestModel configRequestModel = new ConfigRequestModel();
        BeanUtils.copyProperties((Object)bill, configRequestModel);
        SysConfigExtBean sysConfigExtBean = this.localConfigMetadataCacheManager.querySysInfoConfig(configRequestModel, ConfigTypeEnum.SYS_CONFIG_TYPE);
        context.setAttribute(ConfigTypeEnum.SYS_CONFIG_TYPE.getObjCode(), (Object)sysConfigExtBean);
        boolean autoSplitPreInvoice = false;
        if (sysConfigExtBean != null && sysConfigExtBean.getAutoSplitBillPreInvoice() != null && sysConfigExtBean.getAutoSplitBillPreInvoice().booleanValue()) {
            autoSplitPreInvoice = sysConfigExtBean.getAutoSplitBillPreInvoice();
        }
        Long groupId = (Long)context.getAttribute("groupId");
        String billType = bill.getSalesbillType();
        Map map = Maps.newHashMap();
        map = ValidateType.IMPORT.value().equals(validType) && !autoSplitPreInvoice ? this.localConfigMetadataCacheManager.queryEffctiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), billType) : this.localConfigMetadataCacheManager.queryEffctiveMetaData(groupId, ObjCodeEnum.INVOICINGROLE.getObjCode(), "");
        List<String> fields = this.localCacheManager.getTableFieldNameCache((Object)new OrdSalesbillInterfaceItemEntity());
        boolean flag = true;
        int size = billItemList.size();
        for (int i = 0; i < size; ++i) {
            OrdSalesbillInterfaceItemEntity item = billItemList.get(i);
            if (ValidateType.IMPORT.value().equals(validType)) {
                item.setSellerTenantId(bill.getSellerTenantId());
                item.setPurchaserTenantId(bill.getPurchaserTenantId());
            }
            StringBuilder itemTaxCodeCheckAll = new StringBuilder();
            if (!ValidateType.UPDATE.value().equals(validType)) {
                this.taxCodeValidator.check(context, item, bill, itemTaxCodeCheckAll);
            }
            this.amtValidator.check(context, item, bill, itemTaxCodeCheckAll);
            itemTaxCodeCheckAll.append(MetaDataUtils.checkFieldByMetadata(map, fields, (Object)item, FieldGroupIndex.BILL_ITEM.value()));
            item.setProcessRemark(itemTaxCodeCheckAll.toString());
            if (!CommonTools.isEmpty(itemTaxCodeCheckAll.toString())) {
                flag = false;
            }
            totalTaxAmt = totalTaxAmt.add(item.getTaxAmount() == null ? BigDecimal.ZERO : item.getTaxAmount());
            totalAmtWithoutTax = totalAmtWithoutTax.add(item.getAmountWithoutTax() == null ? BigDecimal.ZERO : item.getAmountWithoutTax());
            totalAmtWithTax = totalAmtWithTax.add(item.getAmountWithTax() == null ? BigDecimal.ZERO : item.getAmountWithTax());
            sumDiscountTaxAmt = sumDiscountTaxAmt.add(item.getInnerDiscountTax() == null ? BigDecimal.ZERO : item.getInnerDiscountTax());
            sumDiscountAmtWithTax = sumDiscountAmtWithTax.add(item.getInnerDiscountWithTax() == null ? BigDecimal.ZERO : item.getInnerDiscountWithTax());
            sumDiscountAmtWithoutTax = sumDiscountAmtWithoutTax.add(item.getInnerDiscountWithoutTax() == null ? BigDecimal.ZERO : item.getInnerDiscountWithoutTax());
        }
        boolean checkSameNagertive = this.checkdiscountAmt(context, bill);
        if (!checkSameNagertive) {
            return false;
        }
        String systemOrig = bill.getSystemOrig();
        if (BillSystemOrigin.IMPORT.value().equals(systemOrig)) {
            bill.setTaxAmount(totalTaxAmt);
            bill.setAmountWithoutTax(totalAmtWithoutTax);
            bill.setAmountWithTax(totalAmtWithTax);
        } else {
            boolean checkTotalAmtResult = this.checkTotalAmt(context, bill, totalTaxAmt, totalAmtWithTax, totalAmtWithoutTax, validType);
            if (!checkTotalAmtResult) {
                return false;
            }
        }
        boolean checkdiscountAmtResult = this.checkdiscountAmt(context, bill, sumDiscountTaxAmt, sumDiscountAmtWithTax, sumDiscountAmtWithoutTax);
        if (!checkdiscountAmtResult) {
            return false;
        }
        boolean checkRedBillResult = this.checkMainRedBill(context, totalAmtWithTax, bill);
        if (!checkRedBillResult) {
            return false;
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkMainRedBill(ValidatorContext context, BigDecimal totalAmtWithTax, OrdSalesbillInterfaceEntity billEntity) {
        if (billEntity.getAmountWithTax() != null && billEntity.getAmountWithTax().compareTo(BigDecimal.ZERO) < 0) {
            Object sysConfig = context.getAttribute(ConfigTypeEnum.SYS_CONFIG_TYPE.getObjCode());
            if (sysConfig != null) {
                SysInfoRuleDTO sysInfoRuleDTO = (SysInfoRuleDTO)sysConfig;
                if (sysInfoRuleDTO.getCheckRedBillFalg() == null || !sysInfoRuleDTO.getCheckRedBillFalg().booleanValue()) return true;
                if (!this.checkRedSalesBill(context, totalAmtWithTax, billEntity)) return false;
                if (sysInfoRuleDTO.getCheckRedBillOriginInvoiceFalg() == null || !sysInfoRuleDTO.getCheckRedBillOriginInvoiceFalg().booleanValue()) return true;
                return this.checkOriginBlueBill(context, totalAmtWithTax, billEntity);
            }
            if (!this.checkRedSalesBill(context, totalAmtWithTax, billEntity)) return false;
            return this.checkOriginBlueBill(context, totalAmtWithTax, billEntity);
        }
        String redNotificationNo = billEntity.getRedNotification();
        String originInvoiceNo = billEntity.getOriginInvoiceNo();
        String originInvoiceCode = billEntity.getOriginInvoiceCode();
        if (CommonTools.isEmpty(redNotificationNo) && CommonTools.isEmpty(originInvoiceNo) && CommonTools.isEmpty(originInvoiceCode)) return true;
        context.addErrorMsg("---\u84dd\u5b57\u5355\u636e.\u539f\u53d1\u7968\u53f7\u7801\u3001\u539f\u53d1\u7968\u4ee3\u7801\u3001\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7.\u5747\u4e0d\u80fd\u586b\u5199---");
        return false;
    }

    private boolean checkRedSalesBill(ValidatorContext context, BigDecimal totalAmtWithTax, OrdSalesbillInterfaceEntity billEntity) {
        String businessBillType = billEntity.getBusinessBillType();
        String invoiceType = billEntity.getInvoiceType();
        String redNotificationNo = billEntity.getRedNotification();
        String originInvoiceNo = billEntity.getOriginInvoiceNo();
        String originInvoiceCode = billEntity.getOriginInvoiceCode();
        if (totalAmtWithTax.compareTo(BigDecimal.ZERO) == 1) {
            if (!(CommonTools.isEmpty(billEntity.getOriginInvoiceNo()) && CommonTools.isEmpty(billEntity.getOriginInvoiceCode()) && CommonTools.isEmpty(billEntity.getRedNotification()))) {
                context.addErrorMsg("\u7ea2\u5b57\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\u3002\u5f53\u91d1\u989d\u5927\u4e8e0\u65f6\uff0c\u7ea2\u5b57\u4fe1\u606f\u4e0d\u5e94\u586b\u5199.");
                return false;
            }
        } else if (InvoiceType.SPECIAL.value().equals(invoiceType) || InvoiceType.TRANSPORTATION.value().equals(invoiceType)) {
            if (CommonTools.isEmpty(redNotificationNo) || CommonTools.isEmpty(originInvoiceNo) || CommonTools.isEmpty(originInvoiceCode)) {
                context.addErrorMsg("\u7ea2\u5b57\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\u3002\u7ea2\u5b57\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4e2d\uff0c\u539f\u53d1\u7968\u53f7\u7801\u3001\u539f\u53d1\u7968\u4ee3\u7801\u3001\u7ea2\u5b57\u4fe1\u606f\u8868\u7f16\u53f7\u9700\u586b\u5199\u5b8c\u6574.");
                return false;
            }
        } else if (InvoiceType.NORMAL.value().equals(invoiceType) && (CommonTools.isEmpty(originInvoiceNo) || CommonTools.isEmpty(originInvoiceCode))) {
            context.addErrorMsg("\u7ea2\u5b57\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\u3002\u7ea2\u5b57\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u4e2d\uff0c\u539f\u53d1\u7968\u53f7\u7801\u3001\u4ee3\u7801\u82e5\u586b\u5199\uff0c\u9700\u586b\u5199\u5b8c\u6574.");
            return false;
        }
        return true;
    }

    private boolean checkOriginBlueBill(ValidatorContext context, BigDecimal totalAmtWithTax, OrdSalesbillInterfaceEntity billEntity) {
        MsQueryInvoiceResponse invoice = this.localInvoiceCacheManager.getInvoice(billEntity.getOriginInvoiceNo(), billEntity.getOriginInvoiceCode());
        if (invoice != null) {
            BigDecimal originAmtWithTax = invoice.getAmountWithTax();
            if (originAmtWithTax.compareTo(BigDecimal.ZERO) == -1) {
                context.addErrorMsg("--\u7ea2\u5b57\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\u3002\u7531\u539f\u53d1\u7968\u53f7\u7801\u548c\u4ee3\u7801\u67e5\u8be2\u6240\u5f97\u84dd\u5b57\u53d1\u7968\u91d1\u989d\u5c0f\u4e8e0.[" + originAmtWithTax.setScale(2, 4) + "]--");
                return false;
            }
            if (totalAmtWithTax.abs().compareTo(originAmtWithTax.abs()) == 1) {
                context.addErrorMsg("[06001]:\u7ea2\u5b57\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\u3002\u6b64\u5355\u636e\u7ea2\u51b2\u7684\u6b63\u6570\u542b\u7a0e\u91d1\u989d\u5927\u4e8e\u7531\u539f\u53d1\u7968\u53f7\u7801\u548c\u4ee3\u7801\u67e5\u8be2\u6240\u5f97\u84dd\u5b57\u53d1\u7968\u91d1\u989d.[\u6b64\u5355\u636e\u6b63\u6570\u542b\u7a0e\u91d1\u989d:" + totalAmtWithTax.setScale(2, 4).abs() + "]-[\u539f\u84dd\u5b57\u53d1\u7968\u542b\u7a0e\u91d1\u989d:" + originAmtWithTax.setScale(2, 4) + "]");
                return false;
            }
        } else {
            context.addErrorMsg("--\u7ea2\u5b57\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\u3002\u6b64\u5355\u636e\u4e3a\u8d1f\u91d1\u989d\u5355\u636e\uff0c\u6839\u636e\u539f\u53d1\u7968\u53f7\u7801\u3001\u4ee3\u7801\u3001\u8d2d\u9500\u65b9\u516c\u53f8\u4ee3\u7801\u672a\u67e5\u5230\u539f\u84dd\u5b57\u53d1\u7968.--");
            return false;
        }
        return true;
    }

    private Boolean checkTotalAmt(ValidatorContext context, OrdSalesbillInterfaceEntity billEntity, BigDecimal totalTaxAmt, BigDecimal totalAmtWithTax, BigDecimal totalAmtWithoutTax, String validType) {
        String msg;
        BigDecimal blueDeviation = new BigDecimal("0.01");
        boolean isImport = ValidateType.IMPORT.value().equals(validType);
        String billNO = billEntity.getSalesbillNo();
        BigDecimal amountWithoutTax = billEntity.getAmountWithoutTax();
        BigDecimal taxAmount = billEntity.getTaxAmount();
        BigDecimal amountWithTax = billEntity.getAmountWithTax();
        Boolean checkResult = true;
        if (amountWithTax != null && amountWithTax.compareTo(BigDecimal.ZERO) == 0) {
            msg = CommonTools.format("--\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u542b\u7a0e\u91d1\u989d[{}]\u4e0d\u80fd\u7b49\u4e8e0---", billNO, amountWithTax);
            this.logger.info(msg);
            context.addErrorMsg(msg);
            checkResult = false;
        }
        if (amountWithoutTax != null && amountWithoutTax.compareTo(BigDecimal.ZERO) == 0) {
            msg = CommonTools.format("--\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u4e0d\u542b\u7a0e\u91d1\u989d[{}]\u4e0d\u80fd\u7b49\u4e8e0---", billNO, amountWithoutTax);
            this.logger.info(msg);
            context.addErrorMsg(msg);
            checkResult = false;
        }
        if (ValidateType.IMPORT.value().equals(validType)) {
            if (amountWithoutTax != null && amountWithoutTax.compareTo(totalAmtWithoutTax) != 0) {
                msg = CommonTools.format("--\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u4e0d\u542b\u7a0e\u91d1\u989d[{}]\u4e0e\u660e\u7ec6\u5408\u8ba1\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c[{}]\u4e0d\u76f8\u7b49--", billNO, amountWithoutTax, totalAmtWithoutTax);
                this.logger.info(msg);
                context.addErrorMsg(msg);
                checkResult = false;
            }
            if (taxAmount != null && taxAmount.compareTo(totalTaxAmt) != 0) {
                msg = CommonTools.format("--\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u7a0e\u989d[{}]\u4e0e\u660e\u7ec6\u5408\u8ba1\u7684\u7a0e\u989d\u603b\u548c[{}]\u4e0d\u76f8\u7b49--", billNO, taxAmount, totalTaxAmt);
                this.logger.info(msg);
                context.addErrorMsg(msg);
                checkResult = false;
            }
            if (amountWithTax != null && amountWithTax.compareTo(totalAmtWithTax) != 0) {
                msg = CommonTools.format("--\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u542b\u7a0e\u91d1\u989d[{}]\u4e0e\u660e\u7ec6\u5408\u8ba1\u7684\u542b\u7a0e\u91d1\u989d[\u603b\u548c[{}]\u4e0d\u76f8\u7b49.--", billNO, amountWithTax, totalAmtWithTax);
                this.logger.info(msg);
                context.addErrorMsg(msg);
                checkResult = false;
            }
        } else {
            if (amountWithoutTax != null && amountWithoutTax.abs().add(blueDeviation).compareTo(totalAmtWithoutTax.abs()) < 0) {
                msg = CommonTools.format("--\u5f00\u7968\u65f6,\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u4e0d\u542b\u7a0e\u91d1\u989d[{}]\u4e0d\u80fd\u5c0f\u4e8e\u660e\u7ec6\u5408\u8ba1\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c[{}]", billNO, amountWithoutTax, totalAmtWithoutTax);
                this.logger.info(msg);
                context.addErrorMsg(msg);
                checkResult = false;
            }
            if (taxAmount != null && taxAmount.abs().add(blueDeviation).compareTo(totalTaxAmt.abs()) < 0) {
                msg = CommonTools.format("--\u5f00\u7968\u65f6,\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u7a0e\u989d[{}]\u4e0d\u80fd\u5c0f\u4e8e\u660e\u7ec6\u5408\u8ba1\u7684\u7a0e\u989d\u603b\u548c[{}]", billNO, taxAmount, totalTaxAmt);
                this.logger.info(msg);
                context.addErrorMsg(msg);
                checkResult = false;
            }
            if (amountWithTax != null && amountWithTax.abs().add(blueDeviation).compareTo(totalAmtWithTax.abs()) < 0) {
                msg = CommonTools.format("--\u5f00\u7968\u65f6,\u5355\u636e{}\u4e3b\u4fe1\u606f\u4e2d\u7684\u542b\u7a0e\u91d1\u989d[{}]\u4e0d\u80fd\u5c0f\u4e8e \u660e\u7ec6\u5408\u8ba1\u7684\u542b\u7a0e\u91d1\u989d[\u603b\u548c[{}].--", billNO, amountWithTax, totalAmtWithTax);
                this.logger.info(msg);
                context.addErrorMsg(msg);
                checkResult = false;
            }
        }
        return checkResult;
    }

    private boolean checkdiscountAmt(ValidatorContext context, OrdSalesbillInterfaceEntity billEntity, BigDecimal sumDiscountTaxAmt, BigDecimal sumDiscountAmtWithTax, BigDecimal sumDiscountAmtWithoutTax) {
        BigDecimal zero = BigDecimal.ZERO;
        BigDecimal innerDiscountTaxAmountWithTax = billEntity.getInnerDiscountWithTax() != null ? billEntity.getInnerDiscountWithTax() : zero;
        BigDecimal innerDiscountTaxAmountWithOutTax = billEntity.getInnerDiscountWithoutTax() != null ? billEntity.getInnerDiscountWithoutTax() : zero;
        BigDecimal outterDiscountTaxAmountWithTax = billEntity.getOutterDiscountWithTax() != null ? billEntity.getOutterDiscountWithTax() : zero;
        BigDecimal outterDiscountTaxAmountWithOutTax = billEntity.getOutterDiscountWithoutTax() != null ? billEntity.getOutterDiscountWithoutTax() : zero;
        BigDecimal innerPrepayTaxAmountWithTax = billEntity.getInnerPrepayAmountWithTax() != null ? billEntity.getInnerPrepayAmountWithTax() : zero;
        BigDecimal innerPrepayTaxAmountWithOutTax = billEntity.getInnerPrepayAmountWithoutTax() != null ? billEntity.getInnerPrepayAmountWithoutTax() : zero;
        BigDecimal outterPrepayTaxAmountWithTax = billEntity.getOutterPrepayAmountWithTax() != null ? billEntity.getOutterPrepayAmountWithTax() : zero;
        BigDecimal outterPrepayTaxAmountWithOutTax = billEntity.getOutterPrepayAmountWithoutTax() != null ? billEntity.getOutterPrepayAmountWithoutTax() : zero;
        BigDecimal totalAmountwithTax = innerDiscountTaxAmountWithTax.add(outterDiscountTaxAmountWithTax).add(innerPrepayTaxAmountWithTax).add(outterPrepayTaxAmountWithTax);
        BigDecimal totalAmountWithoutTax = innerDiscountTaxAmountWithOutTax.add(outterDiscountTaxAmountWithOutTax).add(innerPrepayTaxAmountWithOutTax).add(outterPrepayTaxAmountWithOutTax);
        if (billEntity.getAmountWithTax() != null && billEntity.getAmountWithTax().abs().compareTo(totalAmountwithTax.abs()) <= 0) {
            context.addErrorMsg("--\u4ef7\u5185\u6298\u6263\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u6298\u6263\u542b\u7a0e\u91d1\u989d +\u4ef7\u5185\u9884\u4ed8\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u9884\u4ed8\u542b\u7a0e\u91d1\u989d \u4e0d\u80fd\u5927\u4e8e\u6216\u7b49\u4e8e\u542b\u7a0e\u91d1\u989d---");
            return false;
        }
        if (billEntity.getAmountWithoutTax() != null && billEntity.getAmountWithoutTax().abs().compareTo(totalAmountWithoutTax.abs()) <= 0) {
            context.addErrorMsg("--\u4ef7\u5185\u6298\u6263\u4e0d\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u6298\u6263\u4e0d\u542b\u7a0e\u91d1\u989d +\u4ef7\u5185\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d+\u4ef7\u5916\u9884\u4ed8\u4e0d\u542b\u7a0e\u91d1\u989d \u4e0d\u80fd\u5927\u4e8e\u6216\u7b49\u4e8e\u4e0d\u542b\u7a0e\u91d1\u989d---");
            return false;
        }
        return true;
    }

    private boolean checkdiscountAmt(ValidatorContext context, OrdSalesbillInterfaceEntity billEntity) {
        boolean withTaxFlag;
        boolean withoutTaxeFalg;
        boolean amountWithTaxFlag;
        BigDecimal mainAmt;
        BigDecimal zero = BigDecimal.ZERO;
        StringBuilder msg = new StringBuilder();
        if (billEntity.getTaxAmount() != null && billEntity.getAmountWithoutTax() != null && billEntity.getAmountWithTax() != null) {
            boolean amountWithoutTaxFlag;
            boolean amountWithTaxFlag2 = billEntity.getAmountWithTax().compareTo(zero) > 0;
            boolean bl = amountWithoutTaxFlag = billEntity.getAmountWithoutTax().compareTo(zero) > 0;
            if (amountWithoutTaxFlag != amountWithTaxFlag2) {
                msg.append("\u7a0e\u989d\u3001\u4e0d\u542b\u7a0e\u91d1\u989d\u3001\u542b\u7a0e\u91d1\u989d\u3002\u5e94\u540c\u4e3a\u6b63\u6216\u540c\u4e3a\u8d1f\uff1b\u5b9e\u9645\u4f20\u5165\u6570\u636e\uff1a\u4e0d\u542b\u7a0e\u91d1\u989d[").append(billEntity.getAmountWithoutTax()).append("]\u3001\u542b\u7a0e\u91d1\u989d[").append(billEntity.getAmountWithTax()).append("]");
                context.addErrorMsg(msg.toString());
                return false;
            }
        }
        BigDecimal bigDecimal = mainAmt = billEntity.getAmountWithTax() != null ? billEntity.getAmountWithTax() : billEntity.getAmountWithoutTax();
        if (mainAmt == null) {
            return true;
        }
        boolean bl = amountWithTaxFlag = mainAmt.compareTo(zero) >= 0;
        if (billEntity.getInnerDiscountWithoutTax() != null && billEntity.getInnerDiscountWithTax() != null && billEntity.getAmountWithTax() != null && zero.compareTo(billEntity.getInnerDiscountWithoutTax()) != 0 && zero.compareTo(billEntity.getInnerDiscountWithTax()) != 0) {
            withoutTaxeFalg = billEntity.getInnerDiscountWithoutTax().compareTo(zero) > 0;
            boolean bl2 = withTaxFlag = billEntity.getInnerDiscountWithTax().compareTo(zero) > 0;
            if (withoutTaxeFalg != withTaxFlag || withTaxFlag != amountWithTaxFlag) {
                msg.append("\u4ef7\u5185\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d, \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f");
                context.addErrorMsg(msg.toString());
                return false;
            }
        }
        if (billEntity.getOutterDiscountWithoutTax() != null && billEntity.getOutterDiscountWithTax() != null && zero.compareTo(billEntity.getOutterDiscountWithoutTax()) != 0 && zero.compareTo(billEntity.getOutterDiscountWithTax()) != 0) {
            boolean withoutTaxFalg = billEntity.getOutterDiscountWithoutTax().compareTo(zero) > 0;
            boolean bl3 = withTaxFlag = billEntity.getOutterDiscountWithTax().compareTo(zero) > 0;
            if (withoutTaxFalg != withTaxFlag || withTaxFlag != amountWithTaxFlag) {
                msg.append("\u4ef7\u5916\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u4ef7\u5916\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u4ef7\u5916\u6298\u6263\u7a0e\u989d \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f").append(billEntity.getAmountWithTax()).append("]");
                context.addErrorMsg(msg.toString());
                return false;
            }
        }
        if (billEntity.getInnerPrepayAmountWithoutTax() != null && billEntity.getInnerPrepayAmountWithTax() != null && zero.compareTo(billEntity.getInnerPrepayAmountWithoutTax()) != 0 && zero.compareTo(billEntity.getInnerPrepayAmountWithTax()) != 0) {
            withoutTaxeFalg = billEntity.getInnerPrepayAmountWithoutTax().compareTo(zero) > 0;
            boolean bl4 = withTaxFlag = billEntity.getInnerPrepayAmountWithoutTax().compareTo(zero) > 0;
            if (withoutTaxeFalg != withTaxFlag || withTaxFlag != amountWithTaxFlag) {
                msg.append("\u9884\u4ed8\u4ef7\u5185\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5185\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5185\u6298\u6263\u7a0e\u989d \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f").append(billEntity.getAmountWithTax()).append("]");
                context.addErrorMsg(msg.toString());
                return false;
            }
        }
        if (billEntity.getOutterPrepayAmountWithoutTax() != null && billEntity.getOutterPrepayAmountWithTax() != null && zero.compareTo(billEntity.getOutterPrepayAmountWithoutTax()) != 0 && zero.compareTo(billEntity.getOutterPrepayAmountWithTax()) != 0) {
            withoutTaxeFalg = billEntity.getOutterPrepayAmountWithoutTax().compareTo(zero) > 0;
            boolean bl5 = withTaxFlag = billEntity.getOutterPrepayAmountWithoutTax().compareTo(zero) > 0;
            if (withoutTaxeFalg != withTaxFlag || withTaxFlag != amountWithTaxFlag) {
                msg.append("\u9884\u4ed8\u4ef7\u5916\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5916\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d,\u9884\u4ed8\u4ef7\u5916\u6298\u6263\u7a0e\u989d \u542b\u7a0e\u91d1\u989d \u5fc5\u987b\u662f\u540c\u6b63\u540c\u8d1f").append(billEntity.getAmountWithTax()).append("]");
                context.addErrorMsg(msg.toString());
                return false;
            }
        }
        return true;
    }
}

