/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.detail;

import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupplementDetail {
    private Logger logger = LoggerFactory.getLogger(SupplementDetail.class);
    @Autowired
    private LocalConfigMetadataCacheManager metadataCacheManager;

    OrdSalesbillInterfaceItemEntity supplementQuantityorPrice(OrdSalesbillInterfaceItemEntity item, OrdSalesbillInterfaceEntity billEntity) throws Exception {
        BigDecimal quantity = item.getQuantity();
        BigDecimal unitPrice = item.getUnitPrice();
        BigDecimal unitPriceWithTax = item.getUnitPriceWithTax();
        BigDecimal amountWithoutTax = item.getAmountWithoutTax();
        BigDecimal amountWithTax = item.getAmountWithTax();
        Integer priceMethod = billEntity.getPriceMethod();
        if (quantity == null) {
            this.logger.info("\u5f53\u524d\u6570\u91cf[{}]\u4e3a\u7a7a\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a[{}]\uff0c\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e3a[{}],\u542b\u7a0e\u5355\u4ef7[{}]", new Object[]{quantity, amountWithoutTax, unitPrice, unitPriceWithTax});
            if (unitPrice != null && BigDecimal.ZERO.compareTo(unitPrice) != 0) {
                try {
                    BigDecimal tempUnitPrice;
                    BigDecimal unitPriceForItem = unitPrice.setScale(15, 4);
                    BigDecimal quantityForItem = amountWithoutTax.divide(unitPriceForItem, 6, 4);
                    if (unitPriceWithTax == null && amountWithTax != null) {
                        unitPriceWithTax = amountWithTax.divide(quantityForItem, 15, 4);
                        item.setUnitPriceWithTax(unitPriceWithTax);
                    } else if (amountWithTax != null && unitPriceWithTax.compareTo(tempUnitPrice = amountWithTax.divide(quantityForItem, 15, 4)) != 0) {
                        throw new RuntimeException("\u63a8\u7b97\u7684\u542b\u7a0e\u5355\u4ef7 \u548c\u586b\u5199\u7684\u542b\u7a0e\u5355\u4ef7\u4e0d\u4e00\u81f4");
                    }
                    item.setQuantity(quantityForItem);
                    item = this.checkNumForShort(item, "quantity", priceMethod);
                }
                catch (Exception e) {
                    String msg = "\u5355\u636e \u6839\u636e\u4ef7\u683c\u63a8\u6f14\u6570\u636e\u91cf\u5931\u8d25\uff0c\u542b\u7a0e\u91d1\u989d[" + amountWithTax + "]\u4e0d\u542b\u7a0e\u91d1\u989d[" + amountWithoutTax + "]\u548c\u5355\u4ef7[" + unitPrice + "]";
                    if (!CommonTools.isEmpty(e.getMessage())) {
                        msg = e.getMessage();
                    }
                    this.logger.error(msg);
                    throw new RuntimeException(msg);
                }
            } else if (unitPriceWithTax != null && BigDecimal.ZERO.compareTo(unitPriceWithTax) != 0) {
                try {
                    BigDecimal tempUnitPrice;
                    BigDecimal unitPriceForItem = unitPriceWithTax.setScale(15, 4);
                    BigDecimal quantityForItem = BigDecimal.ZERO;
                    quantityForItem = amountWithTax.divide(unitPriceForItem, 6, 4);
                    if (unitPrice == null && amountWithoutTax != null) {
                        unitPrice = amountWithoutTax.divide(quantityForItem, 15, 4);
                        item.setUnitPrice(unitPrice);
                    } else if (amountWithoutTax != null && unitPrice.compareTo(tempUnitPrice = amountWithoutTax.divide(quantityForItem, 15, 4)) != 0) {
                        throw new RuntimeException("\u63a8\u7b97\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7 \u548c \u586b\u5199\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u4e00\u81f4");
                    }
                    item.setQuantity(quantityForItem);
                    item = this.checkNumForShort(item, "quantity", priceMethod);
                }
                catch (Exception e) {
                    String msg = "\u5355\u636e \u6839\u636e\u4ef7\u683c\u63a8\u6f14\u6570\u636e\u91cf\u5931\u8d25\uff0c\u542b\u7a0e\u91d1\u989d[" + amountWithTax + "]\u4e0d\u542b\u7a0e\u91d1\u989d[" + amountWithoutTax + "]\u548c\u5355\u4ef7[" + unitPrice + "]";
                    if (!CommonTools.isEmpty(e.getMessage())) {
                        msg = e.getMessage();
                    }
                    this.logger.error(msg);
                    throw new RuntimeException(msg);
                }
            }
        } else if (unitPrice == null || unitPriceWithTax == null) {
            this.logger.info("\u5f53\u524d\u5355\u4ef7[{}]\u4e3a\u7a7a\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a[{}]\uff0c\u6570\u91cf\u4e3a[{}]", new Object[]{unitPrice, amountWithoutTax, quantity});
            if (quantity != null && BigDecimal.ZERO.compareTo(quantity) != 0) {
                try {
                    BigDecimal quantityForItem = quantity.setScale(6, 4);
                    if (amountWithoutTax != null) {
                        BigDecimal unitPriceForItem = amountWithoutTax.divide(quantityForItem, 15, 4);
                        if (unitPrice != null) {
                            if (unitPrice.compareTo(unitPriceForItem) != 0) {
                                throw new RuntimeException("\u63a8\u7b97\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7 \u548c\u586b\u5199\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u4e00\u81f4");
                            }
                        } else {
                            item.setUnitPrice(unitPriceForItem);
                        }
                    }
                    if (amountWithTax != null) {
                        BigDecimal unitPriceWithTaxForItem = amountWithTax.divide(quantityForItem, 15, 4);
                        if (unitPriceWithTax != null) {
                            if (unitPriceWithTaxForItem.compareTo(unitPriceWithTax) != 0) {
                                throw new RuntimeException("\u63a8\u7b97\u7684\u542b\u7a0e\u5355\u4ef7 \u548c\u586b\u5199\u7684\u542b\u7a0e\u5355\u4ef7\u4e0d\u4e00\u81f4");
                            }
                        } else {
                            item.setUnitPriceWithTax(unitPriceWithTaxForItem);
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "\u5355\u636e\u660e\u7ec6\u4e2d\u63a8\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u4e0d\u542b\u7a0e\u5355\u4ef7\u51fa\u73b0\u5f02\u5e38";
                    if (!CommonTools.isEmpty(e.getMessage())) {
                        msg = e.getMessage();
                    }
                    this.logger.error(msg);
                    throw new RuntimeException(msg);
                }
            }
        }
        return item;
    }

    void supplementTaxAmount(OrdSalesbillInterfaceItemEntity item, OrdSalesbillInterfaceEntity billEntity) {
        if (billEntity.getPriceMethod() == null || item.getTaxRate() == null || item.getTaxAmount() != null) {
            return;
        }
        if (billEntity.getPriceMethod() == 0 && item.getAmountWithoutTax() != null) {
            if (item.getDeductions() != null) {
                BigDecimal taxAmount = item.getTaxRate().multiply(item.getAmountWithoutTax().subtract(item.getDeductions()));
                item.setTaxAmount(taxAmount);
                item.setAmountWithTax(taxAmount.add(item.getAmountWithoutTax()));
            } else {
                BigDecimal taxAmount = item.getTaxRate().multiply(item.getAmountWithoutTax());
                item.setTaxAmount(taxAmount);
                item.setAmountWithTax(taxAmount.add(item.getAmountWithoutTax()));
            }
        } else if (billEntity.getPriceMethod() == 1 && item.getAmountWithTax() != null) {
            BigDecimal tempTaxRate = BigDecimal.ONE.add(item.getTaxRate());
            if (item.getDeductions() != null) {
                BigDecimal taxAmount = item.getAmountWithTax().subtract(item.getDeductions()).multiply(item.getTaxRate()).divide(tempTaxRate, 2, 4);
                item.setAmountWithoutTax(item.getAmountWithTax().subtract(taxAmount));
            } else {
                BigDecimal taxAmount = item.getAmountWithTax().multiply(item.getTaxRate()).divide(tempTaxRate, 2, 4);
                item.setAmountWithoutTax(item.getAmountWithTax().subtract(taxAmount));
            }
        }
    }

    private OrdSalesbillInterfaceItemEntity checkNumForShort(OrdSalesbillInterfaceItemEntity item, String type, int priceMethod) {
        block7: {
            BigDecimal quantity;
            BigDecimal unitPriceWithTax;
            BigDecimal unitPrice;
            BigDecimal amountWithTax;
            BigDecimal amountWithoutTax;
            block8: {
                amountWithoutTax = item.getAmountWithoutTax();
                amountWithTax = item.getAmountWithTax();
                unitPrice = item.getUnitPrice();
                unitPriceWithTax = item.getUnitPrice();
                quantity = item.getQuantity();
                if (!"unitPrice".equals(type)) break block8;
                if (priceMethod == 0) {
                    String unitPriceStr = unitPrice + "";
                    int count = unitPriceStr.length() - (unitPriceStr.indexOf(".") + 1);
                    for (int i = 1; i < count; ++i) {
                        String checkUnitPrice = unitPriceStr.substring(0, unitPriceStr.length() - i);
                        BigDecimal newUnitPrice = new BigDecimal(checkUnitPrice);
                        BigDecimal newAmount = quantity.multiply(newUnitPrice).setScale(2, 4);
                        if (amountWithoutTax.compareTo(newAmount) != 0) continue;
                        item.setUnitPrice(newUnitPrice);
                        break block7;
                    }
                } else {
                    String unitPriceWithStr = unitPriceWithTax + "";
                    int count = unitPriceWithStr.length() - (unitPriceWithStr.indexOf(".") + 1);
                    for (int i = 1; i < count; ++i) {
                        String checkUnitPrice = unitPriceWithStr.substring(0, unitPriceWithStr.length() - i);
                        BigDecimal newUnitPrice = new BigDecimal(checkUnitPrice);
                        BigDecimal newAmount = quantity.multiply(newUnitPrice).setScale(2, 4);
                        if (amountWithTax.compareTo(newAmount) != 0) continue;
                        item.setUnitPriceWithTax(newUnitPrice);
                    }
                }
                break block7;
            }
            if (!"quantity".equals(type)) break block7;
            String quantityStr = quantity + "";
            int count = quantityStr.length() - (quantityStr.indexOf(".") + 1);
            for (int i = 1; i < count; ++i) {
                BigDecimal newAmountWithoutTax;
                String checkQuantityPrice = quantityStr.substring(0, quantityStr.length() - i);
                BigDecimal newQuantity = new BigDecimal(checkQuantityPrice);
                if (priceMethod == 0 && unitPrice != null && amountWithoutTax.compareTo(newAmountWithoutTax = unitPrice.multiply(newQuantity).setScale(2, 4)) == 0) {
                    item.setQuantity(newQuantity);
                } else {
                    BigDecimal newAmountWithTax;
                    if (priceMethod != 1 || unitPriceWithTax == null || amountWithTax.compareTo(newAmountWithTax = unitPriceWithTax.multiply(newQuantity).setScale(2, 4)) != 0) continue;
                    item.setQuantity(newQuantity);
                }
                break;
            }
        }
        return item;
    }
}

