/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.detail;

import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.xforceplus.phoenix.bill.cache.taxcode.LocalTaxCodeCacheManager;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.core.tools.TaxCodeTools;
import com.xforceplus.phoenix.bill.core.validator.detail.BaseValidator;
import com.xforceplus.phoenix.bill.core.validator.detail.SupplementDetail;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceItemEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.taxcode.client.model.TaxConvertCodeModel;
import com.xforceplus.phoenix.taxcode.client.model.TaxNationalCode;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaxCodeValidator
extends BaseValidator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    LocalTaxCodeCacheManager localTaxCodeCacheManager;
    @Autowired
    TaxCodeTools taxCodeTools;
    @Autowired
    SupplementDetail supplementDetail;

    @Override
    public boolean check(ValidatorContext context, OrdSalesbillInterfaceItemEntity billItem, OrdSalesbillInterfaceEntity billEntity, StringBuilder itemTaxCodeCheckAll) {
        String salesbillNo = billEntity.getSalesbillNo();
        if (!CommonTools.isEmpty(billItem.getGoodsTaxNo())) {
            this.checkByGoodsTaxNo(context, billEntity, billItem, itemTaxCodeCheckAll);
        } else if (!CommonTools.isEmpty(billItem.getTaxConvertCode())) {
            this.checkTaxConvertCode(context, billEntity, billItem, itemTaxCodeCheckAll);
            if (!CommonTools.isEmpty(billItem.getGoodsTaxNo())) {
                this.checkByGoodsTaxNo(context, billEntity, billItem, itemTaxCodeCheckAll);
            }
        }
        itemTaxCodeCheckAll.append((CharSequence)this.taxCodeTools.checkTaxPreAndConAndZero(billItem));
        return CommonTools.isEmpty(itemTaxCodeCheckAll.toString());
    }

    private void checkByGoodsTaxNo(ValidatorContext context, OrdSalesbillInterfaceEntity billEntity, OrdSalesbillInterfaceItemEntity billItem, StringBuilder itemTaxCodeCheckAll) {
        String goodsTaxNo = billItem.getGoodsTaxNo();
        TaxNationalCode taxNationalCode = this.localTaxCodeCacheManager.getNationalTaxCode(goodsTaxNo);
        if (taxNationalCode != null) {
            SysInfoRuleDTO sysInfoRuleDTO;
            if (CommonTools.isPaperOrElectronicInvoice(billEntity.getInvoiceType()).booleanValue()) {
                billItem.setItemShortName(taxNationalCode.getTaxcodeShortName());
                itemTaxCodeCheckAll.append((CharSequence)this.taxCodeTools.getCheckItemInfo(billItem.getItemName(), taxNationalCode.getTaxcodeShortName()));
            }
            billItem.setSplitCode(taxNationalCode.getSplitCode());
            billItem.setItemTypeCode(taxNationalCode.getItemTypeCode());
            billItem.setGoodsNoVer(taxNationalCode.getVersion());
            Object sysConfig = context.getAttribute(ConfigTypeEnum.SYS_CONFIG_TYPE.getObjCode());
            if (sysConfig != null && (sysInfoRuleDTO = (SysInfoRuleDTO)sysConfig).getReffiendOilMixOpenFlag() != null && sysInfoRuleDTO.getReffiendOilMixOpenFlag().booleanValue()) {
                billItem.setSplitCode("1");
            }
        } else {
            itemTaxCodeCheckAll.append("--\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u586b\u5199\u9519\u8bef\uff0c\u5f53\u524d\u586b\u5199\u503c\u4e3a\u3010").append(goodsTaxNo).append("\u3011");
            return;
        }
        itemTaxCodeCheckAll.append((CharSequence)this.taxCodeTools.checkGoodsTaxNoStartWithSix(context, billEntity, billItem));
    }

    private void checkTaxConvertCode(ValidatorContext context, OrdSalesbillInterfaceEntity billEntity, OrdSalesbillInterfaceItemEntity billItem, StringBuilder itemTaxCodeCheckAll) {
        Long groupId = 0L;
        groupId = BusinessBillType.AR.value().equals(billEntity.getBusinessBillType()) ? billEntity.getSellerGroupId() : billEntity.getPurchaserGroupId();
        TaxConvertCodeModel taxcode = this.localTaxCodeCacheManager.getTaxCodeByTaxConvertCode(groupId, billItem.getTaxConvertCode());
        if (taxcode == null) {
            itemTaxCodeCheckAll.append("--\u672a\u627e\u5230\u6709\u6548\u7684\u7a0e\u7f16\u8f6c\u6362\u4ee3\u7801\u3010").append(billItem.getTaxConvertCode().trim()).append("\u3011\uff0c\u5339\u914d\u4e0d\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801--");
        } else {
            SysInfoRuleDTO sysInfoRuleDTO;
            Object sysConfig = context.getAttribute(ConfigTypeEnum.SYS_CONFIG_TYPE.getObjCode());
            if (sysConfig != null && (sysInfoRuleDTO = (SysInfoRuleDTO)sysConfig) != null && sysInfoRuleDTO.getCheckTaxRateByConvertCodeFlag() != null && sysInfoRuleDTO.getCheckTaxRateByConvertCodeFlag().booleanValue() && billItem.getTaxRate() != null && billItem.getTaxRate().compareTo(new BigDecimal(taxcode.getTaxRate())) != 0) {
                itemTaxCodeCheckAll.append("\u4e0a\u4f20\u7684\u7a0e\u7387\u3010").append(billItem.getTaxRate()).append("\u3011\u4e0e\u6240\u7ef4\u62a4\u7684\u7a0e\u7387\u3010").append(taxcode.getTaxRate()).append("\u3011\u4e0d\u4e00\u81f4");
            }
            if (CommonTools.isEmpty(billItem.getGoodsTaxNo())) {
                billItem.setGoodsTaxNo(taxcode.getGoodsTaxNo());
            }
        }
    }
}

