/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.discount;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

@Component
public class BillMainDiscountValidator
extends ValidatorHandler<OrdSalesbillInterfaceEntity>
implements Validator<OrdSalesbillInterfaceEntity> {
    public boolean accept(ValidatorContext context, OrdSalesbillInterfaceEntity productMainDiscount) {
        return true;
    }

    public void onException(Exception e, ValidatorContext context, OrdSalesbillInterfaceEntity productMainDiscount) {
    }

    public boolean validate(ValidatorContext context, OrdSalesbillInterfaceEntity productMainDiscount) {
        return this.checkAndSetDefultMainDiscount(context, productMainDiscount);
    }

    private boolean checkAndSetDefultMainDiscount(ValidatorContext context, OrdSalesbillInterfaceEntity mainDiscount) {
        if (mainDiscount.getInnerDiscountWithoutTax() == null) {
            mainDiscount.setInnerDiscountWithoutTax(BigDecimal.ZERO);
        }
        if (mainDiscount.getInnerDiscountWithTax() == null) {
            mainDiscount.setInnerDiscountWithTax(BigDecimal.ZERO);
        }
        if (mainDiscount.getInnerPrepayAmountWithTax() == null) {
            mainDiscount.setInnerPrepayAmountWithTax(BigDecimal.ZERO);
        }
        if (mainDiscount.getOutterPrepayAmountWithTax() == null) {
            mainDiscount.setOutterPrepayAmountWithTax(BigDecimal.ZERO);
        }
        if (mainDiscount.getOutterDiscountWithoutTax() == null) {
            mainDiscount.setOutterDiscountWithoutTax(BigDecimal.ZERO);
        }
        if (mainDiscount.getOutterDiscountWithTax() == null) {
            mainDiscount.setOutterDiscountWithTax(BigDecimal.ZERO);
        }
        if (mainDiscount.getInnerDiscountWithoutTax().compareTo(BigDecimal.ZERO) != 0 && mainDiscount.getInnerDiscountWithTax().compareTo(BigDecimal.ZERO) != 0) {
            context.addErrorMsg("\u4ef7\u5185\u6298\u6263\u542b\u7a0e\u91d1\u989d\u4e0e\u4ef7\u5185\u6298\u6263\u4e0d\u542b\u7a0e\u91d1\u989d\u53ea\u80fd\u4f20\u5176\u4e00");
            return false;
        }
        if (mainDiscount.getOutterDiscountWithoutTax().compareTo(BigDecimal.ZERO) != 0 && mainDiscount.getOutterDiscountWithTax().compareTo(BigDecimal.ZERO) != 0) {
            context.addErrorMsg("\u4ef7\u5916\u6298\u6263\u542b\u7a0e\u91d1\u989d\u4e0e\u4ef7\u5916\u6298\u6263\u4e0d\u542b\u7a0e\u91d1\u989d\u53ea\u80fd\u4f20\u5176\u4e00");
            return false;
        }
        if (mainDiscount.getInnerPrepayAmountWithTax().compareTo(BigDecimal.ZERO) != 0 && mainDiscount.getInnerPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) != 0) {
            context.addErrorMsg("\u4ef7\u5185\u9884\u4ed8\u5361\u542b\u7a0e\u91d1\u989d\u4e0e\u4ef7\u5185\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u53ea\u80fd\u4f20\u5176\u4e00");
            return false;
        }
        if (mainDiscount.getOutterPrepayAmountWithTax().compareTo(BigDecimal.ZERO) != 0 && mainDiscount.getOutterPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) != 0) {
            context.addErrorMsg("\u4ef7\u5916\u9884\u4ed8\u5361\u542b\u7a0e\u91d1\u989d\u4e0e\u4ef7\u5916\u9884\u4ed8\u5361\u4e0d\u542b\u7a0e\u91d1\u989d\u53ea\u80fd\u4f20\u5176\u4e00");
            return false;
        }
        return this.checkAmountValid(context, mainDiscount);
    }

    private boolean checkAmountValid(ValidatorContext context, OrdSalesbillInterfaceEntity mainDiscount) {
        if (mainDiscount.getInnerDiscountWithoutTax().scale() > 2) {
            context.addErrorMsg("\u4f20\u5165\u91d1\u989d\u7cbe\u5ea6\u4e0d\u6b63\u786e\uff0c\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\uff01");
            return false;
        }
        if (mainDiscount.getInnerDiscountWithTax().scale() > 2) {
            context.addErrorMsg("\u4f20\u5165\u91d1\u989d\u7cbe\u5ea6\u4e0d\u6b63\u786e\uff0c\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\uff01");
            return false;
        }
        if (mainDiscount.getInnerPrepayAmountWithTax().scale() > 2) {
            context.addErrorMsg("\u4f20\u5165\u91d1\u989d\u7cbe\u5ea6\u4e0d\u6b63\u786e\uff0c\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\uff01");
            return false;
        }
        if (mainDiscount.getOutterPrepayAmountWithTax().scale() > 2) {
            context.addErrorMsg("\u4f20\u5165\u91d1\u989d\u7cbe\u5ea6\u4e0d\u6b63\u786e\uff0c\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\uff01");
            return false;
        }
        if (mainDiscount.getOutterDiscountWithoutTax().scale() > 2) {
            context.addErrorMsg("\u4f20\u5165\u91d1\u989d\u7cbe\u5ea6\u4e0d\u6b63\u786e\uff0c\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\uff01");
            return false;
        }
        if (mainDiscount.getOutterDiscountWithTax().scale() > 2) {
            context.addErrorMsg("\u4f20\u5165\u91d1\u989d\u7cbe\u5ea6\u4e0d\u6b63\u786e\uff0c\u6700\u591a\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570\uff01");
            return false;
        }
        return true;
    }
}

