/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.validator.main;

import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.ValidatorHandler;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.InvoiceType;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SalesBillMainInfoValidate
extends ValidatorHandler<OrdSalesbillInterfaceEntity>
implements Validator<OrdSalesbillInterfaceEntity> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private LocalConfigMetadataCacheManager configMetadataCacheManager;

    public boolean accept(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        return true;
    }

    public void onException(Exception e, ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        context.addErrorMsg(e.getMessage());
    }

    public boolean validate(ValidatorContext context, OrdSalesbillInterfaceEntity ordSalesbillInterfaceEntity) {
        List<MsGroupTypeBean> groupTypeBeans;
        String salesBillTypeId;
        String reciverUser;
        this.logger.info("=========================SalesBillMainInfoValidate-\u5355\u636e\u53f7-{}==================", (Object)ordSalesbillInterfaceEntity.getSalesbillNo());
        long groupId = (Long)context.getAttribute("groupId");
        StringBuilder msg = new StringBuilder();
        String businessBillType = ordSalesbillInterfaceEntity.getBusinessBillType();
        String invoiceType = ordSalesbillInterfaceEntity.getInvoiceType();
        String sellerAddress = ordSalesbillInterfaceEntity.getSellerAddress();
        String sellerTel = ordSalesbillInterfaceEntity.getSellerTel();
        String sellerBankName = ordSalesbillInterfaceEntity.getSellerBankName();
        String sellerBankAccount = ordSalesbillInterfaceEntity.getSellerBankAccount();
        String sellerTaxNo = ordSalesbillInterfaceEntity.getSellerTaxNo();
        String purchaserAddress = ordSalesbillInterfaceEntity.getPurchaserAddress();
        String purchaserTel = ordSalesbillInterfaceEntity.getPurchaserTel();
        String purchaserBankName = ordSalesbillInterfaceEntity.getPurchaserBankName();
        String purchaserBankAccount = ordSalesbillInterfaceEntity.getPurchaserBankAccount();
        String purchaserName = ordSalesbillInterfaceEntity.getPurchaserName();
        String purchaserTaxNo = ordSalesbillInterfaceEntity.getPurchaserTaxNo();
        String sellerNo = ordSalesbillInterfaceEntity.getSellerNo();
        String sellerName = ordSalesbillInterfaceEntity.getSellerName();
        String purchaserNo = ordSalesbillInterfaceEntity.getPurchaserNo();
        String salesbillType = ordSalesbillInterfaceEntity.getSalesbillType();
        this.logger.info("=================businessBillType-{},invoiceType-{}==================", (Object)businessBillType, (Object)invoiceType);
        if (CommonTools.isEmpty(sellerNo) && CommonTools.isEmpty(sellerTaxNo)) {
            msg.append("--\u9500\u65b9\u4fe1\u606f\u8bc6\u522b\u65b9\u5f0f\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u9500\u65b9\u7a0e\u53f7\u548c\u540d\u79f0\u6216\u9500\u65b9\u7f16\u53f7--");
        }
        if (BusinessBillType.AR.value().equals(businessBillType) && (InvoiceType.NORMAL.value().equals(invoiceType) || InvoiceType.ELECTRONIC.value().equals(invoiceType))) {
            if (CommonTools.isEmpty(purchaserNo) && CommonTools.isEmpty(purchaserName)) {
                msg.append("--\u8d2d\u65b9\u4fe1\u606f\u8bc6\u522b\u65b9\u5f0f\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u8d2d\u65b9\u540d\u79f0\u6216\u8d2d\u65b9\u7f16\u53f7--");
            }
        } else if (CommonTools.isEmpty(purchaserNo) && CommonTools.isEmpty(purchaserTaxNo)) {
            msg.append("--\u8d2d\u65b9\u4fe1\u606f\u8bc6\u522b\u65b9\u5f0f\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u8d2d\u65b9\u7a0e\u53f7\u548c\u540d\u79f0\u6216\u8d2d\u65b9\u7f16\u53f7--");
        }
        StringBuilder sellerAddrTel = new StringBuilder();
        sellerAddrTel.append(sellerAddress).append(sellerTel);
        if (CommonTools.exceedMaxLength(sellerAddrTel.toString(), 101)) {
            msg.append("--\u9500\u65b9\u5730\u5740\u3010").append(sellerAddress).append("\u3011,\u9500\u65b9\u7535\u8bdd\u3010").append(sellerTel).append("\u3011,\u5bf9\u5e94\u7684\u9500\u65b9\u5730\u5740\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc7100--");
        }
        StringBuilder purchaserAddrTel = new StringBuilder();
        purchaserAddrTel.append(purchaserAddress).append(purchaserTel);
        if (CommonTools.exceedMaxLength(purchaserAddrTel.toString(), 101)) {
            msg.append("--\u8d2d\u65b9\u5730\u5740\u3010").append(purchaserAddress).append("\u3011,\u8d2d\u65b9\u7535\u8bdd\u3010").append(purchaserTel).append("\u3011,\u5bf9\u5e94\u7684\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u957f\u5ea6\u8d85\u8fc7100--");
        }
        if (!(CommonTools.isEmpty(sellerAddress) && CommonTools.isEmpty(sellerTel) && CommonTools.isEmpty(sellerBankAccount) && CommonTools.isEmpty(sellerBankName) || !CommonTools.isEmpty(sellerAddress) && !CommonTools.isEmpty(sellerTel) && !CommonTools.isEmpty(sellerBankAccount) && !CommonTools.isEmpty(sellerBankName))) {
            msg.append("--\u9500\u65b9\u5730\u5740\uff0c\u7535\u8bdd\uff0c\u94f6\u884c\u540d\u79f0\uff0c\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u82e5\u586b\u5199\u5219\u8be5\u56db\u9879\u4fe1\u606f\u9700\u5168\u90e8\u586b\u5199--");
        }
        if (!(CommonTools.isEmpty(purchaserAddress) && CommonTools.isEmpty(purchaserTel) && CommonTools.isEmpty(purchaserBankName) && CommonTools.isEmpty(purchaserBankAccount) || !CommonTools.isEmpty(purchaserAddress) && !CommonTools.isEmpty(purchaserTel) && !CommonTools.isEmpty(purchaserBankName) && !CommonTools.isEmpty(purchaserBankAccount) || !InvoiceType.SPECIAL.value().equals(ordSalesbillInterfaceEntity.getInvoiceType()))) {
            msg.append("--\u8d2d\u65b9\u5730\u5740\uff0c\u7535\u8bdd\uff0c\u94f6\u884c\u540d\u79f0\uff0c\u94f6\u884c\u8d26\u53f7\u4fe1\u606f\u82e5\u586b\u5199\u5219\u8be5\u56db\u9879\u4fe1\u606f\u9700\u5168\u90e8\u586b\u5199--");
        }
        if (!CommonTools.isEmpty(reciverUser = ordSalesbillInterfaceEntity.getReceiveUserEmail())) {
            String[] reciverUsers = reciverUser.split(";");
            for (int i = 0; i < reciverUsers.length; ++i) {
                String reciver = reciverUsers[i].trim();
                String[] reciverUsers2 = reciver.split("\uff1b");
                for (int j = 0; j < reciverUsers2.length; ++j) {
                    Boolean flag;
                    String reciver2 = reciverUsers2[j].trim();
                    if (CommonTools.isEmpty(reciver2) || (flag = Boolean.valueOf(CommonTools.validateEmail(reciver2))).booleanValue()) continue;
                    msg.append("--\u90ae\u7bb1\u3010").append(reciver).append("\u3011\u683c\u5f0f\u4e0d\u5408\u6cd5--");
                }
            }
        }
        if (CommonTools.isEmpty(salesBillTypeId = this.configMetadataCacheManager.getSalesBillTypeId(groupTypeBeans = this.configMetadataCacheManager.queryGroupObjType(groupId, ObjCodeEnum.BILL.getObjCode()), salesbillType))) {
            msg.append("--\u672a\u67e5\u8be2\uff0c\u5339\u914d\u5230\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3010" + salesbillType + "\u3011--");
        }
        if (!CommonTools.isEmpty(msg.toString())) {
            context.addErrorMsg(msg.toString());
            return false;
        }
        return true;
    }
}

