/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.rabbitmq.salesbill;

import com.xforceplus.phoenix.bill.core.service.BillInvoiceService;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.seller.invoice.client.model.NoticeBillMsg;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvoiceCompleteListener {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceCompleteListener.class);
    @Autowired
    private BillInvoiceService billInvoiceService;

    @RabbitListener(queuesToDeclare={@Queue(value="bill.invoice.makeOut")})
    public void handleMsg(Message message) {
        logger.info("\u5f00\u7968:{}", (Object)message.getMessageProperties());
        try {
            String body = new String(message.getBody());
            logger.info("\u5f00\u7968\u6570\u636e:{}", (Object)body);
            List<NoticeBillMsg> noticeBillMsg = JsonUtils.writeFastJsonToListObject(body, NoticeBillMsg.class);
            this.billInvoiceService.invoiceComplete(noticeBillMsg);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f00\u7968\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }
}

