/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.service.controller;

import com.xforceplus.phoenix.bill.client.api.BillOperationApi;
import com.xforceplus.phoenix.bill.client.config.MsPhoenixBillApi;
import com.xforceplus.phoenix.bill.client.model.AbandonBillByParamRequest;
import com.xforceplus.phoenix.bill.client.model.BillDetailInfoResponse;
import com.xforceplus.phoenix.bill.client.model.BillMainInfoResponse;
import com.xforceplus.phoenix.bill.client.model.BillRequest;
import com.xforceplus.phoenix.bill.client.model.DiscountRequest;
import com.xforceplus.phoenix.bill.client.model.GetBillDetailInfoRequest;
import com.xforceplus.phoenix.bill.client.model.GetBillMainInfoRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceByBillIdsRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceByBillItemIdsRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleRequest;
import com.xforceplus.phoenix.bill.client.model.GetInvoiceSplitRuleResponse;
import com.xforceplus.phoenix.bill.client.model.MakeOutInvoiceResponse;
import com.xforceplus.phoenix.bill.client.model.MakeoutInvoiceRequest;
import com.xforceplus.phoenix.bill.core.service.BillOperationService;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.swagger.annotations.ApiParam;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@MsPhoenixBillApi
public class BillOperationApiController
implements BillOperationApi {
    private BillOperationService billOperationService;
    private UserInfoHolder<UserInfo> userInfoHolder;

    @Autowired
    public BillOperationApiController(BillOperationService billOperationService, UserInfoHolder<UserInfo> userInfoHolder) {
        this.billOperationService = billOperationService;
        this.userInfoHolder = userInfoHolder;
    }

    public Response manualSplitDiscount(@ApiParam(value="\u624b\u52a8\u5206\u644a\u6298\u6263", required=true) @RequestBody DiscountRequest discountRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        return this.billOperationService.manualSplitDiscount(discountRequest, userInfo);
    }

    public Response abandonBill(@ApiParam(value="\u9875\u9762\u7684\u7b5b\u9009\u6761\u4ef6", required=true) @RequestBody BillRequest conditions, @NotNull @ApiParam(value="AR or AP", required=true) @RequestParam(value="role") String role) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        return this.billOperationService.abandonBill(conditions, role, userInfo);
    }

    public Response abandonBillByParam(@ApiParam(value="\u6309\u6761\u4ef6\u6279\u91cf\u4f5c\u5e9f") @RequestBody AbandonBillByParamRequest abandonBillByIdsRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        return this.billOperationService.abandonBillByParam(abandonBillByIdsRequest, userInfo);
    }

    public GetInvoiceResponse getInvoiceByBillIds(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u83b7\u53d6\u53d1\u7968\u5217\u8868") @RequestBody GetInvoiceByBillIdsRequest getInvoiceByBillIdsRequest) {
        return this.billOperationService.getInvoiceByBillIds(getInvoiceByBillIdsRequest);
    }

    public GetInvoiceResponse getInvoiceByBillItemIds(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u660e\u7ec6\u83b7\u53d6\u53d1\u7968\u5217\u8868") @RequestBody GetInvoiceByBillItemIdsRequest getInvoiceByBillItemIdsRequest) {
        return this.billOperationService.getInvoiceByBillItemIds(getInvoiceByBillItemIdsRequest);
    }

    public GetInvoiceSplitRuleResponse getInvoiceSplitRule(@ApiParam(value="\u6839\u636e\u9009\u62e9\u5355\u636e\u660e\u7ec6\u83b7\u53d6 \u5f00\u7968\u65f6 \u9700\u8981\u7684\u62c6\u7968\u3001\u62ac\u5934\u4fe1\u606f") @RequestBody GetInvoiceSplitRuleRequest getInvoiceSplitRuleRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        return this.billOperationService.getInvoiceSplitRule(getInvoiceSplitRuleRequest, userInfo);
    }

    public MakeOutInvoiceResponse makeOutInvoice(@ApiParam(value="\u5355\u636e\u5f00\u5177\u8bf7\u6c42") @RequestBody MakeoutInvoiceRequest makeoutInvoiceRequest) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        return this.billOperationService.makeOutInvoice(makeoutInvoiceRequest, userInfo);
    }

    public BillDetailInfoResponse getBillDetailInfo(@ApiParam(value="\u67e5\u8be2\u5355\u636e\u53ca\u660e\u7ec6\u8be6\u60c5") @RequestBody GetBillDetailInfoRequest getBillDetailInfoRequest) {
        return this.billOperationService.getBillDetailInfo(getBillDetailInfoRequest);
    }

    public BillMainInfoResponse getBillMainInfo(@ApiParam(value="\u67e5\u8be2\u5355\u636e\u4e3b\u4fe1\u606f\u8be6\u60c5") @RequestBody GetBillMainInfoRequest getBillMainInfoRequest) {
        return this.billOperationService.getBillMainInfo(getBillMainInfoRequest);
    }
}

