/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.sqs;

import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.service.CooperationService;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.sqs.model.AntSalesbillEntity;
import com.xforceplus.phoenix.bill.sqs.model.AntSalesbillItemEntity;
import com.xforceplus.phoenix.bill.sqs.model.SyncBill;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.sqs.BaseSQSListener;
import com.xforceplus.xplat.aws.spring.annotation.SQSListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@SQSListener(queueName="ant-phx-settlement-sync", attributeAll=true)
public class CooperationSalesBillListener
extends BaseSQSListener {
    private static final Logger logger = LoggerFactory.getLogger(CooperationSalesBillListener.class);
    @Autowired
    private CooperationService cooperationService;

    public boolean onMessage(String messageId, Map headers, String messageBody) {
        logger.debug("messageId:{}, messageBody:{}", (Object)messageId, (Object)messageBody);
        try {
            boolean b;
            SyncBill bill = JsonUtils.writeFastJsonToObject(messageBody, SyncBill.class);
            ArrayList<OrdSalesbillEntity> billMainList = new ArrayList<OrdSalesbillEntity>();
            ArrayList<OrdSalesbillItemEntity> billItemList = new ArrayList<OrdSalesbillItemEntity>();
            if (bill != null && (b = this.handleProcessflag(bill))) {
                OrdSalesbillEntity ordSalesbillEntity = new OrdSalesbillEntity();
                BeanUtils.copyProperties((Object)bill.getBill(), (Object)ordSalesbillEntity);
                ordSalesbillEntity.setSalesbillId(Long.parseLong(bill.getBill().getExternalId()));
                ordSalesbillEntity.setSysOrgId(null);
                billMainList.add(ordSalesbillEntity);
                List<AntSalesbillItemEntity> antBillItems = bill.getBillItems();
                antBillItems.forEach(item -> {
                    OrdSalesbillItemEntity itemEntity = new OrdSalesbillItemEntity();
                    BeanUtils.copyProperties(item, (Object)itemEntity);
                    itemEntity.setSalesbillItemId(Long.parseLong(item.getExternalId()));
                    billItemList.add(itemEntity);
                });
            }
            this.cooperationService.updateSalesBillAndItems(billMainList, billItemList);
        }
        catch (Exception e) {
            logger.error("process update amount message occurred error, messageId:{}, messageBody:{}", new Object[]{messageId, messageBody, e});
        }
        return true;
    }

    private boolean handleProcessflag(SyncBill bill) {
        AntSalesbillEntity antbill = bill.getBill();
        boolean originIdFlag = CommonTools.isEmpty(antbill.getExternalId());
        boolean billStatusFlag = SalesBillStatus.checkIsExist(antbill.getStatus());
        logger.info("\u534f\u540c\u4e1a\u52a1\u5355\u53f7:{},\u539f\u59cbexternalId:{},status:{}", new Object[]{antbill.getSalesbillNo(), antbill.getExternalId(), antbill.getStatus()});
        return !originIdFlag && billStatusFlag;
    }
}

