/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.sqs;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.runtime.Settings;
import com.xforceplus.phoenix.bill.core.service.BillChangeService;
import com.xforceplus.phoenix.bill.sqs.model.MatchResult;
import com.xforceplus.phoenix.sqs.BaseSQSListener;
import com.xforceplus.xplat.aws.spring.annotation.SQSListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@SQSListener(queueName="phoenix-invoice-draw-out-update-bill-amount", attributeAll=true)
public class InvoiceDrawOutUpdateBillListener
extends BaseSQSListener {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceDrawOutUpdateBillListener.class);
    @Autowired
    private BillChangeService billChangeService;

    public boolean onMessage(String messageId, Map headers, String messageBody) {
        logger.debug("messageId:{}, messageBody:{}", (Object)messageId, (Object)messageBody);
        try {
            DslJson dslJson = new DslJson(Settings.withRuntime().allowArrayFormat(true).includeServiceLoader());
            byte[] bytes = messageBody.getBytes("utf-8");
            MatchResult matchResult = (MatchResult)dslJson.deserialize(MatchResult.class, bytes, bytes.length);
            this.billChangeService.onAutoMatch(matchResult);
        }
        catch (Exception e) {
            logger.error("process update amount message occurred error, messageId:{}, messageBody:{}", new Object[]{messageId, messageBody, e});
        }
        return true;
    }
}

