/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.utils;

import com.google.common.collect.Lists;
import com.xforceplus.bss.external.client.model.CoordinationModel;
import com.xforceplus.phoenix.bill.cache.bssexternal.LocalBssExternalCacheManager;
import com.xforceplus.phoenix.bill.component.BillHisotryBean;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.component.SplitMergeHistoryComponent;
import com.xforceplus.phoenix.bill.constant.enums.AutoPassFlag;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.CooperateFlag;
import com.xforceplus.phoenix.bill.constant.enums.CooperateModifyStatus;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillCatalog;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillOperateDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillInterfaceEntity;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CooperationUtils {
    private static final Logger logger = LoggerFactory.getLogger(CooperationUtils.class);
    @Autowired
    private LocalBssExternalCacheManager localBssExternalCacheManager;
    @Autowired
    private SalesBillOperateDao operateDao;
    @Autowired
    private LocalBssExternalCacheManager bssExternalCacheManager;
    @Autowired
    private SplitMergeHistoryComponent splitMergeHistoryComponent;

    private BillHisotryBean getBillHisotryBean(Long sourceId, BillOperationType billItemOperation, String desc, Long userId) {
        BillHisotryBean billHisotryBean = new BillHisotryBean();
        billHisotryBean.setSourceId(sourceId);
        billHisotryBean.setBillItemOperation(billItemOperation);
        billHisotryBean.setDesc(desc);
        billHisotryBean.setUserId(userId);
        return billHisotryBean;
    }

    private String getOpertionDesc(String salesBillNo, BillOperationType billOperationType) {
        StringBuilder desc = new StringBuilder();
        switch (billOperationType) {
            case CONFIRM: {
                desc.append("\u5355\u636e\u53f7\u3010").append(salesBillNo).append("\u3011\u5df2\u786e\u8ba4");
                break;
            }
            case UPDATE: {
                desc.append("\u5355\u636e\u53f7\u3010").append(salesBillNo).append("\u3011\u5df2\u4fee\u6539");
                break;
            }
            case REJECT: {
                desc.append("\u5355\u636e\u53f7\u3010").append(salesBillNo).append("\u3011\u5df2\u9a73\u56de");
                break;
            }
            case AUTO_CONFIRM: {
                desc.append("\u5355\u636e\u53f7\u3010").append(salesBillNo).append("\u3011").append(billOperationType.getDesc()).append("\u64cd\u4f5c\uff0c\u81ea\u52a8\u786e\u8ba4");
            }
        }
        return desc.toString();
    }

    public Response handlAutoFlag(List<OrdSalesbillEntity> ordSalesbillEntities, String role, BillOperationType operation, String desc) {
        ArrayList hisotryBeans = Lists.newArrayList();
        SplitAndMergeHistoryOperationBean historyOperationBean = new SplitAndMergeHistoryOperationBean();
        for (OrdSalesbillEntity entity : ordSalesbillEntities) {
            String businessBillType;
            String salesbillType;
            Long sellerId = entity.getSellerId();
            Long sellerGroupId = entity.getSellerGroupId();
            Long purchaserId = entity.getPurchaserId();
            Long purchaserGroupId = entity.getPurchaserGroupId();
            CoordinationModel coordiantion = this.bssExternalCacheManager.getBssExternalCoordiantion(sellerGroupId, sellerId, purchaserGroupId, purchaserId, salesbillType = entity.getSalesbillType(), businessBillType = entity.getBusinessBillType());
            if (coordiantion == null) {
                coordiantion = new CoordinationModel();
            }
            if (CooperateFlag.NO_COOPERATE.value().equals(entity.getCooperateFlag())) {
                coordiantion.setBusinessUploadedReceiverFlag(AutoPassFlag.yes.value());
                coordiantion.setBusinessChangedReceiverFlag(AutoPassFlag.yes.value());
            }
            if (BillOperationType.REJECT == operation) {
                hisotryBeans.addAll(this.handleReconfirmAutoFlag(entity, role, operation, coordiantion, desc));
            } else if (BillOperationType.CONFIRM == operation) {
                logger.info("===================CooperateModifyStatus-{}========================================", (Object)entity.getCooperateModifyStatus());
                if (CooperateModifyStatus.modified.value().equals(entity.getCooperateModifyStatus())) {
                    hisotryBeans.addAll(this.handleUpdateAutoFlag(entity, role, BillOperationType.UPDATE, coordiantion));
                } else if (CooperateModifyStatus.no_modified.value().equals(entity.getCooperateModifyStatus())) {
                    hisotryBeans.addAll(this.handleConfirmAutoFlag(entity, role, BillOperationType.CONFIRM, coordiantion));
                }
            }
            entity.setCooperateModifyStatus(CooperateModifyStatus.no_modified.value());
        }
        int count = this.operateDao.updateSalesBillConfirmFlag(ordSalesbillEntities);
        if (count == ordSalesbillEntities.size()) {
            historyOperationBean.setBillItemOperation(operation);
            historyOperationBean.setHisotryBeans(hisotryBeans);
            this.splitMergeHistoryComponent.billHitoryOper(historyOperationBean);
        }
        return Response.from((Integer)Response.OK, (String)(operation.getDesc() + "\u6210\u529f" + count + "\u6761"));
    }

    public void handlUploadAutoFlag(OrdSalesbillInterfaceEntity interfaceEntity, String role, BillOperationType operation, CoordinationModel coordiantion) {
        if (coordiantion == null) {
            coordiantion = new CoordinationModel();
        }
        if (CooperateFlag.NO_COOPERATE.value().equals(interfaceEntity.getCooperateFlag())) {
            coordiantion.setBusinessUploadedReceiverFlag(AutoPassFlag.yes.value());
            coordiantion.setBusinessChangedReceiverFlag(AutoPassFlag.yes.value());
            coordiantion.setBusinessUploadedSenderFlag(AutoPassFlag.yes.value());
            coordiantion.setBusinessChangedSenderFlag(AutoPassFlag.yes.value());
        }
        if (BusinessBillType.AR.value().equals(role)) {
            if (role.equals(interfaceEntity.getBusinessBillType()) && BillOperationType.UPLOAD == operation && AutoPassFlag.yes.value().equals(coordiantion.getBusinessUploadedSenderFlag())) {
                interfaceEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                interfaceEntity.setReceiveConfirmFlag(SalesBillCatalog.CONFIRMING.value());
                if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessUploadedReceiverFlag())) {
                    interfaceEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                    interfaceEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                }
            }
        } else if (BusinessBillType.AP.value().equals(role) && role.equals(interfaceEntity.getBusinessBillType()) && BillOperationType.UPLOAD == operation && AutoPassFlag.yes.value().equals(coordiantion.getBusinessUploadedSenderFlag())) {
            interfaceEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
            interfaceEntity.setReceiveConfirmFlag(SalesBillCatalog.CONFIRMING.value());
            if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessUploadedReceiverFlag())) {
                interfaceEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                interfaceEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
            }
        }
    }

    public List<BillHisotryBean> handleConfirmAutoFlag(OrdSalesbillEntity ordSalesbillEntity, String role, BillOperationType operation, CoordinationModel coordiantion) {
        Long salesbillId = ordSalesbillEntity.getSalesbillId();
        long createUser = ordSalesbillEntity.getCreateUser();
        ArrayList billHisotryBeans = Lists.newArrayList();
        if (BusinessBillType.AR.value().equals(role)) {
            if (role.equals(ordSalesbillEntity.getBusinessBillType())) {
                if (BillOperationType.CONFIRM == operation) {
                    if (SalesBillCatalog.CONFIRMING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CONFIRMING.value());
                        String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                        billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
                        if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessUploadedReceiverFlag())) {
                            ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                            billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                        }
                    } else if (SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                        String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                        billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
                    }
                }
            } else if (BillOperationType.CONFIRM == operation) {
                ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
            }
        } else if (BusinessBillType.AP.value().equals(role)) {
            if (role.equals(ordSalesbillEntity.getBusinessBillType())) {
                if (BillOperationType.CONFIRM == operation) {
                    if (SalesBillCatalog.CONFIRMING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CONFIRMING.value());
                        String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                        billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
                        if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessUploadedReceiverFlag())) {
                            ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                            billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                        }
                    } else if (SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                        String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                        billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
                    }
                }
            } else if (BillOperationType.CONFIRM == operation) {
                ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
            }
        }
        return billHisotryBeans;
    }

    public List<BillHisotryBean> handleReconfirmAutoFlag(OrdSalesbillEntity ordSalesbillEntity, String role, BillOperationType operation, CoordinationModel coordiantion, String desc) {
        ArrayList billHisotryBeans = Lists.newArrayList();
        Long salesbillId = ordSalesbillEntity.getSalesbillId();
        long createUser = ordSalesbillEntity.getCreateUser();
        if (BusinessBillType.AR.value().equals(role)) {
            if (role.equals(ordSalesbillEntity.getBusinessBillType())) {
                if (BillOperationType.REJECT == operation) {
                    ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                    ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CHANGING.value());
                    String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                    billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
                }
            } else if (BillOperationType.REJECT == operation) {
                ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.CHANGING.value());
                ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
            }
        } else if (BusinessBillType.AP.value().equals(role)) {
            if (role.equals(ordSalesbillEntity.getBusinessBillType())) {
                if (BillOperationType.REJECT == operation) {
                    ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                    ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CHANGING.value());
                    String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                    billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
                }
            } else if (BillOperationType.REJECT == operation) {
                ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.CHANGING.value());
                ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), operation);
                billHisotryBeans.add(this.getBillHisotryBean(salesbillId, operation, opertionDesc, createUser));
            }
        }
        return billHisotryBeans;
    }

    public List<BillHisotryBean> handleUpdateAutoFlag(OrdSalesbillEntity ordSalesbillEntity, String role, BillOperationType operation, CoordinationModel coordiantion) {
        ArrayList billHisotryBeans = Lists.newArrayList();
        Long salesbillId = ordSalesbillEntity.getSalesbillId();
        long createUser = ordSalesbillEntity.getCreateUser();
        if (BusinessBillType.AR.value().equals(role)) {
            if (role.equals(ordSalesbillEntity.getBusinessBillType())) {
                if (BillOperationType.UPDATE == operation) {
                    if (SalesBillCatalog.CONFIRMING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CHANGING.value());
                        if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessChangedReceiverFlag())) {
                            ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                            billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                        }
                    } else if (SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getUploadConfirmFlag()) || SalesBillCatalog.WAITING_MAKE_INVOICE.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CHANGING.value());
                        if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessChangedReceiverFlag())) {
                            ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                            billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                        }
                    }
                }
            } else if (BillOperationType.UPDATE == operation) {
                ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.CHANGING.value());
                ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessChangedSenderFlag())) {
                    ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                    ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                    String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                    billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                }
            }
        } else if (BusinessBillType.AP.value().equals(role)) {
            if (role.equals(ordSalesbillEntity.getBusinessBillType())) {
                if (BillOperationType.UPDATE == operation) {
                    if (SalesBillCatalog.CONFIRMING.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CHANGING.value());
                        if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessChangedReceiverFlag())) {
                            ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                            billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                        }
                    } else if (SalesBillCatalog.CHANGING.value().equals(ordSalesbillEntity.getUploadConfirmFlag()) || SalesBillCatalog.WAITING_MAKE_INVOICE.value().equals(ordSalesbillEntity.getUploadConfirmFlag())) {
                        ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                        ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.CHANGING.value());
                        if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessChangedReceiverFlag())) {
                            ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                            String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                            billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                        }
                    }
                }
            } else if (BillOperationType.UPDATE == operation) {
                ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.CHANGING.value());
                ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.OPPOSITE_CONFIRMING.value());
                if (AutoPassFlag.yes.value().equals(coordiantion.getBusinessChangedSenderFlag())) {
                    ordSalesbillEntity.setUploadConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                    ordSalesbillEntity.setReceiveConfirmFlag(SalesBillCatalog.WAITING_MAKE_INVOICE.value());
                    String opertionDesc = this.getOpertionDesc(ordSalesbillEntity.getSalesbillNo(), BillOperationType.AUTO_CONFIRM);
                    billHisotryBeans.add(this.getBillHisotryBean(salesbillId, BillOperationType.AUTO_CONFIRM, opertionDesc, createUser));
                }
            }
        }
        return billHisotryBeans;
    }
}

