/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.utils;

import java.math.BigDecimal;

public class MoneyUtil {
    private static final String CN_UNIT = "\u4e07\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5706\u89d2\u5206";
    private static final String CN_DIGIT = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
    private static final double MAX_VALUE = 9.99999999999999E12;

    public static String toChineseUpperCase(double v) {
        if ((v = Math.abs(v)) > 9.99999999999999E12) {
            return "\u53c2\u6570\u975e\u6cd5!";
        }
        long l = Math.round(v * 100.0);
        if (l == 0L) {
            return "\u96f6\u5706\u6574";
        }
        String strValue = l + "";
        int i = 0;
        int j = CN_UNIT.length() - strValue.length();
        StringBuilder rs = new StringBuilder();
        boolean isZero = false;
        while (i < strValue.length()) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if (CN_UNIT.charAt(j) == '\u4ebf' || CN_UNIT.charAt(j) == '\u4e07' || CN_UNIT.charAt(j) == '\u5706') {
                    rs.append(CN_UNIT.charAt(j));
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs.append("\u96f6");
                    isZero = false;
                }
                rs.append(CN_DIGIT.charAt(ch - 48)).append(CN_UNIT.charAt(j));
            }
            ++i;
            ++j;
        }
        String result = rs.toString();
        if (!result.endsWith("\u5206") && !result.endsWith("\u89d2")) {
            rs.append("\u6574");
            result = rs.toString();
        }
        if (result.indexOf("\u6574") < 0 && result.indexOf("\u96f6") < 0) {
            result = result.replaceAll("\u62fe\u5706", "\u62fe\u5706\u96f6");
            result = result.replaceAll("\u4edf\u5706", "\u4edf\u5706\u96f6");
            result = result.replaceAll("\u4e07\u5706", "\u4e07\u5706\u96f6");
        }
        result = result.replaceAll("\u4ebf\u4e07", "\u4ebf");
        return result;
    }

    public static BigDecimal formatAmount(BigDecimal amount) {
        if (null == amount) {
            return new BigDecimal("0");
        }
        return amount.setScale(2, 4);
    }

    public static BigDecimal getTaxRate(BigDecimal taxAmount, BigDecimal amountWithoutTax) {
        BigDecimal taxRate = new BigDecimal("0");
        try {
            taxRate = taxAmount.divide(amountWithoutTax, 2, 4).multiply(new BigDecimal(100));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return taxRate;
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal ne = new BigDecimal("1");
        return b.divide(ne, scale, 4).doubleValue();
    }
}

