/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.utils;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SpringContextUtil
implements ApplicationContextAware,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringContextUtil.class);
    private static ApplicationContext context;
    private static Environment environment;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static ApplicationContext geteContext() {
        return context;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)context.getBean(clazz);
    }

    public static Object getBean(String beanId) {
        return context.getBean(beanId);
    }

    public static <T> T getBean(String beanName, Class<T> requiredType) {
        return (T)context.getBean(beanName, requiredType);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationTag) throws BeansException {
        return context.getBeansWithAnnotation(annotationTag);
    }

    public void setEnvironment(Environment environment) {
        SpringContextUtil.environment = environment;
    }

    public static String getEnvProperty(String key) {
        return environment.getProperty(key);
    }
}

