/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.cache.bssexternal;

import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.bss.external.client.model.CoordinationModel;
import com.xforceplus.bss.external.client.model.GetCompanyInfoRequest;
import com.xforceplus.bss.external.client.model.GetCompanyInfoResponse;
import com.xforceplus.bss.external.client.model.GetCoordinationInfoRequest;
import com.xforceplus.bss.external.client.model.GetCoordinationInfoResponse;
import com.xforceplus.bss.external.client.model.GetGroupInfoRequest;
import com.xforceplus.bss.external.client.model.GetGroupInfoResponse;
import com.xforceplus.bss.external.client.model.GroupModel;
import com.xforceplus.phoenix.bill.cache.configmetadata.LocalConfigMetadataCacheManager;
import com.xforceplus.phoenix.bill.cache.ucenter.LocalUcenterExternalCacheManager;
import com.xforceplus.phoenix.bill.client.bssexternal.BssExternalCompanyClient;
import com.xforceplus.phoenix.bill.client.bssexternal.BssExternalCoordinationClient;
import com.xforceplus.phoenix.bill.client.bssexternal.BssExternalGroupClient;
import com.xforceplus.phoenix.bill.constant.enums.BusinessBillType;
import com.xforceplus.phoenix.bill.constant.enums.OrgType;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.ucenter.external.client.model.OrgModel;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalBssExternalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String cacheName = "BSS_EXTERNAL_LOCAL_CACHE";
    @Autowired
    private BssExternalCompanyClient bssExternalCompanyClient;
    @Autowired
    private BssExternalGroupClient bssExternalGroupClient;
    @Autowired
    private BssExternalCoordinationClient bssExternalCoordinationClient;
    @Autowired
    private LocalConfigMetadataCacheManager configMetadataCacheManager;
    @Autowired
    private LocalUcenterExternalCacheManager localUcenterExternalCacheManager;

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"})
    public CompanyModel getCompanyMainInfoByNo(String companyNo, long groupId) {
        List<OrgModel> orgList = this.localUcenterExternalCacheManager.getOrgListByCompanyNo(groupId, null, OrgType.Company.value(), companyNo);
        if (CommonTools.isEmpty(orgList)) {
            return null;
        }
        Long companyId = 0L;
        for (int i = 0; i < orgList.size(); ++i) {
            List<String> list;
            OrgModel orgModel = orgList.get(i);
            String companyNoStr = orgModel.getCompanyNo();
            if (CommonTools.isEmpty(companyNoStr) || !(list = JsonUtils.writeFastJsonToListObject(companyNoStr, String.class)).contains(companyNo)) continue;
            companyId = orgModel.getCompanyId();
            break;
        }
        GetCompanyInfoRequest request = new GetCompanyInfoRequest();
        request.setDataType(GetCompanyInfoRequest.DataTypeEnum.COMPANYID);
        request.setDataValue(String.valueOf(companyId));
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        this.logger.info("======================getCompanyMainInfoByNo-request-{}============================", (Object)request);
        GetCompanyInfoResponse companyInfo = this.bssExternalCompanyClient.getCompanyInfo(request);
        this.logger.info("=================CompanyModeByNO-{}============================", (Object)companyInfo.getResult());
        return companyInfo.getResult();
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"})
    public CompanyModel getCompanyMainInfoByTaxNo(String companyTaxNo) {
        GetCompanyInfoRequest request = new GetCompanyInfoRequest();
        request.setDataType(GetCompanyInfoRequest.DataTypeEnum.TAXNUM);
        request.setDataValue(companyTaxNo);
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        this.logger.info("======================getCompanyMainInfoByTaxNo-request-{}============================", (Object)request);
        GetCompanyInfoResponse companyInfo = this.bssExternalCompanyClient.getCompanyInfo(request);
        this.logger.info("=================CompanyModeByTaxNo-{}============================", (Object)companyInfo.getResult());
        return companyInfo.getResult();
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"})
    public GroupModel getTenantCodeByCompanyId(long companyId) {
        GetGroupInfoRequest request = new GetGroupInfoRequest();
        request.setDataType(GetGroupInfoRequest.DataTypeEnum.COMPANYID);
        request.setDataValue(String.valueOf(companyId));
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        this.logger.debug("======================getTenantCodeByCompanyId-request-{}============================", (Object)request);
        GetGroupInfoResponse groupInfo = this.bssExternalGroupClient.getGroupInfo(request);
        this.logger.debug("=================GroupModel-{}===========================", (Object)groupInfo.getResult());
        return groupInfo.getResult();
    }

    @Cacheable(cacheNames={"BSS_EXTERNAL_LOCAL_CACHE"})
    public CoordinationModel getBssExternalCoordiantion(Long sellerGroupId, Long sellerId, Long purchaserGroupId, Long purchaserId, String salesBillType, String businessType) {
        GetCoordinationInfoRequest request = new GetCoordinationInfoRequest();
        request.setAppid("phoenix-bill-service");
        request.setRid(UUID.randomUUID().toString());
        request.setSellerCompanyId(sellerId);
        request.setSellerGroupId(sellerGroupId);
        request.setPurchaserCompanyId(purchaserId);
        request.setPurchaserGroupId(purchaserGroupId);
        request.setCoordinationType("CG");
        Long grouId = BusinessBillType.AR.value().equals(businessType) ? sellerGroupId : purchaserGroupId;
        List<MsGroupTypeBean> groupTypeBeans = this.configMetadataCacheManager.queryGroupObjType(grouId, ObjCodeEnum.BILL.getObjCode());
        String salesBillTypeId = this.configMetadataCacheManager.getSalesBillTypeId(groupTypeBeans, salesBillType);
        request.setBusinessType(salesBillTypeId);
        this.logger.debug("======================getCoordiantion-request-{}============================", (Object)request);
        GetCoordinationInfoResponse coordinationInfo = this.bssExternalCoordinationClient.getCoordinationInfo(request);
        this.logger.debug("==================CoordinationModel-{}================================", (Object)coordinationInfo.getResult());
        return coordinationInfo.getResult();
    }
}

