/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.cache.configmetadata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.configmetadata.ConfigMetaDataClient;
import com.xforceplus.phoenix.bill.client.configmetadata.CustomDefinitionClient;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillVO;
import com.xforceplus.phoenix.bill.client.splitconfig.ConfigApiClient;
import com.xforceplus.phoenix.bill.client.splitconfig.InvoiceSplitConfigClient;
import com.xforceplus.phoenix.bill.repository.model.modelext.ConfigRequestModel;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtBean;
import com.xforceplus.phoenix.bill.sellerconfigext.SysConfigExtParser;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemResponse;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeResponse;
import com.xforceplus.seller.config.client.model.MsImportFieldResponse;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsMetadataItemResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.InvoiceInfoRlueParser;
import com.xforceplus.xplatframework.model.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class LocalConfigMetadataCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CACHE_NANME = "PHOENIX_BILL_CONFIG_CACHE";
    private static final String BILL_CONFIG_GET_INVOICE_SPLIT_RULE = "PHOENIX_BILL_CONFIG_CACHE_GET_INVOICE_SPLIT_RULE";
    private ConfigMetaDataClient configMetaDataClient;
    private CustomDefinitionClient customDefinitionClient;
    private InvoiceInfoRlueParser invoiceInfoRlueParser;
    private SysConfigExtParser sysConfigExtParser;
    private InvoiceSplitConfigClient invoiceSplitConfigClient;
    private ConfigApiClient configApiClient;

    public LocalConfigMetadataCacheManager() {
    }

    @Autowired
    public LocalConfigMetadataCacheManager(ConfigMetaDataClient configMetaDataClient, CustomDefinitionClient customDefinitionClient, InvoiceInfoRlueParser invoiceInfoRlueParser, SysConfigExtParser sysInfoRuleParser, InvoiceSplitConfigClient invoiceSplitConfigClient, ConfigApiClient configApiClient) {
        this.configMetaDataClient = configMetaDataClient;
        this.customDefinitionClient = customDefinitionClient;
        this.invoiceInfoRlueParser = invoiceInfoRlueParser;
        this.sysConfigExtParser = sysInfoRuleParser;
        this.invoiceSplitConfigClient = invoiceSplitConfigClient;
        this.configApiClient = configApiClient;
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE"})
    public List<MsGroupTypeBean> queryGroupObjType(Long groupId, String objCode) {
        MsMataDataQueryRequest request = new MsMataDataQueryRequest();
        request.setGroupId(groupId);
        request.setObjCode(objCode);
        this.logger.info("================queryGroupObjType-{}==============================================", (Object)request);
        MsGroupTypeResponse response = this.configMetaDataClient.queryGroupObjType(request);
        this.logger.info("=================metadataItemResult-{}===========================================", (Object)JsonUtils.writeObjectToFastJson(response.getResult()));
        return response.getResult();
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE"})
    public Map queryEffctiveMetaData(Long groupId, String objCode, String objType) {
        MsMataDataQueryRequest request = new MsMataDataQueryRequest();
        request.setGroupId(groupId);
        request.setObjCode(objCode);
        request.setObjType(objType);
        this.logger.info("================queryEffctiveMetaData-{}==============================================", (Object)request);
        MsMetadataItemResponse response = this.configMetaDataClient.queryEffctiveMetaData(request);
        List result = response.getResult();
        if (Response.Fail.equals(response.getCode()) || CommonTools.isEmpty(result)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        result.forEach(m -> map.put(m.getFieldName() + "#" + m.getFieldGroupIndex(), m));
        this.logger.info("=================metadataItemResult-{}===========================================", (Object)JsonUtils.writeObjectToFastJson(result));
        return map;
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE"}, key="#root.args[0].toString()+#root.args[1]+#root.args[2]")
    public InvoiceInfoRuleDTO queryInvoiceInfoRuleDTO(ConfigRequestModel configRequestModel, ConfigTypeEnum configTypeEnum, String businessBillType) {
        configRequestModel.setBusinessBillType(businessBillType);
        MsConfigQueryRequest msConfigQueryRequest = this.getMsConfigQueryRequest(configRequestModel, configTypeEnum);
        MsResponse msResponse = this.invoiceSplitConfigClient.getOptimalMatchConfig(msConfigQueryRequest);
        if (null == msResponse || msResponse.getCode().intValue() == Response.Fail.intValue() || null == msResponse.getResult()) {
            this.logger.info("\u83b7\u53d6\u6700\u4f18\u7968\u9762\u4eba\u5458\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.");
            return null;
        }
        String itemListString = (String)msResponse.getResult();
        this.logger.debug("LocalConfigMetadataCacheManager---queryInvoiceInfoRuleDTO---itemListString:{}", (Object)itemListString);
        List<MsConfigItemBean> msConfigItemBeanList = JsonUtils.writeFastJsonToListObject(itemListString, MsConfigItemBean.class);
        InvoiceInfoRuleDTO baseRuleBean = this.invoiceInfoRlueParser.parse(msConfigItemBeanList);
        this.logger.debug("LocalConfigMetadataCacheManager-getInvoiceSplitRule-baseRuleBean:{}", (Object)JsonUtils.writeObjectToFastJson(baseRuleBean));
        InvoiceInfoRuleDTO invoiceInfoRuleDTO = baseRuleBean;
        this.logger.info("=======================InvoiceInfoObj-{}============================", (Object)invoiceInfoRuleDTO);
        return invoiceInfoRuleDTO;
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE"}, key="#root.args[0].toString()+#root.args[1]")
    public SysConfigExtBean querySysInfoConfig(ConfigRequestModel configRequestModel, ConfigTypeEnum configTypeEnum) {
        MsConfigQueryRequest msConfigQueryRequest = this.getMsConfigQueryRequest(configRequestModel, configTypeEnum);
        this.logger.info("======================getSysInfoConfig-request-{}============================", (Object)JsonUtils.writeObjectToFastJson(msConfigQueryRequest));
        MsResponse msResponse = this.invoiceSplitConfigClient.getOptimalMatchConfig(msConfigQueryRequest);
        if (null == msResponse || msResponse.getCode().intValue() == Response.Fail.intValue() || null == msResponse.getResult()) {
            this.logger.info("\u83b7\u53d6\u7cfb\u7edf\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.");
            return null;
        }
        String itemListString = (String)msResponse.getResult();
        this.logger.info("LocalConfigMetadataCacheManager-querySysInfoConfig-itemListString:{}", (Object)itemListString);
        List<MsConfigItemBean> itemList = JsonUtils.writeFastJsonToListObject(itemListString, MsConfigItemBean.class);
        SysInfoRuleDTO baseRuleBean = this.sysConfigExtParser.parse(itemList);
        this.logger.info("LocalConfigMetadataCacheManager-querySysInfoConfig-baseRuleBean:{}", (Object)JsonUtils.writeObjectToFastJson(baseRuleBean));
        return (SysConfigExtBean)baseRuleBean;
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE"})
    public HashMap<String, String> queryCustomDefinition(Long userId, Long groupId, String pageCode, String functionPoint) {
        this.logger.info("======================queryCustomDefinition-request----userId:{},groupId:{},pageCode:{},functionPoint:{}============================", new Object[]{userId, groupId, pageCode, functionPoint});
        MsImportFieldResponse response = this.customDefinitionClient.getCustomImportFields(userId, groupId, pageCode, functionPoint);
        HashMap map = Maps.newHashMap();
        if (response.getCode() == 1 && response.getResult() != null) {
            response.getResult().forEach(m -> map.put(m.getFieldCode(), m.getFieldName()));
        }
        return map;
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE"}, key="#root.args[0].toMD5GroupString() + #root.methodName")
    public BaseRuleBean getBillGroupRuleBean(OrdSalesbillVO ordSalesbillVO, ConfigParser configParser) {
        MsResponse msResponse;
        if (Objects.isNull(ordSalesbillVO)) {
            this.logger.warn("getBillGroupRuleBean ordSalesbillVO is null");
            return null;
        }
        MsConfigQueryRequest msConfigQueryRequest = this.getSplitAndMergeConfigRuleRequest(ordSalesbillVO, ConfigTypeEnum.MERGE_CONFIG_TYPE);
        try {
            msResponse = this.invoiceSplitConfigClient.getOptimalMatchConfig(msConfigQueryRequest);
        }
        catch (Exception e) {
            this.logger.warn(String.format("\u5355\u636e\u3010%s\u3011\u83b7\u53d6\u7ec4\u5408\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.", ordSalesbillVO.getSalesbillId()));
            throw new RuntimeException(String.format("\u5355\u636e\u3010%s\u3011\u83b7\u53d6\u7ec4\u5408\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.", ordSalesbillVO.getSalesbillId()));
        }
        if (Objects.isNull(msResponse) || Objects.isNull(msResponse.getResult()) || msResponse.getCode().intValue() == Response.Fail.intValue()) {
            this.logger.warn(String.format("\u5355\u636e\u3010%s\u3011\u83b7\u53d6\u7ec4\u5408\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.", ordSalesbillVO.getSalesbillId()));
            return null;
        }
        String itemListString = (String)msResponse.getResult();
        List<MsConfigItemBean> itemList = JsonUtils.writeFastJsonToListObject(itemListString, MsConfigItemBean.class);
        return configParser.parse(itemList);
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE"}, key="#root.args[0].toMD5GroupString() + #root.methodName")
    public BaseRuleBean getBillItemMergeRuleBean(OrdSalesbillVO ordSalesbillVO, ConfigParser configParser) {
        MsResponse msResponse;
        if (Objects.isNull(ordSalesbillVO)) {
            this.logger.warn("getBillItemMergeRuleBean ordSalesbillVO is null");
            return null;
        }
        MsConfigQueryRequest msConfigQueryRequest = this.getSplitAndMergeConfigRuleRequest(ordSalesbillVO, ConfigTypeEnum.BILL_MERGE_TYPE);
        try {
            msResponse = this.invoiceSplitConfigClient.getOptimalMatchConfig(msConfigQueryRequest);
        }
        catch (Exception e) {
            this.logger.warn(String.format("\u5355\u636e\u3010%s\u3011\u83b7\u53d6\u660e\u7ec6\u5408\u5e76\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.", ordSalesbillVO.getSalesbillId()));
            throw new RuntimeException(String.format("\u5355\u636e\u3010%s\u3011\u83b7\u53d6\u660e\u7ec6\u5408\u5e76\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.", ordSalesbillVO.getSalesbillId()));
        }
        if (Objects.isNull(msResponse) || Objects.isNull(msResponse.getResult()) || msResponse.getCode().intValue() == Response.Fail.intValue()) {
            this.logger.warn(String.format("\u5355\u636e\u3010%s\u3011\u83b7\u53d6\u660e\u7ec6\u5408\u5e76\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.", ordSalesbillVO.getSalesbillId()));
            return null;
        }
        String itemListString = (String)msResponse.getResult();
        List<MsConfigItemBean> itemList = JsonUtils.writeFastJsonToListObject(itemListString, MsConfigItemBean.class);
        return configParser.parse(itemList);
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE_GET_INVOICE_SPLIT_RULE"}, key="#root.args[0].toMD5GroupString() + #root.methodName")
    public BaseRuleBean getInvoiceSplitRule(OrdSalesbillVO ordSalesbillVO, ConfigParser configParser) {
        MsResponse msResponse;
        if (Objects.isNull(ordSalesbillVO)) {
            this.logger.warn("getInvoiceSplitRule ordSalesbillVO is null");
            return null;
        }
        MsConfigQueryRequest msConfigQueryRequest = this.getSplitAndMergeConfigRuleRequest(ordSalesbillVO, ConfigTypeEnum.SPLIT_CONFIG_TYPE);
        try {
            msResponse = this.invoiceSplitConfigClient.getOptimalMatchConfig(msConfigQueryRequest);
        }
        catch (Exception e) {
            this.logger.warn("getInvoiceSplitRule--exception msg:{}", (Object)e.getMessage());
            throw new RuntimeException(String.format("\u5355\u636e\u3010%s\u3011\u83b7\u53d6\u6700\u4f18\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.", ordSalesbillVO.getSalesbillId()));
        }
        if (Objects.isNull(msResponse) || Objects.isNull(msResponse.getResult()) || msResponse.getCode().intValue() == Response.Fail.intValue()) {
            this.logger.warn("\u83b7\u53d6\u6700\u4f18\u62c6\u5206\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.");
            return null;
        }
        String itemListString = (String)msResponse.getResult();
        List<MsConfigItemBean> itemList = JsonUtils.writeFastJsonToListObject(itemListString, MsConfigItemBean.class);
        BaseRuleBean baseRuleBean = configParser.parse(itemList);
        return baseRuleBean;
    }

    @Cacheable(cacheNames={"PHOENIX_BILL_CONFIG_CACHE_GET_INVOICE_SPLIT_RULE"}, key="#root.args[0] + #root.methodName")
    public BaseRuleBean getInvoiceSplitRuleByRuleId(long ruleId, ConfigParser configParser) {
        MsConfigItemResponse itemResponse;
        BaseRuleBean baseRuleBean = null;
        MsConfigItemQueryRequest itemRequest = new MsConfigItemQueryRequest();
        itemRequest.setConfigId(String.valueOf(ruleId));
        try {
            itemResponse = this.configApiClient.queryConfigDetailRule(itemRequest);
        }
        catch (Exception e) {
            this.logger.warn("getInvoiceSplitRuleByRuleId--exception msg:{}", (Object)e.getMessage());
            throw new RuntimeException(String.format("LocalConfigMetadataCacheManager----getInvoiceSplitRuleByRuleId--ruleId:\u3010%s\u3011 is null", ruleId));
        }
        if (Objects.isNull(itemResponse) || Objects.isNull(itemResponse.getResult()) || itemResponse.getCode().intValue() == Response.Fail.intValue()) {
            this.logger.warn("\u83b7\u53d6\u6700\u4f18\u89c4\u5219\u914d\u7f6e\u9879\u4e3a\u7a7a.");
            return null;
        }
        List item = itemResponse.getResult();
        if (CollectionUtils.isNotEmpty((Collection)item)) {
            baseRuleBean = configParser.parse(item);
        }
        return baseRuleBean;
    }

    private MsConfigQueryRequest getMsConfigQueryRequest(ConfigRequestModel configRequestModel, ConfigTypeEnum configTypeEnum) {
        Integer configType = configTypeEnum.getConfigType();
        MsConfigQueryRequest request = new MsConfigQueryRequest();
        BeanUtils.copyProperties(configRequestModel, request);
        request.setSalesbillType(configRequestModel.getSalesbillType());
        request.setConfigType(configType);
        request.setSellerTaxNo(configRequestModel.getSellerTaxNo());
        request.setPurchaserTaxNo(configRequestModel.getPurchaserTaxNo());
        return request;
    }

    private MsConfigQueryRequest getSplitAndMergeConfigRuleRequest(OrdSalesbillVO source, ConfigTypeEnum configTypeEnum) {
        MsConfigQueryRequest target = new MsConfigQueryRequest();
        target.setBusinessBillType(source.getBusinessBillType());
        target.setSalesbillType(source.getSalesbillType());
        target.setSellerGroupId(source.getSellerGroupId());
        target.setSellerName(source.getSellerName());
        target.setSellerTaxNo(source.getSellerTaxNo());
        target.setSellerNo(source.getSellerNo());
        target.setPurchaserGroupId(source.getPurchaserGroupId());
        target.setPurchaserName(source.getPurchaserName());
        target.setPurchaserTaxNo(source.getPurchaserTaxNo());
        target.setPurchaserNo(source.getPurchaserNo());
        target.setInvoiceType(source.getInvoiceType() == null ? null : Lists.newArrayList((Object[])new String[]{source.getInvoiceType()}));
        target.setConfigType(configTypeEnum.getConfigType());
        target.setExt1(source.getExt1());
        target.setExt2(source.getExt2());
        target.setExt3(source.getExt3());
        target.setExt4(source.getExt4());
        target.setExt5(source.getExt5());
        target.setExt6(source.getExt6());
        target.setExt7(source.getExt7());
        target.setExt8(source.getExt8());
        target.setExt9(source.getExt9());
        target.setExt10(source.getExt10());
        target.setExt11(source.getExt11());
        target.setExt12(source.getExt12());
        target.setExt13(source.getExt13());
        target.setExt14(source.getExt14());
        target.setExt15(source.getExt15());
        target.setExt16(source.getExt16());
        target.setExt17(source.getExt17());
        target.setExt18(source.getExt18());
        target.setExt19(source.getExt19());
        target.setExt20(source.getExt20());
        target.setExt21(source.getExt21());
        target.setExt22(source.getExt22());
        target.setExt23(source.getExt23());
        target.setExt24(source.getExt24());
        target.setExt25(source.getExt25());
        return target;
    }

    public String getSalesBillTypeId(List<MsGroupTypeBean> groupTypeBeans, String salesBillType) {
        if (CommonTools.isEmpty(groupTypeBeans)) {
            return "";
        }
        for (int i = 0; i < groupTypeBeans.size(); ++i) {
            MsGroupTypeBean msGroupTypeBean = groupTypeBeans.get(i);
            if (!salesBillType.equals(msGroupTypeBean.getObjType())) continue;
            return msGroupTypeBean.getObjId();
        }
        return "";
    }
}

