/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.component.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.component.AddHistoryLog;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryTargetType;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillHistoryDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryDetailEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.coderbee.mybatis.batch.BatchParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="splitHistoryLog")
public class SplitHistoryLogImpl
implements AddHistoryLog {
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private OrdSalesbillHistoryDao ordSalesbillHistoryDao;
    @Autowired
    private SalesBillBatchDao billBatchDao;
    public static final String SPLIT_FORMAT_STR = "\u3010%s\u3011(%s)\u62c6\u5206\u4e3a2\u6761\uff0c\u5206\u522b\u4e3a(%s)\u3001(%s)";
    public static final String MERGE_FORMAT_STR = "\u7531\u3010%s\u3011\u5408\u5e76\u4e3a\u4e00\u6761";
    public static final String ROLLBACK_FORMAT_STR = "\u64cd\u4f5c %s \u56de\u64a4\u64cd\u4f5c";

    @Override
    public void addLog(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean, UserInfo userInfo, Long operationId) {
        List<OrdSalesbillItemEntity> sourceList = splitAndMergeLogOperationBean.getSourceList();
        Long historyId = this.idGenerator.nextId();
        if (!CollectionUtils.isEmpty(sourceList)) {
            OrdSalesbillHistoryDetailEntity historyDetail;
            OrdSalesbillItemEntity source = sourceList.get(0);
            OrdSalesbillHistoryEntity ordSalesbillHistoryEntity = new OrdSalesbillHistoryEntity();
            ordSalesbillHistoryEntity.setSalesbillHistoryId(historyId);
            ordSalesbillHistoryEntity.setCreateTime(new Date());
            ordSalesbillHistoryEntity.setOpreateUserName(userInfo.getUserName());
            ordSalesbillHistoryEntity.setOperateUserId(userInfo.getUserId());
            ordSalesbillHistoryEntity.setCreateUser(userInfo.getUserId());
            ordSalesbillHistoryEntity.setAction(splitAndMergeLogOperationBean.getBillItemOperation().getDesc());
            ordSalesbillHistoryEntity.setActionBatch(operationId);
            ordSalesbillHistoryEntity.setCreateUser(splitAndMergeLogOperationBean.getUserId());
            ordSalesbillHistoryEntity.setOperateTime(ordSalesbillHistoryEntity.getCreateTime());
            ordSalesbillHistoryEntity.setOperateStatus(BillHistoryStatus.NORMAL.value());
            String desc = this.spellHistoryDesc(splitAndMergeLogOperationBean);
            ordSalesbillHistoryEntity.setOperateContext(desc);
            ordSalesbillHistoryEntity.setCustomerNo(source.getCustomerNo());
            ordSalesbillHistoryEntity.setSourceSalesbillId(source.getSalesbillId());
            ordSalesbillHistoryEntity.setTargetSalesbillId(source.getSalesbillId());
            this.ordSalesbillHistoryDao.insertSelective(ordSalesbillHistoryEntity);
            BillOperationType billItemOperation = splitAndMergeLogOperationBean.getBillItemOperation();
            List<OrdSalesbillItemEntity> targetList = splitAndMergeLogOperationBean.getTargetList();
            int sort = 0;
            ArrayList historyDetails = Lists.newArrayList();
            for (OrdSalesbillItemEntity ordSalesbillItemEntity : sourceList) {
                historyDetail = this.createHistoryDetail(ordSalesbillItemEntity, userInfo, operationId, historyId, billItemOperation.value(), ++sort, String.valueOf(SalesBillStatus.NORMAL.value()), String.valueOf(SalesBillStatus.DELETED.value()));
                historyDetails.add(historyDetail);
            }
            for (OrdSalesbillItemEntity ordSalesbillItemEntity : targetList) {
                historyDetail = this.createHistoryDetail(ordSalesbillItemEntity, userInfo, operationId, historyId, billItemOperation.value(), sort, String.valueOf(SalesBillStatus.DELETED.value()), String.valueOf(SalesBillStatus.NORMAL.value()));
                historyDetails.add(historyDetail);
            }
            this.billBatchDao.historyDetailBatchInsert((BatchParameter<OrdSalesbillHistoryDetailEntity>)BatchParameter.wrap((List)historyDetails));
        }
    }

    public OrdSalesbillHistoryDetailEntity createHistoryDetail(OrdSalesbillItemEntity ordSalesbillItemEntity, UserInfo userInfo, Long actionBatch, Long historyId, Integer actionType, Integer sort, String oldValue, String newValue) {
        OrdSalesbillHistoryDetailEntity ordSalesbillHistoryDetailEntity = new OrdSalesbillHistoryDetailEntity();
        ordSalesbillHistoryDetailEntity.setOrdSalesbillHistoryId(historyId);
        ordSalesbillHistoryDetailEntity.setCreateTime(new Date());
        ordSalesbillHistoryDetailEntity.setSalesbillHistoryDetailId(this.idGenerator.nextId());
        ordSalesbillHistoryDetailEntity.setActionBatch(actionBatch);
        ordSalesbillHistoryDetailEntity.setActionType(actionType);
        ordSalesbillHistoryDetailEntity.setFieldCname("\u72b6\u6001");
        ordSalesbillHistoryDetailEntity.setOldValue(oldValue);
        ordSalesbillHistoryDetailEntity.setNewValue(newValue);
        ordSalesbillHistoryDetailEntity.setFieldEname("status");
        ordSalesbillHistoryDetailEntity.setTargetId(ordSalesbillItemEntity.getSalesbillItemId());
        ordSalesbillHistoryDetailEntity.setTargetType(BillHistoryTargetType.BILL_ITEM.value());
        ordSalesbillHistoryDetailEntity.setActionSort(sort);
        ordSalesbillHistoryDetailEntity.setCustomerNo(ordSalesbillItemEntity.getCustomerNo() != null ? ordSalesbillItemEntity.getCustomerNo() : "");
        ordSalesbillHistoryDetailEntity.setSellerTenantId(0L);
        ordSalesbillHistoryDetailEntity.setPurchaserTenantId(0L);
        ordSalesbillHistoryDetailEntity.setCreateUser(userInfo.getUserId());
        return ordSalesbillHistoryDetailEntity;
    }

    private String spellHistoryDesc(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean) {
        BillOperationType billItemOperation = splitAndMergeLogOperationBean.getBillItemOperation();
        List<OrdSalesbillItemEntity> targetList = splitAndMergeLogOperationBean.getTargetList();
        List<OrdSalesbillItemEntity> sourceList = splitAndMergeLogOperationBean.getSourceList();
        String desc = "";
        switch (billItemOperation) {
            case MERGE: {
                OrdSalesbillItemEntity entity = targetList.get(0);
                desc = String.format(MERGE_FORMAT_STR, sourceList.size());
                break;
            }
            case SPLIT: {
                OrdSalesbillItemEntity itemEntity = sourceList.get(0);
                String itemName = itemEntity.getItemName();
                BigDecimal amountWithTax = itemEntity.getAmountWithTax();
                OrdSalesbillItemEntity targetItem1 = targetList.get(0);
                OrdSalesbillItemEntity targetItem2 = targetList.get(1);
                desc = String.format(SPLIT_FORMAT_STR, itemName, amountWithTax, targetItem1.getAmountWithTax(), targetItem2.getAmountWithTax());
            }
        }
        return desc;
    }
}

