/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.component.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.component.AddHistoryLog;
import com.xforceplus.phoenix.bill.component.BillHisotryBean;
import com.xforceplus.phoenix.bill.component.SplitAndMergeHistoryOperationBean;
import com.xforceplus.phoenix.bill.component.SplitMergeHistoryComponent;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryStatus;
import com.xforceplus.phoenix.bill.constant.enums.BillHistoryTargetType;
import com.xforceplus.phoenix.bill.constant.enums.BillItemOrigin;
import com.xforceplus.phoenix.bill.constant.enums.BillOperationType;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillHistoryDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillHistoryDetailDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillSourceRelDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillSourceRollbackLogDao;
import com.xforceplus.phoenix.bill.repository.daoext.SalesBillBatchDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillHistoryEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillItemEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRelEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRelExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillSourceRollbackLogEntity;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.JsonUtils;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class SplitMergeHistoryComponentImpl
implements SplitMergeHistoryComponent {
    private static final Logger logger = LoggerFactory.getLogger(SplitMergeHistoryComponentImpl.class);
    private OrdSalesbillHistoryDao ordSalesbillHistoryDao;
    private OrdSalesbillHistoryDetailDao ordSalesbillHistoryDetailDao;
    private OrdSalesbillSourceRelDao ordSalesbillSourceRelDao;
    private OrdSalesbillSourceRollbackLogDao ordSalesbillSourceRollbackLogDao;
    private IDGenerator idGenerator;
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private AddHistoryLog updateHistoryLog;
    @Autowired
    private AddHistoryLog splitHistoryLog;
    @Autowired
    private AddHistoryLog mergeHistoryLog;
    @Autowired
    OrdSalesbillDao ordSalesbillDao;
    @Autowired
    private SalesBillBatchDao billBatchDao;
    public static final String SPLIT_FORMAT_STR = "\u3010%s\u3011(%s)\u62c6\u5206\u4e3a2\u6761\uff0c\u5206\u522b\u4e3a(%s)\u3001(%s)";
    public static final String MERGE_FORMAT_STR = "\u7531\u3010%s\u3011\u5408\u5e76\u4e3a\u4e00\u6761";
    public static final String ROLLBACK_FORMAT_STR = "\u64cd\u4f5c %s \u56de\u64a4\u64cd\u4f5c";

    public SplitMergeHistoryComponentImpl(OrdSalesbillHistoryDao ordSalesbillHistoryDao, OrdSalesbillHistoryDetailDao ordSalesbillHistoryDetailDao, OrdSalesbillSourceRelDao ordSalesbillSourceRelDao, OrdSalesbillSourceRollbackLogDao ordSalesbillSourceRollbackLogDao, IDGenerator idGenerator, UserInfoHolder<UserInfo> userInfoHolder) {
        this.ordSalesbillHistoryDao = ordSalesbillHistoryDao;
        this.ordSalesbillHistoryDetailDao = ordSalesbillHistoryDetailDao;
        this.ordSalesbillSourceRelDao = ordSalesbillSourceRelDao;
        this.ordSalesbillSourceRollbackLogDao = ordSalesbillSourceRollbackLogDao;
        this.idGenerator = idGenerator;
        this.userInfoHolder = userInfoHolder;
        this.updateHistoryLog = this.updateHistoryLog;
    }

    @Override
    @Transactional
    public void billHitoryOper(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean) {
        UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
        BillOperationType billItemOperation = splitAndMergeLogOperationBean.getBillItemOperation();
        Long operationId = this.idGenerator.nextId();
        splitAndMergeLogOperationBean.getBillTarge();
        List<OrdSalesbillItemEntity> targetList = splitAndMergeLogOperationBean.getTargetList();
        List<OrdSalesbillItemEntity> sourceList = splitAndMergeLogOperationBean.getSourceList();
        logger.info("==================\u8bb0\u5f55\u5386\u53f2\u7684request-{}=userInfo-{}=operationId-{}================", new Object[]{JsonUtils.writeObjectToFastJson(splitAndMergeLogOperationBean), JsonUtils.writeObjectToFastJson(userInfo), operationId});
        if (billItemOperation == BillOperationType.AUTO_CONFIRM || billItemOperation == BillOperationType.CONFIRM || billItemOperation == BillOperationType.REJECT || billItemOperation == BillOperationType.ROLL_BACK) {
            this.addBillHistoryBatch(splitAndMergeLogOperationBean.getHisotryBeans(), userInfo);
            return;
        }
        if (billItemOperation == BillOperationType.UPDATE) {
            this.updateHistoryLog.addLog(splitAndMergeLogOperationBean, userInfo, operationId);
        } else if (billItemOperation == BillOperationType.SPLIT) {
            this.splitHistoryLog.addLog(splitAndMergeLogOperationBean, userInfo, operationId);
            this.createHistorySourceRel(splitAndMergeLogOperationBean, operationId);
        } else if (billItemOperation == BillOperationType.MERGE) {
            this.mergeHistoryLog.addLog(splitAndMergeLogOperationBean, userInfo, operationId);
            this.createHistorySourceRel(splitAndMergeLogOperationBean, operationId);
        }
    }

    private void addBillHistory(BillHisotryBean tmp, UserInfo userInfo) {
        OrdSalesbillHistoryEntity ordSalesbillHistoryEntity = new OrdSalesbillHistoryEntity();
        ordSalesbillHistoryEntity.setSalesbillHistoryId(this.idGenerator.nextId());
        ordSalesbillHistoryEntity.setTargetSalesbillId(tmp.getSourceId());
        ordSalesbillHistoryEntity.setCreateTime(new Date());
        ordSalesbillHistoryEntity.setAction(tmp.getBillItemOperation().getDesc());
        ordSalesbillHistoryEntity.setActionBatch(this.idGenerator.nextId());
        ordSalesbillHistoryEntity.setCreateUser(tmp.getUserId());
        ordSalesbillHistoryEntity.setOperateTime(ordSalesbillHistoryEntity.getCreateTime());
        ordSalesbillHistoryEntity.setOperateStatus(BillHistoryStatus.NORMAL.value());
        ordSalesbillHistoryEntity.setOperateContext(tmp.getDesc());
        ordSalesbillHistoryEntity.setSourceSalesbillId(tmp.getSourceId());
        ordSalesbillHistoryEntity.setOpreateUserName(userInfo.getUserName());
        ordSalesbillHistoryEntity.setOperateUserId(tmp.getUserId());
        ordSalesbillHistoryEntity.setCustomerNo("");
        this.ordSalesbillHistoryDao.insertSelective(ordSalesbillHistoryEntity);
    }

    private void addBillHistoryBatch(List<BillHisotryBean> hisotryBeans, UserInfo userInfo) {
        for (BillHisotryBean tmp : hisotryBeans) {
            this.addBillHistory(tmp, userInfo);
        }
    }

    private void createHistorySourceRel(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean, Long actionBatch) {
        BillOperationType billItemOperation = splitAndMergeLogOperationBean.getBillItemOperation();
        List<OrdSalesbillItemEntity> targetList = splitAndMergeLogOperationBean.getTargetList();
        List<OrdSalesbillItemEntity> sourceList = splitAndMergeLogOperationBean.getSourceList();
        if (billItemOperation == BillOperationType.MERGE) {
            this.getMergeOriginalBill(splitAndMergeLogOperationBean, actionBatch);
            return;
        }
        List<OrdSalesbillSourceRelEntity> ordSalesbillSourceRelEntities = this.getOriginalBill(sourceList, billItemOperation, actionBatch);
        this.recodeSourceData(ordSalesbillSourceRelEntities, targetList, billItemOperation, actionBatch);
    }

    public List<OrdSalesbillSourceRelEntity> getOriginalBill(List<OrdSalesbillItemEntity> sourceList, BillOperationType billOperationType, Long actionBatch) {
        ArrayList result = Lists.newArrayList();
        if (billOperationType == BillOperationType.SPLIT) {
            if (CollectionUtils.isEmpty(sourceList)) {
                String msg = "\u8bb0\u5f55\u6eaf\u6e90\u8868,\u62c6\u5206\u7684\u6e90\u5355\u636e\u4f20\u5165\u4e3a\u7a7a,\u8bf7\u68c0\u67e5";
                logger.info(msg);
                throw new RuntimeException(msg);
            }
            OrdSalesbillItemEntity source = sourceList.get(0);
            OrdSalesbillEntity ordSalesbillEntity = this.ordSalesbillDao.selectByPrimaryKey(source.getSalesbillId());
            String salesbillNo = ordSalesbillEntity.getSalesbillNo();
            int rel_sort = 0;
            if (BillItemOrigin.ORIGINAL.value().equals(source.getOrigin())) {
                Long sourceSalesbillRelId = this.idGenerator.nextId();
                OrdSalesbillSourceRelEntity ordSalesbillSourceRelEntity = new OrdSalesbillSourceRelEntity();
                ordSalesbillSourceRelEntity.setSourceSalesbillRelId(sourceSalesbillRelId);
                ordSalesbillSourceRelEntity.setTargetSalesbillId(source.getSalesbillId());
                ordSalesbillSourceRelEntity.setTargetSalesbillItemId(source.getSalesbillItemId());
                ordSalesbillSourceRelEntity.setSourceSalesbillId(0L);
                ordSalesbillSourceRelEntity.setSourceSalesbillItemId(0L);
                ordSalesbillSourceRelEntity.setActionBatch(actionBatch);
                ordSalesbillSourceRelEntity.setSalesbillNo(salesbillNo);
                ordSalesbillSourceRelEntity.setDeductions(source.getDeductions());
                ordSalesbillSourceRelEntity.setInnerDiscountTax(source.getInnerDiscountTax());
                ordSalesbillSourceRelEntity.setInnerDiscountWithoutTax(source.getInnerDiscountWithoutTax());
                ordSalesbillSourceRelEntity.setInnerDiscountWithTax(source.getInnerDiscountWithTax());
                ordSalesbillSourceRelEntity.setInnerPrepayAmountTax(source.getInnerPrepayAmountTax());
                ordSalesbillSourceRelEntity.setInnerPrepayAmountWithTax(source.getInnerPrepayAmountWithTax());
                ordSalesbillSourceRelEntity.setInnerPrepayAmountWithoutTax(source.getInnerPrepayAmountWithoutTax());
                ordSalesbillSourceRelEntity.setOutterDiscountTax(source.getOutterDiscountTax());
                ordSalesbillSourceRelEntity.setOutterDiscountWithoutTax(source.getOutterDiscountWithoutTax());
                ordSalesbillSourceRelEntity.setOutterDiscountWithTax(source.getOutterDiscountWithTax());
                ordSalesbillSourceRelEntity.setOutterPrepayAmountTax(source.getOutterPrepayAmountTax());
                ordSalesbillSourceRelEntity.setOutterPrepayAmountWithTax(source.getOutterPrepayAmountWithTax());
                ordSalesbillSourceRelEntity.setOutterPrepayAmountWithoutTax(source.getOutterPrepayAmountWithoutTax());
                ordSalesbillSourceRelEntity.setSourceTaxAmount(source.getTaxAmount());
                ordSalesbillSourceRelEntity.setSourceAmountWithoutTax(source.getAmountWithoutTax());
                ordSalesbillSourceRelEntity.setSourceAmountWithTax(source.getAmountWithTax());
                ordSalesbillSourceRelEntity.setRelType(billOperationType.value());
                ordSalesbillSourceRelEntity.setRelStatus(1);
                ordSalesbillSourceRelEntity.setCustomerNo("");
                ordSalesbillSourceRelEntity.setCreateTime(new Date());
                ordSalesbillSourceRelEntity.setCreateUser(0L);
                ordSalesbillSourceRelEntity.setTenantId(0L);
                result.add(ordSalesbillSourceRelEntity);
                this.ordSalesbillSourceRelDao.insertSelective(ordSalesbillSourceRelEntity);
                OrdSalesbillSourceRollbackLogEntity ordSalesbillSourceRollbackLogEntity = new OrdSalesbillSourceRollbackLogEntity();
                ordSalesbillSourceRollbackLogEntity.setOldValue(String.valueOf(BillHistoryStatus.ROLL_BACK.value()));
                ordSalesbillSourceRollbackLogEntity.setNewValue(String.valueOf(BillHistoryStatus.NORMAL.value()));
                ordSalesbillSourceRollbackLogEntity.setId(this.idGenerator.nextId());
                ordSalesbillSourceRollbackLogEntity.setFieldEname("rel_status");
                ordSalesbillSourceRollbackLogEntity.setTargetId(ordSalesbillSourceRelEntity.getSourceSalesbillRelId());
                ordSalesbillSourceRollbackLogEntity.setCreateTime(new Date());
                ordSalesbillSourceRollbackLogEntity.setTargetType(BillHistoryTargetType.BILL_SOURCE_REL.value());
                ordSalesbillSourceRollbackLogEntity.setActionSort(rel_sort++);
                ordSalesbillSourceRollbackLogEntity.setFieldCname("\u72b6\u6001");
                ordSalesbillSourceRollbackLogEntity.setActionBatch(actionBatch);
                ordSalesbillSourceRollbackLogEntity.setTenantId(0L);
                ordSalesbillSourceRollbackLogEntity.setCreateUser(0L);
                ordSalesbillSourceRollbackLogEntity.setActionType(billOperationType.value());
                this.ordSalesbillSourceRollbackLogDao.insertSelective(ordSalesbillSourceRollbackLogEntity);
            } else {
                OrdSalesbillSourceRelExample example = new OrdSalesbillSourceRelExample();
                example.createCriteria().andTargetSalesbillItemIdEqualTo(source.getSalesbillItemId()).andRelStatusEqualTo(StatusEnum.NORMAL.getStatus());
                List<OrdSalesbillSourceRelEntity> curentSalesbillSourceRelEntities = this.ordSalesbillSourceRelDao.selectByExample(example);
                if (CollectionUtils.isEmpty(curentSalesbillSourceRelEntities)) {
                    String msg = "\u8bb0\u5f55\u6eaf\u6e90\u8868,\u62c6\u5206\u65f6,sourceList,\u5728\u6eaf\u6e90\u8868\u4e2d\u8bb0\u5f55\u4e0d\u5b58\u5728";
                    logger.info(msg);
                    throw new RuntimeException(msg);
                }
                OrdSalesbillSourceRelEntity ordSalesbillSourceRelEntity = curentSalesbillSourceRelEntities.get(0);
                example.createCriteria().andTargetSalesbillItemIdEqualTo(ordSalesbillSourceRelEntity.getSourceSalesbillItemId()).andRelStatusEqualTo(StatusEnum.NORMAL.getStatus());
                List<OrdSalesbillSourceRelEntity> originSalesbillSourceRelEntities = this.ordSalesbillSourceRelDao.selectByExample(example);
                result.addAll(originSalesbillSourceRelEntities);
                int sort = 0;
                for (OrdSalesbillSourceRelEntity tmp : curentSalesbillSourceRelEntities) {
                    OrdSalesbillSourceRollbackLogEntity ordSalesbillSourceRollbackLogEntity = new OrdSalesbillSourceRollbackLogEntity();
                    ordSalesbillSourceRollbackLogEntity.setActionBatch(actionBatch);
                    ordSalesbillSourceRollbackLogEntity.setOldValue(String.valueOf(BillHistoryStatus.NORMAL.value()));
                    ordSalesbillSourceRollbackLogEntity.setNewValue(String.valueOf(BillHistoryStatus.ROLL_BACK.value()));
                    ordSalesbillSourceRollbackLogEntity.setId(this.idGenerator.nextId());
                    ordSalesbillSourceRollbackLogEntity.setFieldEname("rel_status");
                    ordSalesbillSourceRollbackLogEntity.setTargetId(tmp.getSourceSalesbillRelId());
                    ordSalesbillSourceRollbackLogEntity.setCreateTime(new Date());
                    ordSalesbillSourceRollbackLogEntity.setTargetType(BillHistoryTargetType.BILL_SOURCE_REL.value());
                    ordSalesbillSourceRollbackLogEntity.setActionSort(sort++);
                    ordSalesbillSourceRollbackLogEntity.setFieldCname("\u72b6\u6001");
                    ordSalesbillSourceRollbackLogEntity.setTenantId(0L);
                    ordSalesbillSourceRollbackLogEntity.setCreateUser(0L);
                    ordSalesbillSourceRollbackLogEntity.setActionType(billOperationType.value());
                    this.ordSalesbillSourceRollbackLogDao.insertSelective(ordSalesbillSourceRollbackLogEntity);
                }
            }
        }
        return result;
    }

    private void recodeSourceData(List<OrdSalesbillSourceRelEntity> ordSalesbillSourceRelEntities, List<OrdSalesbillItemEntity> targetList, BillOperationType billOperationType, Long actionBatch) {
        ArrayList result = Lists.newArrayList();
        for (OrdSalesbillSourceRelEntity ordSalesbillSourceRelEntity : ordSalesbillSourceRelEntities) {
            for (OrdSalesbillItemEntity ordSalesbillItemEntity : targetList) {
                OrdSalesbillSourceRelEntity tmpSoruceRel = new OrdSalesbillSourceRelEntity();
                if (billOperationType.value().intValue() == BillOperationType.SPLIT.value().intValue()) {
                    tmpSoruceRel.setSourceSalesbillRelId(this.idGenerator.nextId());
                    tmpSoruceRel.setTargetSalesbillId(ordSalesbillItemEntity.getSalesbillId());
                    tmpSoruceRel.setSourceSalesbillId(ordSalesbillItemEntity.getSalesbillId());
                    tmpSoruceRel.setSourceSalesbillItemId(ordSalesbillSourceRelEntity.getTargetSalesbillItemId());
                    tmpSoruceRel.setTargetSalesbillItemId(ordSalesbillItemEntity.getSalesbillItemId());
                    tmpSoruceRel.setActionBatch(actionBatch);
                    tmpSoruceRel.setSalesbillNo(ordSalesbillSourceRelEntity.getSalesbillNo());
                    tmpSoruceRel.setDeductions(ordSalesbillItemEntity.getDeductions());
                    tmpSoruceRel.setInnerDiscountTax(ordSalesbillItemEntity.getInnerDiscountTax());
                    tmpSoruceRel.setInnerDiscountWithoutTax(ordSalesbillItemEntity.getInnerDiscountWithoutTax());
                    tmpSoruceRel.setInnerPrepayAmountTax(ordSalesbillItemEntity.getInnerPrepayAmountTax());
                    tmpSoruceRel.setInnerPrepayAmountWithTax(ordSalesbillItemEntity.getInnerPrepayAmountWithTax());
                    tmpSoruceRel.setInnerDiscountWithTax(ordSalesbillItemEntity.getInnerDiscountWithTax());
                    tmpSoruceRel.setInnerPrepayAmountWithoutTax(ordSalesbillItemEntity.getInnerPrepayAmountWithoutTax());
                    tmpSoruceRel.setOutterDiscountTax(ordSalesbillItemEntity.getOutterDiscountTax());
                    tmpSoruceRel.setOutterDiscountWithoutTax(ordSalesbillItemEntity.getOutterDiscountWithoutTax());
                    tmpSoruceRel.setOutterDiscountWithTax(ordSalesbillItemEntity.getOutterDiscountWithTax());
                    tmpSoruceRel.setOutterPrepayAmountTax(ordSalesbillItemEntity.getOutterPrepayAmountTax());
                    tmpSoruceRel.setOutterPrepayAmountWithTax(ordSalesbillItemEntity.getOutterPrepayAmountWithTax());
                    tmpSoruceRel.setOutterPrepayAmountWithoutTax(ordSalesbillItemEntity.getOutterPrepayAmountWithoutTax());
                    tmpSoruceRel.setSourceAmountWithoutTax(ordSalesbillItemEntity.getAmountWithoutTax());
                    tmpSoruceRel.setSourceAmountWithTax(ordSalesbillItemEntity.getAmountWithTax());
                    tmpSoruceRel.setSourceTaxAmount(ordSalesbillItemEntity.getTaxAmount());
                    ordSalesbillSourceRelEntity.setRelType(billOperationType.value());
                    ordSalesbillSourceRelEntity.setRelStatus(1);
                    ordSalesbillSourceRelEntity.setCustomerNo("");
                    ordSalesbillSourceRelEntity.setCreateTime(new Date());
                    ordSalesbillSourceRelEntity.setCreateUser(0L);
                    ordSalesbillSourceRelEntity.setTenantId(0L);
                }
                result.add(tmpSoruceRel);
            }
        }
        int sort = 0;
        for (OrdSalesbillSourceRelEntity tmp : result) {
            OrdSalesbillSourceRollbackLogEntity ordSalesbillSourceRollbackLogEntity = new OrdSalesbillSourceRollbackLogEntity();
            ordSalesbillSourceRollbackLogEntity.setActionBatch(actionBatch);
            ordSalesbillSourceRollbackLogEntity.setOldValue(String.valueOf(BillHistoryStatus.ROLL_BACK.value()));
            ordSalesbillSourceRollbackLogEntity.setNewValue(String.valueOf(BillHistoryStatus.NORMAL.value()));
            ordSalesbillSourceRollbackLogEntity.setId(this.idGenerator.nextId());
            ordSalesbillSourceRollbackLogEntity.setFieldEname("rel_status");
            ordSalesbillSourceRollbackLogEntity.setTargetId(tmp.getSourceSalesbillRelId());
            ordSalesbillSourceRollbackLogEntity.setCreateTime(new Date());
            ordSalesbillSourceRollbackLogEntity.setTargetType(BillHistoryTargetType.BILL_SOURCE_REL.value());
            ordSalesbillSourceRollbackLogEntity.setActionSort(sort++);
            ordSalesbillSourceRollbackLogEntity.setFieldCname("\u72b6\u6001");
            ordSalesbillSourceRollbackLogEntity.setTenantId(0L);
            ordSalesbillSourceRollbackLogEntity.setCreateUser(0L);
            ordSalesbillSourceRollbackLogEntity.setActionType(billOperationType.value());
            this.ordSalesbillSourceRollbackLogDao.insertSelective(ordSalesbillSourceRollbackLogEntity);
            this.ordSalesbillSourceRelDao.insertSelective(tmp);
        }
    }

    public void getMergeOriginalBill(SplitAndMergeHistoryOperationBean splitAndMergeLogOperationBean, Long actionBatch) {
        OrdSalesbillEntity billTarge = splitAndMergeLogOperationBean.getBillTarge();
        List<OrdSalesbillItemEntity> sourceList = splitAndMergeLogOperationBean.getSourceList();
        List<OrdSalesbillItemEntity> targetList = splitAndMergeLogOperationBean.getTargetList();
        BillOperationType billItemOperation = splitAndMergeLogOperationBean.getBillItemOperation();
        ArrayList sourceRelEntities = Lists.newArrayList();
        ArrayList sourceRollbackLogEntities = Lists.newArrayList();
        ArrayList originSourceList = Lists.newArrayList();
        ArrayList notOriginSourceList = Lists.newArrayList();
        for (int i = 0; i < sourceList.size(); ++i) {
            Integer origin = sourceList.get(i).getOrigin();
            if (BillItemOrigin.ORIGINAL.value().equals(origin)) {
                originSourceList.add(sourceList.get(i));
                continue;
            }
            notOriginSourceList.add(sourceList.get(i));
        }
        if (!CommonTools.isEmpty(notOriginSourceList)) {
            List<Long> salesBillItemIds = notOriginSourceList.stream().map(m -> m.getSalesbillItemId()).collect(Collectors.toList());
            List<OrdSalesbillSourceRelEntity> sourceRelList = this.getSourceRelList(salesBillItemIds, billItemOperation, actionBatch, sourceRollbackLogEntities);
            for (int i = 0; i < sourceRelList.size(); ++i) {
                OrdSalesbillSourceRelEntity sourceRelEntity = sourceRelList.get(i);
                for (int j = 0; j < targetList.size(); ++j) {
                    OrdSalesbillItemEntity target = targetList.get(j);
                    Long targetSalesBillId = target.getSalesbillId();
                    Long targetSalesbillItemId = target.getSalesbillItemId();
                    OrdSalesbillItemEntity source = new OrdSalesbillItemEntity();
                    BeanUtils.copyProperties((Object)sourceRelEntity, (Object)source);
                    OrdSalesbillSourceRelEntity ordSalesbillSourceRelEntity = this.SpellSourceRel(source, targetSalesBillId, targetSalesbillItemId, billItemOperation, actionBatch);
                    sourceRelEntities.add(ordSalesbillSourceRelEntity);
                }
            }
        }
        boolean rel_sort = false;
        for (int i = 0; i < originSourceList.size(); ++i) {
            OrdSalesbillItemEntity source = (OrdSalesbillItemEntity)((Object)originSourceList.get(i));
            for (int j = 0; j < targetList.size(); ++j) {
                OrdSalesbillItemEntity target = targetList.get(j);
                Long targetSalesBillId = target.getSalesbillId();
                Long targetSalesbillItemId = target.getSalesbillItemId();
                OrdSalesbillSourceRelEntity ordSalesbillSourceRelEntity = this.SpellSourceRel(source, targetSalesBillId, targetSalesbillItemId, billItemOperation, actionBatch);
                sourceRelEntities.add(ordSalesbillSourceRelEntity);
                Long sourceSalesBillId = source.getSalesbillId();
                Long sourceSalesBillItemId = source.getSalesbillItemId();
                source.setSalesbillId(0L);
                source.setSalesbillItemId(0L);
                sourceRelEntities.add(this.SpellSourceRel(source, sourceSalesBillId, sourceSalesBillItemId, billItemOperation, actionBatch));
            }
        }
        for (OrdSalesbillSourceRelEntity tmp : sourceRelEntities) {
            OrdSalesbillSourceRollbackLogEntity rollbackLogEntity = this.spellSourceRollBack(tmp, billItemOperation, actionBatch);
            sourceRollbackLogEntities.add(rollbackLogEntity);
        }
        this.billBatchDao.billSourceRelBatchInsert((BatchParameter<OrdSalesbillSourceRelEntity>)BatchParameter.wrap((List)sourceRelEntities));
        this.billBatchDao.billSourceRollbackLogBatchInsert((BatchParameter<OrdSalesbillSourceRollbackLogEntity>)BatchParameter.wrap((List)sourceRollbackLogEntities));
    }

    private OrdSalesbillSourceRelEntity SpellSourceRel(OrdSalesbillItemEntity source, Long targetSalesBillId, Long targetSalesBillItemId, BillOperationType billOperationType, Long actionBatch) {
        long sourceSalesbillRelId = this.idGenerator.nextId();
        OrdSalesbillSourceRelEntity ordSalesbillSourceRelEntity = new OrdSalesbillSourceRelEntity();
        ordSalesbillSourceRelEntity.setSourceSalesbillRelId(sourceSalesbillRelId);
        ordSalesbillSourceRelEntity.setTargetSalesbillId(targetSalesBillId);
        ordSalesbillSourceRelEntity.setTargetSalesbillItemId(targetSalesBillItemId);
        ordSalesbillSourceRelEntity.setSourceSalesbillId(source.getSalesbillId());
        ordSalesbillSourceRelEntity.setSourceSalesbillItemId(source.getSalesbillItemId());
        ordSalesbillSourceRelEntity.setActionBatch(actionBatch);
        ordSalesbillSourceRelEntity.setSalesbillNo(source.getSalesbillNo());
        ordSalesbillSourceRelEntity.setDeductions(source.getDeductions());
        ordSalesbillSourceRelEntity.setInnerDiscountTax(source.getInnerDiscountTax());
        ordSalesbillSourceRelEntity.setInnerDiscountWithoutTax(source.getInnerDiscountWithoutTax());
        ordSalesbillSourceRelEntity.setInnerDiscountWithTax(source.getInnerDiscountWithTax());
        ordSalesbillSourceRelEntity.setInnerPrepayAmountTax(source.getInnerPrepayAmountTax());
        ordSalesbillSourceRelEntity.setInnerPrepayAmountWithTax(source.getInnerPrepayAmountWithTax());
        ordSalesbillSourceRelEntity.setInnerPrepayAmountWithoutTax(source.getInnerPrepayAmountWithoutTax());
        ordSalesbillSourceRelEntity.setOutterDiscountTax(source.getOutterDiscountTax());
        ordSalesbillSourceRelEntity.setOutterDiscountWithoutTax(source.getOutterDiscountWithoutTax());
        ordSalesbillSourceRelEntity.setOutterDiscountWithTax(source.getOutterDiscountWithTax());
        ordSalesbillSourceRelEntity.setOutterPrepayAmountTax(source.getOutterPrepayAmountTax());
        ordSalesbillSourceRelEntity.setOutterPrepayAmountWithTax(source.getOutterPrepayAmountWithTax());
        ordSalesbillSourceRelEntity.setOutterPrepayAmountWithoutTax(source.getOutterPrepayAmountWithoutTax());
        ordSalesbillSourceRelEntity.setSourceTaxAmount(source.getTaxAmount());
        ordSalesbillSourceRelEntity.setSourceAmountWithoutTax(source.getAmountWithoutTax());
        ordSalesbillSourceRelEntity.setSourceAmountWithTax(source.getAmountWithTax());
        ordSalesbillSourceRelEntity.setRelType(billOperationType.value());
        ordSalesbillSourceRelEntity.setRelStatus(1);
        ordSalesbillSourceRelEntity.setCustomerNo("");
        ordSalesbillSourceRelEntity.setCreateTime(new Date());
        ordSalesbillSourceRelEntity.setCreateUser(0L);
        ordSalesbillSourceRelEntity.setTenantId(0L);
        return ordSalesbillSourceRelEntity;
    }

    private OrdSalesbillSourceRollbackLogEntity spellSourceRollBack(OrdSalesbillSourceRelEntity ordSalesbillSourceRelEntity, BillOperationType billOperationType, Long actionBatch) {
        int rel_sort = 0;
        OrdSalesbillSourceRollbackLogEntity ordSalesbillSourceRollbackLogEntity = new OrdSalesbillSourceRollbackLogEntity();
        ordSalesbillSourceRollbackLogEntity.setOldValue(String.valueOf(BillHistoryStatus.ROLL_BACK.value()));
        ordSalesbillSourceRollbackLogEntity.setNewValue(String.valueOf(BillHistoryStatus.NORMAL.value()));
        ordSalesbillSourceRollbackLogEntity.setId(this.idGenerator.nextId());
        ordSalesbillSourceRollbackLogEntity.setFieldEname("rel_status");
        ordSalesbillSourceRollbackLogEntity.setTargetId(ordSalesbillSourceRelEntity.getSourceSalesbillRelId());
        ordSalesbillSourceRollbackLogEntity.setCreateTime(new Date());
        ordSalesbillSourceRollbackLogEntity.setTargetType(BillHistoryTargetType.BILL_SOURCE_REL.value());
        ordSalesbillSourceRollbackLogEntity.setActionSort(rel_sort++);
        ordSalesbillSourceRollbackLogEntity.setFieldCname("\u72b6\u6001");
        ordSalesbillSourceRollbackLogEntity.setActionBatch(actionBatch);
        ordSalesbillSourceRollbackLogEntity.setTenantId(0L);
        ordSalesbillSourceRollbackLogEntity.setCreateUser(0L);
        ordSalesbillSourceRollbackLogEntity.setActionType(billOperationType.value());
        return ordSalesbillSourceRollbackLogEntity;
    }

    private List<OrdSalesbillSourceRelEntity> getSourceRelList(List<Long> salesBillItemIds, BillOperationType billOperationType, Long actionBatch, List<OrdSalesbillSourceRollbackLogEntity> sourceRollbackLogEntities) {
        OrdSalesbillSourceRelExample example = new OrdSalesbillSourceRelExample();
        example.createCriteria().andTargetSalesbillItemIdIn((List)salesBillItemIds).andRelStatusEqualTo(StatusEnum.NORMAL.getStatus());
        List<OrdSalesbillSourceRelEntity> curentSalesbillSourceRelEntities = this.ordSalesbillSourceRelDao.selectByExample(example);
        if (CollectionUtils.isEmpty(curentSalesbillSourceRelEntities)) {
            String msg = "\u8bb0\u5f55\u6eaf\u6e90\u8868,\u62c6\u5206\u65f6,sourceList,\u5728\u6eaf\u6e90\u8868\u4e2d\u8bb0\u5f55\u4e0d\u5b58\u5728";
            logger.info(msg);
            throw new RuntimeException(msg);
        }
        List sourceSalesBillItemIds = curentSalesbillSourceRelEntities.stream().map(m -> m.getSourceSalesbillItemId()).collect(Collectors.toList());
        example.createCriteria().andTargetSalesbillItemIdIn(sourceSalesBillItemIds).andRelStatusEqualTo(StatusEnum.NORMAL.getStatus());
        List<OrdSalesbillSourceRelEntity> originSalesbillSourceRelEntities = this.ordSalesbillSourceRelDao.selectByExample(example);
        int sort = 0;
        for (OrdSalesbillSourceRelEntity tmp : curentSalesbillSourceRelEntities) {
            OrdSalesbillSourceRollbackLogEntity ordSalesbillSourceRollbackLogEntity = new OrdSalesbillSourceRollbackLogEntity();
            ordSalesbillSourceRollbackLogEntity.setActionBatch(actionBatch);
            ordSalesbillSourceRollbackLogEntity.setOldValue(String.valueOf(BillHistoryStatus.NORMAL.value()));
            ordSalesbillSourceRollbackLogEntity.setNewValue(String.valueOf(BillHistoryStatus.ROLL_BACK.value()));
            ordSalesbillSourceRollbackLogEntity.setId(this.idGenerator.nextId());
            ordSalesbillSourceRollbackLogEntity.setFieldEname("rel_status");
            ordSalesbillSourceRollbackLogEntity.setTargetId(tmp.getSourceSalesbillRelId());
            ordSalesbillSourceRollbackLogEntity.setCreateTime(new Date());
            ordSalesbillSourceRollbackLogEntity.setTargetType(BillHistoryTargetType.BILL_SOURCE_REL.value());
            ordSalesbillSourceRollbackLogEntity.setActionSort(sort++);
            ordSalesbillSourceRollbackLogEntity.setFieldCname("\u72b6\u6001");
            ordSalesbillSourceRollbackLogEntity.setTenantId(0L);
            ordSalesbillSourceRollbackLogEntity.setCreateUser(0L);
            ordSalesbillSourceRollbackLogEntity.setActionType(billOperationType.value());
            sourceRollbackLogEntities.add(ordSalesbillSourceRollbackLogEntity);
        }
        return originSalesbillSourceRelEntities;
    }
}

