/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.constant.enums;

import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public enum InvoiceType {
    NONE("", "\u672a\u77e5\u53d1\u7968\u7c7b\u578b"),
    NORMAL("c", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968"),
    SPECIAL("s", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    VEHICLE("v", "\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968"),
    UNIVERSAL("t", "\u901a\u7528\u673a\u6253\u53d1\u7968"),
    TRANSPORTATION("y", "\u8fd0\u8f93\u4e1a\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    ELECTRONIC("ce", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968"),
    ROLL("ju", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)");

    private final String type;
    private final String description;

    private InvoiceType(String type, String desc) {
        this.type = type;
        this.description = desc;
    }

    public String value() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values()).filter(t -> t.value().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
    }

    public static String descriptionFromValue(String invoiceType) {
        return Stream.of(InvoiceType.values()).filter(t -> t.value().equals(invoiceType)).findFirst().orElse(NONE).description();
    }

    public static boolean isValidInvoiceType(String invoiceType) {
        if (StringUtils.isEmpty((String)invoiceType)) {
            return false;
        }
        return Stream.of(InvoiceType.values()).filter(t -> t.value().equals(invoiceType)).findFirst().isPresent();
    }

    public boolean isNormal() {
        return this.equals((Object)NORMAL) || this.equals((Object)ELECTRONIC) || this.equals((Object)ROLL);
    }

    public boolean isSpecial() {
        return this.equals((Object)SPECIAL);
    }
}

