/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.constant.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public enum SalesBillStatus {
    INVALID(0, "\u4f5c\u5e9f"),
    NORMAL(1, "\u6b63\u5e38"),
    DELETED(9, "\u5220\u9664");

    private final Integer status;
    private final String desc;

    private SalesBillStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer value() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public static SalesBillStatus fromValue(String value) throws RuntimeException {
        return Stream.of(SalesBillStatus.values()).filter(t -> t.value().toString().equals(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u52a8\u4f5c\uff01"));
    }

    public static List<SalesBillStatus> getDeadStatus() {
        ArrayList<SalesBillStatus> invalidStatusLst = new ArrayList<SalesBillStatus>(2);
        invalidStatusLst.add(DELETED);
        return invalidStatusLst;
    }

    public static List<Integer> getDeadStatusValue() {
        ArrayList<Integer> invalidStatusLst = new ArrayList<Integer>(2);
        for (SalesBillStatus status : SalesBillStatus.getDeadStatus()) {
            invalidStatusLst.add(status.status);
        }
        return invalidStatusLst;
    }

    public static List<SalesBillStatus> getNoDeleteStatus() {
        ArrayList<SalesBillStatus> invalidStatusLst = new ArrayList<SalesBillStatus>(2);
        invalidStatusLst.add(INVALID);
        invalidStatusLst.add(NORMAL);
        return invalidStatusLst;
    }

    public static List<Integer> getNoDeleteStatusValue() {
        ArrayList<Integer> invalidStatusLst = new ArrayList<Integer>(2);
        for (SalesBillStatus status : SalesBillStatus.getNoDeleteStatus()) {
            invalidStatusLst.add(status.status);
        }
        return invalidStatusLst;
    }

    public static boolean checkIsExist(Integer value) {
        if (value == null) {
            return false;
        }
        for (SalesBillStatus item : SalesBillStatus.values()) {
            if (item.status.intValue() != value.intValue()) continue;
            return true;
        }
        return false;
    }
}

