/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.BillAttachment;
import com.xforceplus.phoenix.bill.client.model.UploadAttachmentRequest;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.constant.enums.UserRole;
import com.xforceplus.phoenix.bill.core.service.BillAttachmentService;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillAttachmentDao;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillAttachmentEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillAttachmentExample;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.bill.utils.CommonTools;
import com.xforceplus.phoenix.bill.utils.DateTools;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BillAttachmentServiceImpl
implements BillAttachmentService {
    private Logger logger = LoggerFactory.getLogger(BillAttachmentServiceImpl.class);
    @Autowired
    private OrdSalesbillAttachmentDao ordSalesbillAttachmentDao;
    @Autowired
    private OrdSalesbillDao ordSalesbillDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    private IDGenerator idGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trace
    public Response uploadAttachment(UploadAttachmentRequest uploadAttachmentRequest) {
        String traceId = TraceContext.traceId();
        this.logger.info("traceId:{}, salesBillNo:{}", (Object)traceId, (Object)uploadAttachmentRequest.getSalesbillNo());
        this.logger.info("\u5355\u636e\u9644\u4ef6\u5217\u8868:{}", (Object)uploadAttachmentRequest.getAttachmentList());
        if (CollectionUtils.isEmpty((Collection)uploadAttachmentRequest.getAttachmentList())) {
            return Response.failed((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u65e0\u4e0a\u4f20\u9644\u4ef6");
        }
        if (uploadAttachmentRequest.getUserRole() == null) {
            return Response.failed((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u4e0a\u4f20\u65b9");
        }
        if (uploadAttachmentRequest.getTenantId() == null) {
            return Response.failed((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u4e0a\u4f20\u65b9\u79df\u6237id");
        }
        if (CommonTools.isEmpty(uploadAttachmentRequest.getSalesbillNo())) {
            return Response.failed((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u6307\u5b9a\u5355\u636e\u53f7");
        }
        SqlSession sqlSession = null;
        try {
            OrdSalesbillExample ordSalesbillExample = new OrdSalesbillExample();
            OrdSalesbillExample.Criteria criteria = ordSalesbillExample.createCriteria().andSalesbillNoEqualTo(uploadAttachmentRequest.getSalesbillNo()).andStatusEqualTo(SalesBillStatus.NORMAL.value());
            if (UserRole.SELLER.intValue() == uploadAttachmentRequest.getUserRole().intValue()) {
                criteria.andSellerGroupIdEqualTo(uploadAttachmentRequest.getTenantId());
            } else {
                criteria.andPurchaserGroupIdEqualTo(uploadAttachmentRequest.getTenantId());
            }
            OrdSalesbillEntity ordSalesbillEntity = this.ordSalesbillDao.selectOneByExample(ordSalesbillExample);
            if (ordSalesbillEntity == null) {
                Response response = Response.failed((String)CommonTools.format("\u4e0a\u4f20\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u6b64\u5355\u636e{}", uploadAttachmentRequest.getSalesbillNo()));
                return response;
            }
            long salesBillId = ordSalesbillEntity.getSalesbillId();
            sqlSession = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
            List list = uploadAttachmentRequest.getAttachmentList();
            OrdSalesbillAttachmentDao batchDao = (OrdSalesbillAttachmentDao)sqlSession.getMapper(OrdSalesbillAttachmentDao.class);
            int success = 0;
            int total = list.size();
            for (BillAttachment attachment : list) {
                if (CommonTools.isEmpty(attachment.getFileName()) || CommonTools.isEmpty(attachment.getFilePath())) continue;
                OrdSalesbillAttachmentEntity entity = new OrdSalesbillAttachmentEntity();
                BeanUtils.copyProperties(attachment, (Object)entity);
                entity.setStatus(SalesBillStatus.NORMAL.value());
                long fileId = this.idGenerator.nextId();
                entity.setAttachmentId(fileId);
                entity.setSalesbillNo(uploadAttachmentRequest.getSalesbillNo());
                entity.setCreateTime(DateTools.currentTime());
                entity.setSalesbillId(salesBillId);
                entity.setCreateUser(123L);
                entity.setUpdateUser(123L);
                entity.setUpateTime(DateTools.currentTime());
                entity.setFileId(fileId);
                batchDao.insert(entity);
                ++success;
            }
            Response response = Response.ok((String)CommonTools.format("\u9644\u4ef6\u4e0a\u4f20\u6210\u529f, \u603b\u5171:{}\u6761,\u6210\u529f:{}\u6761,\u5931\u8d25:{}\u6761\u3002", total, success, total - success));
            return response;
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e\u53f7:[{}],\u4e0a\u4f20\u5355\u636e\u9644\u4ef6\u53d1\u751f\u5f02\u5e38", (Object)uploadAttachmentRequest.getSalesbillNo(), (Object)e);
            Response response = Response.failed((String)"\u4e0a\u4f20\u5931\u8d25");
            return response;
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.clearCache();
            }
        }
    }

    @Override
    @Trace
    public Response downloadAttachment(List<Long> fileIds) {
        if (CommonTools.isEmpty(fileIds)) {
            return Response.failed((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u6307\u5b9a\u9644\u4ef6id");
        }
        try {
            OrdSalesbillAttachmentExample example = new OrdSalesbillAttachmentExample();
            example.createCriteria().andFileIdIn((List)fileIds).andStatusEqualTo(SalesBillStatus.NORMAL.value());
            List<OrdSalesbillAttachmentEntity> attachmentList = this.ordSalesbillAttachmentDao.selectByExample(example);
            return this.toResult(attachmentList);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5355\u636e\u9644\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return Response.failed((String)"\u67e5\u8be2\u9644\u4ef6\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trace
    public Response deleteAttachment(List<Long> fileIds) {
        if (CommonTools.isEmpty(fileIds)) {
            return Response.failed((String)"\u5220\u9664\u5931\u8d25\uff0c\u672a\u6307\u5b9a\u9644\u4ef6id");
        }
        SqlSession sqlSession = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        try {
            OrdSalesbillAttachmentDao dao = (OrdSalesbillAttachmentDao)sqlSession.getMapper(OrdSalesbillAttachmentDao.class);
            for (Long id : fileIds) {
                OrdSalesbillAttachmentEntity entity = new OrdSalesbillAttachmentEntity();
                entity.setAttachmentId(id);
                entity.setStatus(SalesBillStatus.DELETED.value());
                entity.setUpateTime(DateTools.currentTime());
                entity.setUpdateUser(0L);
                dao.updateByPrimaryKeySelective(entity);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u9644\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            Response response = Response.failed((String)"\u5220\u9664\u9644\u4ef6\u5931\u8d25");
            return response;
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.clearCache();
            }
        }
        return Response.ok((String)"\u5220\u9664\u9644\u4ef6\u6210\u529f");
    }

    @Override
    @Trace
    public Response attachmentList(Long salesBillId) {
        if (salesBillId == null) {
            return Response.failed((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u6307\u5b9a\u5355\u636eid");
        }
        try {
            OrdSalesbillAttachmentExample example = new OrdSalesbillAttachmentExample();
            example.createCriteria().andSalesbillIdEqualTo(salesBillId);
            List<OrdSalesbillAttachmentEntity> attachmentList = this.ordSalesbillAttachmentDao.selectByExample(example);
            return this.toResult(attachmentList);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5355\u636e\u9644\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return Response.failed((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    private Response toResult(List<OrdSalesbillAttachmentEntity> attachmentList) {
        if (CommonTools.isEmpty(attachmentList)) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u9644\u4ef6");
        }
        ArrayList resultList = Lists.newArrayList();
        for (OrdSalesbillAttachmentEntity attachmentEntity : attachmentList) {
            BillAttachment attachment = new BillAttachment();
            BeanUtils.copyProperties((Object)attachmentEntity, attachment);
            resultList.add(attachment);
        }
        Response response = Response.ok((String)"\u67e5\u8be2\u6210\u529f");
        response.setResult((Object)resultList);
        return response;
    }
}

