/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.bill.core.impl;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.runtime.Settings;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.constant.BillConstants;
import com.xforceplus.phoenix.bill.constant.enums.SalesBillStatus;
import com.xforceplus.phoenix.bill.core.service.BillChangeService;
import com.xforceplus.phoenix.bill.core.service.BillInvoiceService;
import com.xforceplus.phoenix.bill.repository.dao.OrdSalesbillDao;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillEntity;
import com.xforceplus.phoenix.bill.repository.model.OrdSalesbillExample;
import com.xforceplus.phoenix.bill.sqs.model.CooperationRequest;
import com.xforceplus.phoenix.bill.sqs.model.InvSellerInvoiceEntity;
import com.xforceplus.phoenix.bill.sqs.model.InvSellerPreSalesDetailEntity;
import com.xforceplus.phoenix.bill.sqs.model.MatchResult;
import com.xforceplus.phoenix.bill.utils.BeanUtils;
import com.xforceplus.phoenix.sqs.SQSSender;
import com.xforceplus.seller.invoice.client.model.BillReleaseType;
import com.xforceplus.seller.invoice.client.model.DetailInfo;
import com.xforceplus.seller.invoice.client.model.InvoiceOperation;
import com.xforceplus.seller.invoice.client.model.NoticeBillMsg;
import com.xforceplus.seller.invoice.client.model.NoticeBillReleaseMsg;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BillChangeServiceImpl
implements BillChangeService {
    private static final Logger logger = LoggerFactory.getLogger(BillChangeServiceImpl.class);
    @Autowired
    private BillInvoiceService billInvoiceService;
    @Autowired
    private OrdSalesbillDao salesBillDao;

    @Override
    public boolean onInvoice(long salesBillId, BigDecimal amountWithTax, BigDecimal amountWithoutTax, BigDecimal tax) {
        return false;
    }

    @Override
    public boolean onRedInvoice(long salesBillId, BigDecimal amountWithTax, BigDecimal amountWithoutTax, BigDecimal tax) {
        return false;
    }

    @Override
    public boolean onAbandon(long salesBillId, BigDecimal amountWithTax, BigDecimal amountWithoutTax, BigDecimal tax) {
        return false;
    }

    @Override
    public boolean onMatch(long salesBillId, BigDecimal amountWithTax, BigDecimal amountWithoutTax, BigDecimal tax, int invoiceStatus) {
        return false;
    }

    private OrdSalesbillEntity onMatch(OrdSalesbillEntity salesBill, BigDecimal amountWithTax, BigDecimal amountWithoutTax, BigDecimal tax, int invoiceStatus) {
        OrdSalesbillEntity updateEntity = new OrdSalesbillEntity();
        updateEntity.setSalesbillId(salesBill.getSalesbillId());
        if (invoiceStatus != 0) {
            updateEntity.setAlreadyMakeAmountTaxAmount(salesBill.getAlreadyMakeAmountTaxAmount().add(tax));
            updateEntity.setAlreadyMakeAmountWithoutTax(salesBill.getAlreadyMakeAmountWithoutTax().add(amountWithoutTax));
            updateEntity.setAlreadyMakeAmountWithTax(salesBill.getAlreadyMakeAmountWithTax().add(amountWithTax));
            this.salesBillDao.updateByPrimaryKeySelective(updateEntity);
            return updateEntity;
        }
        return salesBill;
    }

    @Override
    public boolean onUnMatch(long salesBillId, BigDecimal amountWithTax, BigDecimal amountWithoutTax, BigDecimal tax) {
        return false;
    }

    @Override
    public boolean onAutoMatch(MatchResult matchResult) {
        if (matchResult == null) {
            return false;
        }
        CooperationRequest cooperationRequest = new CooperationRequest();
        InvSellerInvoiceEntity invoice = matchResult.getInvoice();
        cooperationRequest.setInvoiceId(invoice.getId());
        if (matchResult.isMatchPreInvoice()) {
            List<InvSellerPreSalesDetailEntity> relationList = matchResult.getRelationList();
            String invoiceCode = invoice.getInvoiceCode();
            String invoiceNo = invoice.getInvoiceNo();
            long batchNo = relationList.get(0).getBatchNo();
            if (invoice.getAmountWithTax().compareTo(BigDecimal.ZERO) > 0) {
                if (BillConstants.INVOICE_STATUS_NORMAL.equals(invoice.getStatus())) {
                    this.blueInvoice(relationList, invoiceCode, invoiceNo, batchNo);
                } else {
                    this.abandonOrRedInvoice(relationList, invoiceCode, invoiceNo, batchNo, InvoiceOperation.ABANDON_INVOICE.value());
                }
            } else {
                this.abandonOrRedInvoice(relationList, invoiceCode, invoiceNo, batchNo, InvoiceOperation.RED_INVOICE.value());
            }
            cooperationRequest.setPreInvoiceId(invoice.getPreInvoiceId());
            cooperationRequest.setCooperationType(2);
        } else {
            OrdSalesbillExample example = new OrdSalesbillExample();
            example.createCriteria().andSalesbillNoEqualTo(matchResult.getSalesBillNo()).andSellerIdEqualTo(invoice.getSellerId()).andSellerGroupIdEqualTo(invoice.getSellerGroupId()).andStatusEqualTo(SalesBillStatus.NORMAL.value());
            List<OrdSalesbillEntity> list = this.salesBillDao.selectByExample(example);
            if (!CollectionUtils.isEmpty(list)) {
                this.onMatch(list.get(0), invoice.getAmountWithTax(), invoice.getAmountWithoutTax(), invoice.getTaxAmount(), (int)invoice.getStatus());
                cooperationRequest.setSalesBillId(list.get(0).getSalesbillId());
                cooperationRequest.setCooperationType(1);
            } else {
                logger.warn("\u62bd\u53d6\u53d1\u7968\u672a\u5339\u914d\u5230\u4e1a\u52a1\u5355,\u53d1\u7968\u4ee3\u7801:{},\u53d1\u7968\u53f7\u7801:{},\u5907\u6ce8\u4e2d\u7684\u4e1a\u52a1\u5355\u53f7:{}", new Object[]{matchResult.getSalesBillNo(), invoice.getInvoiceCode(), invoice.getInvoiceNo(), matchResult.getSalesBillNo()});
                cooperationRequest.setCooperationType(3);
            }
        }
        this.sendSellerInvoiceCooperation(cooperationRequest);
        return true;
    }

    private void sendSellerInvoiceCooperation(CooperationRequest cooperationRequest) {
        DslJson dslJson = new DslJson(Settings.withRuntime().allowArrayFormat(true).includeServiceLoader());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            dslJson.serialize((Object)cooperationRequest, (OutputStream)os);
            SQSSender.sendStrMsg((String)"phoenix-invoice-cooperation-request", (String)os.toString("utf-8"), (Map)Maps.newHashMap(), (boolean)true);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u534f\u540c\u8bf7\u6c42\u5931\u8d25:{}", (Object)cooperationRequest, (Object)e);
        }
    }

    private void abandonOrRedInvoice(List<InvSellerPreSalesDetailEntity> entityList, String invoiceCode, String invoiceNo, long batchNo, int operationType) {
        NoticeBillReleaseMsg releaseMsg = new NoticeBillReleaseMsg();
        releaseMsg.setBatchNo(Long.valueOf(batchNo));
        releaseMsg.setInvoiceCode(invoiceCode);
        releaseMsg.setInvoiceNo(invoiceNo);
        releaseMsg.setOperationType(operationType);
        releaseMsg.setReleaseType(BillReleaseType.NOT_RELEASE.value().intValue());
        releaseMsg.setDetailInfoList(this.convertToDetailList(entityList));
        this.billInvoiceService.revertBillAndItem(releaseMsg);
    }

    private void blueInvoice(List<InvSellerPreSalesDetailEntity> entityList, String invoiceCode, String invoiceNo, long batchNo) {
        NoticeBillMsg msg = new NoticeBillMsg();
        msg.setBatchNo(Long.valueOf(batchNo));
        msg.setInvoiceNo(invoiceNo);
        msg.setInvoiceCode(invoiceCode);
        msg.setDetailInfoList(this.convertToDetailList(entityList));
        this.billInvoiceService.invoiceComplete(msg);
    }

    private List<DetailInfo> convertToDetailList(List<InvSellerPreSalesDetailEntity> entityList) {
        return entityList.stream().map(entity -> {
            DetailInfo detailInfo = new DetailInfo();
            BeanUtils.copyProperties(entity, detailInfo);
            return detailInfo;
        }).collect(Collectors.toList());
    }
}

